--
-- PostgreSQL database dump
--

-- Dumped from database version 16.4
-- Dumped by pg_dump version 16.4

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- Name: comun; Type: SCHEMA; Schema: -; Owner: iepnb
--

CREATE SCHEMA comun;


ALTER SCHEMA comun OWNER TO iepnb;

--
-- Name: especie; Type: SCHEMA; Schema: -; Owner: iepnb
--

CREATE SCHEMA especie;


ALTER SCHEMA especie OWNER TO iepnb;

--
-- Name: SCHEMA especie; Type: COMMENT; Schema: -; Owner: iepnb
--

COMMENT ON SCHEMA especie IS 'especies/taxonomia';


--
-- Name: habitat; Type: SCHEMA; Schema: -; Owner: iepnb
--

CREATE SCHEMA habitat;


ALTER SCHEMA habitat OWNER TO iepnb;

--
-- Name: SCHEMA habitat; Type: COMMENT; Schema: -; Owner: iepnb
--

COMMENT ON SCHEMA habitat IS 'Esquema con las tablas relacionadas con habitats';


--
-- Name: seguimiento_especie; Type: SCHEMA; Schema: -; Owner: iepnb
--

CREATE SCHEMA seguimiento_especie;


ALTER SCHEMA seguimiento_especie OWNER TO iepnb;

--
-- Name: update_text_geometry(numeric); Type: FUNCTION; Schema: seguimiento_especie; Owner: iepnb
--

CREATE FUNCTION seguimiento_especie.update_text_geometry(id numeric) RETURNS text
    LANGUAGE plpgsql
    AS $$
        DECLARE        
                wkt_geo text;
        BEGIN
                update seguimiento_especie.gis_geometria SET wkt_geometria = ST_AsText(geometria) where id_geometria = id;
                return "X";
        END;
$$;


ALTER FUNCTION seguimiento_especie.update_text_geometry(id numeric) OWNER TO iepnb;

--
-- Name: wkt_gis_geometria(); Type: FUNCTION; Schema: seguimiento_especie; Owner: iepnb
--

CREATE FUNCTION seguimiento_especie.wkt_gis_geometria() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
	begin
		update seguimiento_especie.gis_geometria SET wkt_geometria = ST_AsText(geometria);
			return new;

	END;
$$;


ALTER FUNCTION seguimiento_especie.wkt_gis_geometria() OWNER TO iepnb;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: ccaa_elemento_toponimo; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.ccaa_elemento_toponimo (
    id_elemento_toponimo bigint NOT NULL,
    id_ccaa integer NOT NULL
);


ALTER TABLE comun.ccaa_elemento_toponimo OWNER TO iepnb;

--
-- Name: TABLE ccaa_elemento_toponimo; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON TABLE comun.ccaa_elemento_toponimo IS 'Se realciona los elementos toponimos con la CCAA en la que se ecuentran';


--
-- Name: coleccion_medida; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.coleccion_medida (
    id_coleccion_medida numeric(20,0) NOT NULL,
    cod_id_en_coleccion character varying(100),
    nombre character varying(2000) NOT NULL,
    descripcion text,
    id_organismo numeric(20,0),
    organismo_orign_corto character varying(20),
    nombre_organismo character varying(400),
    fecha_creacion timestamp without time zone,
    fecha_modificacion timestamp without time zone,
    id_usuario_crea_registro integer,
    id_usuario_modifica_registro integer
);


ALTER TABLE comun.coleccion_medida OWNER TO iepnb;

--
-- Name: COLUMN coleccion_medida.id_coleccion_medida; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.coleccion_medida.id_coleccion_medida IS 'Id. de la colección de medidas';


--
-- Name: COLUMN coleccion_medida.cod_id_en_coleccion; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.coleccion_medida.cod_id_en_coleccion IS 'Id. o código de la medida dentro de lista';


--
-- Name: COLUMN coleccion_medida.nombre; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.coleccion_medida.nombre IS 'Nombre de la medida';


--
-- Name: COLUMN coleccion_medida.descripcion; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.coleccion_medida.descripcion IS 'Descripción de la medida';


--
-- Name: COLUMN coleccion_medida.id_organismo; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.coleccion_medida.id_organismo IS 'Id. Organismo del que procede la colección, FRK a T_ORGANISMO';


--
-- Name: COLUMN coleccion_medida.organismo_orign_corto; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.coleccion_medida.organismo_orign_corto IS 'ACrónimo o nombre corto del organismo origen';


--
-- Name: COLUMN coleccion_medida.nombre_organismo; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.coleccion_medida.nombre_organismo IS 'Nombre del organimso si no tien id_organismo';


--
-- Name: documento; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.documento (
    id_documento bigint NOT NULL,
    titulo character varying(1000) NOT NULL,
    descripcion text,
    id_tipo_documento integer,
    cod_documento_almacenaje character varying(200) NOT NULL,
    privado boolean,
    difusion boolean,
    fecha_creacion timestamp with time zone,
    fecha_modificacion timestamp with time zone,
    id_usuario_crea_registro integer,
    id_usuario_modifica_registro integer,
    version character varying(20),
    codigo_verficacion character varying(500),
    id_tipo_verificacion_documento integer,
    id_aplicacion integer
);


ALTER TABLE comun.documento OWNER TO iepnb;

--
-- Name: COLUMN documento.version; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.documento.version IS 'Campo para guardar la versión del documento';


--
-- Name: COLUMN documento.codigo_verficacion; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.documento.codigo_verficacion IS 'Campo para guardar el código de verificación';


--
-- Name: COLUMN documento.id_tipo_verificacion_documento; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.documento.id_tipo_verificacion_documento IS 'Identificador para referenciar a la tabla de t_tipo_verificacion';


--
-- Name: COLUMN documento.id_aplicacion; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.documento.id_aplicacion IS 'Identificador de la aplicación';


--
-- Name: especimen_sec; Type: SEQUENCE; Schema: comun; Owner: iepnb
--

CREATE SEQUENCE comun.especimen_sec
    START WITH 18263
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE comun.especimen_sec OWNER TO iepnb;

--
-- Name: especimen; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.especimen (
    id_especimen bigint DEFAULT nextval('comun.especimen_sec'::regclass) NOT NULL,
    id_especimen_especifico numeric(20,0),
    id_taxon bigint,
    id_hibrido bigint,
    id_cites bigint,
    fecha_alta_nacimiento_puesta date,
    fecha_baja date,
    cod_marcado character varying(100) NOT NULL,
    id_especimen_padre bigint,
    id_especimen_madre bigint,
    id_motivo_baja integer,
    id_motivo_alta integer,
    id_sexo integer,
    id_tipo_marcado integer,
    certificado_cite character varying,
    cod_anexo character varying(10),
    fecha_eclosion date,
    estado_fisico text,
    id_centro bigint,
    tiene_proced_adminis integer,
    tiene_proced_judicial integer,
    cod_proced_adminis character varying(200),
    cod_proced_judicial character varying(200),
    id_estado_validacion integer,
    fecha_creacion timestamp without time zone,
    fecha_modificacion timestamp without time zone,
    id_usuario_crea_registro integer,
    id_usuario_modifica_registro integer,
    detalle_baja character varying,
    centro_cesion text,
    depositador text,
    id_aplicacion integer NOT NULL
);


ALTER TABLE comun.especimen OWNER TO iepnb;

--
-- Name: grupo_taxon_eidos_otros; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.grupo_taxon_eidos_otros (
    id_grupo_taxon numeric(6,0) NOT NULL,
    id_grupotax_eidos numeric(6,0) NOT NULL
);


ALTER TABLE comun.grupo_taxon_eidos_otros OWNER TO iepnb;

--
-- Name: listado_provisonal_org_distintos; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.listado_provisonal_org_distintos (
    resp_name character varying(500)
);


ALTER TABLE comun.listado_provisonal_org_distintos OWNER TO iepnb;

--
-- Name: medida_conservacion_norma; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.medida_conservacion_norma (
    id_medida numeric(20,0) NOT NULL,
    id_norma numeric(20,0) NOT NULL,
    observaciones text,
    fecha_creacion timestamp without time zone,
    fecha_modificacion timestamp without time zone,
    id_usuario_crea_registro integer,
    id_usuario_modifica_registro integer
);


ALTER TABLE comun.medida_conservacion_norma OWNER TO iepnb;

--
-- Name: norma_ccaa; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.norma_ccaa (
    id_norma bigint NOT NULL,
    id_ccaa integer NOT NULL
);


ALTER TABLE comun.norma_ccaa OWNER TO iepnb;

--
-- Name: TABLE norma_ccaa; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON TABLE comun.norma_ccaa IS 'Relación de la legislación y su ambito de aplición en CCAA';


--
-- Name: norma_componente; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.norma_componente (
    id_norma integer NOT NULL,
    id_componente integer NOT NULL,
    fecha_creacion timestamp without time zone,
    fecha_modificacion timestamp without time zone,
    id_usuario_crea_registro integer,
    id_usuario_modifica_registro integer
);


ALTER TABLE comun.norma_componente OWNER TO iepnb;

--
-- Name: norma_elemento_toponimo; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.norma_elemento_toponimo (
    id_elemento_toponimo bigint NOT NULL,
    id_norma bigint NOT NULL
);


ALTER TABLE comun.norma_elemento_toponimo OWNER TO iepnb;

--
-- Name: TABLE norma_elemento_toponimo; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON TABLE comun.norma_elemento_toponimo IS 'Espcifica el ambito de aplicación de la ley, en relación a tomponimos';


--
-- Name: norma_norma; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.norma_norma (
    id_norma integer NOT NULL,
    id_norma_2 integer NOT NULL,
    id_tipo_relacion_norma integer,
    observaciones text,
    fecha_creacion timestamp without time zone,
    fecha_modificacion timestamp without time zone,
    id_usuario_crea_registro integer,
    id_usuario_modifica_registro integer
);


ALTER TABLE comun.norma_norma OWNER TO iepnb;

--
-- Name: COLUMN norma_norma.id_norma; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.norma_norma.id_norma IS 'Id de la norma. FK a T_NORMAS';


--
-- Name: COLUMN norma_norma.id_norma_2; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.norma_norma.id_norma_2 IS 'Id de la norma. FK a T_NORMAS';


--
-- Name: COLUMN norma_norma.id_tipo_relacion_norma; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.norma_norma.id_tipo_relacion_norma IS 'Identificador del tipo de relación. FK a T_ TIPO_RELACION_NORMAS';


--
-- Name: COLUMN norma_norma.observaciones; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.norma_norma.observaciones IS 'Observaciones';


--
-- Name: norma_tema; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.norma_tema (
    id_norma numeric(20,0) NOT NULL,
    id_tema smallint NOT NULL,
    fecha_creacion timestamp without time zone,
    fecha_modificacion timestamp without time zone,
    id_usuario_crea_registro integer,
    id_usuario_modifica_registro integer
);


ALTER TABLE comun.norma_tema OWNER TO iepnb;

--
-- Name: TABLE norma_tema; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON TABLE comun.norma_tema IS 'Tabla que registra los datos enviados a ABS-CH de acceso';


--
-- Name: sec_organismo_ambito_aplica; Type: SEQUENCE; Schema: comun; Owner: iepnb
--

CREATE SEQUENCE comun.sec_organismo_ambito_aplica
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE comun.sec_organismo_ambito_aplica OWNER TO iepnb;

--
-- Name: organismo_ambito_aplica; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.organismo_ambito_aplica (
    id_organismo_ambito_aplica integer DEFAULT nextval('comun.sec_organismo_ambito_aplica'::regclass) NOT NULL,
    id_organismo integer NOT NULL,
    id_aplicacion integer,
    id_ccaa integer,
    id_provincia integer,
    id_municipio integer,
    id_ambito_aplica integer NOT NULL,
    fecha_creacion timestamp without time zone,
    fecha_modificacion timestamp without time zone,
    id_usuario_crea_registro integer,
    id_usuario_modifica_registro integer
);


ALTER TABLE comun.organismo_ambito_aplica OWNER TO iepnb;

--
-- Name: TABLE organismo_ambito_aplica; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON TABLE comun.organismo_ambito_aplica IS 'Tabla con la relación del tipo de ámbito y dónde aplica';


--
-- Name: COLUMN organismo_ambito_aplica.id_organismo_ambito_aplica; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.organismo_ambito_aplica.id_organismo_ambito_aplica IS 'Identificador de la relación';


--
-- Name: COLUMN organismo_ambito_aplica.id_organismo; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.organismo_ambito_aplica.id_organismo IS 'Identificador del organismo';


--
-- Name: COLUMN organismo_ambito_aplica.id_aplicacion; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.organismo_ambito_aplica.id_aplicacion IS 'Identificador de la aplicación';


--
-- Name: COLUMN organismo_ambito_aplica.id_ccaa; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.organismo_ambito_aplica.id_ccaa IS 'Identificador de la CCAA';


--
-- Name: COLUMN organismo_ambito_aplica.id_provincia; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.organismo_ambito_aplica.id_provincia IS 'Identificador de la provincia';


--
-- Name: COLUMN organismo_ambito_aplica.id_municipio; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.organismo_ambito_aplica.id_municipio IS 'Identificador del municipio';


--
-- Name: COLUMN organismo_ambito_aplica.id_ambito_aplica; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.organismo_ambito_aplica.id_ambito_aplica IS 'Identificador de ámbito donde aplica la relación';


--
-- Name: COLUMN organismo_ambito_aplica.fecha_creacion; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.organismo_ambito_aplica.fecha_creacion IS 'Fecha de creacion del registro';


--
-- Name: COLUMN organismo_ambito_aplica.fecha_modificacion; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.organismo_ambito_aplica.fecha_modificacion IS 'Fecha de modificación del registro';


--
-- Name: COLUMN organismo_ambito_aplica.id_usuario_crea_registro; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.organismo_ambito_aplica.id_usuario_crea_registro IS 'Identificador del usuario que crea el registro';


--
-- Name: COLUMN organismo_ambito_aplica.id_usuario_modifica_registro; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.organismo_ambito_aplica.id_usuario_modifica_registro IS 'Identificador del usuario que  modifica el registro';


--
-- Name: organismo_aplicacion; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.organismo_aplicacion (
    id_organismo integer NOT NULL,
    nombre character varying(2000),
    telefono numeric(20,0),
    persona_contacto character varying(1000),
    direccion character varying(2000),
    email character varying(1000),
    nombre_corto character varying NOT NULL,
    ccaa smallint,
    id_aplicacion smallint NOT NULL,
    id_org_app numeric(6,0) NOT NULL,
    fecha_creacion timestamp without time zone,
    fecha_modificacion timestamp without time zone,
    id_usuario_crea_registro integer,
    id_usuario_modifica_registro integer,
    direcc_tipo_via character varying(500),
    direcc_cod_postal integer,
    direcc_nombre_localizador character varying(500),
    direcc_inspire character varying(1000),
    direcc_area character varying(500),
    id_provincia integer,
    id_municipio integer
);


ALTER TABLE comun.organismo_aplicacion OWNER TO iepnb;

--
-- Name: COLUMN organismo_aplicacion.id_org_app; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.organismo_aplicacion.id_org_app IS 'Es el identificador de la tabla';


--
-- Name: COLUMN organismo_aplicacion.direcc_tipo_via; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.organismo_aplicacion.direcc_tipo_via IS 'Es el campo de spire thoroughfare';


--
-- Name: COLUMN organismo_aplicacion.direcc_nombre_localizador; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.organismo_aplicacion.direcc_nombre_localizador IS 'En inspire locatorname';


--
-- Name: COLUMN organismo_aplicacion.direcc_inspire; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.organismo_aplicacion.direcc_inspire IS 'campo inspare para la dirección (locatordesignator)';


--
-- Name: COLUMN organismo_aplicacion.direcc_area; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.organismo_aplicacion.direcc_area IS 'campo de dirección inspire (addressarea)';


--
-- Name: organismo_ccaa; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.organismo_ccaa (
    id_organismo integer NOT NULL,
    id_ccaa integer NOT NULL
);


ALTER TABLE comun.organismo_ccaa OWNER TO iepnb;

--
-- Name: organismo_organismo; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.organismo_organismo (
    id_organismo integer NOT NULL,
    id_organismo2 integer NOT NULL,
    id_aplicacion smallint,
    fecha_creacion timestamp without time zone,
    fecha_modificacion timestamp without time zone,
    id_usuario_crea_registro integer,
    id_usuario_modifica_registro integer
);


ALTER TABLE comun.organismo_organismo OWNER TO iepnb;

--
-- Name: COLUMN organismo_organismo.id_organismo; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.organismo_organismo.id_organismo IS 'Organiso superior';


--
-- Name: organismo_provincia; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.organismo_provincia (
    id_organismo integer NOT NULL,
    id_provincia numeric(4,0) NOT NULL,
    fecha_creacion timestamp without time zone,
    fecha_modificacion timestamp without time zone,
    id_usuario_crea_registro integer,
    id_usuario_modifica_registro integer
);


ALTER TABLE comun.organismo_provincia OWNER TO iepnb;

--
-- Name: sec_perfil_funcionalidad; Type: SEQUENCE; Schema: comun; Owner: iepnb
--

CREATE SEQUENCE comun.sec_perfil_funcionalidad
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE comun.sec_perfil_funcionalidad OWNER TO iepnb;

--
-- Name: perfil_funcionalidad; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.perfil_funcionalidad (
    id_perfil_funcionalidad integer DEFAULT nextval('comun.sec_perfil_funcionalidad'::regclass) NOT NULL,
    id_perfil integer NOT NULL,
    id_funcionalidad integer NOT NULL,
    fecha_creacion timestamp without time zone,
    fecha_modificacion timestamp without time zone,
    id_usuario_crea_registro integer,
    id_usuario_modifica_registro integer
);


ALTER TABLE comun.perfil_funcionalidad OWNER TO iepnb;

--
-- Name: TABLE perfil_funcionalidad; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON TABLE comun.perfil_funcionalidad IS 'Tabla que relaciona los perfiles de las aplicaciones con sus correspondientes funcionalidades';


--
-- Name: COLUMN perfil_funcionalidad.id_perfil_funcionalidad; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.perfil_funcionalidad.id_perfil_funcionalidad IS 'Identificador del perfil y funcionalidad';


--
-- Name: COLUMN perfil_funcionalidad.id_perfil; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.perfil_funcionalidad.id_perfil IS 'Identificador del perfil';


--
-- Name: COLUMN perfil_funcionalidad.id_funcionalidad; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.perfil_funcionalidad.id_funcionalidad IS 'Identificador de la funcionalidad';


--
-- Name: COLUMN perfil_funcionalidad.fecha_creacion; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.perfil_funcionalidad.fecha_creacion IS 'Fecha de creacion del registro';


--
-- Name: COLUMN perfil_funcionalidad.fecha_modificacion; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.perfil_funcionalidad.fecha_modificacion IS 'Fecha de modificación del registro';


--
-- Name: COLUMN perfil_funcionalidad.id_usuario_crea_registro; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.perfil_funcionalidad.id_usuario_crea_registro IS 'Id de usuario que ha creado el registro';


--
-- Name: COLUMN perfil_funcionalidad.id_usuario_modifica_registro; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.perfil_funcionalidad.id_usuario_modifica_registro IS 'Id de usuario que ha modificado el registro';


--
-- Name: presion_amenaza_organismo; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.presion_amenaza_organismo (
    id_presion bigint,
    cod_presion_propio character varying(100),
    id_organismo integer,
    observacion text
);


ALTER TABLE comun.presion_amenaza_organismo OWNER TO iepnb;

--
-- Name: TABLE presion_amenaza_organismo; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON TABLE comun.presion_amenaza_organismo IS 'Tabla que permite añadir cod_identificativos usados por otros organimso para una presión en concreto';


--
-- Name: COLUMN presion_amenaza_organismo.id_presion; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.presion_amenaza_organismo.id_presion IS 'Id la presión o amenaza';


--
-- Name: COLUMN presion_amenaza_organismo.cod_presion_propio; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.presion_amenaza_organismo.cod_presion_propio IS 'Códigoa asignado a la presión segun otros organismos';


--
-- Name: sec_revision_info; Type: SEQUENCE; Schema: comun; Owner: iepnb
--

CREATE SEQUENCE comun.sec_revision_info
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE comun.sec_revision_info OWNER TO iepnb;

--
-- Name: revision_info; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.revision_info (
    id_revision_info bigint DEFAULT nextval('comun.sec_revision_info'::regclass) NOT NULL,
    revision_date timestamp without time zone,
    id_usuario integer
);


ALTER TABLE comun.revision_info OWNER TO iepnb;

--
-- Name: TABLE revision_info; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON TABLE comun.revision_info IS 'Tabla de auditoría que registra los cambios realizados';


--
-- Name: COLUMN revision_info.id_revision_info; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.revision_info.id_revision_info IS 'Identificador de la revisión';


--
-- Name: COLUMN revision_info.revision_date; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.revision_info.revision_date IS 'Fecha de la revisión';


--
-- Name: COLUMN revision_info.id_usuario; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.revision_info.id_usuario IS 'Id usuario que realiza la revisión';


--
-- Name: revtype; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.revtype (
    id_revtype integer NOT NULL,
    descripcion character varying(50) NOT NULL
);


ALTER TABLE comun.revtype OWNER TO iepnb;

--
-- Name: sec_casticket; Type: SEQUENCE; Schema: comun; Owner: iepnb
--

CREATE SEQUENCE comun.sec_casticket
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE comun.sec_casticket OWNER TO iepnb;

--
-- Name: sec_catalogo; Type: SEQUENCE; Schema: comun; Owner: iepnb
--

CREATE SEQUENCE comun.sec_catalogo
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE comun.sec_catalogo OWNER TO iepnb;

--
-- Name: sec_funcionalidad; Type: SEQUENCE; Schema: comun; Owner: iepnb
--

CREATE SEQUENCE comun.sec_funcionalidad
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE comun.sec_funcionalidad OWNER TO iepnb;

--
-- Name: sec_id_ambito_t_ambito; Type: SEQUENCE; Schema: comun; Owner: iepnb
--

CREATE SEQUENCE comun.sec_id_ambito_t_ambito
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE comun.sec_id_ambito_t_ambito OWNER TO iepnb;

--
-- Name: sec_id_certificado_digital; Type: SEQUENCE; Schema: comun; Owner: iepnb
--

CREATE SEQUENCE comun.sec_id_certificado_digital
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE comun.sec_id_certificado_digital OWNER TO iepnb;

--
-- Name: sec_id_normativa; Type: SEQUENCE; Schema: comun; Owner: iepnb
--

CREATE SEQUENCE comun.sec_id_normativa
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE comun.sec_id_normativa OWNER TO iepnb;

--
-- Name: sec_id_normativarelacionada; Type: SEQUENCE; Schema: comun; Owner: iepnb
--

CREATE SEQUENCE comun.sec_id_normativarelacionada
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE comun.sec_id_normativarelacionada OWNER TO iepnb;

--
-- Name: sec_id_tiporelacionnormativa; Type: SEQUENCE; Schema: comun; Owner: iepnb
--

CREATE SEQUENCE comun.sec_id_tiporelacionnormativa
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE comun.sec_id_tiporelacionnormativa OWNER TO iepnb;

--
-- Name: sec_medida; Type: SEQUENCE; Schema: comun; Owner: iepnb
--

CREATE SEQUENCE comun.sec_medida
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE comun.sec_medida OWNER TO iepnb;

--
-- Name: sec_normas; Type: SEQUENCE; Schema: comun; Owner: iepnb
--

CREATE SEQUENCE comun.sec_normas
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE comun.sec_normas OWNER TO iepnb;

--
-- Name: sec_organismo_aplicacion; Type: SEQUENCE; Schema: comun; Owner: iepnb
--

CREATE SEQUENCE comun.sec_organismo_aplicacion
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE comun.sec_organismo_aplicacion OWNER TO iepnb;

--
-- Name: sec_organismos; Type: SEQUENCE; Schema: comun; Owner: iepnb
--

CREATE SEQUENCE comun.sec_organismos
    START WITH 33
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE comun.sec_organismos OWNER TO iepnb;

--
-- Name: sec_origen; Type: SEQUENCE; Schema: comun; Owner: iepnb
--

CREATE SEQUENCE comun.sec_origen
    START WITH 4
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE comun.sec_origen OWNER TO iepnb;

--
-- Name: sec_parametro_configuracion; Type: SEQUENCE; Schema: comun; Owner: iepnb
--

CREATE SEQUENCE comun.sec_parametro_configuracion
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE comun.sec_parametro_configuracion OWNER TO iepnb;

--
-- Name: sec_perfil; Type: SEQUENCE; Schema: comun; Owner: iepnb
--

CREATE SEQUENCE comun.sec_perfil
    START WITH 200
    INCREMENT BY 1
    MINVALUE 200
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE comun.sec_perfil OWNER TO iepnb;

--
-- Name: sec_t_tipo_plan; Type: SEQUENCE; Schema: comun; Owner: iepnb
--

CREATE SEQUENCE comun.sec_t_tipo_plan
    START WITH 7
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE comun.sec_t_tipo_plan OWNER TO iepnb;

--
-- Name: sec_usuarios; Type: SEQUENCE; Schema: comun; Owner: iepnb
--

CREATE SEQUENCE comun.sec_usuarios
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE comun.sec_usuarios OWNER TO iepnb;

--
-- Name: sec_visible; Type: SEQUENCE; Schema: comun; Owner: iepnb
--

CREATE SEQUENCE comun.sec_visible
    START WITH 3
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE comun.sec_visible OWNER TO iepnb;

--
-- Name: t_ambito; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_ambito (
    cod_ambito character varying(2) NOT NULL,
    ambito character varying(150),
    descripcion character varying(300),
    fecha_creacion timestamp without time zone,
    fecha_modificacion timestamp without time zone,
    id_usuario_crea_registro integer,
    id_usuario_modifica_registro integer
);


ALTER TABLE comun.t_ambito OWNER TO iepnb;

--
-- Name: t_ambito_aplica; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_ambito_aplica (
    id_ambito_aplica integer NOT NULL,
    codigo_ambito_aplica character varying(50) NOT NULL,
    nombre character varying(100) NOT NULL,
    descripcion character varying(500),
    id_aplicacion integer,
    fecha_creacion timestamp without time zone,
    fecha_modificacion timestamp without time zone,
    id_usuario_crea_registro integer,
    id_usuario_modifica_registro integer
);


ALTER TABLE comun.t_ambito_aplica OWNER TO iepnb;

--
-- Name: TABLE t_ambito_aplica; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON TABLE comun.t_ambito_aplica IS 'Tabla con los ámbitos de aplicación del iepnb';


--
-- Name: COLUMN t_ambito_aplica.id_ambito_aplica; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_ambito_aplica.id_ambito_aplica IS 'Identificador del ámbito de aplicacion';


--
-- Name: COLUMN t_ambito_aplica.codigo_ambito_aplica; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_ambito_aplica.codigo_ambito_aplica IS 'Código que identifica el ámbito de aplicacion';


--
-- Name: COLUMN t_ambito_aplica.nombre; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_ambito_aplica.nombre IS 'Nombre del ámbito de aplicacion';


--
-- Name: COLUMN t_ambito_aplica.descripcion; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_ambito_aplica.descripcion IS 'Descripción del ámbito de aplicacion';


--
-- Name: COLUMN t_ambito_aplica.id_aplicacion; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_ambito_aplica.id_aplicacion IS 'Aplicación que define la relación';


--
-- Name: COLUMN t_ambito_aplica.fecha_creacion; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_ambito_aplica.fecha_creacion IS 'Fecha de creacion del registro';


--
-- Name: COLUMN t_ambito_aplica.fecha_modificacion; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_ambito_aplica.fecha_modificacion IS 'Fecha de modificación del registro';


--
-- Name: COLUMN t_ambito_aplica.id_usuario_crea_registro; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_ambito_aplica.id_usuario_crea_registro IS 'Identificador del usuario que crea el registro';


--
-- Name: COLUMN t_ambito_aplica.id_usuario_modifica_registro; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_ambito_aplica.id_usuario_modifica_registro IS 'Identificador del usuario que  modifica el registro';


--
-- Name: t_ambito_nivel_geografico_politico; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_ambito_nivel_geografico_politico (
    id_ambito_nivel_geografico_politico integer NOT NULL,
    nombre character varying(500),
    descripcion character varying(1000),
    fecha_creacion timestamp without time zone,
    fecha_modificacion timestamp without time zone,
    id_usuario_crea_registro integer,
    id_usuario_modifica_registro integer
);


ALTER TABLE comun.t_ambito_nivel_geografico_politico OWNER TO iepnb;

--
-- Name: TABLE t_ambito_nivel_geografico_politico; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON TABLE comun.t_ambito_nivel_geografico_politico IS 'Catálogo de los niveles de ambito geogafico tipo político';


--
-- Name: t_aplicacion; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_aplicacion (
    id_aplicacion integer NOT NULL,
    nombre character varying(250) NOT NULL,
    descripcion character varying(250),
    email character varying(250),
    url character varying(250),
    es_stadar_gest_usu smallint,
    fecha_creacion timestamp without time zone,
    fecha_modificacion timestamp without time zone,
    id_usuario_crea_registro integer,
    id_usuario_modifica_registro integer,
    activo smallint DEFAULT 1 NOT NULL,
    responsable character varying(250)
);


ALTER TABLE comun.t_aplicacion OWNER TO iepnb;

--
-- Name: TABLE t_aplicacion; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON TABLE comun.t_aplicacion IS 'Tabla con todos los identificadores de las aplicaciones que componen el sistema IEPNB';


--
-- Name: COLUMN t_aplicacion.id_aplicacion; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_aplicacion.id_aplicacion IS 'Identificador de la aplicación';


--
-- Name: COLUMN t_aplicacion.nombre; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_aplicacion.nombre IS 'Nombre de la aplicación';


--
-- Name: COLUMN t_aplicacion.descripcion; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_aplicacion.descripcion IS 'Descripción de la aplicación';


--
-- Name: COLUMN t_aplicacion.es_stadar_gest_usu; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_aplicacion.es_stadar_gest_usu IS '1 indica que tiene gestión de usarios y prefiles standar, 0 que es específica de esa app ';


--
-- Name: COLUMN t_aplicacion.activo; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_aplicacion.activo IS 'Campo que indica si una aplicación está a activa 1, o no activa a 0.';


--
-- Name: COLUMN t_aplicacion.responsable; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_aplicacion.responsable IS 'Este campo indica el nombre de la persona responsable de la aplicación';


--
-- Name: t_catalogo; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_catalogo (
    id_catalogo integer DEFAULT nextval('comun.sec_catalogo'::regclass) NOT NULL,
    nombre character varying(100) NOT NULL,
    descripcion character varying(500),
    id_aplicacion integer NOT NULL,
    gestionada smallint DEFAULT 0 NOT NULL
);


ALTER TABLE comun.t_catalogo OWNER TO iepnb;

--
-- Name: TABLE t_catalogo; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON TABLE comun.t_catalogo IS 'Tabla que contendrá el nombre de las tablas que son consideradas catálogos';


--
-- Name: COLUMN t_catalogo.id_catalogo; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_catalogo.id_catalogo IS 'Identificador del catálogo';


--
-- Name: COLUMN t_catalogo.nombre; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_catalogo.nombre IS 'Nombre de la tabla';


--
-- Name: COLUMN t_catalogo.descripcion; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_catalogo.descripcion IS 'Descripción del contenido de la tabla';


--
-- Name: COLUMN t_catalogo.id_aplicacion; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_catalogo.id_aplicacion IS 'Identificador de la aplicación asociada al catálogo';


--
-- Name: COLUMN t_catalogo.gestionada; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_catalogo.gestionada IS 'Campo que indica si se ha implementado la gestión del catálogo o no. 0 significa que no, 1 si';


--
-- Name: t_categoria_medida_conservacion; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_categoria_medida_conservacion (
    id_categoria_medida_conserva integer NOT NULL,
    nombre character varying(200) NOT NULL,
    descripcion text,
    id_aplicacion integer
);


ALTER TABLE comun.t_categoria_medida_conservacion OWNER TO iepnb;

--
-- Name: TABLE t_categoria_medida_conservacion; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON TABLE comun.t_categoria_medida_conservacion IS 'Tabla con lo tipos de medidas de conservación posibles';


--
-- Name: t_ccaa; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_ccaa (
    id_ccaa integer NOT NULL,
    cod_nut2 character varying(100) NOT NULL,
    nombre character varying(300),
    id_nut1 integer,
    fecha_creacion timestamp without time zone,
    fecha_modificacion timestamp without time zone,
    id_usuario_crea_registro integer,
    id_usuario_modifica_registro integer,
    id_aplicacion integer,
    id_agrupacion integer
);


ALTER TABLE comun.t_ccaa OWNER TO iepnb;

--
-- Name: t_clasif_objetivo_norma; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_clasif_objetivo_norma (
    nombre character varying,
    descripcion text,
    id_clasific_objetivo_norma integer NOT NULL
);


ALTER TABLE comun.t_clasif_objetivo_norma OWNER TO iepnb;

--
-- Name: t_componente; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_componente (
    id_componente numeric(4,0) NOT NULL,
    componente character varying(500) NOT NULL,
    id_tema smallint NOT NULL,
    fecha_creacion timestamp without time zone,
    fecha_modificacion timestamp without time zone,
    id_usuario_crea_registro integer,
    id_usuario_modifica_registro integer
);


ALTER TABLE comun.t_componente OWNER TO iepnb;

--
-- Name: t_contaminante; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_contaminante (
    id_contaminante numeric(20,0) NOT NULL,
    nombre character varying(300) NOT NULL,
    nombre_en character varying(300),
    cod_cntryes character varying(10),
    fecha_creacion timestamp without time zone,
    fecha_modificacion timestamp without time zone,
    id_usuario_crea_registro integer,
    id_usuario_modifica_registro integer
);


ALTER TABLE comun.t_contaminante OWNER TO iepnb;

--
-- Name: t_elemento_toponomico; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_elemento_toponomico (
    id_elemento_toponimico bigint NOT NULL,
    id_nombre_toponimo bigint NOT NULL,
    nombre_especifico character varying(250),
    id_tipo_relieve integer,
    id_tipo_toponimo integer,
    cod_punto_cardinal character varying(4),
    id_ambito_nivel_geograf_politico integer
);


ALTER TABLE comun.t_elemento_toponomico OWNER TO iepnb;

--
-- Name: t_estado_conserva_otras_codif; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_estado_conserva_otras_codif (
    id_estado_conserva bigint NOT NULL,
    cod_estado_conserva character varying(50),
    id_aplicacion smallint NOT NULL,
    otro_nombre character varying(200)
);


ALTER TABLE comun.t_estado_conserva_otras_codif OWNER TO iepnb;

--
-- Name: t_fuente_presion_amenaza; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_fuente_presion_amenaza (
    id_fuente_presion_amenza numeric NOT NULL,
    nombre character varying(500),
    nombre_corto character varying(25)
);


ALTER TABLE comun.t_fuente_presion_amenaza OWNER TO iepnb;

--
-- Name: t_funcionalidad; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_funcionalidad (
    id_funcionalidad integer DEFAULT nextval('comun.sec_funcionalidad'::regclass) NOT NULL,
    id_aplicacion integer NOT NULL,
    codigo_funcionalidad character varying(50) NOT NULL,
    etiqueta character varying(50) NOT NULL,
    descripcion character varying(250),
    fecha_creacion timestamp without time zone,
    fecha_modificacion timestamp without time zone,
    id_usuario_crea_registro integer,
    id_usuario_modifica_registro integer
);


ALTER TABLE comun.t_funcionalidad OWNER TO iepnb;

--
-- Name: TABLE t_funcionalidad; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON TABLE comun.t_funcionalidad IS 'Tabla con las funcionalidades de todos los sitemas del iepnb';


--
-- Name: COLUMN t_funcionalidad.id_funcionalidad; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_funcionalidad.id_funcionalidad IS 'Identificador de la funcionalidad';


--
-- Name: COLUMN t_funcionalidad.id_aplicacion; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_funcionalidad.id_aplicacion IS 'Identificador de la aplicacion';


--
-- Name: COLUMN t_funcionalidad.codigo_funcionalidad; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_funcionalidad.codigo_funcionalidad IS 'Campo que contiene el código que identifique la funcionalidad';


--
-- Name: COLUMN t_funcionalidad.etiqueta; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_funcionalidad.etiqueta IS 'Nombre o etiqueta de la funcionalidad';


--
-- Name: COLUMN t_funcionalidad.descripcion; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_funcionalidad.descripcion IS 'Descripción de la funcionalidad';


--
-- Name: COLUMN t_funcionalidad.fecha_creacion; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_funcionalidad.fecha_creacion IS 'Fecha de creacion del registro';


--
-- Name: COLUMN t_funcionalidad.fecha_modificacion; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_funcionalidad.fecha_modificacion IS 'Fecha de modificación del registro';


--
-- Name: COLUMN t_funcionalidad.id_usuario_crea_registro; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_funcionalidad.id_usuario_crea_registro IS 'Identificador del usuario que crea el registro';


--
-- Name: COLUMN t_funcionalidad.id_usuario_modifica_registro; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_funcionalidad.id_usuario_modifica_registro IS 'Identificador del usuario que  modifica el registro';


--
-- Name: t_grupo_taxonomico; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_grupo_taxonomico (
    id_grupo_taxon numeric(6,0) NOT NULL,
    cod_especifico character varying(20),
    id_aplicacion integer,
    fecha_creacion timestamp without time zone,
    fecha_modificacion timestamp without time zone,
    id_usuario_crea_registro integer,
    id_usuario_modifica_registro integer,
    id_nombre_grupo_taxon integer
);


ALTER TABLE comun.t_grupo_taxonomico OWNER TO iepnb;

--
-- Name: t_idioma; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_idioma (
    ididioma integer NOT NULL,
    codidioma character varying(3),
    id integer DEFAULT nextval('comun.sec_id_normativa'::regclass) NOT NULL,
    idioma character varying,
    orden smallint
);


ALTER TABLE comun.t_idioma OWNER TO iepnb;

--
-- Name: COLUMN t_idioma.orden; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_idioma.orden IS 'Id. para establecer la prioridad del lenguaje a usar.';


--
-- Name: t_impacto; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_impacto (
    id_impacto integer NOT NULL,
    nombre character varying(1000) NOT NULL,
    descripcion text,
    fecha_creacion timestamp without time zone,
    fecha_modificacion timestamp without time zone,
    id_usuario_crea_registro integer,
    id_usuario_modifica_registro integer
);


ALTER TABLE comun.t_impacto OWNER TO iepnb;

--
-- Name: t_importancia; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_importancia (
    id_importancia integer NOT NULL,
    valor_importancia character varying,
    valor_importancia_castellano character varying
);


ALTER TABLE comun.t_importancia OWNER TO iepnb;

--
-- Name: t_localidad; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_localidad (
    id_localidad bigint NOT NULL,
    nombre character varying NOT NULL,
    id_municipio integer NOT NULL
);


ALTER TABLE comun.t_localidad OWNER TO iepnb;

--
-- Name: t_medida_conserva_gestion; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_medida_conserva_gestion (
    id_medida numeric(20,0) NOT NULL,
    nombre character varying(4000) NOT NULL,
    descripcion_medida text,
    id_aplicacion_origen integer,
    id_medida_padre numeric(20,0),
    id_ambito_pol integer,
    id_ambito_geografico integer,
    id_region_biogeografica integer,
    id_coleccion_medida numeric(20,0),
    nombre_en character varying(4000),
    descripcion_en text,
    nivel integer,
    id_categoria integer,
    fecha_creacion timestamp without time zone,
    fecha_modificacion timestamp without time zone,
    id_usuario_crea_registro integer,
    id_usuario_modifica_registro integer,
    cod_medida character varying(255)
);


ALTER TABLE comun.t_medida_conserva_gestion OWNER TO iepnb;

--
-- Name: TABLE t_medida_conserva_gestion; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON TABLE comun.t_medida_conserva_gestion IS 'Código oficial si existe de la medida';


--
-- Name: COLUMN t_medida_conserva_gestion.id_medida; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_medida_conserva_gestion.id_medida IS 'Id. de la medida';


--
-- Name: COLUMN t_medida_conserva_gestion.nombre; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_medida_conserva_gestion.nombre IS 'Nombre de la medida';


--
-- Name: COLUMN t_medida_conserva_gestion.descripcion_medida; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_medida_conserva_gestion.descripcion_medida IS 'Descripción de la medida';


--
-- Name: COLUMN t_medida_conserva_gestion.id_aplicacion_origen; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_medida_conserva_gestion.id_aplicacion_origen IS 'Id. de la aplicación que da de alta la medida';


--
-- Name: COLUMN t_medida_conserva_gestion.id_medida_padre; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_medida_conserva_gestion.id_medida_padre IS 'La medida padre';


--
-- Name: COLUMN t_medida_conserva_gestion.id_ambito_pol; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_medida_conserva_gestion.id_ambito_pol IS 'dentificación del ámbito político de la medida';


--
-- Name: COLUMN t_medida_conserva_gestion.id_ambito_geografico; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_medida_conserva_gestion.id_ambito_geografico IS 'Id del ambito geográfico';


--
-- Name: COLUMN t_medida_conserva_gestion.id_region_biogeografica; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_medida_conserva_gestion.id_region_biogeografica IS 'Id de la región biogeográfica';


--
-- Name: COLUMN t_medida_conserva_gestion.id_coleccion_medida; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_medida_conserva_gestion.id_coleccion_medida IS 'Id. de la colección de medidas.FK a T_COLECCION_MEDIDA';


--
-- Name: COLUMN t_medida_conserva_gestion.nombre_en; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_medida_conserva_gestion.nombre_en IS 'Nombre en Inglés';


--
-- Name: COLUMN t_medida_conserva_gestion.descripcion_en; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_medida_conserva_gestion.descripcion_en IS 'Descripción de la medida en Inglés';


--
-- Name: COLUMN t_medida_conserva_gestion.nivel; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_medida_conserva_gestion.nivel IS 'Nivel de concreción de la medida';


--
-- Name: COLUMN t_medida_conserva_gestion.id_categoria; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_medida_conserva_gestion.id_categoria IS 'Id de la categoria de la medida, por ejemplo actuación';


--
-- Name: t_municipio; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_municipio (
    cod_nut3 character varying(5),
    nombre character varying(255),
    area numeric(126,0),
    cmun character varying(255),
    id_municipios integer NOT NULL,
    id_provincia integer NOT NULL,
    id_nuts3_es integer,
    fecha_creacion timestamp without time zone,
    fecha_modificacion timestamp without time zone,
    id_usuario_crea_registro integer,
    id_usuario_modifica_registro integer
);


ALTER TABLE comun.t_municipio OWNER TO iepnb;

--
-- Name: t_nombre_grupo_taxonomico; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_nombre_grupo_taxonomico (
    id_nombre_grupo_taxon numeric(6,0) NOT NULL,
    nombre character varying(200),
    nombre_en character varying(200),
    fecha_creacion timestamp without time zone,
    fecha_modificacion timestamp without time zone,
    id_usuario_crea_registro integer,
    id_usuario_modifica_registro integer
);


ALTER TABLE comun.t_nombre_grupo_taxonomico OWNER TO iepnb;

--
-- Name: t_nombre_toponimia; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_nombre_toponimia (
    id_nombre_toponimia bigint NOT NULL,
    nombre character varying(250) NOT NULL
);


ALTER TABLE comun.t_nombre_toponimia OWNER TO iepnb;

--
-- Name: t_norma; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_norma (
    id_norma numeric(20,0) NOT NULL,
    norma character varying(1250) NOT NULL,
    id_rango_norma_sup integer,
    anio smallint,
    para_informe character varying(2),
    fecha timestamp(0) without time zone,
    id_organismo integer,
    id_usuario integer,
    id_rango_norma_int integer,
    id_rango_norma_inf integer,
    id_aplicacion smallint,
    nombre_corto character varying(250),
    url character varying(2000),
    fecha_creacion timestamp without time zone,
    fecha_modificacion timestamp without time zone,
    id_usuario_crea_registro integer,
    id_usuario_modifica_registro integer,
    id_clasif_objetivo_norma integer,
    id_ambito_nivel_geografico_politico smallint,
    id_visible integer DEFAULT 1 NOT NULL
);


ALTER TABLE comun.t_norma OWNER TO iepnb;

--
-- Name: COLUMN t_norma.id_norma; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_norma.id_norma IS 'Identificador de la legislación';


--
-- Name: COLUMN t_norma.norma; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_norma.norma IS 'Nombre';


--
-- Name: COLUMN t_norma.id_rango_norma_sup; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_norma.id_rango_norma_sup IS 'Tipo de Legislación';


--
-- Name: COLUMN t_norma.anio; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_norma.anio IS 'Año de la Legislación';


--
-- Name: COLUMN t_norma.para_informe; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_norma.para_informe IS 'Indica si se utlizará en informe o no , valores: SI o NO';


--
-- Name: COLUMN t_norma.fecha; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_norma.fecha IS 'Fecha de la nomra';


--
-- Name: COLUMN t_norma.id_organismo; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_norma.id_organismo IS 'Id del organismo';


--
-- Name: COLUMN t_norma.id_usuario; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_norma.id_usuario IS 'Id usuario que da de lata la norma';


--
-- Name: COLUMN t_norma.id_rango_norma_int; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_norma.id_rango_norma_int IS 'Id. de rango de norma intermedio';


--
-- Name: COLUMN t_norma.id_rango_norma_inf; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_norma.id_rango_norma_inf IS 'Id. de rango  de norma de nivel Inferior';


--
-- Name: COLUMN t_norma.id_aplicacion; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_norma.id_aplicacion IS 'Id. de la plación que dio de alta la legislacion';


--
-- Name: COLUMN t_norma.id_visible; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_norma.id_visible IS 'Campo para indicar si es visible o no la norma en la parte pública. 1 significa que si, 0 no es visible. Por defecto 1';


--
-- Name: t_nut; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_nut (
    id_ccaa integer NOT NULL,
    cod_nut2 character varying(100) NOT NULL,
    nombre character varying(300),
    id_nut1 integer,
    fecha_creacion timestamp without time zone,
    fecha_modificacion timestamp without time zone,
    id_usuario_crea_registro integer,
    id_usuario_modifica_registro integer,
    id_nut integer
);


ALTER TABLE comun.t_nut OWNER TO iepnb;

--
-- Name: t_organismo; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_organismo (
    id_organismo numeric(20,0) DEFAULT nextval('comun.sec_organismos'::regclass) NOT NULL,
    nombre character varying(250) NOT NULL,
    descripcion character varying(500),
    nombre_corto character varying(250),
    correo_electronico character varying(500),
    fecha_creacion timestamp without time zone,
    fecha_modificacion timestamp without time zone,
    id_usuario_crea_registro integer,
    id_usuario_modifica_registro integer,
    nif character varying(9),
    id_tipo_organismo integer,
    id_ambito_nivel_geografico_politico integer NOT NULL,
    legislar smallint DEFAULT 0 NOT NULL
);


ALTER TABLE comun.t_organismo OWNER TO iepnb;

--
-- Name: TABLE t_organismo; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON TABLE comun.t_organismo IS 'Tabla con todos los  organismos a los que pertenecen los usuarios';


--
-- Name: COLUMN t_organismo.id_organismo; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_organismo.id_organismo IS 'Identificador del organismo';


--
-- Name: COLUMN t_organismo.nombre; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_organismo.nombre IS 'Nombre del organismo';


--
-- Name: COLUMN t_organismo.descripcion; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_organismo.descripcion IS 'Descripción del organismo';


--
-- Name: COLUMN t_organismo.nombre_corto; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_organismo.nombre_corto IS 'Nombre reducido, para mostrr en  la web';


--
-- Name: COLUMN t_organismo.correo_electronico; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_organismo.correo_electronico IS 'Dirección de correo';


--
-- Name: COLUMN t_organismo.nif; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_organismo.nif IS 'Nif/cif del organismo';


--
-- Name: COLUMN t_organismo.id_tipo_organismo; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_organismo.id_tipo_organismo IS 'Tipo de organismo';


--
-- Name: COLUMN t_organismo.id_ambito_nivel_geografico_politico; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_organismo.id_ambito_nivel_geografico_politico IS 'Este campo indica el id del ambito del nivel geografico político';


--
-- Name: COLUMN t_organismo.legislar; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_organismo.legislar IS 'Este campo indica si el organismo tiene poder legislativo o no';


--
-- Name: t_origen; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_origen (
    idorigen integer NOT NULL,
    origen character varying
);


ALTER TABLE comun.t_origen OWNER TO iepnb;

--
-- Name: t_parametro_configuracion; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_parametro_configuracion (
    id_parametro integer DEFAULT nextval('comun.sec_parametro_configuracion'::regclass) NOT NULL,
    id_aplicacion integer,
    nombre character varying(100) NOT NULL,
    valor character varying(300) NOT NULL,
    descripcion character varying(300),
    encriptado smallint DEFAULT 0 NOT NULL,
    fecha_creacion timestamp without time zone,
    fecha_modificacion timestamp without time zone,
    id_usuario_crea_registro integer,
    id_usuario_modifica_registro integer
);


ALTER TABLE comun.t_parametro_configuracion OWNER TO iepnb;

--
-- Name: TABLE t_parametro_configuracion; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON TABLE comun.t_parametro_configuracion IS 'Tabla de auditoría de t_parametro_configuracion';


--
-- Name: COLUMN t_parametro_configuracion.id_parametro; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_parametro_configuracion.id_parametro IS 'Identificador del parámetro';


--
-- Name: COLUMN t_parametro_configuracion.id_aplicacion; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_parametro_configuracion.id_aplicacion IS 'Identificador de la aplicacion';


--
-- Name: COLUMN t_parametro_configuracion.nombre; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_parametro_configuracion.nombre IS 'Nombre del parámetro';


--
-- Name: COLUMN t_parametro_configuracion.valor; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_parametro_configuracion.valor IS 'Se corresponde con el contenido del parámetro';


--
-- Name: COLUMN t_parametro_configuracion.descripcion; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_parametro_configuracion.descripcion IS 'Breve descripción del uso del pámetro';


--
-- Name: COLUMN t_parametro_configuracion.encriptado; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_parametro_configuracion.encriptado IS 'Este campo indica si el parámetro está encriptado o no, 1 indica que si está encriptado, mientras que 0 hace referencia a que no lo está';


--
-- Name: COLUMN t_parametro_configuracion.fecha_creacion; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_parametro_configuracion.fecha_creacion IS 'Fecha de creación del registro';


--
-- Name: COLUMN t_parametro_configuracion.fecha_modificacion; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_parametro_configuracion.fecha_modificacion IS 'Fecha de modificación del registro';


--
-- Name: COLUMN t_parametro_configuracion.id_usuario_crea_registro; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_parametro_configuracion.id_usuario_crea_registro IS 'Identificador del usuario que crea el registro';


--
-- Name: COLUMN t_parametro_configuracion.id_usuario_modifica_registro; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_parametro_configuracion.id_usuario_modifica_registro IS 'Identificador del usuario que  modifica el registro';


--
-- Name: t_perfil; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_perfil (
    id_perfil smallint DEFAULT nextval('comun.sec_perfil'::regclass) NOT NULL,
    id_aplicacion integer,
    descripcion character varying(250),
    etiqueta character varying(250),
    fecha_creacion timestamp without time zone,
    fecha_modificacion timestamp without time zone,
    id_usuario_crea_registro integer,
    id_usuario_modifica_registro integer,
    es_estandar smallint DEFAULT 0 NOT NULL
);


ALTER TABLE comun.t_perfil OWNER TO iepnb;

--
-- Name: TABLE t_perfil; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON TABLE comun.t_perfil IS 'Tabla con los perfiles de todos los sitemas del iepnb';


--
-- Name: COLUMN t_perfil.id_perfil; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_perfil.id_perfil IS 'Identificador del pperfil';


--
-- Name: COLUMN t_perfil.id_aplicacion; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_perfil.id_aplicacion IS 'Identificador de la aplicación ala que pertenece la funcionalidad';


--
-- Name: COLUMN t_perfil.descripcion; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_perfil.descripcion IS 'Descripción del perfil';


--
-- Name: COLUMN t_perfil.etiqueta; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_perfil.etiqueta IS 'Literal a sacar enla interfaz de usuario';


--
-- Name: COLUMN t_perfil.es_estandar; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_perfil.es_estandar IS 'Este campo indica si es un perfil estándar o no, 1 indica que si, mientras que 0 hace referencia a que no lo es';


--
-- Name: t_presion_amenaza; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_presion_amenaza (
    id_presion numeric(20,0) NOT NULL,
    cod_presion character varying(100),
    nombre character varying(500) NOT NULL,
    id_fuente_catalogo numeric(20,0),
    id_nivel numeric(6,0),
    id_padre numeric(20,0),
    fecha_creacion timestamp without time zone,
    fecha_modificacion timestamp without time zone,
    id_usuario_crea_registro integer,
    id_usuario_modifica_registro integer,
    nombre_en character varying(500)
);


ALTER TABLE comun.t_presion_amenaza OWNER TO iepnb;

--
-- Name: t_provincia; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_provincia (
    id_provincia numeric(4,0) NOT NULL,
    nombre character varying(500) NOT NULL,
    id_ccaa integer NOT NULL,
    codigo_nuts2 character(4) NOT NULL,
    codigo_nuts3 character(5),
    fecha_creacion timestamp without time zone,
    fecha_modificacion timestamp without time zone,
    id_usuario_crea_registro integer,
    id_usuario_modifica_registro integer
);


ALTER TABLE comun.t_provincia OWNER TO iepnb;

--
-- Name: t_punto_cardinal; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_punto_cardinal (
    cod_cardinal character varying(10) NOT NULL,
    nombre character varying(250) NOT NULL,
    acronimo character varying(10)
);


ALTER TABLE comun.t_punto_cardinal OWNER TO iepnb;

--
-- Name: t_rango_norma_inf; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_rango_norma_inf (
    id_rango_norma integer NOT NULL,
    rango_norma character varying(200) NOT NULL,
    id_rango_sup integer NOT NULL,
    id_rango_int integer NOT NULL,
    descripcion character varying(750),
    fecha_creacion timestamp without time zone,
    fecha_modificacion timestamp without time zone,
    id_usuario_crea_registro integer,
    id_usuario_modifica_registro integer
);


ALTER TABLE comun.t_rango_norma_inf OWNER TO iepnb;

--
-- Name: t_rango_norma_int; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_rango_norma_int (
    id_rango_norma integer NOT NULL,
    rango_norma character varying(200) NOT NULL,
    id_rango_sup integer NOT NULL,
    descripcion character varying(750),
    fecha_creacion timestamp without time zone,
    fecha_modificacion timestamp without time zone,
    id_usuario_crea_registro integer,
    id_usuario_modifica_registro integer
);


ALTER TABLE comun.t_rango_norma_int OWNER TO iepnb;

--
-- Name: t_rango_norma_sup; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_rango_norma_sup (
    id_rango_norma integer NOT NULL,
    rango_norma character varying(200) NOT NULL,
    descripcion character varying(750),
    fecha_creacion timestamp without time zone,
    fecha_modificacion timestamp without time zone,
    id_usuario_crea_registro integer,
    id_usuario_modifica_registro integer
);


ALTER TABLE comun.t_rango_norma_sup OWNER TO iepnb;

--
-- Name: taxonnombre; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.taxonnombre (
    idtaxon numeric(40,0) NOT NULL,
    iddataset numeric(40,0) NOT NULL,
    idtaxonnombre bigint NOT NULL,
    idnombre numeric(40,0) NOT NULL,
    espreferente boolean,
    url character varying(1000),
    fecha_alta date,
    fecha_baja date,
    idvigente bigint NOT NULL,
    idtiponombre bigint NOT NULL,
    id_ambito_es integer NOT NULL,
    id_tipo_cambio integer
);


ALTER TABLE especie.taxonnombre OWNER TO iepnb;

--
-- Name: COLUMN taxonnombre.idtaxon; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxonnombre.idtaxon IS 'Identificador único de cada taxón';


--
-- Name: COLUMN taxonnombre.iddataset; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxonnombre.iddataset IS 'Id. del conjunto de datos del que proviene la información.';


--
-- Name: COLUMN taxonnombre.idnombre; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxonnombre.idnombre IS 'Id. del nombre utilizado para referirse a un determinado taxon en una colección dada.';


--
-- Name: COLUMN taxonnombre.espreferente; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxonnombre.espreferente IS 'Indica el nombre común considerado preferente para un taxon y un idioma dado.';


--
-- Name: COLUMN taxonnombre.url; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxonnombre.url IS 'Link a la ficha del taxon para un dataset concreto';


--
-- Name: COLUMN taxonnombre.fecha_alta; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxonnombre.fecha_alta IS 'Fecha de alta del taxon en la BDD.';


--
-- Name: COLUMN taxonnombre.fecha_baja; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxonnombre.fecha_baja IS 'Fecha de baja del taxon (por pasar a considerarse sinónimo...)';


--
-- Name: COLUMN taxonnombre.idvigente; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxonnombre.idvigente IS 'Indica la vigecia de la relación del taxon con un nombre concreto.';


--
-- Name: COLUMN taxonnombre.id_tipo_cambio; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxonnombre.id_tipo_cambio IS 'Tipo de cambio efectuado';


--
-- Name: sec_id_taxonnombre; Type: SEQUENCE; Schema: especie; Owner: iepnb
--

CREATE SEQUENCE especie.sec_id_taxonnombre
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE especie.sec_id_taxonnombre OWNER TO iepnb;

--
-- Name: sec_id_taxonnombre; Type: SEQUENCE OWNED BY; Schema: especie; Owner: iepnb
--

ALTER SEQUENCE especie.sec_id_taxonnombre OWNED BY especie.taxonnombre.idtaxonnombre;


--
-- Name: t_ref_bibliografica; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_ref_bibliografica (
    idreferencia numeric(20,0) NOT NULL,
    referencia character varying(70000),
    idfuente integer,
    id integer DEFAULT nextval('especie.sec_id_taxonnombre'::regclass),
    idtipo_publicacion integer,
    titulo character varying(5000),
    subtitulo character varying(5000),
    paginas character varying(9999),
    pagina_inicial character varying(9999),
    pagina_final character varying(9999),
    volumen character varying(5000),
    edicion character varying(5000),
    editorial character varying(5000),
    lista_autores character varying(5000),
    creado character varying(5000),
    ididioma integer,
    uri character varying(70000),
    doi character varying(70000)
);


ALTER TABLE comun.t_ref_bibliografica OWNER TO iepnb;

--
-- Name: t_region_biogeografica; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_region_biogeografica (
    id_region numeric(2,0) NOT NULL,
    id_localid character(4),
    region_classification_value character varying(4),
    name_rbiogeografica character varying(50),
    fecha_creacion timestamp without time zone,
    fecha_modificacion timestamp without time zone,
    id_usuario_crea_registro integer,
    id_usuario_modifica_registro integer
);


ALTER TABLE comun.t_region_biogeografica OWNER TO iepnb;

--
-- Name: t_relacion_espacial; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_relacion_espacial (
    id_relacion smallint NOT NULL,
    nb_relacion character varying(20),
    cd_relacion character varying(1),
    fecha_creacion timestamp without time zone,
    fecha_modificacion timestamp without time zone,
    id_usuario_crea_registro integer,
    id_usuario_modifica_registro integer
);


ALTER TABLE comun.t_relacion_espacial OWNER TO iepnb;

--
-- Name: t_sexo; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_sexo (
    id_sexo integer NOT NULL,
    sexo character varying(50)
);


ALTER TABLE comun.t_sexo OWNER TO iepnb;

--
-- Name: t_sist_coordenadas; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_sist_coordenadas (
    idsistcoord numeric(40,0) NOT NULL,
    verbatimcoordinatesystem character varying(100),
    verbatimsrs character varying(20),
    footprintsrs character varying(500)
);


ALTER TABLE comun.t_sist_coordenadas OWNER TO iepnb;

--
-- Name: t_tema; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_tema (
    id_tema smallint NOT NULL,
    tema character varying(200),
    fecha_creacion timestamp without time zone,
    fecha_modificacion timestamp without time zone,
    id_usuario_crea_registro integer,
    id_usuario_modifica_registro integer
);


ALTER TABLE comun.t_tema OWNER TO iepnb;

--
-- Name: COLUMN t_tema.id_tema; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_tema.id_tema IS 'ID DEL TEMA';


--
-- Name: COLUMN t_tema.tema; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_tema.tema IS 'NOMBRE DEL TEMA';


--
-- Name: t_tipo_cambio; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_tipo_cambio (
    id_tipo_cambio integer NOT NULL,
    nombre character varying(250),
    descripcion text
);


ALTER TABLE comun.t_tipo_cambio OWNER TO iepnb;

--
-- Name: t_tipo_documento; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_tipo_documento (
    id_tipo_documento integer NOT NULL,
    nombre character varying,
    observaciones text
);


ALTER TABLE comun.t_tipo_documento OWNER TO iepnb;

--
-- Name: t_tipo_especif_valor_texto; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_tipo_especif_valor_texto (
    id_especificacion numeric(20,0) NOT NULL,
    id_valor_texto bigint NOT NULL
);


ALTER TABLE comun.t_tipo_especif_valor_texto OWNER TO iepnb;

--
-- Name: t_tipo_especificacion; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_tipo_especificacion (
    id_especificacion numeric(20,0) NOT NULL,
    especificacion character varying(200),
    descripcion text,
    id_agrupa numeric(6,0),
    texto_o_num character varying(1),
    id_padre_especificacion bigint
);


ALTER TABLE comun.t_tipo_especificacion OWNER TO iepnb;

--
-- Name: t_tipo_estado_conservacion; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_tipo_estado_conservacion (
    cod_conservacion character varying(2),
    nombre character varying(100) NOT NULL,
    nombre_en character varying(100),
    id_tipo_conservacion integer NOT NULL,
    id_aplicacion integer
);


ALTER TABLE comun.t_tipo_estado_conservacion OWNER TO iepnb;

--
-- Name: t_tipo_geometria_carto; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_tipo_geometria_carto (
    id_tipo_geometria_carto numeric(6,0) NOT NULL,
    nombre character varying(50),
    descripcion text
);


ALTER TABLE comun.t_tipo_geometria_carto OWNER TO iepnb;

--
-- Name: COLUMN t_tipo_geometria_carto.id_tipo_geometria_carto; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_tipo_geometria_carto.id_tipo_geometria_carto IS 'Identificador del tipo de geometria en el GIS.
1- punto, 2- linea, 3- plígono';


--
-- Name: COLUMN t_tipo_geometria_carto.nombre; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_tipo_geometria_carto.nombre IS 'Nombre del tipo de cartografía';


--
-- Name: COLUMN t_tipo_geometria_carto.descripcion; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_tipo_geometria_carto.descripcion IS 'Descripción del tipo de geometria cartográfica del GIS.';


--
-- Name: t_tipo_medic_valor_texto; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_tipo_medic_valor_texto (
    id_tipo_medicion numeric(20,0) NOT NULL,
    id_valor_texto numeric(38,0) NOT NULL
);


ALTER TABLE comun.t_tipo_medic_valor_texto OWNER TO iepnb;

--
-- Name: COLUMN t_tipo_medic_valor_texto.id_tipo_medicion; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_tipo_medic_valor_texto.id_tipo_medicion IS 'Id. del tipo de medición';


--
-- Name: COLUMN t_tipo_medic_valor_texto.id_valor_texto; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_tipo_medic_valor_texto.id_valor_texto IS 'Id. del valor tipo texto. FK a T_TIPO_VALOR_TEXTO';


--
-- Name: t_tipo_medicion; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_tipo_medicion (
    id_tipo_medicion numeric(20,0) NOT NULL,
    nombre character varying(200),
    descripcion text,
    id_agrupa numeric(6,0),
    texto_o_num character varying(1),
    id_tipo_geometria_carto numeric(6,0),
    id_padre_tipo_medicion bigint,
    id_aplicacion integer,
    multiple boolean
);


ALTER TABLE comun.t_tipo_medicion OWNER TO iepnb;

--
-- Name: COLUMN t_tipo_medicion.id_tipo_medicion; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_tipo_medicion.id_tipo_medicion IS 'Id del tipo d emedición, por ejemplo altitud, poblacion larvaria, etc..';


--
-- Name: COLUMN t_tipo_medicion.nombre; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_tipo_medicion.nombre IS 'Nombre de la medición';


--
-- Name: COLUMN t_tipo_medicion.descripcion; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_tipo_medicion.descripcion IS 'Descripción de la medición';


--
-- Name: COLUMN t_tipo_medicion.id_agrupa; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_tipo_medicion.id_agrupa IS 'Id de agrupación que pueda ser necesaria. FK a TSEG_AGRUP_MEDICION';


--
-- Name: COLUMN t_tipo_medicion.texto_o_num; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_tipo_medicion.texto_o_num IS 'Indiica si sera una valor numerico (N) o texto (T), lo que implica que tamblas mirar si la de unidades o la de texto valor.';


--
-- Name: COLUMN t_tipo_medicion.id_tipo_geometria_carto; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_tipo_medicion.id_tipo_geometria_carto IS 'Id. del tipo de capa GIS que se va asocia a al medición, punto, linea o area o poligono';


--
-- Name: COLUMN t_tipo_medicion.id_aplicacion; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_tipo_medicion.id_aplicacion IS 'Identificador de la aplicación que da alta la medida';


--
-- Name: t_tipo_norma; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_tipo_norma (
    id_tiponorma numeric(4,0) NOT NULL,
    nb_tiponorma character varying(30),
    ds_tiponorma character varying(300),
    fecha_creacion timestamp without time zone,
    fecha_modificacion timestamp without time zone,
    id_usuario_crea_registro integer,
    id_usuario_modifica_registro integer
);


ALTER TABLE comun.t_tipo_norma OWNER TO iepnb;

--
-- Name: t_tipo_organismo; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_tipo_organismo (
    id_tipo_organismo integer NOT NULL,
    nombre character varying(255)
);


ALTER TABLE comun.t_tipo_organismo OWNER TO iepnb;

--
-- Name: TABLE t_tipo_organismo; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON TABLE comun.t_tipo_organismo IS 'Tabla con las funcionalidades de todos los sitemas del iepnb';


--
-- Name: COLUMN t_tipo_organismo.id_tipo_organismo; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_tipo_organismo.id_tipo_organismo IS 'Identificador del tipo de organismo';


--
-- Name: COLUMN t_tipo_organismo.nombre; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_tipo_organismo.nombre IS 'Nombre del tipo de organismo';


--
-- Name: t_tipo_plan; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_tipo_plan (
    id_tipo_plan integer DEFAULT nextval('comun.sec_t_tipo_plan'::regclass) NOT NULL,
    nombre character varying(100),
    descripcion character varying(500)
);


ALTER TABLE comun.t_tipo_plan OWNER TO iepnb;

--
-- Name: t_tipo_relacion_norma; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_tipo_relacion_norma (
    id_tipo_relacion_norma integer NOT NULL,
    nombre character varying(200) NOT NULL,
    descripcion text,
    fecha_creacion timestamp without time zone,
    fecha_modificacion timestamp without time zone,
    id_usuario_crea_registro integer,
    id_usuario_modifica_registro integer
);


ALTER TABLE comun.t_tipo_relacion_norma OWNER TO iepnb;

--
-- Name: COLUMN t_tipo_relacion_norma.id_tipo_relacion_norma; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_tipo_relacion_norma.id_tipo_relacion_norma IS 'Identificador del tipo de relación';


--
-- Name: COLUMN t_tipo_relacion_norma.nombre; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_tipo_relacion_norma.nombre IS 'Nombre del tipo';


--
-- Name: COLUMN t_tipo_relacion_norma.descripcion; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_tipo_relacion_norma.descripcion IS 'Descripción del tipo';


--
-- Name: t_tipo_relieve; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_tipo_relieve (
    id_tipo_relieve integer NOT NULL,
    nombre character varying,
    cod_tipo_ambito character varying(2)
);


ALTER TABLE comun.t_tipo_relieve OWNER TO iepnb;

--
-- Name: TABLE t_tipo_relieve; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON TABLE comun.t_tipo_relieve IS 'Tipos de relieve existetes';


--
-- Name: t_tipo_toponimia; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_tipo_toponimia (
    id_tipo_toponimia integer NOT NULL,
    nombre character varying(100) NOT NULL,
    descripcion character varying
);


ALTER TABLE comun.t_tipo_toponimia OWNER TO iepnb;

--
-- Name: TABLE t_tipo_toponimia; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON TABLE comun.t_tipo_toponimia IS 'Tipos de toponimios existentes';


--
-- Name: COLUMN t_tipo_toponimia.id_tipo_toponimia; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_tipo_toponimia.id_tipo_toponimia IS 'Id del tipo de toponimia';


--
-- Name: t_tipo_verificacion_documento; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_tipo_verificacion_documento (
    id_tipo_verificacion_documento integer NOT NULL,
    nombre character varying(200),
    acronimo character varying(10) NOT NULL,
    descripcion character varying(200)
);


ALTER TABLE comun.t_tipo_verificacion_documento OWNER TO iepnb;

--
-- Name: TABLE t_tipo_verificacion_documento; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON TABLE comun.t_tipo_verificacion_documento IS 'Tabla con los tipos de verificación de un documento';


--
-- Name: COLUMN t_tipo_verificacion_documento.id_tipo_verificacion_documento; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_tipo_verificacion_documento.id_tipo_verificacion_documento IS 'Identificador del tipo de verificación';


--
-- Name: COLUMN t_tipo_verificacion_documento.nombre; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_tipo_verificacion_documento.nombre IS 'Nombre del acrónimo';


--
-- Name: COLUMN t_tipo_verificacion_documento.acronimo; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_tipo_verificacion_documento.acronimo IS 'Acrónimo del tipo de verificación';


--
-- Name: COLUMN t_tipo_verificacion_documento.descripcion; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_tipo_verificacion_documento.descripcion IS 'Descripción del acrónimo';


--
-- Name: t_tipopropiedad; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_tipopropiedad (
    id_tipopropiedad smallint NOT NULL,
    nb_tipopropiedad character varying(100),
    fecha_creacion timestamp without time zone,
    fecha_modificacion timestamp without time zone,
    id_usuario_crea_registro integer,
    id_usuario_modifica_registro integer
);


ALTER TABLE comun.t_tipopropiedad OWNER TO iepnb;

--
-- Name: t_unidad; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_unidad (
    id_unidad numeric(20,0) NOT NULL,
    nombre character varying(100) NOT NULL,
    otro_nombre character varying(100),
    descripcion text,
    fecha_creacion timestamp without time zone,
    fecha_modificacion timestamp without time zone,
    id_usuario_crea_registro integer,
    id_usuario_modifica_registro integer
);


ALTER TABLE comun.t_unidad OWNER TO iepnb;

--
-- Name: COLUMN t_unidad.id_unidad; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_unidad.id_unidad IS 'Id de la unidad de medida';


--
-- Name: COLUMN t_unidad.nombre; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_unidad.nombre IS 'Nombre de la medida';


--
-- Name: COLUMN t_unidad.otro_nombre; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_unidad.otro_nombre IS 'Acrónimo o otra literal que se queira mostrar en lugar delnombre';


--
-- Name: COLUMN t_unidad.descripcion; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_unidad.descripcion IS 'Descripción de la unidad';


--
-- Name: t_unidad_otra_codif; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_unidad_otra_codif (
    id_unidad numeric(20,0) NOT NULL,
    cod_unidad_otro_sist character varying(100),
    id_unidad_otro_sistema numeric(20,0),
    fecha_creacion timestamp without time zone,
    fecha_modificacion timestamp without time zone,
    id_usuario_crea_registro integer,
    id_usuario_modifica_registro integer,
    id_aplicacion integer NOT NULL
);


ALTER TABLE comun.t_unidad_otra_codif OWNER TO iepnb;

--
-- Name: TABLE t_unidad_otra_codif; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON TABLE comun.t_unidad_otra_codif IS 'En esta tbal se relaciona el catalog de unidades con las codificaciónes en otros sistemas';


--
-- Name: COLUMN t_unidad_otra_codif.id_unidad; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_unidad_otra_codif.id_unidad IS 'ID de la unidad';


--
-- Name: COLUMN t_unidad_otra_codif.cod_unidad_otro_sist; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_unidad_otra_codif.cod_unidad_otro_sist IS 'Codigo de la unidad';


--
-- Name: t_usuario; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_usuario (
    id_usuario integer NOT NULL,
    nombre character varying(50) NOT NULL,
    apellido1 character varying(100),
    apellido2 character varying(100),
    nif character varying(25),
    tlf1 numeric(22,0),
    tlf2 numeric(22,0),
    mail character varying(50) NOT NULL,
    observaciones character varying(50),
    activo smallint NOT NULL,
    username character varying(50),
    password character varying(500),
    fecha_creacion timestamp without time zone,
    fecha_modificacion timestamp without time zone,
    id_organismo integer,
    es_empresa integer,
    id_usuario_crea_registro integer,
    id_usuario_modifica_registro integer
);


ALTER TABLE comun.t_usuario OWNER TO iepnb;

--
-- Name: TABLE t_usuario; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON TABLE comun.t_usuario IS 'Tabla con los usuarios de la aplicación';


--
-- Name: COLUMN t_usuario.id_usuario; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_usuario.id_usuario IS 'Identificador del usuario';


--
-- Name: COLUMN t_usuario.nombre; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_usuario.nombre IS 'Nombre del usuario';


--
-- Name: COLUMN t_usuario.es_empresa; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_usuario.es_empresa IS 'Campo que indica que los datos vien de un certificado de empresa';


--
-- Name: t_valor_medida; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_valor_medida (
    id_valor_medida numeric NOT NULL,
    valor character varying,
    id_tipo_medicion numeric
);


ALTER TABLE comun.t_valor_medida OWNER TO iepnb;

--
-- Name: t_valor_texto; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_valor_texto (
    id_valor_texto numeric(38,0) NOT NULL,
    nombre_valor character varying(150),
    descripcion text,
    id_agrupacion numeric(6,0),
    nombre_valor_en character varying(150)
);


ALTER TABLE comun.t_valor_texto OWNER TO iepnb;

--
-- Name: TABLE t_valor_texto; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON TABLE comun.t_valor_texto IS 'Tabla catálogo de los valores texto posibles, por ejmplo "Bueno", "Representativo", "Invernante", etc...';


--
-- Name: COLUMN t_valor_texto.id_valor_texto; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_valor_texto.id_valor_texto IS 'Id del valor texto';


--
-- Name: COLUMN t_valor_texto.nombre_valor; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_valor_texto.nombre_valor IS 'Texto corrsegondiente, por ejemplo" bueno"," alto", etc...';


--
-- Name: COLUMN t_valor_texto.descripcion; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_valor_texto.descripcion IS 'Descripción del valor';


--
-- Name: COLUMN t_valor_texto.id_agrupacion; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_valor_texto.id_agrupacion IS 'Id de agurpacion si es necesario';


--
-- Name: t_valor_texto_otra_codif; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_valor_texto_otra_codif (
    id_valor_texto bigint NOT NULL,
    cod_unidad_otro_sist character varying(50) NOT NULL,
    id_valor_texto_otro_sistema numeric(20,0),
    id_aplicacion integer NOT NULL,
    otro_nombre character varying(200)
);


ALTER TABLE comun.t_valor_texto_otra_codif OWNER TO iepnb;

--
-- Name: COLUMN t_valor_texto_otra_codif.id_aplicacion; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.t_valor_texto_otra_codif.id_aplicacion IS 'Id. de la aplicación';


--
-- Name: sec_id_vigencia; Type: SEQUENCE; Schema: especie; Owner: iepnb
--

CREATE SEQUENCE especie.sec_id_vigencia
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE especie.sec_id_vigencia OWNER TO iepnb;

--
-- Name: t_vigente; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_vigente (
    idvigente bigint NOT NULL,
    id bigint DEFAULT nextval('especie.sec_id_vigencia'::regclass),
    vigencia character varying
);


ALTER TABLE comun.t_vigente OWNER TO iepnb;

--
-- Name: t_visible; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.t_visible (
    idvisible integer DEFAULT nextval('comun.sec_visible'::regclass) NOT NULL,
    visible character varying(15)
);


ALTER TABLE comun.t_visible OWNER TO iepnb;

--
-- Name: unidad_tipo_medicion; Type: TABLE; Schema: comun; Owner: iepnb
--

CREATE TABLE comun.unidad_tipo_medicion (
    id_unidad numeric(20,0) NOT NULL,
    id_tipo_medicion numeric(38,0) NOT NULL,
    id_aplicacion integer,
    fecha_creacion timestamp without time zone,
    fecha_modificacion timestamp without time zone,
    id_usuario_crea_registro integer,
    id_usuario_modifica_registro integer,
    cod_especific character varying(50),
    id_especific integer
);


ALTER TABLE comun.unidad_tipo_medicion OWNER TO iepnb;

--
-- Name: TABLE unidad_tipo_medicion; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON TABLE comun.unidad_tipo_medicion IS 'Tabla donde se relaciona el tipo de medición con sus unidades posibles. La pk incluye el id de aplición, si la realción es para cualqueir aplicación se pondra el id de aplicación del portal.';


--
-- Name: COLUMN unidad_tipo_medicion.id_unidad; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.unidad_tipo_medicion.id_unidad IS 'Id de la unidad';


--
-- Name: COLUMN unidad_tipo_medicion.id_tipo_medicion; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.unidad_tipo_medicion.id_tipo_medicion IS 'Id. del tipo de medida';


--
-- Name: COLUMN unidad_tipo_medicion.id_aplicacion; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.unidad_tipo_medicion.id_aplicacion IS 'Id. de la aplicación';


--
-- Name: COLUMN unidad_tipo_medicion.cod_especific; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.unidad_tipo_medicion.cod_especific IS 'Código identificativo de la unicad en el sitemas correspondiente';


--
-- Name: COLUMN unidad_tipo_medicion.id_especific; Type: COMMENT; Schema: comun; Owner: iepnb
--

COMMENT ON COLUMN comun.unidad_tipo_medicion.id_especific IS 'Id. especifico de la unidad en la apicalción correspondiente';


--
-- Name: v_t_parametro_configuracion; Type: VIEW; Schema: comun; Owner: iepnb
--

CREATE VIEW comun.v_t_parametro_configuracion AS
 SELECT nombre AS "KEY",
    valor AS "VALUE",
    'iepnb'::text AS "APPLICATION",
        CASE
            WHEN (id_aplicacion IS NULL) THEN 'default'::text
            ELSE (id_aplicacion)::text
        END AS "PROFILE",
    'v1'::text AS "LABEL"
   FROM comun.t_parametro_configuracion tpc;


ALTER VIEW comun.v_t_parametro_configuracion OWNER TO iepnb;

--
-- Name: atributo_taxon; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.atributo_taxon (
    idtaxon numeric(40,0) NOT NULL,
    id_atributo bigint NOT NULL,
    id_tipo_atributo integer,
    valor_atributo numeric,
    id_unidad_atributo integer,
    id_metodo_medida_atributo integer,
    id_precision_medidad_atributo integer,
    id_aplicado_a integer NOT NULL,
    fecha date,
    observaciones character varying,
    id_aplica_a integer,
    id_coleccion integer,
    id_atributo_valor bigint
);


ALTER TABLE especie.atributo_taxon OWNER TO iepnb;

--
-- Name: endemismo; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.endemismo (
    idendemismo numeric(40,0) NOT NULL,
    idendemicoen integer NOT NULL,
    idtaxon numeric(40,0) NOT NULL,
    iddataset numeric(40,0) NOT NULL,
    observaciones character varying(1000),
    idvigente bigint DEFAULT 1 NOT NULL,
    fecha_creacion timestamp without time zone,
    fecha_modificacion timestamp without time zone,
    id_usuario_crea_registro integer,
    id_usuario_modifica_registro integer,
    fecha_alta date,
    fecha_baja date,
    id_tipo_cambio integer DEFAULT 1 NOT NULL
);


ALTER TABLE especie.endemismo OWNER TO iepnb;

--
-- Name: TABLE endemismo; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON TABLE especie.endemismo IS 'https://github.com/tdwg/PlinianCore/wiki/EndemicType
Tabla que almacena taxones y sus localizaciones cuando estos viven exclusivamente en un territorio determinado sin que puedan encontrarse en ningún otro lugar.';


--
-- Name: COLUMN endemismo.idendemismo; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.endemismo.idendemismo IS 'Id. único de la tabla.';


--
-- Name: COLUMN endemismo.idendemicoen; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.endemismo.idendemicoen IS 'Id. áreas de endemismo.';


--
-- Name: COLUMN endemismo.idtaxon; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.endemismo.idtaxon IS 'Id. de taxon.';


--
-- Name: COLUMN endemismo.iddataset; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.endemismo.iddataset IS 'Id. del conjunto de datos del que proviene la información.';


--
-- Name: COLUMN endemismo.idvigente; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.endemismo.idvigente IS 'Id de vigencia respecto al taxon';


--
-- Name: COLUMN endemismo.fecha_creacion; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.endemismo.fecha_creacion IS 'Fecha de creación del registro';


--
-- Name: COLUMN endemismo.fecha_modificacion; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.endemismo.fecha_modificacion IS 'Fecha de modificación del registro';


--
-- Name: COLUMN endemismo.id_usuario_crea_registro; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.endemismo.id_usuario_crea_registro IS 'Usuario creador del registro';


--
-- Name: COLUMN endemismo.id_usuario_modifica_registro; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.endemismo.id_usuario_modifica_registro IS 'Usuario modificador del registro';


--
-- Name: COLUMN endemismo.fecha_alta; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.endemismo.fecha_alta IS 'Fecha de alta del registro';


--
-- Name: COLUMN endemismo.fecha_baja; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.endemismo.fecha_baja IS 'Fecha de baja del registro';


--
-- Name: COLUMN endemismo.id_tipo_cambio; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.endemismo.id_tipo_cambio IS 'Tipo de cambio efectuado';


--
-- Name: sec_id_grupocoleccion; Type: SEQUENCE; Schema: especie; Owner: iepnb
--

CREATE SEQUENCE especie.sec_id_grupocoleccion
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE especie.sec_id_grupocoleccion OWNER TO iepnb;

--
-- Name: grupodataset; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.grupodataset (
    idgrupo bigint NOT NULL,
    iddataset numeric(40,0) NOT NULL,
    id bigint DEFAULT nextval('especie.sec_id_grupocoleccion'::regclass)
);


ALTER TABLE especie.grupodataset OWNER TO iepnb;

--
-- Name: COLUMN grupodataset.iddataset; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.grupodataset.iddataset IS 'Id. del conjunto de datos del que proviene la información.';


--
-- Name: grupolegislacion; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.grupolegislacion (
    idgrupo bigint NOT NULL,
    idnorma numeric(40,0) NOT NULL,
    id bigint DEFAULT nextval('especie.sec_id_grupocoleccion'::regclass)
);


ALTER TABLE especie.grupolegislacion OWNER TO iepnb;

--
-- Name: sec_id_taxoncoleccion; Type: SEQUENCE; Schema: especie; Owner: iepnb
--

CREATE SEQUENCE especie.sec_id_taxoncoleccion
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE especie.sec_id_taxoncoleccion OWNER TO iepnb;

--
-- Name: lp_fotofija; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.lp_fotofija (
    idnombre bigint NOT NULL,
    iddataset integer NOT NULL,
    id bigint DEFAULT nextval('especie.sec_id_taxoncoleccion'::regclass),
    fechalp date NOT NULL
);


ALTER TABLE especie.lp_fotofija OWNER TO iepnb;

--
-- Name: lp_fuentereferencias; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.lp_fuentereferencias (
    idorigenlp integer NOT NULL,
    idfuentereferencialp integer NOT NULL
);


ALTER TABLE especie.lp_fuentereferencias OWNER TO iepnb;

--
-- Name: sec_lp_origen; Type: SEQUENCE; Schema: especie; Owner: iepnb
--

CREATE SEQUENCE especie.sec_lp_origen
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE especie.sec_lp_origen OWNER TO iepnb;

--
-- Name: lp_origen; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.lp_origen (
    idnombre numeric(40,0) NOT NULL,
    iddataset numeric(40,0) NOT NULL,
    anioentrada integer,
    idvigente bigint NOT NULL,
    id bigint DEFAULT nextval('especie.sec_lp_origen'::regclass),
    aniosalida integer,
    idorigenlp numeric(40,0) NOT NULL
);


ALTER TABLE especie.lp_origen OWNER TO iepnb;

--
-- Name: lp_sociedades; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.lp_sociedades (
    idorigenlp integer NOT NULL,
    idsociedadlp integer NOT NULL
);


ALTER TABLE especie.lp_sociedades OWNER TO iepnb;

--
-- Name: nombre; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.nombre (
    idnombre numeric(40,0) NOT NULL,
    nombre character varying(250),
    ididioma integer,
    observaciones character varying,
    justificacion character varying,
    fecha_alta date,
    fecha_baja date
);


ALTER TABLE especie.nombre OWNER TO iepnb;

--
-- Name: TABLE nombre; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON TABLE especie.nombre IS 'Catálogo de todos los nombres para referirse a los distintos taxones.';


--
-- Name: COLUMN nombre.idnombre; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.nombre.idnombre IS 'Id. del nombre utilizado para referirse a un determinado taxon.';


--
-- Name: COLUMN nombre.nombre; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.nombre.nombre IS 'Nombre utilizado para referirse a un determinado taxon.';


--
-- Name: COLUMN nombre.ididioma; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.nombre.ididioma IS 'Id. del idioma en el que está el nombre.';


--
-- Name: COLUMN nombre.justificacion; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.nombre.justificacion IS 'Justificación de la sinonimia o la BDD de referencia..';


--
-- Name: sec_id_nombrecodigoexterno; Type: SEQUENCE; Schema: especie; Owner: iepnb
--

CREATE SEQUENCE especie.sec_id_nombrecodigoexterno
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE especie.sec_id_nombrecodigoexterno OWNER TO iepnb;

--
-- Name: nombrecodigosexternos; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.nombrecodigosexternos (
    idnombre numeric(40,0) NOT NULL,
    codigo character varying NOT NULL,
    id integer DEFAULT nextval('especie.sec_id_nombrecodigoexterno'::regclass) NOT NULL,
    iddataset numeric(40,0) NOT NULL,
    fecha_alta date,
    fecha_baja date,
    id_tipo_codigo integer NOT NULL
);


ALTER TABLE especie.nombrecodigosexternos OWNER TO iepnb;

--
-- Name: TABLE nombrecodigosexternos; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON TABLE especie.nombrecodigosexternos IS 'Tabla que almacena los fiferentes códigos asiganados a los taxones: código CITES, EURING, Red Natura..';


--
-- Name: COLUMN nombrecodigosexternos.idnombre; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.nombrecodigosexternos.idnombre IS 'Id. del nombre del taxon';


--
-- Name: COLUMN nombrecodigosexternos.codigo; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.nombrecodigosexternos.codigo IS 'Valor del código del taxon';


--
-- Name: sec_id_grupotax; Type: SEQUENCE; Schema: especie; Owner: iepnb
--

CREATE SEQUENCE especie.sec_id_grupotax
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE especie.sec_id_grupotax OWNER TO iepnb;

--
-- Name: nombrepreferencia; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.nombrepreferencia (
    idnombre numeric(40,0),
    ididioma bigint,
    preferente boolean,
    id integer DEFAULT nextval('especie.sec_id_grupotax'::regclass),
    idnombrepreferente numeric(40,0) NOT NULL,
    column1 character varying
);


ALTER TABLE especie.nombrepreferencia OWNER TO iepnb;

--
-- Name: COLUMN nombrepreferencia.idnombre; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.nombrepreferencia.idnombre IS 'Id. del nombre vernáculo utilizado para referirse a un determinado taxon.';


--
-- Name: sec_id_plinian; Type: SEQUENCE; Schema: especie; Owner: iepnb
--

CREATE SEQUENCE especie.sec_id_plinian
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE especie.sec_id_plinian OWNER TO iepnb;

--
-- Name: pliniancore-extension; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie."pliniancore-extension" (
    idtaxon numeric(40,0) NOT NULL,
    iddataset numeric(40,0) NOT NULL,
    idatributo numeric(40,0) NOT NULL,
    valor character varying,
    id bigint DEFAULT nextval('especie.sec_id_plinian'::regclass),
    idfuente integer NOT NULL,
    prioritario boolean,
    fecha_alta date,
    fecha_baja date,
    idvigente integer,
    url character varying(255),
    id_usuario_crea_registro integer,
    id_usuario_modifica_registro integer,
    fecha_creacion timestamp without time zone,
    fecha_modificacion timestamp without time zone
);


ALTER TABLE especie."pliniancore-extension" OWNER TO iepnb;

--
-- Name: TABLE "pliniancore-extension"; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON TABLE especie."pliniancore-extension" IS 'Tabla que recoge información no estructurada del taxon';


--
-- Name: COLUMN "pliniancore-extension".idtaxon; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie."pliniancore-extension".idtaxon IS 'Id. del taxon.';


--
-- Name: COLUMN "pliniancore-extension".iddataset; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie."pliniancore-extension".iddataset IS 'Id. del conjunto de datos del que proviene la información.';


--
-- Name: COLUMN "pliniancore-extension".idatributo; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie."pliniancore-extension".idatributo IS 'Id. del atributo';


--
-- Name: COLUMN "pliniancore-extension".valor; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie."pliniancore-extension".valor IS 'Información de un taxon según una colección concreta relativa a un atributo  determinado.';


--
-- Name: COLUMN "pliniancore-extension".idfuente; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie."pliniancore-extension".idfuente IS 'Id. de la fuente bibliográfica de la información.';


--
-- Name: COLUMN "pliniancore-extension".prioritario; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie."pliniancore-extension".prioritario IS 'Indica la descripción prioritaria o pricipal del taxon.';


--
-- Name: COLUMN "pliniancore-extension".id_usuario_crea_registro; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie."pliniancore-extension".id_usuario_crea_registro IS 'Id de usuario que ha creado el registro';


--
-- Name: COLUMN "pliniancore-extension".id_usuario_modifica_registro; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie."pliniancore-extension".id_usuario_modifica_registro IS 'Id de usuario que ha modificado el registro';


--
-- Name: COLUMN "pliniancore-extension".fecha_creacion; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie."pliniancore-extension".fecha_creacion IS 'Fecha de creacion del registro';


--
-- Name: COLUMN "pliniancore-extension".fecha_modificacion; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie."pliniancore-extension".fecha_modificacion IS 'Fecha de modificacion del registro';


--
-- Name: poblacion_aplicaa_nut2; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.poblacion_aplicaa_nut2 (
    idpoblacion bigint NOT NULL,
    observacionespoblacion character varying NOT NULL,
    idaplicaa_nut2 bigint NOT NULL,
    excepto_idaplicaa_nut2 bigint NOT NULL,
    excepto_concatenado character varying
);


ALTER TABLE especie.poblacion_aplicaa_nut2 OWNER TO iepnb;

--
-- Name: poblacion_aplicaa_nut2_idpoblacion_seq; Type: SEQUENCE; Schema: especie; Owner: iepnb
--

ALTER TABLE especie.poblacion_aplicaa_nut2 ALTER COLUMN idpoblacion ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME especie.poblacion_aplicaa_nut2_idpoblacion_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: sec_estado_cuadricula; Type: SEQUENCE; Schema: especie; Owner: iepnb
--

CREATE SEQUENCE especie.sec_estado_cuadricula
    START WITH 4
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE especie.sec_estado_cuadricula OWNER TO iepnb;

--
-- Name: sec_id_ubicacion; Type: SEQUENCE; Schema: especie; Owner: iepnb
--

CREATE SEQUENCE especie.sec_id_ubicacion
    START WITH 1083
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE especie.sec_id_ubicacion OWNER TO iepnb;

--
-- Name: t_dataset; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.t_dataset (
    iddataset numeric(40,0) NOT NULL,
    idambitogeografico integer,
    idtiponormativadataset bigint,
    fechapublicacion date,
    url character varying,
    dataset character varying,
    identidaddistr numeric(40,0),
    idtipoambitodistr integer
);


ALTER TABLE especie.t_dataset OWNER TO iepnb;

--
-- Name: COLUMN t_dataset.iddataset; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_dataset.iddataset IS 'Id. de la tabla';


--
-- Name: COLUMN t_dataset.idambitogeografico; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_dataset.idambitogeografico IS 'Clave foránea para relacionar con Ambito geográfico';


--
-- Name: COLUMN t_dataset.idtiponormativadataset; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_dataset.idtiponormativadataset IS 'Clave foránea para relacionar con Tipo Normativa Colección';


--
-- Name: COLUMN t_dataset.fechapublicacion; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_dataset.fechapublicacion IS 'Fecha de la publicación de la colección';


--
-- Name: COLUMN t_dataset.url; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_dataset.url IS 'Url donde se encuentra toda la infromación de la colección';


--
-- Name: COLUMN t_dataset.dataset; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_dataset.dataset IS 'Nombre de la colección';


--
-- Name: COLUMN t_dataset.idtipoambitodistr; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_dataset.idtipoambitodistr IS 'Clave foránea para relacionar con Tipo Ambito Distribución';


--
-- Name: t_estado_cuadricula; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.t_estado_cuadricula (
    idestadocuad numeric(40,0) DEFAULT nextval('especie.sec_estado_cuadricula'::regclass) NOT NULL,
    estadocuad character varying(100),
    observaciones character varying(200)
);


ALTER TABLE especie.t_estado_cuadricula OWNER TO iepnb;

--
-- Name: t_tiponombre; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.t_tiponombre (
    idtiponombre bigint NOT NULL,
    tiponombre character varying,
    definicion character varying,
    observaciones character varying,
    id_agrup_tiponombre bigint
);


ALTER TABLE especie.t_tiponombre OWNER TO iepnb;

--
-- Name: COLUMN t_tiponombre.idtiponombre; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_tiponombre.idtiponombre IS 'Id. de la tabla';


--
-- Name: COLUMN t_tiponombre.tiponombre; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_tiponombre.tiponombre IS 'Descripción del tipo nombre';


--
-- Name: COLUMN t_tiponombre.definicion; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_tiponombre.definicion IS 'Explicación del tipo de nombre';


--
-- Name: COLUMN t_tiponombre.observaciones; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_tiponombre.observaciones IS 'Observaciones';


--
-- Name: COLUMN t_tiponombre.id_agrup_tiponombre; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_tiponombre.id_agrup_tiponombre IS 'Id. de la agrupación del tipo de nombre.';


--
-- Name: taxon; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.taxon (
    idtaxon numeric(40,0) NOT NULL,
    idgrupotax integer,
    idestadotaxon integer,
    id numeric(40,0) NOT NULL,
    idorigen integer,
    fecha_alta date,
    fecha_baja date,
    cod_ambito character varying(2),
    idorigen_canarias integer,
    id_img_fototeca bigint
);


ALTER TABLE especie.taxon OWNER TO iepnb;

--
-- Name: TABLE taxon; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON TABLE especie.taxon IS 'https://dwc.tdwg.org/terms/#taxon';


--
-- Name: COLUMN taxon.fecha_alta; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxon.fecha_alta IS 'Fecha de alta del taxon en la BDD.';


--
-- Name: COLUMN taxon.fecha_baja; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxon.fecha_baja IS 'Fecha de baja del taxon (por pasar a considerarse sinónimo...)';


--
-- Name: COLUMN taxon.idorigen_canarias; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxon.idorigen_canarias IS 'Fecha de alta del registro.';


--
-- Name: taxonubicacion; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.taxonubicacion (
    idubicacion numeric(40,0) DEFAULT nextval('especie.sec_id_ubicacion'::regclass) NOT NULL,
    idtaxon numeric(40,0) NOT NULL,
    iddataset numeric(38,0) NOT NULL,
    countrycode character varying(10),
    idsistcoord numeric(40,0) NOT NULL,
    cuadr character varying(255) NOT NULL,
    tamaniocuadr numeric(38,0),
    idestadocuadr numeric(38,0),
    fecha date NOT NULL,
    y_latitud double precision DEFAULT 0 NOT NULL,
    x_longitud double precision DEFAULT 0 NOT NULL
);


ALTER TABLE especie.taxonubicacion OWNER TO iepnb;

--
-- Name: presencia_cuadriculas; Type: VIEW; Schema: especie; Owner: iepnb
--

CREATE VIEW especie.presencia_cuadriculas AS
 SELECT t.idgrupotax,
    g.nombre AS grupotax,
    t.cod_ambito,
    t.idtaxon,
    m.idnombre,
    n.nombre,
    m.idtiponombre,
    p.tiponombre,
    u.iddataset,
    d.dataset,
    u.cuadr,
    u.tamaniocuadr,
    u.idsistcoord,
    s.verbatimcoordinatesystem,
    e.estadocuad
   FROM (comun.t_sist_coordenadas s
     JOIN (((especie.taxonubicacion u
     JOIN (especie.t_tiponombre p
     JOIN (comun.t_nombre_grupo_taxonomico g
     JOIN (especie.nombre n
     JOIN (especie.taxon t
     JOIN especie.taxonnombre m ON ((t.idtaxon = m.idtaxon))) ON ((n.idnombre = m.idnombre))) ON ((g.id_nombre_grupo_taxon = (t.idgrupotax)::numeric))) ON ((p.idtiponombre = m.idtiponombre))) ON ((u.idtaxon = t.idtaxon)))
     JOIN especie.t_dataset d ON ((u.iddataset = d.iddataset)))
     JOIN especie.t_estado_cuadricula e ON ((u.idestadocuadr = e.idestadocuad))) ON ((s.idsistcoord = u.idsistcoord)))
  WHERE (m.idtiponombre < 20)
  ORDER BY t.idtaxon;


ALTER VIEW especie.presencia_cuadriculas OWNER TO iepnb;

--
-- Name: relacion_taxonomica; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.relacion_taxonomica (
    idreltax integer NOT NULL,
    idtaxon numeric(40,0),
    iddataset numeric(40,0),
    fuente_reltax character varying,
    reltax_segun character varying,
    fecha_alta_establecim_reltax date,
    observaciones_reltax character varying(500),
    idtaxon1_relacionado numeric(40,0),
    idtipo_reltax integer,
    idtaxon2_relacionado numeric(40,0),
    idtaxon3_relacionado numeric,
    idtaxon4_relacionado numeric,
    fecha_baja_establecim_reltax date,
    idtaxon5_relacionado numeric,
    idtaxon6_relacionado numeric
);


ALTER TABLE especie.relacion_taxonomica OWNER TO iepnb;

--
-- Name: TABLE relacion_taxonomica; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON TABLE especie.relacion_taxonomica IS 'https://dwc.tdwg.org/terms/#resourcerelationship
Establece relaciones entre taxones distintas a las de padre-hijo: taxon incluído en, que incluye a, híbrido del cruce de...';


--
-- Name: COLUMN relacion_taxonomica.idreltax; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.relacion_taxonomica.idreltax IS 'Id. de la tabla.';


--
-- Name: COLUMN relacion_taxonomica.idtaxon; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.relacion_taxonomica.idtaxon IS 'Id. del taxon.';


--
-- Name: COLUMN relacion_taxonomica.iddataset; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.relacion_taxonomica.iddataset IS 'Id. del conjunto de datos del que proviene la información.';


--
-- Name: COLUMN relacion_taxonomica.fuente_reltax; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.relacion_taxonomica.fuente_reltax IS 'Fuente que establece la relación entre los taxones.';


--
-- Name: COLUMN relacion_taxonomica.fecha_alta_establecim_reltax; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.relacion_taxonomica.fecha_alta_establecim_reltax IS 'Fecha en la que se establece la relación entre los taxones';


--
-- Name: COLUMN relacion_taxonomica.idtaxon1_relacionado; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.relacion_taxonomica.idtaxon1_relacionado IS 'Id. del primer taxon implicado en la relación taxonómica correspondiente.';


--
-- Name: COLUMN relacion_taxonomica.idtipo_reltax; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.relacion_taxonomica.idtipo_reltax IS 'Id. del tipo de la relación taxonómica';


--
-- Name: COLUMN relacion_taxonomica.idtaxon2_relacionado; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.relacion_taxonomica.idtaxon2_relacionado IS 'Si existe, Id. del segundo taxon implicado en la relación taxonómica.';


--
-- Name: COLUMN relacion_taxonomica.idtaxon3_relacionado; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.relacion_taxonomica.idtaxon3_relacionado IS 'Si existe, Id. del tercer taxon implicado en la relación taxonómica.';


--
-- Name: COLUMN relacion_taxonomica.idtaxon4_relacionado; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.relacion_taxonomica.idtaxon4_relacionado IS 'Si existe, Id. del cuarto taxon implicado en la relación taxonómica.';


--
-- Name: COLUMN relacion_taxonomica.fecha_baja_establecim_reltax; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.relacion_taxonomica.fecha_baja_establecim_reltax IS 'Fecha en la que desaparece la relación entre los taxones';


--
-- Name: sec_id; Type: SEQUENCE; Schema: especie; Owner: iepnb
--

CREATE SEQUENCE especie.sec_id
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 999999999999
    CACHE 1;


ALTER SEQUENCE especie.sec_id OWNER TO iepnb;

--
-- Name: sec_id_ambitogeo; Type: SEQUENCE; Schema: especie; Owner: iepnb
--

CREATE SEQUENCE especie.sec_id_ambitogeo
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE especie.sec_id_ambitogeo OWNER TO iepnb;

--
-- Name: sec_id_aplicadoa; Type: SEQUENCE; Schema: especie; Owner: iepnb
--

CREATE SEQUENCE especie.sec_id_aplicadoa
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE especie.sec_id_aplicadoa OWNER TO iepnb;

--
-- Name: sec_id_atributo; Type: SEQUENCE; Schema: especie; Owner: iepnb
--

CREATE SEQUENCE especie.sec_id_atributo
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE especie.sec_id_atributo OWNER TO iepnb;

--
-- Name: sec_id_coleccion; Type: SEQUENCE; Schema: especie; Owner: iepnb
--

CREATE SEQUENCE especie.sec_id_coleccion
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE especie.sec_id_coleccion OWNER TO iepnb;

--
-- Name: sec_id_coltiponorm; Type: SEQUENCE; Schema: especie; Owner: iepnb
--

CREATE SEQUENCE especie.sec_id_coltiponorm
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE especie.sec_id_coltiponorm OWNER TO iepnb;

--
-- Name: sec_id_endemismo; Type: SEQUENCE; Schema: especie; Owner: iepnb
--

CREATE SEQUENCE especie.sec_id_endemismo
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE especie.sec_id_endemismo OWNER TO iepnb;

--
-- Name: sec_id_estadolegal; Type: SEQUENCE; Schema: especie; Owner: iepnb
--

CREATE SEQUENCE especie.sec_id_estadolegal
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE especie.sec_id_estadolegal OWNER TO iepnb;

--
-- Name: sec_id_estadonombre; Type: SEQUENCE; Schema: especie; Owner: iepnb
--

CREATE SEQUENCE especie.sec_id_estadonombre
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE especie.sec_id_estadonombre OWNER TO iepnb;

--
-- Name: sec_id_estadonombrevalor; Type: SEQUENCE; Schema: especie; Owner: iepnb
--

CREATE SEQUENCE especie.sec_id_estadonombrevalor
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE especie.sec_id_estadonombrevalor OWNER TO iepnb;

--
-- Name: sec_id_estadotaxon; Type: SEQUENCE; Schema: especie; Owner: iepnb
--

CREATE SEQUENCE especie.sec_id_estadotaxon
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE especie.sec_id_estadotaxon OWNER TO iepnb;

--
-- Name: sec_id_estadovig; Type: SEQUENCE; Schema: especie; Owner: iepnb
--

CREATE SEQUENCE especie.sec_id_estadovig
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE especie.sec_id_estadovig OWNER TO iepnb;

--
-- Name: sec_id_grupo; Type: SEQUENCE; Schema: especie; Owner: iepnb
--

CREATE SEQUENCE especie.sec_id_grupo
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE especie.sec_id_grupo OWNER TO iepnb;

--
-- Name: sec_id_taxon; Type: SEQUENCE; Schema: especie; Owner: iepnb
--

CREATE SEQUENCE especie.sec_id_taxon
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE especie.sec_id_taxon OWNER TO iepnb;

--
-- Name: sec_id_taxon; Type: SEQUENCE OWNED BY; Schema: especie; Owner: iepnb
--

ALTER SEQUENCE especie.sec_id_taxon OWNED BY especie.taxon.id;


--
-- Name: sec_id_taxonestadolegal; Type: SEQUENCE; Schema: especie; Owner: iepnb
--

CREATE SEQUENCE especie.sec_id_taxonestadolegal
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE especie.sec_id_taxonestadolegal OWNER TO iepnb;

--
-- Name: sec_id_tiponombre; Type: SEQUENCE; Schema: especie; Owner: iepnb
--

CREATE SEQUENCE especie.sec_id_tiponombre
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE especie.sec_id_tiponombre OWNER TO iepnb;

--
-- Name: sec_id_tiponormativacoleccion; Type: SEQUENCE; Schema: especie; Owner: iepnb
--

CREATE SEQUENCE especie.sec_id_tiponormativacoleccion
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE especie.sec_id_tiponormativacoleccion OWNER TO iepnb;

--
-- Name: t_agrup_tiponombre; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.t_agrup_tiponombre (
    id_agrup_tiponombre integer NOT NULL,
    agrup_tiponombre character varying
);


ALTER TABLE especie.t_agrup_tiponombre OWNER TO iepnb;

--
-- Name: t_ambito_distribucion; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.t_ambito_distribucion (
    idtipoambitodistr integer,
    idambitodistr integer NOT NULL,
    ambitodistribucion character varying
);


ALTER TABLE especie.t_ambito_distribucion OWNER TO iepnb;

--
-- Name: TABLE t_ambito_distribucion; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON TABLE especie.t_ambito_distribucion IS 'Catálogo con los posibles  ámbitos de distribución en función del "Tipo ámbito" elegido previamente.';


--
-- Name: COLUMN t_ambito_distribucion.idtipoambitodistr; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_ambito_distribucion.idtipoambitodistr IS 'Id. del tipo de ámbito de distribución (nacional o mundial).';


--
-- Name: COLUMN t_ambito_distribucion.idambitodistr; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_ambito_distribucion.idambitodistr IS 'Id. del ámbito de distribución.';


--
-- Name: COLUMN t_ambito_distribucion.ambitodistribucion; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_ambito_distribucion.ambitodistribucion IS 'Ámbito de distribución.';


--
-- Name: t_ambito_es; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.t_ambito_es (
    id_ambito_es integer NOT NULL,
    ambito character varying(5),
    descripcion_ambito character varying(50)
);


ALTER TABLE especie.t_ambito_es OWNER TO iepnb;

--
-- Name: COLUMN t_ambito_es.id_ambito_es; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_ambito_es.id_ambito_es IS 'Id. de la tabla';


--
-- Name: COLUMN t_ambito_es.ambito; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_ambito_es.ambito IS 'Ambito';


--
-- Name: COLUMN t_ambito_es.descripcion_ambito; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_ambito_es.descripcion_ambito IS 'Descripción del ámbito';


--
-- Name: t_aplicaa_conservacion; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.t_aplicaa_conservacion (
    idaplicaa integer NOT NULL,
    aplicaa character varying,
    idautoridad integer,
    id integer DEFAULT nextval('especie.sec_id_tiponormativacoleccion'::regclass),
    codigo character varying
);


ALTER TABLE especie.t_aplicaa_conservacion OWNER TO iepnb;

--
-- Name: COLUMN t_aplicaa_conservacion.idaplicaa; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_aplicaa_conservacion.idaplicaa IS 'Id. de la tabla';


--
-- Name: COLUMN t_aplicaa_conservacion.aplicaa; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_aplicaa_conservacion.aplicaa IS 'Texto de dónde aplica';


--
-- Name: COLUMN t_aplicaa_conservacion.idautoridad; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_aplicaa_conservacion.idautoridad IS 'Clave foránea para relacionar con la autoridad';


--
-- Name: COLUMN t_aplicaa_conservacion.id; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_aplicaa_conservacion.id IS 'Campo autonumérico único incrementándose en una unidad';


--
-- Name: t_aplicaa_distribucion; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.t_aplicaa_distribucion (
    idtipoambitodistr integer,
    idambitodistr bigint,
    codigo character varying,
    aplicadoa_distribucion character varying,
    idaplicaa numeric(40,0) NOT NULL,
    id bigint,
    id_organismo numeric(20,0),
    codigo_num double precision
);


ALTER TABLE especie.t_aplicaa_distribucion OWNER TO iepnb;

--
-- Name: TABLE t_aplicaa_distribucion; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON TABLE especie.t_aplicaa_distribucion IS 'Catálogo de los nombres de las distintas entidades geográficas según distintos criterios.';


--
-- Name: COLUMN t_aplicaa_distribucion.idtipoambitodistr; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_aplicaa_distribucion.idtipoambitodistr IS 'Id. del tipo de ámbito de distribución (nacional o mundial).';


--
-- Name: COLUMN t_aplicaa_distribucion.idambitodistr; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_aplicaa_distribucion.idambitodistr IS 'Id. del ámbito de distribución (CCAA, demarcación marina, ..l).';


--
-- Name: COLUMN t_aplicaa_distribucion.codigo; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_aplicaa_distribucion.codigo IS 'Código de la entidad geográfica.';


--
-- Name: COLUMN t_aplicaa_distribucion.aplicadoa_distribucion; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_aplicaa_distribucion.aplicadoa_distribucion IS 'Entidad geográfica.';


--
-- Name: COLUMN t_aplicaa_distribucion.idaplicaa; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_aplicaa_distribucion.idaplicaa IS '⁯Id.  de la entidad geográfica.';


--
-- Name: COLUMN t_aplicaa_distribucion.id; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_aplicaa_distribucion.id IS 'Campo autonumérico único incrementándose en una unidad';


--
-- Name: COLUMN t_aplicaa_distribucion.id_organismo; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_aplicaa_distribucion.id_organismo IS 'Identificador único del organismo.';


--
-- Name: COLUMN t_aplicaa_distribucion.codigo_num; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_aplicaa_distribucion.codigo_num IS 'Este campo se usa para relacionar con las capas GIS, en algunos casos el campo es numérico (y relacionamos con codigo_num) y en otros es de texto (y relacionamos con código).';


--
-- Name: t_aplicaa_nut2; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.t_aplicaa_nut2 (
    idaplicaa numeric(40,0) NOT NULL,
    nut2 bigint NOT NULL
);


ALTER TABLE especie.t_aplicaa_nut2 OWNER TO iepnb;

--
-- Name: t_atributo; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.t_atributo (
    idatributo numeric(40,0) NOT NULL,
    atributo character varying,
    id bigint DEFAULT nextval('especie.sec_id_atributo'::regclass),
    descripcion character varying(10000)
);


ALTER TABLE especie.t_atributo OWNER TO iepnb;

--
-- Name: TABLE t_atributo; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON TABLE especie.t_atributo IS 'Catálogo de los atributos dónde se cargará la información no estructurada del taxon.';


--
-- Name: COLUMN t_atributo.idatributo; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_atributo.idatributo IS 'Id. único del atributo.';


--
-- Name: COLUMN t_atributo.atributo; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_atributo.atributo IS 'Nombre del atributo donde se cargará información sin normalizar.';


--
-- Name: COLUMN t_atributo.id; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_atributo.id IS 'Campo autonumérico único incrementándose en una unidad';


--
-- Name: COLUMN t_atributo.descripcion; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_atributo.descripcion IS 'Descripción del atributo, del tipo de información a cargar en cada campo.';


--
-- Name: t_autoridad_conservacion; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.t_autoridad_conservacion (
    idautoridad integer NOT NULL,
    autoridad character varying
);


ALTER TABLE especie.t_autoridad_conservacion OWNER TO iepnb;

--
-- Name: TABLE t_autoridad_conservacion; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON TABLE especie.t_autoridad_conservacion IS 'Catálogo de entidades que realizan la evaluación del grado de conservación de los taxones.';


--
-- Name: COLUMN t_autoridad_conservacion.idautoridad; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_autoridad_conservacion.idautoridad IS 'Id. de la tabla.';


--
-- Name: COLUMN t_autoridad_conservacion.autoridad; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_autoridad_conservacion.autoridad IS 'Entidad que evalúa el estado de conservación.';


--
-- Name: t_categoria_conservacion; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.t_categoria_conservacion (
    idcategoria integer NOT NULL,
    categoriaconservacion character varying,
    tipo_cat character varying,
    idautoridad integer,
    category_en character varying(255)
);


ALTER TABLE especie.t_categoria_conservacion OWNER TO iepnb;

--
-- Name: TABLE t_categoria_conservacion; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON TABLE especie.t_categoria_conservacion IS 'Catálogo de las distintas categorías de conservación de los taxones en función de la entidad que los evalúe.';


--
-- Name: COLUMN t_categoria_conservacion.idcategoria; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_categoria_conservacion.idcategoria IS 'Id. de la tabla';


--
-- Name: COLUMN t_categoria_conservacion.categoriaconservacion; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_categoria_conservacion.categoriaconservacion IS 'Categoría de conservación';


--
-- Name: COLUMN t_categoria_conservacion.tipo_cat; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_categoria_conservacion.tipo_cat IS 'Abreviatura o acrónimo de la categoría de conservación';


--
-- Name: COLUMN t_categoria_conservacion.idautoridad; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_categoria_conservacion.idautoridad IS 'Clave foránea para relacionar con la autoridad de conservación';


--
-- Name: COLUMN t_categoria_conservacion.category_en; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_categoria_conservacion.category_en IS 'Categoría de conservación (inglés)';


--
-- Name: t_codigohabitat; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.t_codigohabitat (
    idcodigo integer NOT NULL,
    codigo character varying,
    id integer DEFAULT nextval('especie.sec_id_vigencia'::regclass)
);


ALTER TABLE especie.t_codigohabitat OWNER TO iepnb;

--
-- Name: COLUMN t_codigohabitat.idcodigo; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_codigohabitat.idcodigo IS 'Id. de la tabla';


--
-- Name: COLUMN t_codigohabitat.codigo; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_codigohabitat.codigo IS 'Código del habitat al que pertene';


--
-- Name: COLUMN t_codigohabitat.id; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_codigohabitat.id IS 'Campo autonumérico único incrementándose en una unidad';


--
-- Name: t_codigosexternos_eliminar; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.t_codigosexternos_eliminar (
    idcodigoexterno bigint NOT NULL,
    codigoexterno character varying,
    id integer
);


ALTER TABLE especie.t_codigosexternos_eliminar OWNER TO iepnb;

--
-- Name: COLUMN t_codigosexternos_eliminar.idcodigoexterno; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_codigosexternos_eliminar.idcodigoexterno IS 'Id. de la tabla';


--
-- Name: COLUMN t_codigosexternos_eliminar.codigoexterno; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_codigosexternos_eliminar.codigoexterno IS 'Código externo al que pertenece';


--
-- Name: COLUMN t_codigosexternos_eliminar.id; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_codigosexternos_eliminar.id IS 'Campo autonumérico único incrementándose en una unidad';


--
-- Name: t_criteriomedidaconservacion; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.t_criteriomedidaconservacion (
    idcriterio integer NOT NULL,
    criteriomedidaconservacion character varying,
    id bigint DEFAULT nextval('especie.sec_id_coltiponorm'::regclass) NOT NULL
);


ALTER TABLE especie.t_criteriomedidaconservacion OWNER TO iepnb;

--
-- Name: COLUMN t_criteriomedidaconservacion.idcriterio; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_criteriomedidaconservacion.idcriterio IS 'Id. de la tabla';


--
-- Name: COLUMN t_criteriomedidaconservacion.criteriomedidaconservacion; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_criteriomedidaconservacion.criteriomedidaconservacion IS 'Descripción del criterio medido de conservación';


--
-- Name: COLUMN t_criteriomedidaconservacion.id; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_criteriomedidaconservacion.id IS 'Campo autonumérico único incrementándose en una unidad';


--
-- Name: t_dataset_medida; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.t_dataset_medida (
    id_dataset_medida numeric(20,0) NOT NULL,
    cod_id_en_coleccion character varying(100),
    nombre character varying(2000) NOT NULL,
    descripcion text,
    id_organismo numeric(20,0),
    organismo_orign_corto character varying(20),
    nombre_organismo character varying(400)
);


ALTER TABLE especie.t_dataset_medida OWNER TO iepnb;

--
-- Name: COLUMN t_dataset_medida.id_dataset_medida; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_dataset_medida.id_dataset_medida IS 'Id. de la colección de medidas';


--
-- Name: COLUMN t_dataset_medida.cod_id_en_coleccion; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_dataset_medida.cod_id_en_coleccion IS 'Id. o código de la medida dentro de lista';


--
-- Name: COLUMN t_dataset_medida.nombre; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_dataset_medida.nombre IS 'Nombre de la medida';


--
-- Name: COLUMN t_dataset_medida.descripcion; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_dataset_medida.descripcion IS 'Descripción de la medida';


--
-- Name: COLUMN t_dataset_medida.id_organismo; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_dataset_medida.id_organismo IS 'Id. Organismo del que procede la colección, FRK a T_ORGANISMO';


--
-- Name: COLUMN t_dataset_medida.organismo_orign_corto; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_dataset_medida.organismo_orign_corto IS 'ACrónimo o nombre corto del organismo origen';


--
-- Name: COLUMN t_dataset_medida.nombre_organismo; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_dataset_medida.nombre_organismo IS 'Nombre del organimso si no tien id_organismo';


--
-- Name: t_endemicoen; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.t_endemicoen (
    idendemicoen integer NOT NULL,
    endemicoen character varying
);


ALTER TABLE especie.t_endemicoen OWNER TO iepnb;

--
-- Name: TABLE t_endemicoen; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON TABLE especie.t_endemicoen IS 'Lista estructurada de las áreas o localidades dónde se encuentra algún taxon de forma exclusiva, sin que pueda encontrarse este en ningún otro lugar.';


--
-- Name: COLUMN t_endemicoen.idendemicoen; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_endemicoen.idendemicoen IS 'Id. Área/localidad del endemismo.';


--
-- Name: COLUMN t_endemicoen.endemicoen; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_endemicoen.endemicoen IS 'Nombre del área/localidad del endemismo.';


--
-- Name: t_estadolegal; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.t_estadolegal (
    idestadolegal bigint NOT NULL,
    idvigente bigint,
    id_norma numeric(40,0),
    observacionespoblacion character varying(10000),
    descripcion character varying,
    id bigint DEFAULT nextval('especie.sec_id_estadolegal'::regclass),
    estadolegal character varying,
    temp character varying,
    idestadolegaldataset numeric(40,0),
    iddataset numeric(40,0)
);


ALTER TABLE especie.t_estadolegal OWNER TO iepnb;

--
-- Name: COLUMN t_estadolegal.idestadolegal; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_estadolegal.idestadolegal IS 'Id. de la tabla';


--
-- Name: COLUMN t_estadolegal.idvigente; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_estadolegal.idvigente IS 'Clave foránea para relacionar con T_VIGENTE';


--
-- Name: COLUMN t_estadolegal.id_norma; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_estadolegal.id_norma IS 'Clave foránea para relacionar Norma';


--
-- Name: COLUMN t_estadolegal.observacionespoblacion; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_estadolegal.observacionespoblacion IS 'borrar';


--
-- Name: COLUMN t_estadolegal.descripcion; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_estadolegal.descripcion IS 'borrar?';


--
-- Name: COLUMN t_estadolegal.id; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_estadolegal.id IS 'Campo autonumérico único incrementándose en una unidad';


--
-- Name: COLUMN t_estadolegal.estadolegal; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_estadolegal.estadolegal IS 'Estado Legal en el que se encuentra';


--
-- Name: t_estadotaxon; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.t_estadotaxon (
    idestadotaxon bigint NOT NULL,
    estadotaxon character varying,
    id character varying DEFAULT nextval('especie.sec_id_estadotaxon'::regclass)
);


ALTER TABLE especie.t_estadotaxon OWNER TO iepnb;

--
-- Name: COLUMN t_estadotaxon.idestadotaxon; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_estadotaxon.idestadotaxon IS 'Id. de la tabla';


--
-- Name: COLUMN t_estadotaxon.estadotaxon; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_estadotaxon.estadotaxon IS 'Estado del taxón';


--
-- Name: COLUMN t_estadotaxon.id; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_estadotaxon.id IS 'Campo autonumérico único incrementándose en una unidad';


--
-- Name: t_fuente; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.t_fuente (
    idfuente integer NOT NULL,
    fuente character varying,
    id integer DEFAULT nextval('especie.sec_id_taxonnombre'::regclass) NOT NULL
);


ALTER TABLE especie.t_fuente OWNER TO iepnb;

--
-- Name: COLUMN t_fuente.idfuente; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_fuente.idfuente IS 'Id. de la tabla';


--
-- Name: COLUMN t_fuente.fuente; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_fuente.fuente IS 'Fuente del dato';


--
-- Name: COLUMN t_fuente.id; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_fuente.id IS 'Campo autonumérico único incrementándose en una unidad';


--
-- Name: t_fuentereferencias_lp; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.t_fuentereferencias_lp (
    idfuentereferencialp integer NOT NULL,
    fechapublicacion date,
    url character varying(2000),
    fuentereferencialp character varying(500),
    observaciones character varying(500)
);


ALTER TABLE especie.t_fuentereferencias_lp OWNER TO iepnb;

--
-- Name: t_grupo; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.t_grupo (
    idgrupo bigint NOT NULL,
    grupo character varying,
    descripcion character varying,
    id bigint DEFAULT nextval('especie.sec_id_grupo'::regclass)
);


ALTER TABLE especie.t_grupo OWNER TO iepnb;

--
-- Name: COLUMN t_grupo.idgrupo; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_grupo.idgrupo IS 'Id. de la tabla';


--
-- Name: COLUMN t_grupo.grupo; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_grupo.grupo IS 'Grupo al que pertenece';


--
-- Name: COLUMN t_grupo.descripcion; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_grupo.descripcion IS 'Descripción del grupo';


--
-- Name: COLUMN t_grupo.id; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_grupo.id IS 'Campo autonumérico único incrementándose en una unidad';


--
-- Name: t_medidaconservacion; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.t_medidaconservacion (
    idmedidaconservacion integer NOT NULL,
    medidaconservacion character varying,
    descripcion character varying,
    idfuente integer,
    id integer DEFAULT nextval('especie.sec_id_grupotax'::regclass) NOT NULL,
    idtipomedidaconservacion integer
);


ALTER TABLE especie.t_medidaconservacion OWNER TO iepnb;

--
-- Name: COLUMN t_medidaconservacion.idmedidaconservacion; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_medidaconservacion.idmedidaconservacion IS 'Id. de la tabla';


--
-- Name: COLUMN t_medidaconservacion.medidaconservacion; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_medidaconservacion.medidaconservacion IS 'Medida de conservación que se lleva a cabo';


--
-- Name: COLUMN t_medidaconservacion.descripcion; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_medidaconservacion.descripcion IS 'Descripción de la medida de conservación';


--
-- Name: COLUMN t_medidaconservacion.idfuente; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_medidaconservacion.idfuente IS 'Clave foránea para relacionar con Fuente del dato';


--
-- Name: COLUMN t_medidaconservacion.id; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_medidaconservacion.id IS 'Campo autonumérico único incrementándose en una unidad';


--
-- Name: COLUMN t_medidaconservacion.idtipomedidaconservacion; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_medidaconservacion.idtipomedidaconservacion IS 'Clave foránea para relacionar con el tipo de la medida de conservación';


--
-- Name: t_metodomedida; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.t_metodomedida (
    idmetodomedida integer NOT NULL,
    metodomedida character varying,
    id integer DEFAULT nextval('especie.sec_id_grupotax'::regclass) NOT NULL,
    idtipomedida integer
);


ALTER TABLE especie.t_metodomedida OWNER TO iepnb;

--
-- Name: COLUMN t_metodomedida.idmetodomedida; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_metodomedida.idmetodomedida IS 'Id. de la tabla';


--
-- Name: COLUMN t_metodomedida.metodomedida; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_metodomedida.metodomedida IS 'Descripción del método de medida';


--
-- Name: COLUMN t_metodomedida.id; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_metodomedida.id IS 'Campo autonumérico único incrementándose en una unidad';


--
-- Name: t_objetivo_planesgestion; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.t_objetivo_planesgestion (
    idobjetivoplan bigint NOT NULL,
    codigo character varying(5),
    objetivoplan character varying,
    definicion character varying,
    observaciones character varying
);


ALTER TABLE especie.t_objetivo_planesgestion OWNER TO iepnb;

--
-- Name: t_origen_lp; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.t_origen_lp (
    idorigenlp numeric(40,0) NOT NULL,
    fechapublicacion date,
    url character varying,
    id bigint DEFAULT nextval('especie.sec_id_coleccion'::regclass),
    origenlp character varying,
    observaciones character varying
);


ALTER TABLE especie.t_origen_lp OWNER TO iepnb;

--
-- Name: COLUMN t_origen_lp.idorigenlp; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_origen_lp.idorigenlp IS 'Id. de la tabla';


--
-- Name: COLUMN t_origen_lp.fechapublicacion; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_origen_lp.fechapublicacion IS 'Fecha de publicación';


--
-- Name: COLUMN t_origen_lp.url; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_origen_lp.url IS 'Url donde se encuentra información';


--
-- Name: COLUMN t_origen_lp.id; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_origen_lp.id IS 'Campo Id de la fuente de la colección para relacionarlo con ella';


--
-- Name: COLUMN t_origen_lp.origenlp; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_origen_lp.origenlp IS 'Descripción del origen de la lista patrón';


--
-- Name: COLUMN t_origen_lp.observaciones; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_origen_lp.observaciones IS 'Observaciones';


--
-- Name: t_origentaxon; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.t_origentaxon (
    idorigen integer NOT NULL,
    origen character varying,
    origin character varying,
    descripcion character varying,
    id numeric(40,0) DEFAULT nextval('especie.sec_id_estadonombrevalor'::regclass),
    idfuente integer
);


ALTER TABLE especie.t_origentaxon OWNER TO iepnb;

--
-- Name: COLUMN t_origentaxon.idorigen; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_origentaxon.idorigen IS 'Id. de la tabla';


--
-- Name: COLUMN t_origentaxon.origen; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_origentaxon.origen IS 'Origen del taxon';


--
-- Name: COLUMN t_origentaxon.descripcion; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_origentaxon.descripcion IS 'Descripción del origen del taxon';


--
-- Name: COLUMN t_origentaxon.id; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_origentaxon.id IS 'Campo Id de la fuente de la colección para relacionarlo con ella';


--
-- Name: COLUMN t_origentaxon.idfuente; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_origentaxon.idfuente IS 'Clave foránea para relacionarlo con la fuente';


--
-- Name: t_poblacionreferida; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.t_poblacionreferida (
    idpoblacionreferida integer NOT NULL,
    poblacionreferida character varying,
    id integer DEFAULT nextval('especie.sec_id_vigencia'::regclass)
);


ALTER TABLE especie.t_poblacionreferida OWNER TO iepnb;

--
-- Name: COLUMN t_poblacionreferida.idpoblacionreferida; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_poblacionreferida.idpoblacionreferida IS 'Id. de la tabla';


--
-- Name: COLUMN t_poblacionreferida.poblacionreferida; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_poblacionreferida.poblacionreferida IS 'Descripción de la población referida';


--
-- Name: COLUMN t_poblacionreferida.id; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_poblacionreferida.id IS 'Campo autonumérico único incrementándose en una unidad';


--
-- Name: t_precisionmedida; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.t_precisionmedida (
    idprecisionmedida integer NOT NULL,
    precisionmedida character varying
);


ALTER TABLE especie.t_precisionmedida OWNER TO iepnb;

--
-- Name: COLUMN t_precisionmedida.idprecisionmedida; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_precisionmedida.idprecisionmedida IS 'Id. de la tabla';


--
-- Name: COLUMN t_precisionmedida.precisionmedida; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_precisionmedida.precisionmedida IS 'Descripción de la precisión de la medida';


--
-- Name: t_regionreferenciada; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.t_regionreferenciada (
    idregionreferenciada integer NOT NULL,
    regionreferenciada character varying,
    id integer DEFAULT nextval('especie.sec_id_vigencia'::regclass)
);


ALTER TABLE especie.t_regionreferenciada OWNER TO iepnb;

--
-- Name: COLUMN t_regionreferenciada.idregionreferenciada; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_regionreferenciada.idregionreferenciada IS 'Id. de la tabla';


--
-- Name: COLUMN t_regionreferenciada.regionreferenciada; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_regionreferenciada.regionreferenciada IS 'Descripción de la región referenciada';


--
-- Name: COLUMN t_regionreferenciada.id; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_regionreferenciada.id IS 'Campo autonumérico único incrementándose en una unidad';


--
-- Name: t_rutaintroduccion; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.t_rutaintroduccion (
    idrutaintroduccion bigint NOT NULL,
    rutaintroduccion character varying,
    idfuente bigint
);


ALTER TABLE especie.t_rutaintroduccion OWNER TO iepnb;

--
-- Name: COLUMN t_rutaintroduccion.idrutaintroduccion; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_rutaintroduccion.idrutaintroduccion IS 'Id. de la tabla';


--
-- Name: COLUMN t_rutaintroduccion.rutaintroduccion; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_rutaintroduccion.rutaintroduccion IS 'Descripción de la ruta de introducción';


--
-- Name: COLUMN t_rutaintroduccion.idfuente; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_rutaintroduccion.idfuente IS 'Campo Id de la fuente de la colección para relacionarlo con ella';


--
-- Name: t_sociedades_lp; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.t_sociedades_lp (
    idsociedadlp integer NOT NULL,
    fechapublicacion date,
    url character varying(2000),
    sociedadlp character varying(500),
    observaciones character varying(500)
);


ALTER TABLE especie.t_sociedades_lp OWNER TO iepnb;

--
-- Name: t_taxonrank; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.t_taxonrank (
    idtaxonrank bigint NOT NULL,
    taxonrank character varying,
    verbatimtaxonrank character varying
);


ALTER TABLE especie.t_taxonrank OWNER TO iepnb;

--
-- Name: COLUMN t_taxonrank.idtaxonrank; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_taxonrank.idtaxonrank IS 'Id. de la tabla';


--
-- Name: COLUMN t_taxonrank.taxonrank; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_taxonrank.taxonrank IS 'Nivel dentro de la jerarquía taxonómica.';


--
-- Name: COLUMN t_taxonrank.verbatimtaxonrank; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_taxonrank.verbatimtaxonrank IS 'Abreviatura del rango taxonómico.';


--
-- Name: t_tendencia; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.t_tendencia (
    idtendencia integer NOT NULL,
    tendencia character varying,
    id integer DEFAULT nextval('especie.sec_id_taxoncoleccion'::regclass),
    idmetodomedida integer
);


ALTER TABLE especie.t_tendencia OWNER TO iepnb;

--
-- Name: COLUMN t_tendencia.idtendencia; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_tendencia.idtendencia IS 'Id. de la tabla';


--
-- Name: COLUMN t_tendencia.tendencia; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_tendencia.tendencia IS 'Descripción de la tendencia';


--
-- Name: COLUMN t_tendencia.id; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_tendencia.id IS 'Campo autonumérico único incrementándose en una unidad';


--
-- Name: t_tipo_atributo_taxon; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.t_tipo_atributo_taxon (
    id_tipo_atributo_taxon integer NOT NULL,
    nombre_atributo character varying
);


ALTER TABLE especie.t_tipo_atributo_taxon OWNER TO iepnb;

--
-- Name: t_tipo_codigo; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.t_tipo_codigo (
    id_tipo_codigo integer NOT NULL,
    tipo_codigo character varying,
    observaciones character varying(200)
);


ALTER TABLE especie.t_tipo_codigo OWNER TO iepnb;

--
-- Name: COLUMN t_tipo_codigo.observaciones; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_tipo_codigo.observaciones IS 'Detalle del tipo de código.';


--
-- Name: t_tipo_distribucion; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.t_tipo_distribucion (
    idtipodistribucion integer NOT NULL,
    tipodistribucion character varying,
    solo_invasoras boolean
);


ALTER TABLE especie.t_tipo_distribucion OWNER TO iepnb;

--
-- Name: TABLE t_tipo_distribucion; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON TABLE especie.t_tipo_distribucion IS 'Catálogo con las categorías de distribución según distintos criterios: temporal ( "potencial", "histórica") ,  origen de la especie ("natural","como invasora")...';


--
-- Name: COLUMN t_tipo_distribucion.idtipodistribucion; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_tipo_distribucion.idtipodistribucion IS 'Id. de la tabla';


--
-- Name: COLUMN t_tipo_distribucion.tipodistribucion; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_tipo_distribucion.tipodistribucion IS 'Descripción del tipo de distribución';


--
-- Name: COLUMN t_tipo_distribucion.solo_invasoras; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_tipo_distribucion.solo_invasoras IS 'Será true en caso de que sea especie invasora';


--
-- Name: t_tipo_planesgestion; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.t_tipo_planesgestion (
    idtipoplan bigint NOT NULL,
    codigo character varying(5),
    tipoplan character varying,
    definicion character varying,
    observaciones character varying
);


ALTER TABLE especie.t_tipo_planesgestion OWNER TO iepnb;

--
-- Name: t_tipo_publicacion; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.t_tipo_publicacion (
    idtipo_publicacion integer NOT NULL,
    publicacion character varying
);


ALTER TABLE especie.t_tipo_publicacion OWNER TO iepnb;

--
-- Name: COLUMN t_tipo_publicacion.idtipo_publicacion; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_tipo_publicacion.idtipo_publicacion IS 'Id. de la tabla';


--
-- Name: COLUMN t_tipo_publicacion.publicacion; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_tipo_publicacion.publicacion IS 'Descripción de la publicación';


--
-- Name: t_tipo_relaciontax; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.t_tipo_relaciontax (
    idtipo_reltax integer NOT NULL,
    relacion_taxonomica character varying(255)
);


ALTER TABLE especie.t_tipo_relaciontax OWNER TO iepnb;

--
-- Name: COLUMN t_tipo_relaciontax.idtipo_reltax; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_tipo_relaciontax.idtipo_reltax IS 'Id. de la tabla';


--
-- Name: COLUMN t_tipo_relaciontax.relacion_taxonomica; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_tipo_relaciontax.relacion_taxonomica IS 'Tipo de la relación taxonómica';


--
-- Name: t_tipoambito_ditribucion; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.t_tipoambito_ditribucion (
    idtipoambitodistr integer NOT NULL,
    tipoambitodistribucion character varying
);


ALTER TABLE especie.t_tipoambito_ditribucion OWNER TO iepnb;

--
-- Name: COLUMN t_tipoambito_ditribucion.idtipoambitodistr; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_tipoambito_ditribucion.idtipoambitodistr IS 'Id. de la tabla';


--
-- Name: COLUMN t_tipoambito_ditribucion.tipoambitodistribucion; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_tipoambito_ditribucion.tipoambitodistribucion IS 'Descripción del tipo de ámbito de la distribución';


--
-- Name: t_tipoamenaza; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.t_tipoamenaza (
    idtipoamenaza integer NOT NULL,
    tipoamenaza character varying,
    id integer DEFAULT nextval('especie.sec_id_vigencia'::regclass)
);


ALTER TABLE especie.t_tipoamenaza OWNER TO iepnb;

--
-- Name: COLUMN t_tipoamenaza.idtipoamenaza; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_tipoamenaza.idtipoamenaza IS 'Id. de la tabla';


--
-- Name: COLUMN t_tipoamenaza.tipoamenaza; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_tipoamenaza.tipoamenaza IS 'Descripción del tipo de amenaza';


--
-- Name: COLUMN t_tipoamenaza.id; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_tipoamenaza.id IS 'Campo autonumérico único incrementándose en una unidad';


--
-- Name: t_tipomedidaconservacion; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.t_tipomedidaconservacion (
    idtipomedidaconservacion integer NOT NULL,
    tipomedidaconservacion character varying
);


ALTER TABLE especie.t_tipomedidaconservacion OWNER TO iepnb;

--
-- Name: COLUMN t_tipomedidaconservacion.idtipomedidaconservacion; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_tipomedidaconservacion.idtipomedidaconservacion IS 'Id. de la tabla';


--
-- Name: COLUMN t_tipomedidaconservacion.tipomedidaconservacion; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_tipomedidaconservacion.tipomedidaconservacion IS 'Descripción del tipo de medida de conservación';


--
-- Name: t_tiponormativadataset; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.t_tiponormativadataset (
    idtiponormativadataset bigint NOT NULL,
    tiponormativadataset character varying,
    id character varying DEFAULT nextval('especie.sec_id_tiponormativacoleccion'::regclass)
);


ALTER TABLE especie.t_tiponormativadataset OWNER TO iepnb;

--
-- Name: COLUMN t_tiponormativadataset.idtiponormativadataset; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_tiponormativadataset.idtiponormativadataset IS 'Id. de la tabla';


--
-- Name: COLUMN t_tiponormativadataset.tiponormativadataset; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_tiponormativadataset.tiponormativadataset IS 'Descripción del tipo de normativa de la colección';


--
-- Name: COLUMN t_tiponormativadataset.id; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_tiponormativadataset.id IS 'Campo autonumérico único incrementándose en una unidad';


--
-- Name: t_tipouso_nivel1; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.t_tipouso_nivel1 (
    iduso1 integer NOT NULL,
    nivel1 character varying
);


ALTER TABLE especie.t_tipouso_nivel1 OWNER TO iepnb;

--
-- Name: t_tipouso_nivel2; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.t_tipouso_nivel2 (
    iduso1 integer,
    iduso2 integer NOT NULL,
    nivel2 character varying
);


ALTER TABLE especie.t_tipouso_nivel2 OWNER TO iepnb;

--
-- Name: t_tipouso_nivel3; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.t_tipouso_nivel3 (
    iduso1 integer,
    iduso2 integer,
    iduso3 bigint NOT NULL,
    nivel3 character varying
);


ALTER TABLE especie.t_tipouso_nivel3 OWNER TO iepnb;

--
-- Name: t_tituloamenaza; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.t_tituloamenaza (
    idtituloamenaza integer NOT NULL,
    tituloamenaza character varying,
    id integer DEFAULT nextval('especie.sec_id_vigencia'::regclass)
);


ALTER TABLE especie.t_tituloamenaza OWNER TO iepnb;

--
-- Name: COLUMN t_tituloamenaza.idtituloamenaza; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_tituloamenaza.idtituloamenaza IS 'Id. de la tabla';


--
-- Name: COLUMN t_tituloamenaza.tituloamenaza; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_tituloamenaza.tituloamenaza IS 'Título de la amenaza';


--
-- Name: COLUMN t_tituloamenaza.id; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_tituloamenaza.id IS 'Campo autonumérico único incrementándose en una unidad';


--
-- Name: t_titulopoblacion; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.t_titulopoblacion (
    idtitulo integer NOT NULL,
    titulo character varying,
    id integer DEFAULT nextval('especie.sec_id_vigencia'::regclass)
);


ALTER TABLE especie.t_titulopoblacion OWNER TO iepnb;

--
-- Name: COLUMN t_titulopoblacion.idtitulo; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_titulopoblacion.idtitulo IS 'Id. de la tabla';


--
-- Name: COLUMN t_titulopoblacion.titulo; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_titulopoblacion.titulo IS 'Título';


--
-- Name: COLUMN t_titulopoblacion.id; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.t_titulopoblacion.id IS 'Campo autonumérico único incrementándose en una unidad';


--
-- Name: t_unidad_medida_atributo; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.t_unidad_medida_atributo (
    id_unidad_medida_atributo integer NOT NULL,
    nombre_unidad_medida_atributo character varying
);


ALTER TABLE especie.t_unidad_medida_atributo OWNER TO iepnb;

--
-- Name: t_valor_atributo; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.t_valor_atributo (
    id_valor_aributo integer NOT NULL,
    texto_valor character varying,
    id_tipo_atributo_taxon bigint
);


ALTER TABLE especie.t_valor_atributo OWNER TO iepnb;

--
-- Name: taxon_imagen; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.taxon_imagen (
    id_taxon character varying(20) NOT NULL,
    id_foto numeric(20,0) NOT NULL,
    es_prioridad smallint,
    description text,
    ruta_foto character varying(300)
);


ALTER TABLE especie.taxon_imagen OWNER TO iepnb;

--
-- Name: COLUMN taxon_imagen.ruta_foto; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxon_imagen.ruta_foto IS 'Indica la ruta de la foto en la fototeca';


--
-- Name: taxon_medicion; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.taxon_medicion (
    idtaxon numeric(40,0) NOT NULL,
    idmedida integer NOT NULL,
    idtipomedida integer,
    valormedida numeric,
    idunidadmedida integer,
    idmetodomedida integer,
    idprecisionmedida integer,
    idaplicadoa integer,
    id integer DEFAULT nextval('especie.sec_id_grupotax'::regclass) NOT NULL,
    fechamedida date,
    observaciones character varying,
    iddataset numeric(40,0),
    id_valor_medida numeric,
    valor_medida_texto character varying,
    valor_minimo numeric,
    valor_maximo numeric,
    id_ambito_es integer,
    anio_inicio integer,
    anio_final integer,
    idvigente bigint DEFAULT 0 NOT NULL,
    id_usuario_crea_registro integer,
    id_usuario_modifica_registro integer,
    id_tipo_cambio integer,
    fecha_creacion timestamp without time zone,
    fecha_modificacion timestamp without time zone,
    fecha_baja timestamp without time zone,
    fecha_alta date,
    temp character varying
);


ALTER TABLE especie.taxon_medicion OWNER TO iepnb;

--
-- Name: TABLE taxon_medicion; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON TABLE especie.taxon_medicion IS 'https://github.com/tdwg/PlinianCore/wiki/NaturalHistoryType
Tabla que almacena rasgos o características biológicas(Traits) de los taxones: temperatura, altuta min/max, inicio/fin floración...';


--
-- Name: COLUMN taxon_medicion.idtaxon; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxon_medicion.idtaxon IS 'Id. de taxon.';


--
-- Name: COLUMN taxon_medicion.idmedida; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxon_medicion.idmedida IS '⁯Id. único de la tabla.';


--
-- Name: COLUMN taxon_medicion.idtipomedida; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxon_medicion.idtipomedida IS 'Id. de la caracteristica o rasgo biológico que se mide.';


--
-- Name: COLUMN taxon_medicion.valormedida; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxon_medicion.valormedida IS 'Valor de la característica o rasgo evaluado.';


--
-- Name: COLUMN taxon_medicion.idunidadmedida; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxon_medicion.idunidadmedida IS 'Id. de la unidad de medida de la característica o rasgo evaluado.';


--
-- Name: COLUMN taxon_medicion.idmetodomedida; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxon_medicion.idmetodomedida IS 'Id. del método empleado para realizar la medida o evaluación.';


--
-- Name: COLUMN taxon_medicion.idprecisionmedida; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxon_medicion.idprecisionmedida IS 'Id. de la precisión de la medida realizada.';


--
-- Name: COLUMN taxon_medicion.idaplicadoa; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxon_medicion.idaplicadoa IS 'Id. del ámbito geográfico al que está referido.';


--
-- Name: COLUMN taxon_medicion.id; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxon_medicion.id IS 'Campo autonumérico único incrementándose en una unidad';


--
-- Name: COLUMN taxon_medicion.fechamedida; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxon_medicion.fechamedida IS 'Fecha de realización de la medida o valoración.';


--
-- Name: COLUMN taxon_medicion.iddataset; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxon_medicion.iddataset IS 'Id. del conjunto de datos del que proviene la información.';


--
-- Name: COLUMN taxon_medicion.idvigente; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxon_medicion.idvigente IS 'Id. de vigencia respecto al taxón';


--
-- Name: COLUMN taxon_medicion.id_usuario_crea_registro; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxon_medicion.id_usuario_crea_registro IS 'Id. del usuario que crea el registro';


--
-- Name: COLUMN taxon_medicion.id_usuario_modifica_registro; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxon_medicion.id_usuario_modifica_registro IS 'Id. del usuario que modifica el registro';


--
-- Name: COLUMN taxon_medicion.id_tipo_cambio; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxon_medicion.id_tipo_cambio IS 'id. del tipo de cambio';


--
-- Name: COLUMN taxon_medicion.fecha_creacion; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxon_medicion.fecha_creacion IS 'fecha de creación del registro';


--
-- Name: COLUMN taxon_medicion.fecha_modificacion; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxon_medicion.fecha_modificacion IS 'fecha de modificación del registro';


--
-- Name: COLUMN taxon_medicion.fecha_baja; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxon_medicion.fecha_baja IS 'fecha de la baja lógica del registro';


--
-- Name: COLUMN taxon_medicion.fecha_alta; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxon_medicion.fecha_alta IS 'Fecha de la alta de la medición.';


--
-- Name: COLUMN taxon_medicion.temp; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxon_medicion.temp IS 'Columna temporal de validación de carga de datos.';


--
-- Name: taxondataset; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.taxondataset (
    idtaxon numeric(40,0) NOT NULL,
    iddataset bigint NOT NULL,
    anioentrada integer,
    idvigente bigint NOT NULL,
    id bigint DEFAULT nextval('especie.sec_id_taxoncoleccion'::regclass),
    id_ambito_es integer NOT NULL,
    aniosalida integer
);


ALTER TABLE especie.taxondataset OWNER TO iepnb;

--
-- Name: TABLE taxondataset; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON TABLE especie.taxondataset IS 'https://dwc.tdwg.org/list/#dwc_Dataset';


--
-- Name: COLUMN taxondataset.idtaxon; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxondataset.idtaxon IS 'Identificador único de cada taxón';


--
-- Name: COLUMN taxondataset.iddataset; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxondataset.iddataset IS 'Id. del conjunto de datos del que proviene la información.';


--
-- Name: COLUMN taxondataset.anioentrada; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxondataset.anioentrada IS 'Año en el que el taxon se incluye en una colección dada.';


--
-- Name: COLUMN taxondataset.idvigente; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxondataset.idvigente IS 'Indica la vigencia del taxon en el dataset.';


--
-- Name: COLUMN taxondataset.aniosalida; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxondataset.aniosalida IS 'Año en el que el taxon se excluye del dataset.';


--
-- Name: taxondistribucion; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.taxondistribucion (
    iddistribucion numeric(40,0) NOT NULL,
    idtipodistribucion bigint,
    idtipoambitodistr integer,
    idambitodistr integer,
    coberturatemporal character varying,
    idtaxon numeric(40,0) NOT NULL,
    url character varying,
    idaplicadoa numeric(40,0) NOT NULL,
    observaciones character varying(1000),
    iddataset numeric(40,0) NOT NULL,
    idvigente bigint DEFAULT 1 NOT NULL,
    id_usuario_crea_registro integer,
    id_usuario_modifica_registro integer,
    id_tipo_cambio integer,
    fecha_creacion timestamp without time zone,
    fecha_modificacion timestamp without time zone,
    fecha_baja timestamp without time zone,
    idfuente integer
);


ALTER TABLE especie.taxondistribucion OWNER TO iepnb;

--
-- Name: TABLE taxondistribucion; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON TABLE especie.taxondistribucion IS 'https://github.com/tdwg/PlinianCore/wiki/DistributionType
Tabla que recoge datos de la distribución geográfica, categorizada por diversos criterios,  que presenta cada taxon.';


--
-- Name: COLUMN taxondistribucion.iddistribucion; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxondistribucion.iddistribucion IS 'Id. dela tabla.';


--
-- Name: COLUMN taxondistribucion.idtipodistribucion; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxondistribucion.idtipodistribucion IS 'Id. del tipo de distribución: Natural, potencial, histórica..';


--
-- Name: COLUMN taxondistribucion.iddataset; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxondistribucion.iddataset IS 'Id. del conjunto de datos del que proviene la información.';


--
-- Name: COLUMN taxondistribucion.idvigente; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxondistribucion.idvigente IS 'Id. de vigencia respecto al taxón';


--
-- Name: COLUMN taxondistribucion.id_usuario_crea_registro; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxondistribucion.id_usuario_crea_registro IS 'Id. del usuario que crea el registro';


--
-- Name: COLUMN taxondistribucion.id_usuario_modifica_registro; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxondistribucion.id_usuario_modifica_registro IS 'Id. del usuario que modifica el registro';


--
-- Name: COLUMN taxondistribucion.id_tipo_cambio; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxondistribucion.id_tipo_cambio IS 'Id. del tipo de cambio efectuado';


--
-- Name: COLUMN taxondistribucion.fecha_creacion; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxondistribucion.fecha_creacion IS 'Fecha de alta de la distribución';


--
-- Name: COLUMN taxondistribucion.fecha_modificacion; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxondistribucion.fecha_modificacion IS 'Fecha de la última modificación del registro';


--
-- Name: COLUMN taxondistribucion.fecha_baja; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxondistribucion.fecha_baja IS 'Fecha en la que se da de baja (lógica) del registro';


--
-- Name: COLUMN taxondistribucion.idfuente; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxondistribucion.idfuente IS 'Id. de la fuente a la que se asocia la distribución del taxón';


--
-- Name: taxonestadoconservacion; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.taxonestadoconservacion (
    idtaxon numeric(40,0) NOT NULL,
    estadoconservacion character varying,
    anio integer NOT NULL,
    idestadoconservacion numeric(40,0),
    idcategoria integer NOT NULL,
    idcriterio integer,
    id bigint DEFAULT nextval('especie.sec_id_taxoncoleccion'::regclass) NOT NULL,
    descripcion character varying,
    criterios character varying(1000),
    idautoridad integer,
    idaplicaa integer NOT NULL,
    iddataset bigint NOT NULL,
    fechaalta date,
    fechabaja date,
    idnombre numeric(40,0),
    idvisible integer,
    idvigente integer,
    observaciones character varying
);


ALTER TABLE especie.taxonestadoconservacion OWNER TO iepnb;

--
-- Name: TABLE taxonestadoconservacion; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON TABLE especie.taxonestadoconservacion IS 'https://github.com/tdwg/PlinianCore/wiki/ThreatStatusAtomizedType';


--
-- Name: COLUMN taxonestadoconservacion.idtaxon; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxonestadoconservacion.idtaxon IS 'Identificador único de cada taxón';


--
-- Name: COLUMN taxonestadoconservacion.estadoconservacion; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxonestadoconservacion.estadoconservacion IS 'Categoría del estado de conservación (en caso de no estar incluida en el catálogo especie.t_categoria_conservacion)';


--
-- Name: COLUMN taxonestadoconservacion.anio; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxonestadoconservacion.anio IS 'Año de evaluación del estado de conservación';


--
-- Name: COLUMN taxonestadoconservacion.idcategoria; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxonestadoconservacion.idcategoria IS 'Categoría de evaluación según catálogo especie._t_categoria_conservación';


--
-- Name: COLUMN taxonestadoconservacion.idcriterio; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxonestadoconservacion.idcriterio IS 'Identificador del criterio de evaluación según catálogo especie.t_criteriomedidaconservacion';


--
-- Name: COLUMN taxonestadoconservacion.descripcion; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxonestadoconservacion.descripcion IS 'Descripción del registro';


--
-- Name: COLUMN taxonestadoconservacion.criterios; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxonestadoconservacion.criterios IS 'Criterios de evaluación';


--
-- Name: COLUMN taxonestadoconservacion.idautoridad; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxonestadoconservacion.idautoridad IS 'Autoridad que realiza la evaluación.';


--
-- Name: COLUMN taxonestadoconservacion.idaplicaa; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxonestadoconservacion.idaplicaa IS 'Ámbito de aplicación.';


--
-- Name: COLUMN taxonestadoconservacion.iddataset; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxonestadoconservacion.iddataset IS 'Id. del conjunto de datos del que proviene la información.';


--
-- Name: COLUMN taxonestadoconservacion.fechaalta; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxonestadoconservacion.fechaalta IS 'Fecha de entrada del registro en la BDD.';


--
-- Name: COLUMN taxonestadoconservacion.idvigente; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxonestadoconservacion.idvigente IS 'Indica si el dato es vigente';


--
-- Name: taxonestadolegal; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.taxonestadolegal (
    idtaxon numeric(40,0) NOT NULL,
    idestadolegal bigint NOT NULL,
    id numeric(40,0) DEFAULT nextval('especie.sec_id_taxonestadolegal'::regclass),
    idvigente bigint,
    observacionespoblacion character varying,
    descripcion character varying,
    idaplicadoa numeric(40,0),
    iddataset numeric(40,0),
    id_tipo_cambio integer,
    fecha_alta date,
    fecha_baja date
);


ALTER TABLE especie.taxonestadolegal OWNER TO iepnb;

--
-- Name: TABLE taxonestadolegal; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON TABLE especie.taxonestadolegal IS 'https://github.com/tdwg/PlinianCore/wiki/LegislationType';


--
-- Name: COLUMN taxonestadolegal.iddataset; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxonestadolegal.iddataset IS 'Id. del conjunto de datos del que proviene la información.';


--
-- Name: COLUMN taxonestadolegal.id_tipo_cambio; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxonestadolegal.id_tipo_cambio IS 'Tipo de cambio efectuado';


--
-- Name: COLUMN taxonestadolegal.fecha_baja; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxonestadolegal.fecha_baja IS 'Id. del origen del taxón en Canarias';


--
-- Name: taxonfactoresamenaza; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.taxonfactoresamenaza (
    idtaxon numeric(40,0) NOT NULL,
    idfactoramenaza integer NOT NULL,
    idtituloamenaza integer,
    fecha date,
    idimportancia integer,
    observaciones character varying,
    idaplicaa integer NOT NULL,
    id integer DEFAULT nextval('especie.sec_id_vigencia'::regclass),
    iddataset numeric(40,0) NOT NULL,
    id_tipo_medicion integer NOT NULL
);


ALTER TABLE especie.taxonfactoresamenaza OWNER TO iepnb;

--
-- Name: COLUMN taxonfactoresamenaza.iddataset; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxonfactoresamenaza.iddataset IS 'Id. del conjunto de datos del que proviene la información.';


--
-- Name: taxonhabitat; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.taxonhabitat (
    idtaxon numeric(40,0) NOT NULL,
    idhabitat numeric(20,0) NOT NULL,
    idfuente integer,
    id numeric(40,0) DEFAULT nextval('especie.sec_id_taxoncoleccion'::regclass),
    iddataset numeric(40,0) NOT NULL,
    idaplicaa numeric(40,0) NOT NULL,
    id_tipo_cambio integer DEFAULT 1 NOT NULL,
    idvigente bigint DEFAULT 1 NOT NULL,
    fecha_creacion timestamp without time zone,
    fecha_modificacion timestamp without time zone,
    id_usuario_crea_registro integer,
    id_usuario_modifica_registro integer,
    fecha_alta timestamp without time zone,
    fecha_baja timestamp without time zone
);


ALTER TABLE especie.taxonhabitat OWNER TO iepnb;

--
-- Name: COLUMN taxonhabitat.iddataset; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxonhabitat.iddataset IS 'Id. del conjunto de datos del que proviene la información.';


--
-- Name: COLUMN taxonhabitat.id_tipo_cambio; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxonhabitat.id_tipo_cambio IS 'Tipo de cambio efectuado';


--
-- Name: COLUMN taxonhabitat.idvigente; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxonhabitat.idvigente IS 'Id de vigencia respecto al taxon';


--
-- Name: COLUMN taxonhabitat.fecha_creacion; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxonhabitat.fecha_creacion IS 'Fecha de creación del registro';


--
-- Name: COLUMN taxonhabitat.fecha_modificacion; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxonhabitat.fecha_modificacion IS 'Fecha de modificación del registro';


--
-- Name: COLUMN taxonhabitat.id_usuario_crea_registro; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxonhabitat.id_usuario_crea_registro IS 'Usuario creador del registro';


--
-- Name: COLUMN taxonhabitat.id_usuario_modifica_registro; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxonhabitat.id_usuario_modifica_registro IS 'Usuario modificador del registro';


--
-- Name: COLUMN taxonhabitat.fecha_alta; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxonhabitat.fecha_alta IS 'Fecha de alta del hábitat';


--
-- Name: COLUMN taxonhabitat.fecha_baja; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxonhabitat.fecha_baja IS 'Fecha de baja del hábitat';


--
-- Name: taxonmedidaconservacion; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.taxonmedidaconservacion (
    idtaxon numeric(40,0) NOT NULL,
    idmedidaconservacion integer NOT NULL,
    idtipomedidaconservacion integer,
    idimportancia integer,
    idcriterio integer,
    anio character varying,
    observaciones character varying,
    idaplicadoa bigint,
    iddataset numeric(40,0)
);


ALTER TABLE especie.taxonmedidaconservacion OWNER TO iepnb;

--
-- Name: COLUMN taxonmedidaconservacion.iddataset; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxonmedidaconservacion.iddataset IS 'Id. del conjunto de datos del que proviene la información.';


--
-- Name: taxonomia; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.taxonomia (
    idnombre numeric(40,0) NOT NULL,
    idtiponombre bigint,
    taxonconceptid character varying(255),
    idphylum numeric(38,0),
    idorder numeric(38,0),
    idfamily numeric(38,0),
    idgenus numeric(38,0),
    idsubgenus numeric(38,0),
    idgrupotaxonomico numeric(38,0),
    idkingdom numeric(38,0),
    idtaxonrank bigint,
    verbatimtaxonrank character varying(255),
    specificepithet character varying(255),
    infraspecificepithet character varying(255),
    idclass numeric(38,0),
    idpadre numeric(38,0),
    scientificnameid character varying(500),
    originalnameusage character varying(500),
    nameaccordingto character varying(500),
    namepublishedin character varying(500),
    namepublishedinyear character varying(500),
    scientificnameauthorship character varying(500),
    remarks character varying(500),
    withoutauthorship character varying(500),
    idsubgrupotaxonomico integer,
    idvigente bigint DEFAULT 1 NOT NULL,
    fecha_alta timestamp without time zone,
    fecha_baja timestamp without time zone
);


ALTER TABLE especie.taxonomia OWNER TO iepnb;

--
-- Name: COLUMN taxonomia.taxonconceptid; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxonomia.taxonconceptid IS 'https://github.com/PlinianCore/Documentation/wiki/BaseElementsClass     An identifier for the taxonomic concept to which the record refers - not for the nomenclatural details of a taxon.';


--
-- Name: COLUMN taxonomia.idgrupotaxonomico; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxonomia.idgrupotaxonomico IS 'Borrar??-ya está en tabla TAXON';


--
-- Name: COLUMN taxonomia.verbatimtaxonrank; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxonomia.verbatimtaxonrank IS 'Borrar- ya está en  tabla TAXONRANK';


--
-- Name: COLUMN taxonomia.specificepithet; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxonomia.specificepithet IS 'Add';


--
-- Name: COLUMN taxonomia.infraspecificepithet; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxonomia.infraspecificepithet IS 'Add';


--
-- Name: COLUMN taxonomia.idclass; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxonomia.idclass IS 'Add';


--
-- Name: COLUMN taxonomia.idpadre; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxonomia.idpadre IS 'Add';


--
-- Name: COLUMN taxonomia.scientificnameid; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxonomia.scientificnameid IS 'http://tdwg.github.io/dwc/terms/#scientificNameID  Add';


--
-- Name: COLUMN taxonomia.originalnameusage; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxonomia.originalnameusage IS 'http://rs.tdwg.org/dwc/terms/#originalNameUsage  Add';


--
-- Name: COLUMN taxonomia.nameaccordingto; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxonomia.nameaccordingto IS 'http://rs.tdwg.org/dwc/terms/#nameAccordingTo Add';


--
-- Name: COLUMN taxonomia.namepublishedin; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxonomia.namepublishedin IS 'http://rs.tdwg.org/dwc/terms/#namePublishedIn   Add';


--
-- Name: COLUMN taxonomia.namepublishedinyear; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxonomia.namepublishedinyear IS 'http://rs.tdwg.org/dwc/terms/#namePublishedInYear   Add';


--
-- Name: COLUMN taxonomia.scientificnameauthorship; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxonomia.scientificnameauthorship IS 'http://rs.tdwg.org/dwc/terms/#scientificNameAuthorship  Add';


--
-- Name: taxonplanesgestion; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.taxonplanesgestion (
    idtaxon numeric(40,0) NOT NULL,
    idplan integer NOT NULL,
    idtipoplan integer,
    idimportancia integer,
    plan character varying,
    fecha date,
    url character varying,
    observaciones character varying,
    idaplicadoa bigint,
    iddataset numeric(40,0),
    idnorma numeric(40,0),
    idestado_vigencia integer,
    idobjetivoplan smallint,
    id integer NOT NULL,
    fecha_alta date,
    fecha_baja date
);


ALTER TABLE especie.taxonplanesgestion OWNER TO iepnb;

--
-- Name: COLUMN taxonplanesgestion.iddataset; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxonplanesgestion.iddataset IS 'Id. del conjunto de datos del que proviene la información.';


--
-- Name: COLUMN taxonplanesgestion.fecha_alta; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxonplanesgestion.fecha_alta IS 'Fecha de alta del registro.';


--
-- Name: COLUMN taxonplanesgestion.fecha_baja; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxonplanesgestion.fecha_baja IS 'Fecha de baja del registro.';


--
-- Name: taxonplanesgestion_id_seq; Type: SEQUENCE; Schema: especie; Owner: iepnb
--

CREATE SEQUENCE especie.taxonplanesgestion_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE especie.taxonplanesgestion_id_seq OWNER TO iepnb;

--
-- Name: taxonplanesgestion_id_seq; Type: SEQUENCE OWNED BY; Schema: especie; Owner: iepnb
--

ALTER SEQUENCE especie.taxonplanesgestion_id_seq OWNED BY especie.taxonplanesgestion.id;


--
-- Name: taxonreferencia; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.taxonreferencia (
    idreferencia numeric(20,0) NOT NULL,
    idtaxon numeric(40,0) NOT NULL,
    id integer DEFAULT nextval('especie.sec_id_taxonnombre'::regclass) NOT NULL,
    iddataset numeric(40,0)
);


ALTER TABLE especie.taxonreferencia OWNER TO iepnb;

--
-- Name: COLUMN taxonreferencia.iddataset; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxonreferencia.iddataset IS 'Id. del conjunto de datos del que proviene la información.';


--
-- Name: taxonviaintroduccion; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.taxonviaintroduccion (
    idtaxon numeric(40,0) NOT NULL,
    idrutaintroduccion bigint NOT NULL,
    id integer,
    iddataset numeric(40,0)
);


ALTER TABLE especie.taxonviaintroduccion OWNER TO iepnb;

--
-- Name: COLUMN taxonviaintroduccion.iddataset; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.taxonviaintroduccion.iddataset IS 'Id. del conjunto de datos del que proviene la información.';


--
-- Name: tgis_linea; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.tgis_linea (
    id_gis_medicion_poligon numeric(20,0) NOT NULL,
    cod_ocurrencia character varying(50),
    id_tipo_medicion numeric(20,0),
    id_poligon numeric(20,0)
);


ALTER TABLE especie.tgis_linea OWNER TO iepnb;

--
-- Name: tgis_poligon; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.tgis_poligon (
    id_gis_medicion_poligon numeric(20,0) NOT NULL,
    cod_ocurencia character varying(50),
    id_tipo_medicion numeric(20,0),
    id_poligon numeric(20,0)
);


ALTER TABLE especie.tgis_poligon OWNER TO iepnb;

--
-- Name: COLUMN tgis_poligon.id_gis_medicion_poligon; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.tgis_poligon.id_gis_medicion_poligon IS 'Identificador del regitro. FK a TSEG_OCURRENCIA.';


--
-- Name: COLUMN tgis_poligon.cod_ocurencia; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.tgis_poligon.cod_ocurencia IS 'Código identificador de ocurrencia.';


--
-- Name: COLUMN tgis_poligon.id_tipo_medicion; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.tgis_poligon.id_tipo_medicion IS 'Identificador del tipo de medición. FK a la tabla TSEG_TIPO_MEDICION';


--
-- Name: COLUMN tgis_poligon.id_poligon; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.tgis_poligon.id_poligon IS 'Identificador del poligon de la capa correspondiente';


--
-- Name: tgis_punto; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.tgis_punto (
    id_gis_medicion_poligon numeric(20,0) NOT NULL,
    cod_ocurencia character varying(50),
    id_tipo_medicion numeric(20,0),
    id_punto numeric(20,0)
);


ALTER TABLE especie.tgis_punto OWNER TO iepnb;

--
-- Name: usos; Type: TABLE; Schema: especie; Owner: iepnb
--

CREATE TABLE especie.usos (
    iduso numeric(40,0) NOT NULL,
    idfuente integer,
    parte_usada character varying,
    usuarios character varying(50),
    organismo character varying(50),
    anotaciones_nombre character varying(250),
    detalle_produccion character varying(50),
    forma_administration character varying(50),
    temporada_disponible character varying(50),
    datos_explotacion character varying(50),
    economia character varying(50),
    calificacion_popularidad character varying(50),
    propiedades character varying(50),
    potencial character varying(50),
    notas character varying(400),
    idtaxon numeric(40,0),
    iduso1 integer,
    iduso2 integer,
    iduso3 bigint,
    idaplicadoa numeric(40,0),
    iddataset numeric(40,0)
);


ALTER TABLE especie.usos OWNER TO iepnb;

--
-- Name: TABLE usos; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON TABLE especie.usos IS 'https://github.com/tdwg/PlinianCore/wiki/UsesAtomizedType';


--
-- Name: COLUMN usos.iduso; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.usos.iduso IS 'Id. de la tabla';


--
-- Name: COLUMN usos.idfuente; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.usos.idfuente IS '¿De dónde viene la observación? Se deben dar citas de referencia. Cuando proceda, deberán facilitarse los datos del modelo de comprobante (coleccionista, número, fecha, herbario), así como los datos del informante registrado (nombre, sexo, edad aproximada, ocupación, identidad étnica, localidad e idioma hablado).';


--
-- Name: COLUMN usos.parte_usada; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.usos.parte_usada IS 'El grupo de usuarios que reconoce el valor y/o uso de la planta.';


--
-- Name: COLUMN usos.usuarios; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.usos.usuarios IS 'El grupo de usuarios que reconoce el valor y/o uso de la planta.';


--
-- Name: COLUMN usos.organismo; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.usos.organismo IS 'Organismos que utilizan las partes de la planta/ planta.';


--
-- Name: COLUMN usos.anotaciones_nombre; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.usos.anotaciones_nombre IS 'El nombre del taxón debe distinguirse del nombre de las partes de la planta, los nombres de las etapas de procesamiento y el nombre del producto final. Deben identificarse los nombres utilizados en el comercio. También debe mencionarse si cualquier nombre vernáculo se refiere a más de un taxón. El uso de algunos nombres puede estar restringido a una época del año u ocasión, o tener connotaciones sagradas. El idioma o dialecto al que pertenecen los nombres debe indicarse junto con los detalles del grupo étnico. Se debe tener cuidado con la transliteración al alfabeto romano; si existe un sistema estándar, úselo y anote cuál es.';


--
-- Name: COLUMN usos.detalle_produccion; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.usos.detalle_produccion IS 'Proporcione detalles de la protección, el cultivo, la cosecha, los rendimientos, los métodos de procesamiento y almacenamiento utilizados y tome nota de las herramientas especiales, el tiempo, etc.';


--
-- Name: COLUMN usos.forma_administration; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.usos.forma_administration IS 'Esto es específico relevante para medicamentos, venenos.';


--
-- Name: COLUMN usos.temporada_disponible; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.usos.temporada_disponible IS 'La temporada en la que la planta está disponible/se utiliza y, si es relevante, la hora del día.';


--
-- Name: COLUMN usos.datos_explotacion; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.usos.datos_explotacion IS 'Detalles de las propiedades que influyen en su valor para un propósito específico.';


--
-- Name: COLUMN usos.economia; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.usos.economia IS 'Detalles de las propiedades que influyen en su valor para un propósito específico.';


--
-- Name: COLUMN usos.calificacion_popularidad; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.usos.calificacion_popularidad IS 'Evaluación de la planta para su uso y posible preferencia a otras especies, señalando, en este caso, qué especies son. Es útil registrar los factores que influyen en cualquier preferencia.';


--
-- Name: COLUMN usos.propiedades; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.usos.propiedades IS 'Detalles de las propiedades que influyen en su valor para un propósito específico.';


--
-- Name: COLUMN usos.potencial; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.usos.potencial IS 'Aumento potencial del uso, cultivo o producción o posibilidad de introducción en otras zonas o grupos sociales';


--
-- Name: COLUMN usos.notas; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.usos.notas IS 'Aumento potencial del uso, cultivo o producción o posibilidad de introducción en otras zonas o grupos sociales';


--
-- Name: COLUMN usos.iddataset; Type: COMMENT; Schema: especie; Owner: iepnb
--

COMMENT ON COLUMN especie.usos.iddataset IS 'Id. del conjunto de datos del que proviene la información.';


--
-- Name: v_ind_15_1_lesrpe_ceea_especies; Type: VIEW; Schema: especie; Owner: iepnb
--

CREATE VIEW especie.v_ind_15_1_lesrpe_ceea_especies AS
 SELECT a.iddataset,
    a.idtaxon,
    a.cod_ambito,
    a.idgrupotax,
    a.grupotax,
    a.idestadolegal,
    a.estadolegal,
    a.idvigente,
    a.observacionespoblacion,
    a.id_norma,
    a.norma,
    tn.idnombre,
    tn.idtiponombre,
    tn.idnombre AS idnombreaceptado,
    o.nombre AS nombreaceptado,
    x.idtaxonrank,
    r.taxonrank,
        CASE
            WHEN (x.idtaxonrank = 10) THEN a.idtaxon
            WHEN (x.idtaxonrank > 10) THEN x.idpadre
            ELSE NULL::numeric
        END AS id,
    CURRENT_DATE AS fecha_calculo
   FROM ((((( SELECT el.iddataset,
            l.idtaxon,
            t.cod_ambito,
            t.idgrupotax,
            tngt.nombre AS grupotax,
            l.idestadolegal,
            el.idestadolegaldataset,
            el.estadolegal,
            l.idvigente,
            l.observacionespoblacion,
            el.id_norma,
            n.norma
           FROM ((((especie.taxonestadolegal l
             JOIN especie.t_estadolegal el ON ((l.idestadolegal = el.idestadolegal)))
             JOIN comun.t_norma n ON ((n.id_norma = el.id_norma)))
             JOIN especie.taxon t ON ((t.idtaxon = l.idtaxon)))
             JOIN comun.t_nombre_grupo_taxonomico tngt ON ((tngt.id_nombre_grupo_taxon = (t.idgrupotax)::numeric)))
          WHERE ((el.iddataset = (12)::numeric) AND (l.idvigente = 1) AND (el.idestadolegaldataset <> (4)::numeric))) a
     LEFT JOIN especie.taxonnombre tn ON ((tn.idtaxon = a.idtaxon)))
     JOIN especie.nombre o ON ((o.idnombre = tn.idnombre)))
     JOIN especie.taxonomia x ON ((x.idnombre = tn.idnombre)))
     JOIN especie.t_taxonrank r ON ((r.idtaxonrank = x.idtaxonrank)))
  WHERE (tn.idtiponombre = 10);


ALTER VIEW especie.v_ind_15_1_lesrpe_ceea_especies OWNER TO iepnb;

--
-- Name: v_ind_16_1_especies_planes19; Type: VIEW; Schema: especie; Owner: iepnb
--

CREATE VIEW especie.v_ind_16_1_especies_planes19 AS
 SELECT DISTINCT t.iddataset,
    t.idtaxon,
    t.cod_ambito,
    t.idgrupotax,
    t.grupotax,
    te.idestadolegaldataset,
    t.estadolegal,
    t.idvigente,
    t.observacionespoblacion,
    pn.idaplicaa_nut2,
    pn.excepto_idaplicaa_nut2,
    b.array1,
    g.idaplicadoa,
    ad.aplicadoa_distribucion,
    t.id_norma,
    t.norma,
    t.idnombre,
    t.idtiponombre,
    t.idnombreaceptado,
    t.nombreaceptado,
    t.idtaxonrank,
    t.taxonrank,
    t.id,
    t.fecha_calculo,
    g.idtipoplan,
    ttp.nombre AS tipoplan,
    g.idestado_vigencia,
    g.plan,
    g.fecha,
    g.observaciones,
    g.idobjetivoplan,
    top.objetivoplan
   FROM (((((((especie.v_ind_15_1_lesrpe_ceea_especies t
     LEFT JOIN especie.t_estadolegal te ON ((te.idestadolegal = t.idestadolegal)))
     LEFT JOIN especie.poblacion_aplicaa_nut2 pn ON (((pn.observacionespoblacion)::text = (t.observacionespoblacion)::text)))
     LEFT JOIN ( SELECT DISTINCT a.observacionespoblacion,
            array_agg(apn.excepto_idaplicaa_nut2) AS array1
           FROM ((especie.v_ind_15_1_lesrpe_ceea_especies a
             LEFT JOIN especie.t_estadolegal ate ON ((ate.idestadolegal = a.idestadolegal)))
             LEFT JOIN especie.poblacion_aplicaa_nut2 apn ON (((apn.observacionespoblacion)::text = (a.observacionespoblacion)::text)))
          GROUP BY a.observacionespoblacion) b ON (((b.observacionespoblacion)::text = (t.observacionespoblacion)::text)))
     LEFT JOIN especie.taxonplanesgestion g ON ((g.idtaxon = t.idtaxon)))
     LEFT JOIN comun.t_tipo_plan ttp ON ((ttp.id_tipo_plan = g.idtipoplan)))
     LEFT JOIN especie.t_objetivo_planesgestion top ON ((top.idobjetivoplan = g.idobjetivoplan)))
     LEFT JOIN especie.t_aplicaa_distribucion ad ON ((ad.idaplicaa = (g.idaplicadoa)::numeric)))
  WHERE ((g.idestado_vigencia = 1) AND (g.idobjetivoplan = 1) AND (g.idtipoplan = 2) AND (((t.observacionespoblacion)::text = ''::text) OR ((pn.idaplicaa_nut2 = 30) AND (pn.excepto_idaplicaa_nut2 = 0)) OR ((pn.excepto_idaplicaa_nut2 > 0) AND (POSITION(((g.idaplicadoa)::text) IN (array_to_string(b.array1, ' , '::text, ''::text))) = 0)) OR ((pn.idaplicaa_nut2 = g.idaplicadoa) AND (pn.excepto_idaplicaa_nut2 = 0))));


ALTER VIEW especie.v_ind_16_1_especies_planes19 OWNER TO iepnb;

--
-- Name: v_ind_16_1_especies_planes; Type: VIEW; Schema: especie; Owner: iepnb
--

CREATE VIEW especie.v_ind_16_1_especies_planes AS
 SELECT DISTINCT iddataset,
    idtaxon,
    cod_ambito,
    idgrupotax,
    grupotax,
    idestadolegaldataset,
    estadolegal,
    idvigente,
    observacionespoblacion,
    id_norma,
    norma,
    idnombre,
    idtiponombre,
    idnombreaceptado,
    nombreaceptado,
    idtaxonrank,
    taxonrank,
    id,
    fecha_calculo,
    idtipoplan,
    tipoplan,
    idestado_vigencia,
    plan,
    fecha,
    idaplicadoa,
    aplicadoa_distribucion,
    observaciones,
    idobjetivoplan,
    objetivoplan
   FROM especie.v_ind_16_1_especies_planes19 t;


ALTER VIEW especie.v_ind_16_1_especies_planes OWNER TO iepnb;

--
-- Name: v_ind_16_2_group; Type: VIEW; Schema: especie; Owner: iepnb
--

CREATE VIEW especie.v_ind_16_2_group AS
 SELECT DISTINCT cod_ambito,
    idgrupotax,
    grupotax,
    idestadolegaldataset,
    estadolegal,
    id,
    idtipoplan,
    tipoplan,
    plan,
    idaplicadoa,
    aplicadoa_distribucion
   FROM especie.v_ind_16_1_especies_planes
  GROUP BY cod_ambito, idgrupotax, grupotax, idestadolegaldataset, estadolegal, id, idtipoplan, tipoplan, plan, idaplicadoa, aplicadoa_distribucion;


ALTER VIEW especie.v_ind_16_2_group OWNER TO iepnb;

--
-- Name: v_ind_16_3_group_especie; Type: VIEW; Schema: especie; Owner: iepnb
--

CREATE VIEW especie.v_ind_16_3_group_especie AS
 SELECT DISTINCT cod_ambito,
    idgrupotax,
    grupotax,
    idestadolegaldataset,
    estadolegal,
    id
   FROM especie.v_ind_16_2_group
  GROUP BY cod_ambito, idgrupotax, grupotax, idestadolegaldataset, estadolegal, id;


ALTER VIEW especie.v_ind_16_3_group_especie OWNER TO iepnb;

--
-- Name: v_ind_16_4_suma_especies; Type: VIEW; Schema: especie; Owner: iepnb
--

CREATE VIEW especie.v_ind_16_4_suma_especies AS
 SELECT CURRENT_DATE AS fecha_calculo,
    grupotax,
    cod_ambito,
    idestadolegaldataset,
    estadolegal,
    count(id) AS num_sp
   FROM especie.v_ind_16_3_group_especie t
  GROUP BY grupotax, cod_ambito, estadolegal, idestadolegaldataset;


ALTER VIEW especie.v_ind_16_4_suma_especies OWNER TO iepnb;

--
-- Name: v_ind_16_5_suma_especies_tot; Type: VIEW; Schema: especie; Owner: iepnb
--

CREATE VIEW especie.v_ind_16_5_suma_especies_tot AS
 SELECT CURRENT_DATE AS fecha_calculo,
    grupotax,
    cod_ambito,
    count(id) AS num_sp_total
   FROM especie.v_ind_16_3_group_especie t
  GROUP BY grupotax, cod_ambito;


ALTER VIEW especie.v_ind_16_5_suma_especies_tot OWNER TO iepnb;

--
-- Name: v_ind_16_6_suma_planes; Type: VIEW; Schema: especie; Owner: iepnb
--

CREATE VIEW especie.v_ind_16_6_suma_planes AS
 SELECT CURRENT_DATE AS fecha_calculo,
    grupotax,
    cod_ambito,
    idestadolegaldataset,
    estadolegal,
    count(id) AS num_planes
   FROM especie.v_ind_16_2_group t
  GROUP BY grupotax, cod_ambito, estadolegal, idestadolegaldataset;


ALTER VIEW especie.v_ind_16_6_suma_planes OWNER TO iepnb;

--
-- Name: v_ind_16_7_suma_planes_tot; Type: VIEW; Schema: especie; Owner: iepnb
--

CREATE VIEW especie.v_ind_16_7_suma_planes_tot AS
 SELECT CURRENT_DATE AS fecha_calculo,
    grupotax,
    cod_ambito,
    count(id) AS num_planes_total
   FROM especie.v_ind_16_2_group t
  GROUP BY grupotax, cod_ambito;


ALTER VIEW especie.v_ind_16_7_suma_planes_tot OWNER TO iepnb;

--
-- Name: v_ind_16_lesrpe_ceea_planes2; Type: VIEW; Schema: especie; Owner: iepnb
--

CREATE VIEW especie.v_ind_16_lesrpe_ceea_planes2 AS
 SELECT e.fecha_calculo,
    e.grupotax,
    e.cod_ambito,
    e.num_sp_total,
    p.num_planes_total,
        CASE
            WHEN (se.idestadolegaldataset = (1)::numeric) THEN se.num_sp
            ELSE NULL::bigint
        END AS sp_lesrpe,
        CASE
            WHEN (se.idestadolegaldataset = (2)::numeric) THEN se.num_sp
            ELSE NULL::bigint
        END AS sp_vulnerable,
        CASE
            WHEN (se.idestadolegaldataset = (3)::numeric) THEN se.num_sp
            ELSE NULL::bigint
        END AS sp_peligro_ext
   FROM (((especie.v_ind_16_5_suma_especies_tot e
     LEFT JOIN especie.v_ind_16_7_suma_planes_tot p ON ((((p.grupotax)::text = (e.grupotax)::text) AND ((p.cod_ambito)::text = (e.cod_ambito)::text))))
     LEFT JOIN especie.v_ind_16_4_suma_especies se ON ((((se.grupotax)::text = (e.grupotax)::text) AND ((se.cod_ambito)::text = (e.cod_ambito)::text))))
     LEFT JOIN especie.v_ind_16_6_suma_planes sp ON ((((sp.grupotax)::text = (e.grupotax)::text) AND ((sp.cod_ambito)::text = (e.cod_ambito)::text))));


ALTER VIEW especie.v_ind_16_lesrpe_ceea_planes2 OWNER TO iepnb;

--
-- Name: v_ind_16_lesrpe_ceea_planes3; Type: VIEW; Schema: especie; Owner: iepnb
--

CREATE VIEW especie.v_ind_16_lesrpe_ceea_planes3 AS
 SELECT DISTINCT fecha_calculo,
    grupotax,
    cod_ambito,
    num_sp_total,
    num_planes_total,
    sum(sp_lesrpe) AS num_sp_lesrpe,
    sum(sp_vulnerable) AS num_sp_vulnerable,
    sum(sp_peligro_ext) AS num_sp_peligro_ext
   FROM ( SELECT e.fecha_calculo,
            e.grupotax,
            e.cod_ambito,
            e.num_sp_total,
            p.num_planes_total,
                CASE
                    WHEN (se.idestadolegaldataset = (1)::numeric) THEN se.num_sp
                    ELSE NULL::bigint
                END AS sp_lesrpe,
                CASE
                    WHEN (se.idestadolegaldataset = (2)::numeric) THEN se.num_sp
                    ELSE NULL::bigint
                END AS sp_vulnerable,
                CASE
                    WHEN (se.idestadolegaldataset = (3)::numeric) THEN se.num_sp
                    ELSE NULL::bigint
                END AS sp_peligro_ext
           FROM ((especie.v_ind_16_5_suma_especies_tot e
             LEFT JOIN especie.v_ind_16_7_suma_planes_tot p ON ((((p.grupotax)::text = (e.grupotax)::text) AND ((p.cod_ambito)::text = (e.cod_ambito)::text))))
             LEFT JOIN especie.v_ind_16_4_suma_especies se ON ((((se.grupotax)::text = (e.grupotax)::text) AND ((se.cod_ambito)::text = (e.cod_ambito)::text))))) a
  GROUP BY fecha_calculo, grupotax, cod_ambito, num_sp_total, num_planes_total;


ALTER VIEW especie.v_ind_16_lesrpe_ceea_planes3 OWNER TO iepnb;

--
-- Name: v_ind_16_lesrpe_ceea_planes5; Type: VIEW; Schema: especie; Owner: iepnb
--

CREATE VIEW especie.v_ind_16_lesrpe_ceea_planes5 AS
 SELECT DISTINCT a.fecha_calculo,
    a.grupotax,
    a.cod_ambito,
    a.num_sp_total,
    a.num_planes_total,
    a.num_sp_lesrpe,
    a.num_sp_vulnerable,
    a.num_sp_peligro_ext,
        CASE
            WHEN (sp.idestadolegaldataset = (1)::numeric) THEN sp.num_planes
            ELSE NULL::bigint
        END AS planes_lesrpe,
        CASE
            WHEN (sp.idestadolegaldataset = (2)::numeric) THEN sp.num_planes
            ELSE NULL::bigint
        END AS planes_vulnerable,
        CASE
            WHEN (sp.idestadolegaldataset = (3)::numeric) THEN sp.num_planes
            ELSE NULL::bigint
        END AS planes_peligro_ext
   FROM (especie.v_ind_16_lesrpe_ceea_planes3 a
     LEFT JOIN especie.v_ind_16_6_suma_planes sp ON ((((sp.grupotax)::text = (a.grupotax)::text) AND ((sp.cod_ambito)::text = (a.cod_ambito)::text))));


ALTER VIEW especie.v_ind_16_lesrpe_ceea_planes5 OWNER TO iepnb;

--
-- Name: v_ind_16_lesrpe_ceea_planes6; Type: VIEW; Schema: especie; Owner: iepnb
--

CREATE VIEW especie.v_ind_16_lesrpe_ceea_planes6 AS
 SELECT DISTINCT fecha_calculo,
    grupotax,
    cod_ambito,
    num_sp_total,
    num_planes_total,
    num_sp_lesrpe,
    sum(planes_lesrpe) AS num_planes_lesrpe,
    num_sp_vulnerable,
    sum(planes_vulnerable) AS num_planes_vulnerable,
    num_sp_peligro_ext,
    sum(planes_peligro_ext) AS num_planes_peligro_ext
   FROM especie.v_ind_16_lesrpe_ceea_planes5 a
  GROUP BY fecha_calculo, grupotax, cod_ambito, num_sp_total, num_planes_total, num_sp_lesrpe, num_sp_vulnerable, num_sp_peligro_ext;


ALTER VIEW especie.v_ind_16_lesrpe_ceea_planes6 OWNER TO iepnb;

--
-- Name: v_ind_3aves_1_especie; Type: VIEW; Schema: especie; Owner: iepnb
--

CREATE VIEW especie.v_ind_3aves_1_especie AS
 SELECT DISTINCT tm.idtaxon,
    tn.idnombre,
    n.nombre AS nombrecolec,
    tn.idtiponombre,
    tn.iddataset,
    t.idgrupotax,
    tngt.nombre AS grupotax,
    t.cod_ambito,
    tm.anio_inicio,
    tm.anio_final,
    tm.idtipomedida,
    ttm.nombre AS tipomedicion,
    tm.id_valor_medida,
    tvm.valor,
    tm.idaplicadoa,
    tad.aplicadoa_distribucion,
    tm.id_ambito_es,
    tae.ambito
   FROM (((((((((especie.taxon_medicion tm
     LEFT JOIN especie.taxon t ON ((t.idtaxon = tm.idtaxon)))
     LEFT JOIN especie.taxonnombre tn ON ((t.idtaxon = tn.idtaxon)))
     LEFT JOIN especie.nombre n ON ((tn.idnombre = n.idnombre)))
     LEFT JOIN especie.taxonomia x_1 ON ((n.idnombre = x_1.idnombre)))
     LEFT JOIN comun.t_nombre_grupo_taxonomico tngt ON (((t.idgrupotax)::numeric = tngt.id_nombre_grupo_taxon)))
     LEFT JOIN especie.t_aplicaa_distribucion tad ON ((tad.idaplicaa = (tm.idaplicadoa)::numeric)))
     LEFT JOIN especie.t_ambito_es tae ON ((tae.id_ambito_es = tm.id_ambito_es)))
     LEFT JOIN comun.t_tipo_medicion ttm ON ((ttm.id_tipo_medicion = (tm.idtipomedida)::numeric)))
     LEFT JOIN comun.t_valor_medida tvm ON ((tvm.id_valor_medida = tm.id_valor_medida)))
  WHERE ((tm.idtipomedida = 5) AND (tm.iddataset = (71)::numeric) AND (tn.idtiponombre = 30) AND (tn.iddataset = (71)::numeric))
  ORDER BY n.nombre;


ALTER VIEW especie.v_ind_3aves_1_especie OWNER TO iepnb;

--
-- Name: v_ind_3aves_2_especie_agrup; Type: VIEW; Schema: especie; Owner: iepnb
--

CREATE VIEW especie.v_ind_3aves_2_especie_agrup AS
 SELECT DISTINCT nombrecolec,
    idtiponombre,
    iddataset,
    idgrupotax,
    grupotax,
    cod_ambito,
    anio_inicio,
    anio_final,
    idtipomedida,
    tipomedicion,
    id_valor_medida,
    valor,
    idaplicadoa,
    aplicadoa_distribucion,
    id_ambito_es,
    ambito
   FROM especie.v_ind_3aves_1_especie
  ORDER BY nombrecolec;


ALTER VIEW especie.v_ind_3aves_2_especie_agrup OWNER TO iepnb;

--
-- Name: v_ind_3aves_3; Type: VIEW; Schema: especie; Owner: iepnb
--

CREATE VIEW especie.v_ind_3aves_3 AS
 SELECT aplicadoa_distribucion,
    ambito,
    sum(catd) AS d,
    sum(catf) AS f,
    sum(cati) AS i,
    sum(cats) AS s,
    sum(catu) AS u,
    sum(catunk) AS unk,
    sum(total) AS totaleval
   FROM ( SELECT DISTINCT v.aplicadoa_distribucion,
            v.ambito,
                CASE
                    WHEN ((v.valor)::text = 'Regresiva'::text) THEN count(v.valor)
                    ELSE NULL::bigint
                END AS catd,
                CASE
                    WHEN ((v.valor)::text ~~ 'Fluctuante'::text) THEN count(v.valor)
                    ELSE NULL::bigint
                END AS catf,
                CASE
                    WHEN ((v.valor)::text ~~ 'Positiva'::text) THEN count(v.valor)
                    ELSE NULL::bigint
                END AS cati,
                CASE
                    WHEN ((v.valor)::text = 'Estable'::text) THEN count(v.valor)
                    ELSE NULL::bigint
                END AS cats,
                CASE
                    WHEN ((v.valor)::text ~~ 'Incierta'::text) THEN count(v.valor)
                    ELSE NULL::bigint
                END AS catu,
                CASE
                    WHEN ((v.valor)::text ~~ 'Desconocida'::text) THEN count(v.valor)
                    ELSE NULL::bigint
                END AS catunk,
            count(v.valor) AS total
           FROM especie.v_ind_3aves_2_especie_agrup v
          GROUP BY v.ambito, v.aplicadoa_distribucion, v.valor) i
  GROUP BY ambito, aplicadoa_distribucion;


ALTER VIEW especie.v_ind_3aves_3 OWNER TO iepnb;

--
-- Name: v_ind_3aves_4_tot; Type: VIEW; Schema: especie; Owner: iepnb
--

CREATE VIEW especie.v_ind_3aves_4_tot AS
 SELECT sum(totaleval) AS tot
   FROM especie.v_ind_3aves_3 v;


ALTER VIEW especie.v_ind_3aves_4_tot OWNER TO iepnb;

--
-- Name: v_ind_3aves_5_porcent; Type: VIEW; Schema: especie; Owner: iepnb
--

CREATE VIEW especie.v_ind_3aves_5_porcent AS
 SELECT v.aplicadoa_distribucion,
    v.ambito,
    (((v.d * (100)::numeric) / t.tot))::numeric(11,2) AS porcent_d,
    (((v.f * (100)::numeric) / t.tot))::numeric(11,2) AS porcent_f,
    (((v.i * (100)::numeric) / t.tot))::numeric(11,2) AS porcent_i,
    (((v.s * (100)::numeric) / t.tot))::numeric(11,2) AS porcent_s,
    (((v.u * (100)::numeric) / t.tot))::numeric(11,2) AS porcent_u,
    (((v.unk * (100)::numeric) / t.tot))::numeric(11,2) AS porcent_unk
   FROM especie.v_ind_3aves_3 v,
    especie.v_ind_3aves_4_tot t;


ALTER VIEW especie.v_ind_3aves_5_porcent OWNER TO iepnb;

--
-- Name: v_nombre_repetido; Type: VIEW; Schema: especie; Owner: iepnb
--

CREATE VIEW especie.v_nombre_repetido AS
 SELECT DISTINCT nombre,
    ididioma,
    count(nombre) AS total
   FROM especie.nombre n
  GROUP BY nombre, ididioma;


ALTER VIEW especie.v_nombre_repetido OWNER TO iepnb;

--
-- Name: v_nombre_repetido_id; Type: VIEW; Schema: especie; Owner: iepnb
--

CREATE VIEW especie.v_nombre_repetido_id AS
 SELECT n.idnombre,
    n.nombre,
    n.ididioma,
    v.total
   FROM (especie.nombre n
     JOIN especie.v_nombre_repetido v ON ((((n.nombre)::text = (v.nombre)::text) AND (n.ididioma = v.ididioma))))
  WHERE (v.total > 1);


ALTER VIEW especie.v_nombre_repetido_id OWNER TO iepnb;

--
-- Name: v_presencia_cedex; Type: VIEW; Schema: especie; Owner: iepnb
--

CREATE VIEW especie.v_presencia_cedex AS
 SELECT u.idtaxon,
    u.iddataset,
    d.dataset,
    u.countrycode,
    u.idsistcoord,
    tsc.verbatimcoordinatesystem,
    u.cuadr,
    u.tamaniocuadr,
    u.idestadocuadr,
    tec.estadocuad,
    u.fecha,
    u.y_latitud,
    u.x_longitud
   FROM (((especie.taxonubicacion u
     JOIN especie.t_dataset d ON ((d.iddataset = u.iddataset)))
     JOIN comun.t_sist_coordenadas tsc ON ((tsc.idsistcoord = u.idsistcoord)))
     JOIN especie.t_estado_cuadricula tec ON ((tec.idestadocuad = u.idestadocuadr)))
  WHERE (u.iddataset = ANY (ARRAY[(79)::numeric, (50005)::numeric]));


ALTER VIEW especie.v_presencia_cedex OWNER TO iepnb;

--
-- Name: v_taxon_presencia_utm10x10; Type: VIEW; Schema: especie; Owner: iepnb
--

CREATE VIEW especie.v_taxon_presencia_utm10x10 AS
 SELECT tn.iddataset AS "LP",
    t.idtaxon,
    n.nombre AS "ScientificName",
    t.idgrupotax,
    gt.nombre AS "Grupo taxonómico",
    t.cod_ambito,
    u.cuadr,
    u.fecha,
    u.tamaniocuadr,
    u.idestadocuadr,
    te.estadocuad,
    u.idsistcoord,
    ts.verbatimcoordinatesystem,
    u.iddataset,
    d.dataset
   FROM (((((((especie.taxonubicacion u
     LEFT JOIN especie.taxon t ON ((t.idtaxon = u.idtaxon)))
     LEFT JOIN especie.taxonnombre tn ON ((tn.idtaxon = t.idtaxon)))
     LEFT JOIN especie.nombre n ON ((n.idnombre = tn.idnombre)))
     LEFT JOIN comun.t_nombre_grupo_taxonomico gt ON ((gt.id_nombre_grupo_taxon = (t.idgrupotax)::numeric)))
     LEFT JOIN especie.t_estado_cuadricula te ON ((te.idestadocuad = u.idestadocuadr)))
     LEFT JOIN comun.t_sist_coordenadas ts ON ((ts.idsistcoord = u.idsistcoord)))
     LEFT JOIN especie.t_dataset d ON ((d.iddataset = u.iddataset)))
  WHERE ((u.idestadocuadr = (1)::numeric) AND (u.tamaniocuadr = (10)::numeric) AND (u.idsistcoord = ANY (ARRAY[(3)::numeric, (5)::numeric])) AND (tn.idtiponombre = ANY (ARRAY[(10)::bigint, (15)::bigint])));


ALTER VIEW especie.v_taxon_presencia_utm10x10 OWNER TO iepnb;

--
-- Name: v_tendencia_poblacional_dirhab2018; Type: VIEW; Schema: especie; Owner: iepnb
--

CREATE VIEW especie.v_tendencia_poblacional_dirhab2018 AS
 SELECT DISTINCT m.idtaxon,
    n.nombre AS nombrecolec,
    tn.id_ambito_es,
    tae.ambito,
    m.idtipomedida,
    ttm.nombre AS medida,
    m.idaplicadoa,
    tad.aplicadoa_distribucion,
    m.iddataset,
    m.id_valor_medida,
    tvm.valor,
    m.anio_inicio,
    m.anio_final
   FROM (((((((((especie.taxon_medicion m
     LEFT JOIN especie.taxon t ON ((t.idtaxon = m.idtaxon)))
     LEFT JOIN especie.taxonnombre tn ON ((tn.idtaxon = m.idtaxon)))
     LEFT JOIN especie.nombre n ON ((tn.idnombre = n.idnombre)))
     LEFT JOIN especie.taxonomia x ON ((n.idnombre = x.idnombre)))
     LEFT JOIN comun.t_nombre_grupo_taxonomico tngt ON (((t.idgrupotax)::numeric = tngt.id_nombre_grupo_taxon)))
     LEFT JOIN comun.t_tipo_medicion ttm ON ((ttm.id_tipo_medicion = (m.idtipomedida)::numeric)))
     LEFT JOIN especie.t_aplicaa_distribucion tad ON ((tad.idaplicaa = (m.idaplicadoa)::numeric)))
     LEFT JOIN comun.t_valor_medida tvm ON ((tvm.id_valor_medida = m.id_valor_medida)))
     LEFT JOIN especie.t_ambito_es tae ON ((tae.id_ambito_es = tn.id_ambito_es)))
  WHERE ((m.idtipomedida = 5) AND (m.iddataset = (71)::numeric) AND (tn.idtiponombre = 30) AND (tn.iddataset = (71)::numeric));


ALTER VIEW especie.v_tendencia_poblacional_dirhab2018 OWNER TO iepnb;

--
-- Name: vv_riqueza_especies_cuenta; Type: VIEW; Schema: especie; Owner: iepnb
--

CREATE VIEW especie.vv_riqueza_especies_cuenta AS
 SELECT DISTINCT cuadr,
    count(idtaxon) AS num_especies
   FROM ( SELECT DISTINCT tn.idtaxon,
            tn.iddataset,
            tn.idnombre,
            n.nombre,
            t.idgrupotax,
            gt.nombre AS grupo_taxonom,
            tax.idtaxonrank,
            tr.taxonrank,
            tu.cuadr,
            tu.tamaniocuadr,
            tec.estadocuad,
            tu.idsistcoord,
            tsc.verbatimcoordinatesystem,
            tsc.verbatimsrs
           FROM ((((((((especie.taxonnombre tn
             JOIN especie.taxon t ON ((t.idtaxon = tn.idtaxon)))
             JOIN especie.nombre n ON ((tn.idnombre = n.idnombre)))
             JOIN especie.taxonomia tax ON ((n.idnombre = tax.idnombre)))
             JOIN especie.t_taxonrank tr ON ((tax.idtaxonrank = tr.idtaxonrank)))
             JOIN comun.t_nombre_grupo_taxonomico gt ON (((t.idgrupotax)::numeric = gt.id_nombre_grupo_taxon)))
             LEFT JOIN especie.taxonubicacion tu ON ((tn.idtaxon = tu.idtaxon)))
             JOIN especie.t_estado_cuadricula tec ON ((tu.idestadocuadr = tec.idestadocuad)))
             JOIN comun.t_sist_coordenadas tsc ON ((tu.idsistcoord = tsc.idsistcoord)))
          WHERE ((tn.iddataset = (1)::numeric) AND (tn.idtiponombre = 10) AND (tax.idtaxonrank = 10) AND (tu.tamaniocuadr = (10)::numeric) AND (tu.idestadocuadr = (1)::numeric) AND (tu.idsistcoord = ANY (ARRAY[(3)::numeric, (5)::numeric])))) vre
  GROUP BY cuadr;


ALTER VIEW especie.vv_riqueza_especies_cuenta OWNER TO iepnb;

--
-- Name: vv_riqueza_especies_cuenta_new; Type: VIEW; Schema: especie; Owner: iepnb
--

CREATE VIEW especie.vv_riqueza_especies_cuenta_new AS
 SELECT DISTINCT cuadr,
    count(idtaxon) AS num_especies
   FROM ( SELECT DISTINCT tn.idtaxon,
            tn.iddataset,
            tn.idnombre,
            n.nombre,
            t.idgrupotax,
            gt.nombre AS grupo_taxonom,
            tax.idtaxonrank,
            tr.taxonrank,
            tu.cuadr,
            tu.tamaniocuadr,
            tec.estadocuad,
            tu.idsistcoord,
            tsc.verbatimcoordinatesystem,
            tsc.verbatimsrs
           FROM ((((((((especie.taxonnombre tn
             JOIN especie.taxon t ON ((t.idtaxon = tn.idtaxon)))
             JOIN especie.nombre n ON ((tn.idnombre = n.idnombre)))
             JOIN especie.taxonomia tax ON ((n.idnombre = tax.idnombre)))
             JOIN especie.t_taxonrank tr ON ((tax.idtaxonrank = tr.idtaxonrank)))
             JOIN comun.t_nombre_grupo_taxonomico gt ON (((t.idgrupotax)::numeric = gt.id_nombre_grupo_taxon)))
             LEFT JOIN especie.taxonubicacion tu ON ((tn.idtaxon = tu.idtaxon)))
             JOIN especie.t_estado_cuadricula tec ON ((tu.idestadocuadr = tec.idestadocuad)))
             JOIN comun.t_sist_coordenadas tsc ON ((tu.idsistcoord = tsc.idsistcoord)))
          WHERE ((tn.iddataset = (1)::numeric) AND (tn.idtiponombre = 10) AND (tax.idtaxonrank = 10) AND (tu.tamaniocuadr = (10)::numeric) AND (tu.idestadocuadr = (1)::numeric) AND (tu.idsistcoord = ANY (ARRAY[(3)::numeric, (5)::numeric])))) vre
  GROUP BY cuadr;


ALTER VIEW especie.vv_riqueza_especies_cuenta_new OWNER TO iepnb;

--
-- Name: zz_vv_taxon_medicion; Type: VIEW; Schema: especie; Owner: iepnb
--

CREATE VIEW especie.zz_vv_taxon_medicion AS
 SELECT tm.idtaxon,
    tm.idtipomedida,
    ttm.nombre AS tipo_medida,
    tm.valormedida,
    tm.idunidadmedida,
    tu.nombre AS unidad,
    tm.idmetodomedida,
    tmm.metodomedida,
    tm.idprecisionmedida,
    tm.idaplicadoa,
    tad.aplicadoa_distribucion AS aplicadoa,
    tm.fechamedida,
    tm.observaciones,
    tm.iddataset,
    tm.id_valor_medida,
    tvm.valor,
    tm.valor_medida_texto,
    tm.anio_inicio,
    tm.anio_final,
    tm.valor_minimo,
    tm.valor_maximo,
    tm.id_ambito_es
   FROM ((((((especie.taxon_medicion tm
     LEFT JOIN especie.t_dataset td ON ((tm.iddataset = td.iddataset)))
     LEFT JOIN comun.t_tipo_medicion ttm ON ((ttm.id_tipo_medicion = (tm.idtipomedida)::numeric)))
     LEFT JOIN comun.t_unidad tu ON ((tu.id_unidad = (tm.idunidadmedida)::numeric)))
     LEFT JOIN comun.t_valor_medida tvm ON ((tvm.id_valor_medida = tm.id_valor_medida)))
     LEFT JOIN especie.t_metodomedida tmm ON ((tmm.idmetodomedida = tm.idmetodomedida)))
     LEFT JOIN especie.t_aplicaa_distribucion tad ON ((tad.idaplicaa = (tm.idaplicadoa)::numeric)));


ALTER VIEW especie.zz_vv_taxon_medicion OWNER TO iepnb;

--
-- Name: zz_vv_taxonubicacion; Type: VIEW; Schema: especie; Owner: iepnb
--

CREATE VIEW especie.zz_vv_taxonubicacion AS
 SELECT u.idtaxon,
    u.iddataset,
    td.dataset,
    u.countrycode,
    u.idsistcoord,
    tsc.verbatimcoordinatesystem,
    u.cuadr,
    u.tamaniocuadr,
    u.idestadocuadr,
    tec.estadocuad,
    u.fecha,
    u.y_latitud,
    u.x_longitud
   FROM (((especie.taxonubicacion u
     LEFT JOIN especie.t_dataset td ON ((u.iddataset = td.iddataset)))
     LEFT JOIN especie.t_estado_cuadricula tec ON ((u.idestadocuadr = tec.idestadocuad)))
     LEFT JOIN comun.t_sist_coordenadas tsc ON ((u.idsistcoord = tsc.idsistcoord)));


ALTER VIEW especie.zz_vv_taxonubicacion OWNER TO iepnb;

--
-- Name: habitat; Type: TABLE; Schema: habitat; Owner: iepnb
--

CREATE TABLE habitat.habitat (
    id_ieh numeric(20,0) NOT NULL,
    cd_ieh_ref character varying(50) NOT NULL,
    nb_ieh character varying(300),
    nb_ieh_en character varying(300),
    cd_ambito character varying(2),
    nm_nivel smallint,
    id_padre character varying(50),
    id_coleccion smallint,
    id_prioritario smallint NOT NULL,
    id_cehpd smallint,
    dr_fuente_info character varying(200),
    fecha_creacion timestamp without time zone,
    fecha_modificacion timestamp without time zone,
    id_usuario_crea_registro integer,
    id_usuario_modifica_registro integer
);


ALTER TABLE habitat.habitat OWNER TO iepnb;

--
-- Name: habitat_region_biogeografica; Type: TABLE; Schema: habitat; Owner: iepnb
--

CREATE TABLE habitat.habitat_region_biogeografica (
    id_ieh integer NOT NULL,
    id_region_biogeografica integer NOT NULL,
    creado_por character varying(50),
    modificado_por character varying(50),
    fecha_creacion timestamp without time zone,
    fecha_modificacion timestamp without time zone,
    superficie_km2 double precision
);


ALTER TABLE habitat.habitat_region_biogeografica OWNER TO iepnb;

--
-- Name: lc_colecciones; Type: TABLE; Schema: habitat; Owner: iepnb
--

CREATE TABLE habitat.lc_colecciones (
    id_coleccion smallint NOT NULL,
    nb_coleccion character varying(100),
    fc_coleccion smallint,
    fecha_creacion timestamp without time zone,
    fecha_modificacion timestamp without time zone,
    id_usuario_crea_registro integer,
    id_usuario_modifica_registro integer
);


ALTER TABLE habitat.lc_colecciones OWNER TO iepnb;

--
-- Name: MALLA1X1_C_id_seq; Type: SEQUENCE; Schema: seguimiento_especie; Owner: iepnb
--

CREATE SEQUENCE seguimiento_especie."MALLA1X1_C_id_seq"
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE seguimiento_especie."MALLA1X1_C_id_seq" OWNER TO iepnb;

--
-- Name: MALLA1X1_P_id_seq; Type: SEQUENCE; Schema: seguimiento_especie; Owner: iepnb
--

CREATE SEQUENCE seguimiento_especie."MALLA1X1_P_id_seq"
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE seguimiento_especie."MALLA1X1_P_id_seq" OWNER TO iepnb;

--
-- Name: UTM 1x1 PIBAL_id_seq; Type: SEQUENCE; Schema: seguimiento_especie; Owner: iepnb
--

CREATE SEQUENCE seguimiento_especie."UTM 1x1 PIBAL_id_seq"
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE seguimiento_especie."UTM 1x1 PIBAL_id_seq" OWNER TO iepnb;

--
-- Name: csv_fla_fuente_presiones; Type: TABLE; Schema: seguimiento_especie; Owner: iepnb
--

CREATE TABLE seguimiento_especie.csv_fla_fuente_presiones (
    id_nuevo integer,
    "Ocurrencias repetidas" character varying(50),
    cod_ocurrencia character varying(50),
    id_tipo_medicion character varying(50),
    valor_texto character varying(50),
    procedencia integer,
    catalogo_presiones character varying
);


ALTER TABLE seguimiento_especie.csv_fla_fuente_presiones OWNER TO iepnb;

--
-- Name: csv_ocurrencia_multiple_fla; Type: TABLE; Schema: seguimiento_especie; Owner: iepnb
--

CREATE TABLE seguimiento_especie.csv_ocurrencia_multiple_fla (
    id_nuevo character varying,
    "Ocurrencias repetidas" character varying(500),
    id integer,
    cod_ocurrencia character varying(500),
    id_evento character varying(500),
    fecha_hora_ocurrencia timestamp without time zone,
    fecha_hora_registro character varying(500),
    id_taxon integer,
    taxon character varying(500),
    "Nombre en colección" character varying(500),
    id_poligono character varying(500),
    id_linea character varying(500),
    id_punto character varying(500),
    id_persona_ejecutora character varying(500),
    id_especimen character varying(500),
    observaciones character varying(500),
    fecha_carga character varying(500),
    cod_espacio character varying(500),
    id_habitat character varying(500),
    cod_ocurrencia_padre character varying(500),
    cod_muestra character varying(500),
    tipo_medicion character varying(500),
    column23 character varying(500),
    valor_numerico character varying(500),
    id_unidad_medida character varying(500),
    valor_texto character varying(500),
    valor_numerico_max character varying(500),
    "valor _numerico_min" character varying(500),
    presiones character varying(500),
    importancia character varying(500),
    "hábitats" character varying(500),
    grupotax character varying(500),
    otrostaxones_relacionados character varying(500),
    id_tipo_medicion integer,
    t_n_c character varying,
    id_valor_texto integer,
    fuente_presion integer,
    id_presion integer,
    id_importancia integer,
    id_nombre integer,
    idnombre_2 integer
);


ALTER TABLE seguimiento_especie.csv_ocurrencia_multiple_fla OWNER TO iepnb;

--
-- Name: entidad_ejecutora; Type: TABLE; Schema: seguimiento_especie; Owner: iepnb
--

CREATE TABLE seguimiento_especie.entidad_ejecutora (
    id_entidad_ejecutora numeric(20,0) NOT NULL,
    nombre character varying(200),
    descripcion text,
    id_organismo integer
);


ALTER TABLE seguimiento_especie.entidad_ejecutora OWNER TO iepnb;

--
-- Name: COLUMN entidad_ejecutora.id_entidad_ejecutora; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.entidad_ejecutora.id_entidad_ejecutora IS 'Id. de la empresa, organismo,. etc encargada del seguimiento';


--
-- Name: COLUMN entidad_ejecutora.descripcion; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.entidad_ejecutora.descripcion IS 'Descripción';


--
-- Name: COLUMN entidad_ejecutora.id_organismo; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.entidad_ejecutora.id_organismo IS 'Id. del organimso si lo fuera. FK a T_ORGANISMOO';


--
-- Name: equipo_personas; Type: TABLE; Schema: seguimiento_especie; Owner: iepnb
--

CREATE TABLE seguimiento_especie.equipo_personas (
    id_equipo bigint NOT NULL,
    id_persona_ejecutora integer NOT NULL
);


ALTER TABLE seguimiento_especie.equipo_personas OWNER TO iepnb;

--
-- Name: especimen_foto; Type: TABLE; Schema: seguimiento_especie; Owner: iepnb
--

CREATE TABLE seguimiento_especie.especimen_foto (
    id_especimen bigint NOT NULL,
    id_foto character(200) NOT NULL
);


ALTER TABLE seguimiento_especie.especimen_foto OWNER TO iepnb;

--
-- Name: TABLE especimen_foto; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON TABLE seguimiento_especie.especimen_foto IS 'Se registran las fotos relativas a un especimen';


--
-- Name: COLUMN especimen_foto.id_foto; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.especimen_foto.id_foto IS 'Id devuelto directamente por GD o WS correspondiente';


--
-- Name: especimen_medicion; Type: TABLE; Schema: seguimiento_especie; Owner: iepnb
--

CREATE TABLE seguimiento_especie.especimen_medicion (
    id_especimen bigint NOT NULL,
    id_tipo_medicion numeric(20,0) NOT NULL,
    observaciones text,
    valor_numerico numeric(20,3),
    id_unidad_medida numeric(20,0),
    valor_texto character varying(100),
    id_valor_texto numeric(20,0)
);


ALTER TABLE seguimiento_especie.especimen_medicion OWNER TO iepnb;

--
-- Name: evento; Type: TABLE; Schema: seguimiento_especie; Owner: iepnb
--

CREATE TABLE seguimiento_especie.evento (
    id_evento numeric(20,0) NOT NULL,
    nombre character varying(200),
    descripcion text,
    fecha_ini timestamp without time zone,
    fecha_fin timestamp without time zone,
    nombre_corto character varying(20),
    anio numeric(6,0),
    id_persona_ejecutora integer,
    id_equipo bigint,
    id_programa numeric(20,0),
    grupotax character varying(50),
    idpadre numeric(20,0)
);


ALTER TABLE seguimiento_especie.evento OWNER TO iepnb;

--
-- Name: TABLE evento; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON TABLE seguimiento_especie.evento IS 'https://dwc.tdwg.org/terms/#event';


--
-- Name: COLUMN evento.id_evento; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.evento.id_evento IS 'Id. del evento, es decir la acción de seguimiento que se vaya a medir en un plan de seguimiento';


--
-- Name: COLUMN evento.nombre; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.evento.nombre IS 'Nombre del evento o acción, por ejemplo avistamiento, recogida, ánalisis de laboratorio, etc...';


--
-- Name: COLUMN evento.descripcion; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.evento.descripcion IS 'Descripción del evento';


--
-- Name: COLUMN evento.fecha_ini; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.evento.fecha_ini IS 'Fecha de inicio';


--
-- Name: evento_especificacion; Type: TABLE; Schema: seguimiento_especie; Owner: iepnb
--

CREATE TABLE seguimiento_especie.evento_especificacion (
    id_evento_programa numeric(20,0) NOT NULL,
    id_especificacion numeric(20,0) NOT NULL,
    orden numeric(6,0),
    etiqueta character varying(200),
    id_especif_relaciona_sup numeric(20,0),
    observaciones text,
    valor_numerico numeric(20,3),
    id_unidad_medida numeric(20,0),
    valor_texto character varying(100),
    id_valor_texto numeric(20,0)
);


ALTER TABLE seguimiento_especie.evento_especificacion OWNER TO iepnb;

--
-- Name: evento_foto; Type: TABLE; Schema: seguimiento_especie; Owner: iepnb
--

CREATE TABLE seguimiento_especie.evento_foto (
    id_evento numeric(20,0) NOT NULL,
    id_foto character(200) NOT NULL
);


ALTER TABLE seguimiento_especie.evento_foto OWNER TO iepnb;

--
-- Name: evento_medicion; Type: TABLE; Schema: seguimiento_especie; Owner: iepnb
--

CREATE TABLE seguimiento_especie.evento_medicion (
    id_evento_programa numeric(20,0) NOT NULL,
    id_tipo_medicion numeric(20,0) NOT NULL,
    orden numeric(6,0),
    etiqueta character varying(200),
    id_medic_relaciona_sup numeric(20,0),
    observaciones text,
    valor_numerico numeric(20,3),
    id_unidad_medida numeric(20,0),
    valor_texto character varying(100),
    id_valor_texto numeric(20,0)
);


ALTER TABLE seguimiento_especie.evento_medicion OWNER TO iepnb;

--
-- Name: COLUMN evento_medicion.id_evento_programa; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.evento_medicion.id_evento_programa IS 'Id. de la relación entre el evento y el programa. FK a TSEG_EVENTO_PROGRAMA';


--
-- Name: COLUMN evento_medicion.id_tipo_medicion; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.evento_medicion.id_tipo_medicion IS 'Id. de tipo de medición para ese evento. FK a tSEG_TIPO_MEDICION';


--
-- Name: COLUMN evento_medicion.orden; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.evento_medicion.orden IS 'Orden de priorización dentro de los tipos de medida de un evento en concreto';


--
-- Name: COLUMN evento_medicion.etiqueta; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.evento_medicion.etiqueta IS 'Etiqueta de la relación';


--
-- Name: COLUMN evento_medicion.id_medic_relaciona_sup; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.evento_medicion.id_medic_relaciona_sup IS 'Id de una medicion relacionado superiormente';


--
-- Name: COLUMN evento_medicion.observaciones; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.evento_medicion.observaciones IS 'Posibles observaciones de la medición';


--
-- Name: COLUMN evento_medicion.valor_numerico; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.evento_medicion.valor_numerico IS 'Valor de la medición cuando es un valor numérco, debe tener unas unidades en el campo corrsegondinete';


--
-- Name: COLUMN evento_medicion.id_unidad_medida; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.evento_medicion.id_unidad_medida IS 'Id. de la unidad de medida. FK a T_UNIDADES';


--
-- Name: COLUMN evento_medicion.valor_texto; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.evento_medicion.valor_texto IS 'Valor de la medición cuando tiene un valor texto ese tipo de medición';


--
-- Name: COLUMN evento_medicion.id_valor_texto; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.evento_medicion.id_valor_texto IS 'ID de valor texto, cuando este valor texto está en el catálogo de valores texto de una medición';


--
-- Name: evento_medicion_multiple; Type: TABLE; Schema: seguimiento_especie; Owner: iepnb
--

CREATE TABLE seguimiento_especie.evento_medicion_multiple (
    id numeric(20,0) NOT NULL,
    id_evento_programa numeric(20,0) NOT NULL,
    id_tipo_medicion numeric(20,0) NOT NULL,
    orden numeric(6,0),
    etiqueta character varying(200),
    id_medic_relaciona_sup numeric(20,0),
    observaciones text,
    valor_numerico numeric(20,3),
    id_unidad_medida numeric(20,0),
    valor_texto character varying(100),
    id_valor_texto numeric(20,0)
);


ALTER TABLE seguimiento_especie.evento_medicion_multiple OWNER TO iepnb;

--
-- Name: evento_programa; Type: TABLE; Schema: seguimiento_especie; Owner: iepnb
--

CREATE TABLE seguimiento_especie.evento_programa (
    id_evento_programa numeric(20,0) NOT NULL,
    id_evento numeric(20,0),
    id_programa numeric(20,0),
    nombre character varying(500)
);


ALTER TABLE seguimiento_especie.evento_programa OWNER TO iepnb;

--
-- Name: COLUMN evento_programa.id_evento_programa; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.evento_programa.id_evento_programa IS 'Id de un evento relacionado con un programa en concreto';


--
-- Name: COLUMN evento_programa.id_evento; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.evento_programa.id_evento IS 'Identificador del evento. FK a TSEG_EVENTO';


--
-- Name: COLUMN evento_programa.id_programa; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.evento_programa.id_programa IS 'Identificador de progrma. FK a FSEG_PROGRAMA';


--
-- Name: COLUMN evento_programa.nombre; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.evento_programa.nombre IS 'Nombre del evento en concreto para ese programa, por ejemplo análisis de sangre';


--
-- Name: evento_tipo_especificacion; Type: TABLE; Schema: seguimiento_especie; Owner: iepnb
--

CREATE TABLE seguimiento_especie.evento_tipo_especificacion (
    id_evento_programa numeric(20,0) NOT NULL,
    id_especificacion numeric(20,0) NOT NULL,
    orden numeric(6,0),
    etiqueta character varying(200),
    id_especif_relaciona_sup numeric(20,0),
    observaciones text
);


ALTER TABLE seguimiento_especie.evento_tipo_especificacion OWNER TO iepnb;

--
-- Name: evento_tipo_medicion; Type: TABLE; Schema: seguimiento_especie; Owner: iepnb
--

CREATE TABLE seguimiento_especie.evento_tipo_medicion (
    id_evento_programa numeric(20,0) NOT NULL,
    id_tipo_medicion numeric(20,0) NOT NULL,
    orden numeric(6,0),
    etiqueta character varying(200),
    id_medic_relaciona_sup numeric(20,0),
    observaciones text
);


ALTER TABLE seguimiento_especie.evento_tipo_medicion OWNER TO iepnb;

--
-- Name: COLUMN evento_tipo_medicion.id_evento_programa; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.evento_tipo_medicion.id_evento_programa IS 'Id. de la relación entre el evento y el programa. FK a TSEG_EVENTO_PROGRAMA';


--
-- Name: COLUMN evento_tipo_medicion.id_tipo_medicion; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.evento_tipo_medicion.id_tipo_medicion IS 'Id. de tipo de medición para ese evento. FK a tSEG_TIPO_MEDICION';


--
-- Name: COLUMN evento_tipo_medicion.orden; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.evento_tipo_medicion.orden IS 'Orden de priorización dentro de los tipos de medida de un evento en concreto';


--
-- Name: COLUMN evento_tipo_medicion.etiqueta; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.evento_tipo_medicion.etiqueta IS 'Etiqueta de la relación';


--
-- Name: COLUMN evento_tipo_medicion.id_medic_relaciona_sup; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.evento_tipo_medicion.id_medic_relaciona_sup IS 'Id de una medicion relacionado superiormente';


--
-- Name: COLUMN evento_tipo_medicion.observaciones; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.evento_tipo_medicion.observaciones IS 'Posibles observaciones de la medición';


--
-- Name: evento_valor_texto; Type: TABLE; Schema: seguimiento_especie; Owner: iepnb
--

CREATE TABLE seguimiento_especie.evento_valor_texto (
    id_evento numeric(20,0) NOT NULL,
    id_taxon numeric(40,0),
    id_tipo_medicion numeric(20,0),
    id_evento_valortexto numeric(20,0) NOT NULL,
    id_presion numeric(20,0),
    id_habitat numeric(20,0),
    id_contaminante numeric(20,0),
    id_medida numeric(20,0),
    observaciones text
);


ALTER TABLE seguimiento_especie.evento_valor_texto OWNER TO iepnb;

--
-- Name: foto; Type: TABLE; Schema: seguimiento_especie; Owner: iepnb
--

CREATE TABLE seguimiento_especie.foto (
    id_foto character(200) NOT NULL,
    id_contenido_foto integer NOT NULL,
    observaciones text,
    id_persona_ejecutora integer NOT NULL,
    titulo character varying(100) NOT NULL
);


ALTER TABLE seguimiento_especie.foto OWNER TO iepnb;

--
-- Name: gis_medicion_linea; Type: TABLE; Schema: seguimiento_especie; Owner: iepnb
--

CREATE TABLE seguimiento_especie.gis_medicion_linea (
    id_gis_medicion_linea numeric(20,0) NOT NULL,
    cod_ocurrencia character varying(50),
    id_tipo_medicion numeric(20,0),
    id_linea numeric(20,0),
    id_evento numeric(20,0),
    valor_numerico numeric(20,3),
    id_unidad_medida numeric(20,0),
    valor_texto character varying(100),
    id_valor_texto numeric(20,0),
    observaciones text
);


ALTER TABLE seguimiento_especie.gis_medicion_linea OWNER TO iepnb;

--
-- Name: COLUMN gis_medicion_linea.valor_numerico; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.gis_medicion_linea.valor_numerico IS 'Valor de la medición cuando es un valor numérco, debe tener unas unidades en el campo corrsegondinete';


--
-- Name: COLUMN gis_medicion_linea.id_unidad_medida; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.gis_medicion_linea.id_unidad_medida IS 'Id. de la unidad de medida. FK a T_UNIDADES';


--
-- Name: COLUMN gis_medicion_linea.valor_texto; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.gis_medicion_linea.valor_texto IS 'Valor de la medición cuando tiene un valor texto ese tipo de medición';


--
-- Name: COLUMN gis_medicion_linea.id_valor_texto; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.gis_medicion_linea.id_valor_texto IS 'ID de valor texto, cuando este valor texto está en el catálogo de valores texto de una medición';


--
-- Name: COLUMN gis_medicion_linea.observaciones; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.gis_medicion_linea.observaciones IS 'Posibles observaciones de la medición';


--
-- Name: gis_medicion_poligon; Type: TABLE; Schema: seguimiento_especie; Owner: iepnb
--

CREATE TABLE seguimiento_especie.gis_medicion_poligon (
    id_gis_medicion_poligono numeric(20,0) NOT NULL,
    cod_ocurencia character varying(50),
    id_tipo_medicion numeric(20,0),
    id_poligono numeric(20,0),
    id_evento numeric(20,0),
    valor_numerico numeric(20,3),
    id_unidad_medida numeric(20,0),
    valor_texto character varying(100),
    id_valor_texto numeric(20,0),
    observaciones text
);


ALTER TABLE seguimiento_especie.gis_medicion_poligon OWNER TO iepnb;

--
-- Name: COLUMN gis_medicion_poligon.id_gis_medicion_poligono; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.gis_medicion_poligon.id_gis_medicion_poligono IS 'Identificador del regitro. FK a TSEG_OCURRENCIA.';


--
-- Name: COLUMN gis_medicion_poligon.cod_ocurencia; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.gis_medicion_poligon.cod_ocurencia IS 'Código identificador de ocurrencia.';


--
-- Name: COLUMN gis_medicion_poligon.id_tipo_medicion; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.gis_medicion_poligon.id_tipo_medicion IS 'Identificador del tipo de medición. FK a la tabla TSEG_TIPO_MEDICION';


--
-- Name: COLUMN gis_medicion_poligon.id_poligono; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.gis_medicion_poligon.id_poligono IS 'Identificador del poligon de la capa correspondiente';


--
-- Name: COLUMN gis_medicion_poligon.valor_numerico; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.gis_medicion_poligon.valor_numerico IS 'Valor de la medición cuando es un valor numérco, debe tener unas unidades en el campo corrsegondinete';


--
-- Name: COLUMN gis_medicion_poligon.id_unidad_medida; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.gis_medicion_poligon.id_unidad_medida IS 'Id. de la unidad de medida. FK a T_UNIDADES';


--
-- Name: COLUMN gis_medicion_poligon.valor_texto; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.gis_medicion_poligon.valor_texto IS 'Valor de la medición cuando tiene un valor texto ese tipo de medición';


--
-- Name: COLUMN gis_medicion_poligon.id_valor_texto; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.gis_medicion_poligon.id_valor_texto IS 'ID de valor texto, cuando este valor texto está en el catálogo de valores texto de una medición';


--
-- Name: COLUMN gis_medicion_poligon.observaciones; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.gis_medicion_poligon.observaciones IS 'Posibles observaciones de la medición';


--
-- Name: gis_medicion_punto; Type: TABLE; Schema: seguimiento_especie; Owner: iepnb
--

CREATE TABLE seguimiento_especie.gis_medicion_punto (
    id_gis_medicion_punto numeric(20,0) NOT NULL,
    cod_ocurencia character varying(50),
    id_tipo_medicion numeric(20,0),
    id_punto numeric(20,0),
    id_evento numeric(20,0),
    valor_numerico numeric(20,3),
    id_unidad_medida numeric(20,0),
    valor_texto character varying(100),
    id_valor_texto numeric(20,0),
    observaciones text
);


ALTER TABLE seguimiento_especie.gis_medicion_punto OWNER TO iepnb;

--
-- Name: COLUMN gis_medicion_punto.valor_numerico; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.gis_medicion_punto.valor_numerico IS 'Valor de la medición cuando es un valor numérco, debe tener unas unidades en el campo corrsegondinete';


--
-- Name: COLUMN gis_medicion_punto.id_unidad_medida; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.gis_medicion_punto.id_unidad_medida IS 'Id. de la unidad de medida. FK a T_UNIDADES';


--
-- Name: COLUMN gis_medicion_punto.valor_texto; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.gis_medicion_punto.valor_texto IS 'Valor de la medición cuando tiene un valor texto ese tipo de medición';


--
-- Name: COLUMN gis_medicion_punto.id_valor_texto; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.gis_medicion_punto.id_valor_texto IS 'ID de valor texto, cuando este valor texto está en el catálogo de valores texto de una medición';


--
-- Name: COLUMN gis_medicion_punto.observaciones; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.gis_medicion_punto.observaciones IS 'Posibles observaciones de la medición';


--
-- Name: laboratorio; Type: TABLE; Schema: seguimiento_especie; Owner: iepnb
--

CREATE TABLE seguimiento_especie.laboratorio (
    id_laboratorio integer NOT NULL,
    nombre character varying(3000),
    telefono numeric(20,0),
    persona_contacto character varying(1000),
    direccion character varying(2000),
    email character varying(1000)
);


ALTER TABLE seguimiento_especie.laboratorio OWNER TO iepnb;

--
-- Name: malla1x1_70_id_seq; Type: SEQUENCE; Schema: seguimiento_especie; Owner: iepnb
--

CREATE SEQUENCE seguimiento_especie.malla1x1_70_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE seguimiento_especie.malla1x1_70_id_seq OWNER TO iepnb;

--
-- Name: muestra_laboratorio; Type: TABLE; Schema: seguimiento_especie; Owner: iepnb
--

CREATE TABLE seguimiento_especie.muestra_laboratorio (
    cod_muestra character varying(100) NOT NULL,
    cod_muestra_laboratorio character varying(3000),
    descripcion text,
    id_laboratorio integer NOT NULL
);


ALTER TABLE seguimiento_especie.muestra_laboratorio OWNER TO iepnb;

--
-- Name: muestra_medicion; Type: TABLE; Schema: seguimiento_especie; Owner: iepnb
--

CREATE TABLE seguimiento_especie.muestra_medicion (
    cod_muestra character varying(100) NOT NULL,
    id_tipo_medicion numeric(20,0) NOT NULL,
    observaciones text,
    valor_numerico numeric(20,3),
    id_unidad_medida numeric(20,0),
    valor_texto character varying(100),
    id_valor_texto numeric(20,0),
    valor_numerico_max numeric(20,0),
    valor_numeric_min numeric(20,0)
);


ALTER TABLE seguimiento_especie.muestra_medicion OWNER TO iepnb;

--
-- Name: COLUMN muestra_medicion.id_tipo_medicion; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.muestra_medicion.id_tipo_medicion IS 'Id. del tipo de medición';


--
-- Name: COLUMN muestra_medicion.observaciones; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.muestra_medicion.observaciones IS 'Posibles observaciones de la medición';


--
-- Name: COLUMN muestra_medicion.valor_numerico; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.muestra_medicion.valor_numerico IS 'Valor de la medición cuando es un valor numérco, debe tener unas unidades en el campo corrsegondinete';


--
-- Name: COLUMN muestra_medicion.id_unidad_medida; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.muestra_medicion.id_unidad_medida IS 'Id. de la unidad de medida. FK a T_UNIDADES';


--
-- Name: COLUMN muestra_medicion.valor_texto; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.muestra_medicion.valor_texto IS 'aVAlor d ela medicón cunado tien un valor texto ese tipo de medición';


--
-- Name: COLUMN muestra_medicion.id_valor_texto; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.muestra_medicion.id_valor_texto IS 'ID de valor texto, cuando este valor texto está en el catálogo de valores texto de una medición';


--
-- Name: muestra_taxon; Type: TABLE; Schema: seguimiento_especie; Owner: iepnb
--

CREATE TABLE seguimiento_especie.muestra_taxon (
    cod_muestra character varying(100) NOT NULL,
    id_taxon numeric(40,0) NOT NULL
);


ALTER TABLE seguimiento_especie.muestra_taxon OWNER TO iepnb;

--
-- Name: TABLE muestra_taxon; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON TABLE seguimiento_especie.muestra_taxon IS 'Tabla para relacionar las espcies que se localican en una determinada muesta que se recogió en una ocurrencia';


--
-- Name: COLUMN muestra_taxon.cod_muestra; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.muestra_taxon.cod_muestra IS 'En el caso de que en lugar de reconocer una especie se tome una muestra para su reconocimiento posterior. Puede ser una muestra de agua que posiblemente lleve incluidas varias especies';


--
-- Name: COLUMN muestra_taxon.id_taxon; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.muestra_taxon.id_taxon IS 'Id. de taxon';


--
-- Name: ocurrencia; Type: TABLE; Schema: seguimiento_especie; Owner: iepnb
--

CREATE TABLE seguimiento_especie.ocurrencia (
    cod_ocurrencia character varying(100) NOT NULL,
    id_evento_programa numeric(20,0),
    fecha_hora_ocurrencia timestamp(0) without time zone,
    fecha_hora_registro timestamp(0) without time zone,
    id_taxon numeric(40,0),
    id_persona_ejecutora integer,
    id_especimen bigint,
    observaciones text,
    fecha_carga date,
    cod_espacio character varying(50),
    id_habitat numeric(20,0),
    cod_ocurrencia_padre character varying(100),
    idnombre integer,
    id_importancia integer,
    fecha_hora_ocurrencia_fin timestamp without time zone
);


ALTER TABLE seguimiento_especie.ocurrencia OWNER TO iepnb;

--
-- Name: TABLE ocurrencia; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON TABLE seguimiento_especie.ocurrencia IS 'https://dwc.tdwg.org/terms/#occurrence

Tiempos en los que se ha registrado una especie en particular';


--
-- Name: COLUMN ocurrencia.cod_ocurrencia; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.ocurrencia.cod_ocurrencia IS 'Código indentificador de la ocurrencia, es dcier en que momento y quien realizó la medida. Al tratarse de una bbdd cuyo datos distribuidos y que hay que unificar, este código debe estar formado el "ID_EVENTO_PROGRAMA"_"ID_USUARIO"_"AÑOMESDIA"_"AUTONUMERICO".';


--
-- Name: COLUMN ocurrencia.id_evento_programa; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.ocurrencia.id_evento_programa IS 'Id del evento ralcionado con un porgrama.';


--
-- Name: COLUMN ocurrencia.fecha_hora_ocurrencia; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.ocurrencia.fecha_hora_ocurrencia IS 'Fecha y hora de la ocurrencia del eveto';


--
-- Name: COLUMN ocurrencia.fecha_hora_registro; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.ocurrencia.fecha_hora_registro IS 'Fecha y hora del registro ne la BBDD de la ocurrencia';


--
-- Name: COLUMN ocurrencia.id_taxon; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.ocurrencia.id_taxon IS 'Id del taxon';


--
-- Name: COLUMN ocurrencia.id_persona_ejecutora; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.ocurrencia.id_persona_ejecutora IS 'Id de la persona que realiza el seguimiento';


--
-- Name: COLUMN ocurrencia.id_especimen; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.ocurrencia.id_especimen IS 'Id del escpecimen de seguimiento';


--
-- Name: COLUMN ocurrencia.observaciones; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.ocurrencia.observaciones IS 'Observaciones d ela ocurrencia';


--
-- Name: COLUMN ocurrencia.fecha_carga; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.ocurrencia.fecha_carga IS 'Fecha de carga d ela información, porcedente de las app de campo';


--
-- Name: COLUMN ocurrencia.fecha_hora_ocurrencia_fin; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.ocurrencia.fecha_hora_ocurrencia_fin IS 'Fecha y hora de finalización de la toma de la ocurrencia.';


--
-- Name: ocurrencia_especificacion; Type: TABLE; Schema: seguimiento_especie; Owner: iepnb
--

CREATE TABLE seguimiento_especie.ocurrencia_especificacion (
    cod_ocurrencia character varying(100) NOT NULL,
    id_especificacion numeric(20,0) NOT NULL,
    observaciones text,
    valor_numerico numeric(20,3),
    id_unidad_medida numeric(20,0),
    valor_texto character varying(100),
    id_valor_texto numeric(20,0),
    valor_numerico_max numeric(20,0),
    "valor _numerico_min" numeric(20,0)
);


ALTER TABLE seguimiento_especie.ocurrencia_especificacion OWNER TO iepnb;

--
-- Name: ocurrencia_foto; Type: TABLE; Schema: seguimiento_especie; Owner: iepnb
--

CREATE TABLE seguimiento_especie.ocurrencia_foto (
    cod_ocurrencia character varying(100) NOT NULL,
    id_foto character(200) NOT NULL,
    ref_foto_campo character(200),
    id_persona_ejecutora integer
);


ALTER TABLE seguimiento_especie.ocurrencia_foto OWNER TO iepnb;

--
-- Name: COLUMN ocurrencia_foto.id_foto; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.ocurrencia_foto.id_foto IS 'Id devuelto directamente por GD o WS correspondiente';


--
-- Name: COLUMN ocurrencia_foto.ref_foto_campo; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.ocurrencia_foto.ref_foto_campo IS 'Posible referncia de la foto creada o tomada en campo';


--
-- Name: ocurrencia_medicion; Type: TABLE; Schema: seguimiento_especie; Owner: iepnb
--

CREATE TABLE seguimiento_especie.ocurrencia_medicion (
    cod_ocurrencia character varying(100) NOT NULL,
    id_tipo_medicion numeric(20,0) NOT NULL,
    observaciones text,
    valor_numerico numeric(20,3),
    id_unidad numeric(20,0),
    valor_texto character varying(5000),
    id_valor_texto numeric(20,0),
    valor_numerico_max numeric(20,0),
    valor_numerico_min numeric(20,0)
);


ALTER TABLE seguimiento_especie.ocurrencia_medicion OWNER TO iepnb;

--
-- Name: COLUMN ocurrencia_medicion.cod_ocurrencia; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.ocurrencia_medicion.cod_ocurrencia IS 'Cod. de la ocurrencia FK a TSEG_OCURRENCIA, al campo COD_OCURRENCIA.';


--
-- Name: COLUMN ocurrencia_medicion.id_tipo_medicion; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.ocurrencia_medicion.id_tipo_medicion IS 'Id. del tipo de medición';


--
-- Name: COLUMN ocurrencia_medicion.observaciones; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.ocurrencia_medicion.observaciones IS 'Posibles observaciones de la medición';


--
-- Name: COLUMN ocurrencia_medicion.valor_numerico; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.ocurrencia_medicion.valor_numerico IS 'Valor de la medición cuando es un valor numérco, debe tener unas unidades en el campo corrsegondinete';


--
-- Name: COLUMN ocurrencia_medicion.id_unidad; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.ocurrencia_medicion.id_unidad IS 'Id. de la unidad de medida. FK a T_UNIDADES';


--
-- Name: COLUMN ocurrencia_medicion.valor_texto; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.ocurrencia_medicion.valor_texto IS 'aVAlor d ela medicón cunado tien un valor texto ese tipo de medición';


--
-- Name: COLUMN ocurrencia_medicion.id_valor_texto; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.ocurrencia_medicion.id_valor_texto IS 'ID de valor texto, cuando este valor texto está en el catálogo de valores texto de una medición';


--
-- Name: sec_id_ocurrencia_medicion_multiple; Type: SEQUENCE; Schema: seguimiento_especie; Owner: iepnb
--

CREATE SEQUENCE seguimiento_especie.sec_id_ocurrencia_medicion_multiple
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE seguimiento_especie.sec_id_ocurrencia_medicion_multiple OWNER TO iepnb;

--
-- Name: ocurrencia_medicion_multiple; Type: TABLE; Schema: seguimiento_especie; Owner: iepnb
--

CREATE TABLE seguimiento_especie.ocurrencia_medicion_multiple (
    id numeric(20,0) DEFAULT nextval('seguimiento_especie.sec_id_ocurrencia_medicion_multiple'::regclass) NOT NULL,
    cod_ocurrencia character varying(100) NOT NULL,
    id_tipo_medicion numeric(20,0) NOT NULL,
    observaciones text,
    valor_numerico numeric(20,3),
    id_unidad numeric(20,0),
    valor_texto character varying(800),
    id_valor_texto numeric(20,0),
    valor_numerico_max numeric(20,0),
    valor_numerico_min numeric(20,0),
    id_importancia integer,
    id_presion integer
);


ALTER TABLE seguimiento_especie.ocurrencia_medicion_multiple OWNER TO iepnb;

--
-- Name: ocurrencia_muestra; Type: TABLE; Schema: seguimiento_especie; Owner: iepnb
--

CREATE TABLE seguimiento_especie.ocurrencia_muestra (
    cod_ocurencia character varying(100) NOT NULL,
    id_tipo_muestra bigint,
    id_tipo_muestreo bigint,
    cod_muestra character varying(100) NOT NULL
);


ALTER TABLE seguimiento_especie.ocurrencia_muestra OWNER TO iepnb;

--
-- Name: TABLE ocurrencia_muestra; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON TABLE seguimiento_especie.ocurrencia_muestra IS 'Tabla para registrar la correspondiente muestra tomadas en una ocuerrencia';


--
-- Name: ocurrencia_valor_texto; Type: TABLE; Schema: seguimiento_especie; Owner: iepnb
--

CREATE TABLE seguimiento_especie.ocurrencia_valor_texto (
    id_ocurrencia_valor_texto numeric(20,0) NOT NULL,
    cod_ocurrencia character varying(100),
    id_taxon numeric(40,0),
    id_tipo_medicion numeric(20,0),
    id_presion numeric(20,0),
    id_habitat numeric(20,0),
    id_contaminante numeric(20,0),
    id_medida numeric(20,0),
    observaciones text
);


ALTER TABLE seguimiento_especie.ocurrencia_valor_texto OWNER TO iepnb;

--
-- Name: programa; Type: TABLE; Schema: seguimiento_especie; Owner: iepnb
--

CREATE TABLE seguimiento_especie.programa (
    id_programa numeric(20,0) NOT NULL,
    nombre character varying(500),
    descripcion text,
    nombre_corto character varying(50),
    id_tipo_seguimiento numeric(6,0),
    id_grupo_taxonomico numeric(6,0),
    id_org_app numeric(6,0)
);


ALTER TABLE seguimiento_especie.programa OWNER TO iepnb;

--
-- Name: COLUMN programa.id_programa; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.programa.id_programa IS 'Id. del programa';


--
-- Name: COLUMN programa.nombre; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.programa.nombre IS 'Nombre dle porograma';


--
-- Name: COLUMN programa.descripcion; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.programa.descripcion IS 'Descripción del progrma';


--
-- Name: COLUMN programa.nombre_corto; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.programa.nombre_corto IS 'Nombre corto a acrónimo';


--
-- Name: COLUMN programa.id_tipo_seguimiento; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.programa.id_tipo_seguimiento IS 'Id. del tipo de programa de seguimiento';


--
-- Name: COLUMN programa.id_grupo_taxonomico; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.programa.id_grupo_taxonomico IS 'Id del grupo taxonónmico de los segcímnes a seguir';


--
-- Name: COLUMN programa.id_org_app; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.programa.id_org_app IS 'Id del organimso rsegonable o gestor del seguimiento (FK a T_ORGANISMOS)';


--
-- Name: programa_entidad_ejecutora; Type: TABLE; Schema: seguimiento_especie; Owner: iepnb
--

CREATE TABLE seguimiento_especie.programa_entidad_ejecutora (
    id_entidad_ejecutora numeric(20,0) NOT NULL,
    id_programa numeric(20,0) NOT NULL
);


ALTER TABLE seguimiento_especie.programa_entidad_ejecutora OWNER TO iepnb;

--
-- Name: COLUMN programa_entidad_ejecutora.id_entidad_ejecutora; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.programa_entidad_ejecutora.id_entidad_ejecutora IS 'Id. de la entidad ejecutora. FK a TSE_ENTIDAD_EJEUCUTORA';


--
-- Name: COLUMN programa_entidad_ejecutora.id_programa; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.programa_entidad_ejecutora.id_programa IS 'Id-del programa. FK a TSEG_PROGRAMA.';


--
-- Name: rango_valor; Type: TABLE; Schema: seguimiento_especie; Owner: iepnb
--

CREATE TABLE seguimiento_especie.rango_valor (
    id_rango_valor numeric(20,0) NOT NULL,
    id_tipo_medicion numeric(20,0),
    valor_maximo numeric(20,3),
    valor_minimo numeric(20,3),
    id_evento_programa numeric(20,0)
);


ALTER TABLE seguimiento_especie.rango_valor OWNER TO iepnb;

--
-- Name: COLUMN rango_valor.id_rango_valor; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.rango_valor.id_rango_valor IS 'Id. de un rango de valor';


--
-- Name: COLUMN rango_valor.id_tipo_medicion; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.rango_valor.id_tipo_medicion IS 'Id. del timpo de madida. FK a TSEG_TIPO_MEDICION';


--
-- Name: COLUMN rango_valor.valor_maximo; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.rango_valor.valor_maximo IS 'Valor máximo permitido';


--
-- Name: COLUMN rango_valor.valor_minimo; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.rango_valor.valor_minimo IS 'Valor mínimo permitido';


--
-- Name: COLUMN rango_valor.id_evento_programa; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.rango_valor.id_evento_programa IS 'Id del porgram evento al que afecta los rangos. FK a TSET_PROGRMA_EVENTO';


--
-- Name: sec_wkt_geometria; Type: SEQUENCE; Schema: seguimiento_especie; Owner: iepnb
--

CREATE SEQUENCE seguimiento_especie.sec_wkt_geometria
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE seguimiento_especie.sec_wkt_geometria OWNER TO iepnb;

--
-- Name: t_contenido_foto; Type: TABLE; Schema: seguimiento_especie; Owner: iepnb
--

CREATE TABLE seguimiento_especie.t_contenido_foto (
    id_contenido_foto integer NOT NULL,
    descripcion text
);


ALTER TABLE seguimiento_especie.t_contenido_foto OWNER TO iepnb;

--
-- Name: t_equipo_ejecutor; Type: TABLE; Schema: seguimiento_especie; Owner: iepnb
--

CREATE TABLE seguimiento_especie.t_equipo_ejecutor (
    id_equipo bigint NOT NULL,
    nombre character varying(255),
    codigo character varying(20),
    observaciones character varying(255)
);


ALTER TABLE seguimiento_especie.t_equipo_ejecutor OWNER TO iepnb;

--
-- Name: t_gis_linea; Type: TABLE; Schema: seguimiento_especie; Owner: iepnb
--

CREATE TABLE seguimiento_especie.t_gis_linea (
    id_gis_linea numeric(20,0) NOT NULL,
    cod_ocurrencia character varying(100),
    id_tipo_medicion numeric(20,0),
    id_poligon numeric(20,0)
);


ALTER TABLE seguimiento_especie.t_gis_linea OWNER TO iepnb;

--
-- Name: t_gis_poligon; Type: TABLE; Schema: seguimiento_especie; Owner: iepnb
--

CREATE TABLE seguimiento_especie.t_gis_poligon (
    id_gis_poligon numeric(20,0) NOT NULL,
    cod_ocurrencia character varying(100),
    id_tipo_medicion numeric(20,0),
    id_poligon numeric(20,0)
);


ALTER TABLE seguimiento_especie.t_gis_poligon OWNER TO iepnb;

--
-- Name: COLUMN t_gis_poligon.id_gis_poligon; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.t_gis_poligon.id_gis_poligon IS 'Identificador del regitro. FK a TSEG_OCURRENCIA.';


--
-- Name: COLUMN t_gis_poligon.cod_ocurrencia; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.t_gis_poligon.cod_ocurrencia IS 'Código identificador de ocurrencia.';


--
-- Name: COLUMN t_gis_poligon.id_tipo_medicion; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.t_gis_poligon.id_tipo_medicion IS 'Identificador del tipo de medición. FK a la tabla TSEG_TIPO_MEDICION';


--
-- Name: COLUMN t_gis_poligon.id_poligon; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON COLUMN seguimiento_especie.t_gis_poligon.id_poligon IS 'Identificador del poligon de la capa correspondiente';


--
-- Name: t_gis_punto; Type: TABLE; Schema: seguimiento_especie; Owner: iepnb
--

CREATE TABLE seguimiento_especie.t_gis_punto (
    id_gis_poligon numeric(20,0) NOT NULL,
    cod_ocurrencia character varying(100),
    id_tipo_medicion numeric(20,0),
    id_punto numeric(20,0) NOT NULL
);


ALTER TABLE seguimiento_especie.t_gis_punto OWNER TO iepnb;

--
-- Name: t_persona_ejecutora; Type: TABLE; Schema: seguimiento_especie; Owner: iepnb
--

CREATE TABLE seguimiento_especie.t_persona_ejecutora (
    id_persona_ejecutora integer NOT NULL,
    nombre_original character varying(2000),
    apellido1 character varying(2000),
    apellido2 character varying(2000),
    id_tipo_persona integer,
    nombre character varying
);


ALTER TABLE seguimiento_especie.t_persona_ejecutora OWNER TO iepnb;

--
-- Name: t_tipo_identificacion_especimen; Type: TABLE; Schema: seguimiento_especie; Owner: iepnb
--

CREATE TABLE seguimiento_especie.t_tipo_identificacion_especimen (
    "id_tipo_identificación_especimen" integer NOT NULL,
    nombre character varying(2000),
    descripcion text
);


ALTER TABLE seguimiento_especie.t_tipo_identificacion_especimen OWNER TO iepnb;

--
-- Name: TABLE t_tipo_identificacion_especimen; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON TABLE seguimiento_especie.t_tipo_identificacion_especimen IS 'CAtalgo del tipo de indentificadores de os especímenes, anilla, microchip, etc...';


--
-- Name: t_tipo_medicion_darwincore; Type: TABLE; Schema: seguimiento_especie; Owner: iepnb
--

CREATE TABLE seguimiento_especie.t_tipo_medicion_darwincore (
    id_tipo_medicion numeric(20,0),
    clase_darwincore character varying(200),
    propiedad_darwincore character varying(200),
    id_tipo_medicion_darwincore numeric(20,0) NOT NULL
);


ALTER TABLE seguimiento_especie.t_tipo_medicion_darwincore OWNER TO iepnb;

--
-- Name: TABLE t_tipo_medicion_darwincore; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON TABLE seguimiento_especie.t_tipo_medicion_darwincore IS 'Tabla apra relacionar el  tipo de medición con el campo de darwincore que cumplementaria';


--
-- Name: t_tipo_muestreo; Type: TABLE; Schema: seguimiento_especie; Owner: iepnb
--

CREATE TABLE seguimiento_especie.t_tipo_muestreo (
    id_tipo_muestreo bigint NOT NULL,
    tipo_muestreo character varying(100),
    observaciones character varying(100)
);


ALTER TABLE seguimiento_especie.t_tipo_muestreo OWNER TO iepnb;

--
-- Name: t_tipo_persona_ejecutora; Type: TABLE; Schema: seguimiento_especie; Owner: iepnb
--

CREATE TABLE seguimiento_especie.t_tipo_persona_ejecutora (
    id_tipo_persona integer NOT NULL,
    tipo_persona character varying(100),
    tipo_persona_ejecutora character varying(100)
);


ALTER TABLE seguimiento_especie.t_tipo_persona_ejecutora OWNER TO iepnb;

--
-- Name: t_valor_texto_otra_codif_seguimiento; Type: TABLE; Schema: seguimiento_especie; Owner: iepnb
--

CREATE TABLE seguimiento_especie.t_valor_texto_otra_codif_seguimiento (
    id_valor_texto bigint NOT NULL,
    cod_unidad_otro_sist character varying(50) NOT NULL,
    id_valor_texto_otro_sistema numeric(20,0),
    id_tipo_medicion integer NOT NULL,
    otro_nombre character varying(200)
);


ALTER TABLE seguimiento_especie.t_valor_texto_otra_codif_seguimiento OWNER TO iepnb;

--
-- Name: v_bevacet_evento; Type: VIEW; Schema: seguimiento_especie; Owner: iepnb
--

CREATE VIEW seguimiento_especie.v_bevacet_evento AS
 SELECT e.id_evento,
    e.nombre,
    e.descripcion,
    e.fecha_ini,
    e.fecha_fin,
    e.anio,
    e.id_persona_ejecutora,
    tpe.nombre_original AS persona_ejecutora,
    e.id_programa,
    p.nombre AS programa,
    ep.id_evento_programa
   FROM (((seguimiento_especie.evento e
     LEFT JOIN seguimiento_especie.evento_programa ep ON ((e.id_evento = ep.id_evento)))
     LEFT JOIN seguimiento_especie.t_persona_ejecutora tpe ON ((e.id_persona_ejecutora = tpe.id_persona_ejecutora)))
     LEFT JOIN seguimiento_especie.programa p ON ((p.id_programa = e.id_programa)))
  WHERE (e.id_programa = (3)::numeric);


ALTER VIEW seguimiento_especie.v_bevacet_evento OWNER TO iepnb;

--
-- Name: v_bevacet_ocurrencia; Type: VIEW; Schema: seguimiento_especie; Owner: iepnb
--

CREATE VIEW seguimiento_especie.v_bevacet_ocurrencia AS
 SELECT o.cod_ocurrencia,
    o.id_evento_programa,
    o.fecha_hora_ocurrencia,
    o.id_taxon,
    a.nombre_aceptado,
    o.id_persona_ejecutora,
    o.id_especimen,
    o.fecha_carga,
    o.idnombre,
    n.nombre
   FROM (((seguimiento_especie.ocurrencia o
     LEFT JOIN especie.nombre n ON (((o.idnombre)::numeric = n.idnombre)))
     LEFT JOIN especie.taxonnombre tn ON ((o.id_taxon = tn.idtaxon)))
     LEFT JOIN ( SELECT tn2.idtaxon,
            tn2.idnombre,
            n2.nombre AS nombre_aceptado,
            tn2.idtiponombre
           FROM (especie.taxonnombre tn2
             LEFT JOIN especie.nombre n2 ON ((tn2.idnombre = n2.idnombre)))
          WHERE (tn2.idtiponombre = 10)) a ON ((o.id_taxon = a.idtaxon)))
  WHERE (o.id_evento_programa IN ( SELECT v_bevacet_evento.id_evento_programa
           FROM seguimiento_especie.v_bevacet_evento));


ALTER VIEW seguimiento_especie.v_bevacet_ocurrencia OWNER TO iepnb;

--
-- Name: v_bevacet_ocurrencia_medicion; Type: VIEW; Schema: seguimiento_especie; Owner: iepnb
--

CREATE VIEW seguimiento_especie.v_bevacet_ocurrencia_medicion AS
 SELECT o.cod_ocurrencia,
    o.id_tipo_medicion,
    ttm.nombre AS tipo_medida,
    o.observaciones,
    o.valor_numerico,
    o.id_unidad,
    tu.nombre AS unidad,
    o.valor_texto,
    o.id_valor_texto,
    tvt.nombre_valor AS valor,
    o.valor_numerico_max,
    o.valor_numerico_min
   FROM (((seguimiento_especie.ocurrencia_medicion o
     LEFT JOIN comun.t_tipo_medicion ttm ON ((ttm.id_tipo_medicion = o.id_tipo_medicion)))
     LEFT JOIN comun.t_unidad tu ON ((tu.id_unidad = o.id_unidad)))
     LEFT JOIN comun.t_valor_texto tvt ON ((tvt.id_valor_texto = o.id_valor_texto)))
  WHERE ((o.cod_ocurrencia)::text IN ( SELECT c.cod_ocurrencia
           FROM seguimiento_especie.v_bevacet_ocurrencia c));


ALTER VIEW seguimiento_especie.v_bevacet_ocurrencia_medicion OWNER TO iepnb;

--
-- Name: v_bevacet_ocurrencia_muestra; Type: VIEW; Schema: seguimiento_especie; Owner: iepnb
--

CREATE VIEW seguimiento_especie.v_bevacet_ocurrencia_muestra AS
 SELECT cod_ocurencia,
    id_tipo_muestra,
    id_tipo_muestreo,
    cod_muestra
   FROM seguimiento_especie.ocurrencia_muestra m
  WHERE ((cod_ocurencia)::text IN ( SELECT c.cod_ocurrencia
           FROM seguimiento_especie.v_bevacet_ocurrencia c));


ALTER VIEW seguimiento_especie.v_bevacet_ocurrencia_muestra OWNER TO iepnb;

--
-- Name: v_bevacet_programa; Type: VIEW; Schema: seguimiento_especie; Owner: iepnb
--

CREATE VIEW seguimiento_especie.v_bevacet_programa AS
 SELECT p.id_programa,
    p.nombre AS programa,
    p.nombre_corto,
    p.id_grupo_taxonomico,
    gt.nombre AS grupo_taxonomico
   FROM ((seguimiento_especie.programa p
     LEFT JOIN comun.t_grupo_taxonomico tgt ON ((tgt.id_grupo_taxon = p.id_grupo_taxonomico)))
     LEFT JOIN comun.t_nombre_grupo_taxonomico gt ON (((tgt.id_nombre_grupo_taxon)::numeric = gt.id_nombre_grupo_taxon)))
  WHERE ((p.nombre_corto)::text = 'BEVACET'::text);


ALTER VIEW seguimiento_especie.v_bevacet_programa OWNER TO iepnb;

--
-- Name: v_oc_med; Type: VIEW; Schema: seguimiento_especie; Owner: iepnb
--

CREATE VIEW seguimiento_especie.v_oc_med AS
 SELECT DISTINCT o.id_tipo_medicion,
    t.nombre,
    t.texto_o_num,
    o.valor_texto,
    o.valor_numerico,
    o.id_valor_texto,
    o.valor_numerico_max,
    o.valor_numerico_min
   FROM (seguimiento_especie.ocurrencia_medicion o
     LEFT JOIN comun.t_tipo_medicion t ON ((o.id_tipo_medicion = t.id_tipo_medicion)));


ALTER VIEW seguimiento_especie.v_oc_med OWNER TO iepnb;

--
-- Name: taxon id; Type: DEFAULT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxon ALTER COLUMN id SET DEFAULT nextval('especie.sec_id_taxon'::regclass);


--
-- Name: taxonnombre idtaxonnombre; Type: DEFAULT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonnombre ALTER COLUMN idtaxonnombre SET DEFAULT nextval('especie.sec_id_taxonnombre'::regclass);


--
-- Name: taxonplanesgestion id; Type: DEFAULT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonplanesgestion ALTER COLUMN id SET DEFAULT nextval('especie.taxonplanesgestion_id_seq'::regclass);


--
-- Name: especimen ESPECIMEN_pkey; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.especimen
    ADD CONSTRAINT "ESPECIMEN_pkey" PRIMARY KEY (id_especimen);


--
-- Name: organismo_organismo PK_ORGANISMO_ORGANISMO; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.organismo_organismo
    ADD CONSTRAINT "PK_ORGANISMO_ORGANISMO" PRIMARY KEY (id_organismo, id_organismo2);


--
-- Name: organismo_aplicacion PK_ORG_APP; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.organismo_aplicacion
    ADD CONSTRAINT "PK_ORG_APP" PRIMARY KEY (id_org_app);


--
-- Name: norma_componente PK_TCAT_NORMA_COMPONENTE; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.norma_componente
    ADD CONSTRAINT "PK_TCAT_NORMA_COMPONENTE" PRIMARY KEY (id_norma, id_componente);


--
-- Name: t_tipo_norma PK_TIEP_LC_TIPONORMA; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_tipo_norma
    ADD CONSTRAINT "PK_TIEP_LC_TIPONORMA" PRIMARY KEY (id_tiponorma);


--
-- Name: t_ambito PK_T_AMBITO; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_ambito
    ADD CONSTRAINT "PK_T_AMBITO" PRIMARY KEY (cod_ambito);


--
-- Name: t_region_biogeografica PK_T_COMU_REGIONBIOGEOGRAFICA; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_region_biogeografica
    ADD CONSTRAINT "PK_T_COMU_REGIONBIOGEOGRAFICA" PRIMARY KEY (id_region);


--
-- Name: t_relacion_espacial PK_T_COMU_RELACION; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_relacion_espacial
    ADD CONSTRAINT "PK_T_COMU_RELACION" PRIMARY KEY (id_relacion);


--
-- Name: t_contaminante PK_T_CONTAMINANTE; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_contaminante
    ADD CONSTRAINT "PK_T_CONTAMINANTE" PRIMARY KEY (id_contaminante);


--
-- Name: t_nombre_grupo_taxonomico PK_T_NOMBRE_GRUPO_TAONOMICO_1; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_nombre_grupo_taxonomico
    ADD CONSTRAINT "PK_T_NOMBRE_GRUPO_TAONOMICO_1" PRIMARY KEY (id_nombre_grupo_taxon);


--
-- Name: norma_tema PK_T_NORMA_TEMA; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.norma_tema
    ADD CONSTRAINT "PK_T_NORMA_TEMA" PRIMARY KEY (id_tema, id_norma);


--
-- Name: t_presion_amenaza PK_T_PRESION_AMENAZA; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_presion_amenaza
    ADD CONSTRAINT "PK_T_PRESION_AMENAZA" PRIMARY KEY (id_presion);


--
-- Name: t_tipo_organismo PK_T_TIPO_ORGANISMO; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_tipo_organismo
    ADD CONSTRAINT "PK_T_TIPO_ORGANISMO" PRIMARY KEY (id_tipo_organismo);


--
-- Name: t_tipo_verificacion_documento PK_T_TIPO_VERIFICACION_DOCUMENTO; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_tipo_verificacion_documento
    ADD CONSTRAINT "PK_T_TIPO_VERIFICACION_DOCUMENTO" PRIMARY KEY (id_tipo_verificacion_documento);


--
-- Name: t_tipopropiedad TIEP_LC_TIPOPROPIEDAD_PK; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_tipopropiedad
    ADD CONSTRAINT "TIEP_LC_TIPOPROPIEDAD_PK" PRIMARY KEY (id_tipopropiedad);


--
-- Name: t_tipo_medicion TSEG_TIIPO_MEDICION_NUM_PK; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_tipo_medicion
    ADD CONSTRAINT "TSEG_TIIPO_MEDICION_NUM_PK" PRIMARY KEY (id_tipo_medicion);


--
-- Name: t_tipo_geometria_carto TSEG_TIPO_GIMETRIA_CARTO_PK; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_tipo_geometria_carto
    ADD CONSTRAINT "TSEG_TIPO_GIMETRIA_CARTO_PK" PRIMARY KEY (id_tipo_geometria_carto);


--
-- Name: t_tipo_medic_valor_texto TSEG_TIPO_MEDIC_VALOR_TEXT_PK; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_tipo_medic_valor_texto
    ADD CONSTRAINT "TSEG_TIPO_MEDIC_VALOR_TEXT_PK" PRIMARY KEY (id_tipo_medicion, id_valor_texto);


--
-- Name: t_ambito_nivel_geografico_politico T_AMBITO_GEOGRAFICO_PK; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_ambito_nivel_geografico_politico
    ADD CONSTRAINT "T_AMBITO_GEOGRAFICO_PK" PRIMARY KEY (id_ambito_nivel_geografico_politico);


--
-- Name: t_aplicacion T_APLICACION_pkey; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_aplicacion
    ADD CONSTRAINT "T_APLICACION_pkey" PRIMARY KEY (id_aplicacion);


--
-- Name: t_ccaa T_CCAA_pkey; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_ccaa
    ADD CONSTRAINT "T_CCAA_pkey" PRIMARY KEY (id_ccaa);


--
-- Name: t_nut T_CCAA_pkey_1; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_nut
    ADD CONSTRAINT "T_CCAA_pkey_1" PRIMARY KEY (id_ccaa);


--
-- Name: coleccion_medida T_COLECCION_MEDIDA_PK; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.coleccion_medida
    ADD CONSTRAINT "T_COLECCION_MEDIDA_PK" PRIMARY KEY (id_coleccion_medida);


--
-- Name: t_componente T_COMPONENTES_pkey; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_componente
    ADD CONSTRAINT "T_COMPONENTES_pkey" PRIMARY KEY (id_componente);


--
-- Name: t_estado_conserva_otras_codif T_ESTADO_CONSERVA_OTRAS_CODIF_pkey; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_estado_conserva_otras_codif
    ADD CONSTRAINT "T_ESTADO_CONSERVA_OTRAS_CODIF_pkey" PRIMARY KEY (id_estado_conserva, id_aplicacion);


--
-- Name: t_impacto T_IMPACTO_PK; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_impacto
    ADD CONSTRAINT "T_IMPACTO_PK" PRIMARY KEY (id_impacto);


--
-- Name: medida_conservacion_norma T_MEDIDA_NORMA_PK; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.medida_conservacion_norma
    ADD CONSTRAINT "T_MEDIDA_NORMA_PK" PRIMARY KEY (id_medida, id_norma);


--
-- Name: t_medida_conserva_gestion T_MEDIDA_PK; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_medida_conserva_gestion
    ADD CONSTRAINT "T_MEDIDA_PK" PRIMARY KEY (id_medida);


--
-- Name: t_municipio T_MUNICIPIOS_pkey; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_municipio
    ADD CONSTRAINT "T_MUNICIPIOS_pkey" PRIMARY KEY (id_municipios);


--
-- Name: t_norma T_NORMAS_PK; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_norma
    ADD CONSTRAINT "T_NORMAS_PK" PRIMARY KEY (id_norma);


--
-- Name: norma_norma T_NORMA_NORMA_PK; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.norma_norma
    ADD CONSTRAINT "T_NORMA_NORMA_PK" PRIMARY KEY (id_norma, id_norma_2);


--
-- Name: t_organismo T_ORGANISMOS_pkey; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_organismo
    ADD CONSTRAINT "T_ORGANISMOS_pkey" PRIMARY KEY (id_organismo);


--
-- Name: organismo_provincia T_ORGANISMO_PROVINCIA_pkey; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.organismo_provincia
    ADD CONSTRAINT "T_ORGANISMO_PROVINCIA_pkey" PRIMARY KEY (id_organismo, id_provincia);


--
-- Name: t_perfil T_PERFIL_pkey; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_perfil
    ADD CONSTRAINT "T_PERFIL_pkey" PRIMARY KEY (id_perfil);


--
-- Name: t_provincia T_PROVINCIAS_pkey; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_provincia
    ADD CONSTRAINT "T_PROVINCIAS_pkey" PRIMARY KEY (id_provincia);


--
-- Name: t_rango_norma_inf T_RANGOS_NORMA_INF_PK; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_rango_norma_inf
    ADD CONSTRAINT "T_RANGOS_NORMA_INF_PK" PRIMARY KEY (id_rango_norma);


--
-- Name: t_rango_norma_int T_RANGOS_NORMA_INT_PK; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_rango_norma_int
    ADD CONSTRAINT "T_RANGOS_NORMA_INT_PK" PRIMARY KEY (id_rango_norma);


--
-- Name: t_rango_norma_sup T_RANGOS_NORMA_SUP_PK; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_rango_norma_sup
    ADD CONSTRAINT "T_RANGOS_NORMA_SUP_PK" PRIMARY KEY (id_rango_norma);


--
-- Name: t_tema T_TEMAS_PK; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_tema
    ADD CONSTRAINT "T_TEMAS_PK" PRIMARY KEY (id_tema);


--
-- Name: t_tipo_estado_conservacion T_TIPO_ESTADO_CONSERVACION_pkey; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_tipo_estado_conservacion
    ADD CONSTRAINT "T_TIPO_ESTADO_CONSERVACION_pkey" PRIMARY KEY (id_tipo_conservacion);


--
-- Name: t_tipo_relacion_norma T_TIPO_RELACION_NORMA_PK; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_tipo_relacion_norma
    ADD CONSTRAINT "T_TIPO_RELACION_NORMA_PK" PRIMARY KEY (id_tipo_relacion_norma);


--
-- Name: t_unidad T_UNIDAD_PK; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_unidad
    ADD CONSTRAINT "T_UNIDAD_PK" PRIMARY KEY (id_unidad);


--
-- Name: unidad_tipo_medicion T_UNIDAD_TIPO_MEDIDA_PK; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.unidad_tipo_medicion
    ADD CONSTRAINT "T_UNIDAD_TIPO_MEDIDA_PK" PRIMARY KEY (id_unidad, id_tipo_medicion);


--
-- Name: t_usuario T_USUARIO_pkey; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_usuario
    ADD CONSTRAINT "T_USUARIO_pkey" PRIMARY KEY (id_usuario);


--
-- Name: t_valor_texto T_VALORES_TEXTO_PK; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_valor_texto
    ADD CONSTRAINT "T_VALORES_TEXTO_PK" PRIMARY KEY (id_valor_texto);


--
-- Name: t_usuario UK_NIF; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_usuario
    ADD CONSTRAINT "UK_NIF" UNIQUE (nif);


--
-- Name: t_usuario UK_USERNAME; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_usuario
    ADD CONSTRAINT "UK_USERNAME" UNIQUE (username);


--
-- Name: t_unidad_otra_codif UNIDAD_OTRA_CODIF_pkey; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_unidad_otra_codif
    ADD CONSTRAINT "UNIDAD_OTRA_CODIF_pkey" PRIMARY KEY (id_unidad, id_aplicacion);


--
-- Name: ccaa_elemento_toponimo ccaa_elemento_toponimo_pk; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.ccaa_elemento_toponimo
    ADD CONSTRAINT ccaa_elemento_toponimo_pk PRIMARY KEY (id_elemento_toponimo, id_ccaa);


--
-- Name: documento documento_pk; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.documento
    ADD CONSTRAINT documento_pk PRIMARY KEY (id_documento);


--
-- Name: grupo_taxon_eidos_otros grupo_taxon_eidos_otros_pkey; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.grupo_taxon_eidos_otros
    ADD CONSTRAINT grupo_taxon_eidos_otros_pkey PRIMARY KEY (id_grupo_taxon, id_grupotax_eidos);


--
-- Name: t_idioma ididioma_pk; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_idioma
    ADD CONSTRAINT ididioma_pk PRIMARY KEY (ididioma);


--
-- Name: norma_ccaa norma_ccaa_pk; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.norma_ccaa
    ADD CONSTRAINT norma_ccaa_pk PRIMARY KEY (id_norma, id_ccaa);


--
-- Name: norma_elemento_toponimo norma_elemento_toponimo_pk; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.norma_elemento_toponimo
    ADD CONSTRAINT norma_elemento_toponimo_pk PRIMARY KEY (id_elemento_toponimo, id_norma);


--
-- Name: organismo_ccaa organismo_ccaa_pk; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.organismo_ccaa
    ADD CONSTRAINT organismo_ccaa_pk PRIMARY KEY (id_organismo, id_ccaa);


--
-- Name: t_origen origen_pk; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_origen
    ADD CONSTRAINT origen_pk PRIMARY KEY (idorigen);


--
-- Name: organismo_ambito_aplica pk_organismo_ambito_aplica; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.organismo_ambito_aplica
    ADD CONSTRAINT pk_organismo_ambito_aplica PRIMARY KEY (id_organismo_ambito_aplica);


--
-- Name: perfil_funcionalidad pk_perfil_funcionalidad; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.perfil_funcionalidad
    ADD CONSTRAINT pk_perfil_funcionalidad PRIMARY KEY (id_perfil_funcionalidad);


--
-- Name: t_ambito_aplica pk_t_ambito_aplica; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_ambito_aplica
    ADD CONSTRAINT pk_t_ambito_aplica PRIMARY KEY (id_ambito_aplica);


--
-- Name: t_catalogo pk_t_catalogo; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_catalogo
    ADD CONSTRAINT pk_t_catalogo PRIMARY KEY (id_catalogo);


--
-- Name: t_funcionalidad pk_t_funcionalidad; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_funcionalidad
    ADD CONSTRAINT pk_t_funcionalidad PRIMARY KEY (id_funcionalidad);


--
-- Name: t_parametro_configuracion pk_t_parametro_configuracion; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_parametro_configuracion
    ADD CONSTRAINT pk_t_parametro_configuracion PRIMARY KEY (id_parametro);


--
-- Name: t_ref_bibliografica pk_t_ref_bibliografica; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_ref_bibliografica
    ADD CONSTRAINT pk_t_ref_bibliografica PRIMARY KEY (idreferencia);


--
-- Name: t_tipo_plan pk_t_tipo_plan; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_tipo_plan
    ADD CONSTRAINT pk_t_tipo_plan PRIMARY KEY (id_tipo_plan);


--
-- Name: t_visible pk_t_visible; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_visible
    ADD CONSTRAINT pk_t_visible PRIMARY KEY (idvisible);


--
-- Name: revision_info revision_info_pk; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.revision_info
    ADD CONSTRAINT revision_info_pk PRIMARY KEY (id_revision_info);


--
-- Name: revtype revtype_pk; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.revtype
    ADD CONSTRAINT revtype_pk PRIMARY KEY (id_revtype);


--
-- Name: t_categoria_medida_conservacion t_categoria_medida_conservacion_pk; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_categoria_medida_conservacion
    ADD CONSTRAINT t_categoria_medida_conservacion_pk PRIMARY KEY (id_categoria_medida_conserva);


--
-- Name: t_clasif_objetivo_norma t_clasif_objetivo_norma_pk; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_clasif_objetivo_norma
    ADD CONSTRAINT t_clasif_objetivo_norma_pk PRIMARY KEY (id_clasific_objetivo_norma);


--
-- Name: t_elemento_toponomico t_elemento_toponimico_pk; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_elemento_toponomico
    ADD CONSTRAINT t_elemento_toponimico_pk PRIMARY KEY (id_elemento_toponimico);


--
-- Name: t_elemento_toponomico t_elemento_toponimico_un_2; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_elemento_toponomico
    ADD CONSTRAINT t_elemento_toponimico_un_2 UNIQUE (id_nombre_toponimo, id_tipo_relieve, id_tipo_toponimo, cod_punto_cardinal, id_ambito_nivel_geograf_politico);


--
-- Name: t_tipo_especif_valor_texto t_especif_valor_texto_pk; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_tipo_especif_valor_texto
    ADD CONSTRAINT t_especif_valor_texto_pk PRIMARY KEY (id_especificacion);


--
-- Name: t_tipo_especificacion t_especificacion_pkey; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_tipo_especificacion
    ADD CONSTRAINT t_especificacion_pkey PRIMARY KEY (id_especificacion);


--
-- Name: t_fuente_presion_amenaza t_fuente_presion_amenaza_pk; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_fuente_presion_amenaza
    ADD CONSTRAINT t_fuente_presion_amenaza_pk PRIMARY KEY (id_fuente_presion_amenza);


--
-- Name: t_grupo_taxonomico t_grupo_taxonomico_pkey; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_grupo_taxonomico
    ADD CONSTRAINT t_grupo_taxonomico_pkey PRIMARY KEY (id_grupo_taxon);


--
-- Name: t_importancia t_importancia_pk; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_importancia
    ADD CONSTRAINT t_importancia_pk PRIMARY KEY (id_importancia);


--
-- Name: t_localidad t_localidad_pkey; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_localidad
    ADD CONSTRAINT t_localidad_pkey PRIMARY KEY (id_localidad);


--
-- Name: t_nombre_toponimia t_nombre_toponimia_pk; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_nombre_toponimia
    ADD CONSTRAINT t_nombre_toponimia_pk PRIMARY KEY (id_nombre_toponimia);


--
-- Name: t_punto_cardinal t_punto_caardinal_pk; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_punto_cardinal
    ADD CONSTRAINT t_punto_caardinal_pk PRIMARY KEY (cod_cardinal);


--
-- Name: t_sexo t_sexo_pkey; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_sexo
    ADD CONSTRAINT t_sexo_pkey PRIMARY KEY (id_sexo);


--
-- Name: t_sist_coordenadas t_sist_coordenadas_pkey; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_sist_coordenadas
    ADD CONSTRAINT t_sist_coordenadas_pkey PRIMARY KEY (idsistcoord);


--
-- Name: t_tipo_cambio t_tipo_cambio_pk; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_tipo_cambio
    ADD CONSTRAINT t_tipo_cambio_pk PRIMARY KEY (id_tipo_cambio);


--
-- Name: t_tipo_documento t_tipo_documento_pk; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_tipo_documento
    ADD CONSTRAINT t_tipo_documento_pk PRIMARY KEY (id_tipo_documento);


--
-- Name: t_tipo_relieve t_tipo_relieve_pk; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_tipo_relieve
    ADD CONSTRAINT t_tipo_relieve_pk PRIMARY KEY (id_tipo_relieve);


--
-- Name: t_tipo_toponimia t_tipo_toponimia_pk; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_tipo_toponimia
    ADD CONSTRAINT t_tipo_toponimia_pk PRIMARY KEY (id_tipo_toponimia);


--
-- Name: t_valor_medida t_valor_medida_pkey_1; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_valor_medida
    ADD CONSTRAINT t_valor_medida_pkey_1 PRIMARY KEY (id_valor_medida);


--
-- Name: t_valor_texto_otra_codif t_valor_texto_otra_codif_pkey; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_valor_texto_otra_codif
    ADD CONSTRAINT t_valor_texto_otra_codif_pkey PRIMARY KEY (id_valor_texto, id_aplicacion);


--
-- Name: organismo_ambito_aplica unq_organismo_ambito_aplica; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.organismo_ambito_aplica
    ADD CONSTRAINT unq_organismo_ambito_aplica UNIQUE (id_organismo, id_aplicacion, id_ccaa, id_provincia, id_municipio, id_ambito_aplica);


--
-- Name: organismo_aplicacion unq_organismo_aplicacion; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.organismo_aplicacion
    ADD CONSTRAINT unq_organismo_aplicacion UNIQUE (id_organismo, id_aplicacion);


--
-- Name: t_ambito unq_t_ambito; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_ambito
    ADD CONSTRAINT unq_t_ambito UNIQUE (cod_ambito);


--
-- Name: t_ambito_aplica unq_t_ambito_aplica; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_ambito_aplica
    ADD CONSTRAINT unq_t_ambito_aplica UNIQUE (codigo_ambito_aplica);


--
-- Name: t_catalogo unq_t_catalogo; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_catalogo
    ADD CONSTRAINT unq_t_catalogo UNIQUE (nombre);


--
-- Name: t_funcionalidad unq_t_funcionalidad; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_funcionalidad
    ADD CONSTRAINT unq_t_funcionalidad UNIQUE (codigo_funcionalidad);


--
-- Name: t_parametro_configuracion unq_t_parametro; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_parametro_configuracion
    ADD CONSTRAINT unq_t_parametro UNIQUE (nombre);


--
-- Name: perfil_funcionalidad unq_t_perfil_funcionalidad; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.perfil_funcionalidad
    ADD CONSTRAINT unq_t_perfil_funcionalidad UNIQUE (id_perfil, id_funcionalidad);


--
-- Name: t_punto_cardinal unq_t_punto_cardinal; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_punto_cardinal
    ADD CONSTRAINT unq_t_punto_cardinal UNIQUE (cod_cardinal);


--
-- Name: especimen uq_codmarcado; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.especimen
    ADD CONSTRAINT uq_codmarcado UNIQUE (cod_marcado);


--
-- Name: t_vigente vigente_pk; Type: CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_vigente
    ADD CONSTRAINT vigente_pk PRIMARY KEY (idvigente);


--
-- Name: t_origentaxon ORIGENTAXON_pkey; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_origentaxon
    ADD CONSTRAINT "ORIGENTAXON_pkey" PRIMARY KEY (idorigen);


--
-- Name: taxon TAXON_PK; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxon
    ADD CONSTRAINT "TAXON_PK" PRIMARY KEY (idtaxon);


--
-- Name: tgis_linea TSEG_GIS_MEDICION_LINEA_PK; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.tgis_linea
    ADD CONSTRAINT "TSEG_GIS_MEDICION_LINEA_PK" PRIMARY KEY (id_gis_medicion_poligon);


--
-- Name: tgis_poligon TSEG_GIS_MEDICION_POLIGON_PK; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.tgis_poligon
    ADD CONSTRAINT "TSEG_GIS_MEDICION_POLIGON_PK" PRIMARY KEY (id_gis_medicion_poligon);


--
-- Name: tgis_punto TSEG_GIS_MEDICION_PUNTO_PK; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.tgis_punto
    ADD CONSTRAINT "TSEG_GIS_MEDICION_PUNTO_PK" PRIMARY KEY (id_gis_medicion_poligon);


--
-- Name: t_ambito_es T_AMBITO_GEOGRAFICO_PK; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_ambito_es
    ADD CONSTRAINT "T_AMBITO_GEOGRAFICO_PK" PRIMARY KEY (id_ambito_es);


--
-- Name: t_dataset_medida T_COLECCION_MEDIDA_PK; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_dataset_medida
    ADD CONSTRAINT "T_COLECCION_MEDIDA_PK" PRIMARY KEY (id_dataset_medida);


--
-- Name: t_atributo atributo_pk; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_atributo
    ADD CONSTRAINT atributo_pk PRIMARY KEY (idatributo);


--
-- Name: t_categoria_conservacion categoriaconservacion_pk; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_categoria_conservacion
    ADD CONSTRAINT categoriaconservacion_pk PRIMARY KEY (idcategoria);


--
-- Name: t_codigosexternos_eliminar codigoexterno_pk_1; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_codigosexternos_eliminar
    ADD CONSTRAINT codigoexterno_pk_1 PRIMARY KEY (idcodigoexterno);


--
-- Name: t_origen_lp coleccion_pk_1; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_origen_lp
    ADD CONSTRAINT coleccion_pk_1 PRIMARY KEY (idorigenlp);


--
-- Name: t_criteriomedidaconservacion criteriomedidaconservacion_pk; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_criteriomedidaconservacion
    ADD CONSTRAINT criteriomedidaconservacion_pk PRIMARY KEY (idcriterio);


--
-- Name: t_dataset dataset_pk; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_dataset
    ADD CONSTRAINT dataset_pk PRIMARY KEY (iddataset);


--
-- Name: endemismo endemismo_pk; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.endemismo
    ADD CONSTRAINT endemismo_pk PRIMARY KEY (idendemicoen, iddataset, idtaxon);


--
-- Name: t_estadolegal estadolegal_pk; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_estadolegal
    ADD CONSTRAINT estadolegal_pk PRIMARY KEY (idestadolegal);


--
-- Name: t_estadotaxon estadotaxon_pk; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_estadotaxon
    ADD CONSTRAINT estadotaxon_pk PRIMARY KEY (idestadotaxon);


--
-- Name: t_fuente fuente_pk; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_fuente
    ADD CONSTRAINT fuente_pk PRIMARY KEY (idfuente);


--
-- Name: t_grupo grupo_pk; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_grupo
    ADD CONSTRAINT grupo_pk PRIMARY KEY (idgrupo);


--
-- Name: grupodataset grupocoleccion_pk; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.grupodataset
    ADD CONSTRAINT grupocoleccion_pk PRIMARY KEY (idgrupo, iddataset);


--
-- Name: grupolegislacion grupocoleccion_pk_1; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.grupolegislacion
    ADD CONSTRAINT grupocoleccion_pk_1 PRIMARY KEY (idgrupo, idnorma);


--
-- Name: lp_fotofija lp_fotofija_pk; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.lp_fotofija
    ADD CONSTRAINT lp_fotofija_pk PRIMARY KEY (idnombre, fechalp);


--
-- Name: t_medidaconservacion medidaconservacion_pk; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_medidaconservacion
    ADD CONSTRAINT medidaconservacion_pk PRIMARY KEY (idmedidaconservacion);


--
-- Name: t_metodomedida metodomedida_pk; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_metodomedida
    ADD CONSTRAINT metodomedida_pk PRIMARY KEY (idmetodomedida);


--
-- Name: t_poblacionreferida newtable_pk; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_poblacionreferida
    ADD CONSTRAINT newtable_pk PRIMARY KEY (idpoblacionreferida);


--
-- Name: nombre nombre_pk; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.nombre
    ADD CONSTRAINT nombre_pk PRIMARY KEY (idnombre);


--
-- Name: nombrecodigosexternos nombrecodigosexternos_pk; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.nombrecodigosexternos
    ADD CONSTRAINT nombrecodigosexternos_pk PRIMARY KEY (id_tipo_codigo, iddataset, codigo, idnombre);


--
-- Name: nombrepreferencia nombrepreferencia_pk; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.nombrepreferencia
    ADD CONSTRAINT nombrepreferencia_pk PRIMARY KEY (idnombrepreferente);


--
-- Name: t_objetivo_planesgestion objetivoplan_pk; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_objetivo_planesgestion
    ADD CONSTRAINT objetivoplan_pk PRIMARY KEY (idobjetivoplan);


--
-- Name: lp_fuentereferencias pk_lp_fuentereferencias; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.lp_fuentereferencias
    ADD CONSTRAINT pk_lp_fuentereferencias PRIMARY KEY (idorigenlp, idfuentereferencialp);


--
-- Name: lp_origen pk_lp_origen; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.lp_origen
    ADD CONSTRAINT pk_lp_origen PRIMARY KEY (idnombre, idorigenlp, idvigente);


--
-- Name: lp_sociedades pk_lp_sociedades; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.lp_sociedades
    ADD CONSTRAINT pk_lp_sociedades PRIMARY KEY (idorigenlp, idsociedadlp);


--
-- Name: t_fuentereferencias_lp pk_t_fuentereferencias_lp; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_fuentereferencias_lp
    ADD CONSTRAINT pk_t_fuentereferencias_lp PRIMARY KEY (idfuentereferencialp);


--
-- Name: t_sociedades_lp pk_t_sociedades_lp; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_sociedades_lp
    ADD CONSTRAINT pk_t_sociedades_lp PRIMARY KEY (idsociedadlp);


--
-- Name: taxondataset pk_taxondataset; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxondataset
    ADD CONSTRAINT pk_taxondataset PRIMARY KEY (idtaxon, iddataset, id_ambito_es, idvigente);


--
-- Name: taxonestadoconservacion pk_taxonestadoconservacion; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonestadoconservacion
    ADD CONSTRAINT pk_taxonestadoconservacion PRIMARY KEY (idtaxon, anio, idcategoria, idaplicaa, iddataset);


--
-- Name: taxonhabitat pk_taxonhabitat; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonhabitat
    ADD CONSTRAINT pk_taxonhabitat PRIMARY KEY (idtaxon, idhabitat, idaplicaa, id_tipo_cambio, iddataset, idvigente);


--
-- Name: pliniancore-extension pliniancore_extension_pk; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie."pliniancore-extension"
    ADD CONSTRAINT pliniancore_extension_pk PRIMARY KEY (idtaxon, iddataset, idatributo, idfuente);


--
-- Name: poblacion_aplicaa_nut2 poblacion_aplicaa_pk; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.poblacion_aplicaa_nut2
    ADD CONSTRAINT poblacion_aplicaa_pk PRIMARY KEY (observacionespoblacion, idaplicaa_nut2, excepto_idaplicaa_nut2);


--
-- Name: t_precisionmedida precisionmedida_pk; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_precisionmedida
    ADD CONSTRAINT precisionmedida_pk PRIMARY KEY (idprecisionmedida);


--
-- Name: relacion_taxonomica relacion_taxonomica_pk; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.relacion_taxonomica
    ADD CONSTRAINT relacion_taxonomica_pk PRIMARY KEY (idreltax);


--
-- Name: t_agrup_tiponombre t_agrup_tiponombre_pk; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_agrup_tiponombre
    ADD CONSTRAINT t_agrup_tiponombre_pk PRIMARY KEY (id_agrup_tiponombre);


--
-- Name: t_ambito_distribucion t_ambito_ditribucion_pk; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_ambito_distribucion
    ADD CONSTRAINT t_ambito_ditribucion_pk PRIMARY KEY (idambitodistr);


--
-- Name: t_aplicaa_conservacion t_aplicaa_conservacion_pk; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_aplicaa_conservacion
    ADD CONSTRAINT t_aplicaa_conservacion_pk PRIMARY KEY (idaplicaa);


--
-- Name: t_aplicaa_distribucion t_aplicadoa_distribucion_pk; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_aplicaa_distribucion
    ADD CONSTRAINT t_aplicadoa_distribucion_pk PRIMARY KEY (idaplicaa);


--
-- Name: t_autoridad_conservacion t_autoridad_conservacion_pk; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_autoridad_conservacion
    ADD CONSTRAINT t_autoridad_conservacion_pk PRIMARY KEY (idautoridad);


--
-- Name: t_codigohabitat t_codigohabitat_pk; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_codigohabitat
    ADD CONSTRAINT t_codigohabitat_pk PRIMARY KEY (idcodigo);


--
-- Name: t_endemicoen t_endemicoen_pk; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_endemicoen
    ADD CONSTRAINT t_endemicoen_pk PRIMARY KEY (idendemicoen);


--
-- Name: t_estado_cuadricula t_estado_cuadricula_pkey; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_estado_cuadricula
    ADD CONSTRAINT t_estado_cuadricula_pkey PRIMARY KEY (idestadocuad);


--
-- Name: t_regionreferenciada t_regionreferenciada_pk; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_regionreferenciada
    ADD CONSTRAINT t_regionreferenciada_pk PRIMARY KEY (idregionreferenciada);


--
-- Name: t_rutaintroduccion t_rutaintroduccion_pk; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_rutaintroduccion
    ADD CONSTRAINT t_rutaintroduccion_pk PRIMARY KEY (idrutaintroduccion);


--
-- Name: t_tipo_atributo_taxon t_tipo_atributo_taxon_pkey; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_tipo_atributo_taxon
    ADD CONSTRAINT t_tipo_atributo_taxon_pkey PRIMARY KEY (id_tipo_atributo_taxon);


--
-- Name: t_tipo_codigo t_tipo_codigo_pk; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_tipo_codigo
    ADD CONSTRAINT t_tipo_codigo_pk PRIMARY KEY (id_tipo_codigo);


--
-- Name: t_tipo_distribucion t_tipo_distribucion_pk; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_tipo_distribucion
    ADD CONSTRAINT t_tipo_distribucion_pk PRIMARY KEY (idtipodistribucion);


--
-- Name: t_tipo_publicacion t_tipo_publicacion_pk; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_tipo_publicacion
    ADD CONSTRAINT t_tipo_publicacion_pk PRIMARY KEY (idtipo_publicacion);


--
-- Name: t_tipo_relaciontax t_tipo_relaciontax_pk; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_tipo_relaciontax
    ADD CONSTRAINT t_tipo_relaciontax_pk PRIMARY KEY (idtipo_reltax);


--
-- Name: t_tipoambito_ditribucion t_tipoambito_ditribucion_pk; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_tipoambito_ditribucion
    ADD CONSTRAINT t_tipoambito_ditribucion_pk PRIMARY KEY (idtipoambitodistr);


--
-- Name: t_tipoamenaza t_tipoamenaza_pk; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_tipoamenaza
    ADD CONSTRAINT t_tipoamenaza_pk PRIMARY KEY (idtipoamenaza);


--
-- Name: t_tipouso_nivel1 t_tipouso_nivel1_pk; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_tipouso_nivel1
    ADD CONSTRAINT t_tipouso_nivel1_pk PRIMARY KEY (iduso1);


--
-- Name: t_tipouso_nivel2 t_tipouso_nivel2_pk; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_tipouso_nivel2
    ADD CONSTRAINT t_tipouso_nivel2_pk PRIMARY KEY (iduso2);


--
-- Name: t_tipouso_nivel3 t_tipouso_nivel3_pk; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_tipouso_nivel3
    ADD CONSTRAINT t_tipouso_nivel3_pk PRIMARY KEY (iduso3);


--
-- Name: t_tituloamenaza t_tituloamenaza_pk; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_tituloamenaza
    ADD CONSTRAINT t_tituloamenaza_pk PRIMARY KEY (idtituloamenaza);


--
-- Name: t_titulopoblacion t_titulopoblacion_pk; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_titulopoblacion
    ADD CONSTRAINT t_titulopoblacion_pk PRIMARY KEY (idtitulo);


--
-- Name: t_valor_atributo t_valor_atributo_pkey; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_valor_atributo
    ADD CONSTRAINT t_valor_atributo_pkey PRIMARY KEY (id_valor_aributo);


--
-- Name: t_aplicaa_nut2 taplicaanut2_pk; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_aplicaa_nut2
    ADD CONSTRAINT taplicaanut2_pk PRIMARY KEY (idaplicaa, nut2);


--
-- Name: taxon_imagen taxon_imagen_pk; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxon_imagen
    ADD CONSTRAINT taxon_imagen_pk PRIMARY KEY (id_taxon, id_foto);


--
-- Name: taxon_medicion taxon_medicion_pk; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxon_medicion
    ADD CONSTRAINT taxon_medicion_pk PRIMARY KEY (idtaxon, idmedida);


--
-- Name: taxondistribucion taxondistribucion_pk; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxondistribucion
    ADD CONSTRAINT taxondistribucion_pk PRIMARY KEY (idtaxon, idaplicadoa, iddataset);


--
-- Name: taxonestadolegal taxonestadolegal_pk; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonestadolegal
    ADD CONSTRAINT taxonestadolegal_pk PRIMARY KEY (idtaxon, idestadolegal);


--
-- Name: taxonfactoresamenaza taxonfactoresamenaza_pk; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonfactoresamenaza
    ADD CONSTRAINT taxonfactoresamenaza_pk PRIMARY KEY (idtaxon, idfactoramenaza, id_tipo_medicion, idaplicaa, iddataset);


--
-- Name: taxonmedidaconservacion taxonmedidaconservacion_pk; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonmedidaconservacion
    ADD CONSTRAINT taxonmedidaconservacion_pk PRIMARY KEY (idtaxon, idmedidaconservacion);


--
-- Name: taxonnombre taxonnombre_pk; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonnombre
    ADD CONSTRAINT taxonnombre_pk PRIMARY KEY (idtaxon, iddataset, idnombre, idvigente, idtiponombre, id_ambito_es);


--
-- Name: taxonomia taxonomia_pk; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonomia
    ADD CONSTRAINT taxonomia_pk PRIMARY KEY (idnombre);


--
-- Name: taxonplanesgestion taxonplanesgestion_pk; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonplanesgestion
    ADD CONSTRAINT taxonplanesgestion_pk PRIMARY KEY (idtaxon, idplan);


--
-- Name: t_taxonrank taxonrank_pk; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_taxonrank
    ADD CONSTRAINT taxonrank_pk PRIMARY KEY (idtaxonrank);


--
-- Name: taxonreferencia taxonreferencia_pk; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonreferencia
    ADD CONSTRAINT taxonreferencia_pk PRIMARY KEY (idreferencia, idtaxon);


--
-- Name: taxonubicacion taxonubicacion_pk; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonubicacion
    ADD CONSTRAINT taxonubicacion_pk PRIMARY KEY (idtaxon, iddataset, cuadr, fecha, y_latitud, x_longitud);


--
-- Name: taxonviaintroduccion taxonviaintroduccion_pk; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonviaintroduccion
    ADD CONSTRAINT taxonviaintroduccion_pk PRIMARY KEY (idtaxon, idrutaintroduccion);


--
-- Name: t_tendencia tendencia_pk; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_tendencia
    ADD CONSTRAINT tendencia_pk PRIMARY KEY (idtendencia);


--
-- Name: t_tipomedidaconservacion tipomedidaconservacion_pk_1; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_tipomedidaconservacion
    ADD CONSTRAINT tipomedidaconservacion_pk_1 PRIMARY KEY (idtipomedidaconservacion);


--
-- Name: t_tiponombre tiponombre_pk; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_tiponombre
    ADD CONSTRAINT tiponombre_pk PRIMARY KEY (idtiponombre);


--
-- Name: t_tiponormativadataset tiponormativadataset_pk; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_tiponormativadataset
    ADD CONSTRAINT tiponormativadataset_pk PRIMARY KEY (idtiponormativadataset);


--
-- Name: t_tipo_planesgestion tipoplan_pk_1; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_tipo_planesgestion
    ADD CONSTRAINT tipoplan_pk_1 PRIMARY KEY (idtipoplan);


--
-- Name: usos usos_pk; Type: CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.usos
    ADD CONSTRAINT usos_pk PRIMARY KEY (iduso);


--
-- Name: habitat PK_HABITAT; Type: CONSTRAINT; Schema: habitat; Owner: iepnb
--

ALTER TABLE ONLY habitat.habitat
    ADD CONSTRAINT "PK_HABITAT" PRIMARY KEY (id_ieh);


--
-- Name: habitat_region_biogeografica PK_HABITAT_REGIONBIO; Type: CONSTRAINT; Schema: habitat; Owner: iepnb
--

ALTER TABLE ONLY habitat.habitat_region_biogeografica
    ADD CONSTRAINT "PK_HABITAT_REGIONBIO" PRIMARY KEY (id_ieh, id_region_biogeografica);


--
-- Name: lc_colecciones PK_LC_COLECCION; Type: CONSTRAINT; Schema: habitat; Owner: iepnb
--

ALTER TABLE ONLY habitat.lc_colecciones
    ADD CONSTRAINT "PK_LC_COLECCION" PRIMARY KEY (id_coleccion);


--
-- Name: entidad_ejecutora TSEG_ENTIDAD_EJECUTORA_PK; Type: CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.entidad_ejecutora
    ADD CONSTRAINT "TSEG_ENTIDAD_EJECUTORA_PK" PRIMARY KEY (id_entidad_ejecutora);


--
-- Name: evento TSEG_EVENTO_PK; Type: CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.evento
    ADD CONSTRAINT "TSEG_EVENTO_PK" PRIMARY KEY (id_evento);


--
-- Name: evento_programa TSEG_EVENTO_PROGRAMA_PK; Type: CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.evento_programa
    ADD CONSTRAINT "TSEG_EVENTO_PROGRAMA_PK" PRIMARY KEY (id_evento_programa);


--
-- Name: evento_tipo_medicion TSEG_EVENTO_TIPO_MEDICION_PK; Type: CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.evento_tipo_medicion
    ADD CONSTRAINT "TSEG_EVENTO_TIPO_MEDICION_PK" PRIMARY KEY (id_evento_programa, id_tipo_medicion);


--
-- Name: evento_medicion TSEG_EVENTO_TIPO_MEDICION_PK_1; Type: CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.evento_medicion
    ADD CONSTRAINT "TSEG_EVENTO_TIPO_MEDICION_PK_1" PRIMARY KEY (id_evento_programa, id_tipo_medicion);


--
-- Name: t_gis_linea TSEG_GIS_LINEA_PK_1; Type: CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.t_gis_linea
    ADD CONSTRAINT "TSEG_GIS_LINEA_PK_1" PRIMARY KEY (id_gis_linea);


--
-- Name: gis_medicion_linea TSEG_GIS_MEDICION_LINEA_PK; Type: CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.gis_medicion_linea
    ADD CONSTRAINT "TSEG_GIS_MEDICION_LINEA_PK" PRIMARY KEY (id_gis_medicion_linea);


--
-- Name: gis_medicion_poligon TSEG_GIS_MEDICION_POLIGON_PK; Type: CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.gis_medicion_poligon
    ADD CONSTRAINT "TSEG_GIS_MEDICION_POLIGON_PK" PRIMARY KEY (id_gis_medicion_poligono);


--
-- Name: gis_medicion_punto TSEG_GIS_MEDICION_PUNTO_PK; Type: CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.gis_medicion_punto
    ADD CONSTRAINT "TSEG_GIS_MEDICION_PUNTO_PK" PRIMARY KEY (id_gis_medicion_punto);


--
-- Name: t_gis_poligon TSEG_GIS_POLIGON_PK_1; Type: CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.t_gis_poligon
    ADD CONSTRAINT "TSEG_GIS_POLIGON_PK_1" PRIMARY KEY (id_gis_poligon);


--
-- Name: t_gis_punto TSEG_GIS_PUNTO_PK_1; Type: CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.t_gis_punto
    ADD CONSTRAINT "TSEG_GIS_PUNTO_PK_1" PRIMARY KEY (id_punto);


--
-- Name: ocurrencia_medicion TSEG_OCURRENCIA_MEDICION_PK; Type: CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.ocurrencia_medicion
    ADD CONSTRAINT "TSEG_OCURRENCIA_MEDICION_PK" PRIMARY KEY (cod_ocurrencia, id_tipo_medicion);


--
-- Name: ocurrencia_muestra TSEG_OCURRENCIA_MUESTRA_pkey; Type: CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.ocurrencia_muestra
    ADD CONSTRAINT "TSEG_OCURRENCIA_MUESTRA_pkey" PRIMARY KEY (cod_muestra);


--
-- Name: ocurrencia TSEG_OCURRENCIA_PK; Type: CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.ocurrencia
    ADD CONSTRAINT "TSEG_OCURRENCIA_PK" PRIMARY KEY (cod_ocurrencia);


--
-- Name: programa TSEG_PROGRAMA_PK; Type: CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.programa
    ADD CONSTRAINT "TSEG_PROGRAMA_PK" PRIMARY KEY (id_programa);


--
-- Name: programa_entidad_ejecutora TSEG_PROGRAM_ENTID_EJECUTO_PK; Type: CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.programa_entidad_ejecutora
    ADD CONSTRAINT "TSEG_PROGRAM_ENTID_EJECUTO_PK" PRIMARY KEY (id_entidad_ejecutora, id_programa);


--
-- Name: rango_valor TSEG_RANGO_VALOR_PK; Type: CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.rango_valor
    ADD CONSTRAINT "TSEG_RANGO_VALOR_PK" PRIMARY KEY (id_rango_valor);


--
-- Name: equipo_personas equipo_personas_pk; Type: CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.equipo_personas
    ADD CONSTRAINT equipo_personas_pk PRIMARY KEY (id_equipo, id_persona_ejecutora);


--
-- Name: especimen_foto especimen_foto_pkey; Type: CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.especimen_foto
    ADD CONSTRAINT especimen_foto_pkey PRIMARY KEY (id_especimen, id_foto);


--
-- Name: evento_especificacion evento_especificacion_pkey; Type: CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.evento_especificacion
    ADD CONSTRAINT evento_especificacion_pkey PRIMARY KEY (id_evento_programa, id_especificacion);


--
-- Name: evento_foto evento_foto_pk; Type: CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.evento_foto
    ADD CONSTRAINT evento_foto_pk PRIMARY KEY (id_evento, id_foto);


--
-- Name: evento_tipo_especificacion evento_tipo_especificacion_pkey; Type: CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.evento_tipo_especificacion
    ADD CONSTRAINT evento_tipo_especificacion_pkey PRIMARY KEY (id_evento_programa, id_especificacion);


--
-- Name: evento_valor_texto evento_valortexto_pk; Type: CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.evento_valor_texto
    ADD CONSTRAINT evento_valortexto_pk PRIMARY KEY (id_evento, id_evento_valortexto);


--
-- Name: foto foto_pk; Type: CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.foto
    ADD CONSTRAINT foto_pk PRIMARY KEY (id_foto);


--
-- Name: laboratorio laboratorio_pk; Type: CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.laboratorio
    ADD CONSTRAINT laboratorio_pk PRIMARY KEY (id_laboratorio);


--
-- Name: muestra_laboratorio muestra_laboratorio_pkey; Type: CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.muestra_laboratorio
    ADD CONSTRAINT muestra_laboratorio_pkey PRIMARY KEY (cod_muestra, id_laboratorio);


--
-- Name: muestra_taxon muestra_taxon_pk; Type: CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.muestra_taxon
    ADD CONSTRAINT muestra_taxon_pk PRIMARY KEY (cod_muestra, id_taxon);


--
-- Name: ocurrencia_especificacion ocurrencia_especificacion_pkey; Type: CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.ocurrencia_especificacion
    ADD CONSTRAINT ocurrencia_especificacion_pkey PRIMARY KEY (cod_ocurrencia, id_especificacion);


--
-- Name: ocurrencia_foto ocurrencia_foto_pkey; Type: CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.ocurrencia_foto
    ADD CONSTRAINT ocurrencia_foto_pkey PRIMARY KEY (cod_ocurrencia, id_foto);


--
-- Name: ocurrencia_valor_texto ocurrencia_valor_texto_pk; Type: CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.ocurrencia_valor_texto
    ADD CONSTRAINT ocurrencia_valor_texto_pk PRIMARY KEY (id_ocurrencia_valor_texto);


--
-- Name: t_contenido_foto t_contenido_foto_pk; Type: CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.t_contenido_foto
    ADD CONSTRAINT t_contenido_foto_pk PRIMARY KEY (id_contenido_foto);


--
-- Name: t_equipo_ejecutor t_equipo_ejecutor_pk; Type: CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.t_equipo_ejecutor
    ADD CONSTRAINT t_equipo_ejecutor_pk PRIMARY KEY (id_equipo);


--
-- Name: t_persona_ejecutora t_persona_ejecutora_pk; Type: CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.t_persona_ejecutora
    ADD CONSTRAINT t_persona_ejecutora_pk PRIMARY KEY (id_persona_ejecutora);


--
-- Name: t_tipo_identificacion_especimen t_tipo_identificacion_especimen_pk; Type: CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.t_tipo_identificacion_especimen
    ADD CONSTRAINT t_tipo_identificacion_especimen_pk PRIMARY KEY ("id_tipo_identificación_especimen");


--
-- Name: t_tipo_medicion_darwincore t_tipo_medicion_darwincore_pk; Type: CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.t_tipo_medicion_darwincore
    ADD CONSTRAINT t_tipo_medicion_darwincore_pk PRIMARY KEY (id_tipo_medicion_darwincore);


--
-- Name: t_tipo_muestreo t_tipo_muestreo_pk; Type: CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.t_tipo_muestreo
    ADD CONSTRAINT t_tipo_muestreo_pk PRIMARY KEY (id_tipo_muestreo);


--
-- Name: t_tipo_persona_ejecutora t_tipo_persona_ejecutora_pk; Type: CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.t_tipo_persona_ejecutora
    ADD CONSTRAINT t_tipo_persona_ejecutora_pk PRIMARY KEY (id_tipo_persona);


--
-- Name: t_valor_texto_otra_codif_seguimiento t_valor_texto_otra_codif_pkey; Type: CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.t_valor_texto_otra_codif_seguimiento
    ADD CONSTRAINT t_valor_texto_otra_codif_pkey PRIMARY KEY (id_valor_texto, id_tipo_medicion);


--
-- Name: evento_medicion_multiple tseg_evento_medmultiple_pk; Type: CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.evento_medicion_multiple
    ADD CONSTRAINT tseg_evento_medmultiple_pk PRIMARY KEY (id);


--
-- Name: muestra_medicion tseg_muestra_medicion_pk; Type: CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.muestra_medicion
    ADD CONSTRAINT tseg_muestra_medicion_pk PRIMARY KEY (cod_muestra, id_tipo_medicion);


--
-- Name: ocurrencia_medicion_multiple tseg_ocurrencia_medmultiple_pk; Type: CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.ocurrencia_medicion_multiple
    ADD CONSTRAINT tseg_ocurrencia_medmultiple_pk PRIMARY KEY (id);


--
-- Name: especimen_medicion tsegespciemen_medicion_pk; Type: CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.especimen_medicion
    ADD CONSTRAINT tsegespciemen_medicion_pk PRIMARY KEY (id_especimen, id_tipo_medicion);


--
-- Name: INDEX_TIEP_LC_TIPONORMA; Type: INDEX; Schema: comun; Owner: iepnb
--

CREATE UNIQUE INDEX "INDEX_TIEP_LC_TIPONORMA" ON comun.t_tipo_norma USING btree (id_tiponorma);


--
-- Name: INDEX_TIEP_LC_TIPOPROPIEDAD; Type: INDEX; Schema: comun; Owner: iepnb
--

CREATE UNIQUE INDEX "INDEX_TIEP_LC_TIPOPROPIEDAD" ON comun.t_tipopropiedad USING btree (id_tipopropiedad);


--
-- Name: INDEX_T_AMBITOGEOGRAFICO; Type: INDEX; Schema: comun; Owner: iepnb
--

CREATE UNIQUE INDEX "INDEX_T_AMBITOGEOGRAFICO" ON comun.t_ambito_nivel_geografico_politico USING btree (id_ambito_nivel_geografico_politico);


--
-- Name: INDEX_T_AMBITO_GEOGRAFICO; Type: INDEX; Schema: comun; Owner: iepnb
--

CREATE UNIQUE INDEX "INDEX_T_AMBITO_GEOGRAFICO" ON comun.t_ambito_nivel_geografico_politico USING btree (id_ambito_nivel_geografico_politico);


--
-- Name: INDEX_T_COMU_RELACION; Type: INDEX; Schema: comun; Owner: iepnb
--

CREATE UNIQUE INDEX "INDEX_T_COMU_RELACION" ON comun.t_relacion_espacial USING btree (id_relacion);


--
-- Name: INDEX_T_MEDIDA_NORMA; Type: INDEX; Schema: comun; Owner: iepnb
--

CREATE UNIQUE INDEX "INDEX_T_MEDIDA_NORMA" ON comun.medida_conservacion_norma USING btree (id_medida, id_norma);


--
-- Name: INDEX_T_NUTS2; Type: INDEX; Schema: comun; Owner: iepnb
--

CREATE UNIQUE INDEX "INDEX_T_NUTS2" ON comun.t_ccaa USING btree (id_ccaa);


--
-- Name: INDEX_T_NUTS2_1; Type: INDEX; Schema: comun; Owner: iepnb
--

CREATE UNIQUE INDEX "INDEX_T_NUTS2_1" ON comun.t_nut USING btree (id_ccaa);


--
-- Name: INDEX_T_UNIDAD; Type: INDEX; Schema: comun; Owner: iepnb
--

CREATE UNIQUE INDEX "INDEX_T_UNIDAD" ON comun.t_unidad USING btree (id_unidad);


--
-- Name: INDEX_T_UNIDAD_TIPO_MEDIDA; Type: INDEX; Schema: comun; Owner: iepnb
--

CREATE UNIQUE INDEX "INDEX_T_UNIDAD_TIPO_MEDIDA" ON comun.unidad_tipo_medicion USING btree (id_unidad, id_tipo_medicion);


--
-- Name: IND_APLICACION; Type: INDEX; Schema: comun; Owner: iepnb
--

CREATE UNIQUE INDEX "IND_APLICACION" ON comun.t_aplicacion USING btree (id_aplicacion);


--
-- Name: IND_USUARIO; Type: INDEX; Schema: comun; Owner: iepnb
--

CREATE UNIQUE INDEX "IND_USUARIO" ON comun.t_usuario USING btree (id_usuario, id_usuario);


--
-- Name: T_COMPONENTES_PK; Type: INDEX; Schema: comun; Owner: iepnb
--

CREATE UNIQUE INDEX "T_COMPONENTES_PK" ON comun.t_componente USING btree (id_componente, id_componente);


--
-- Name: fki_FK_TRN_ORG_TO_NUT2; Type: INDEX; Schema: comun; Owner: iepnb
--

CREATE INDEX "fki_FK_TRN_ORG_TO_NUT2" ON comun.organismo_aplicacion USING btree (ccaa);


--
-- Name: fki_FK_T_NORMA; Type: INDEX; Schema: comun; Owner: iepnb
--

CREATE INDEX "fki_FK_T_NORMA" ON comun.norma_norma USING btree (id_norma);


--
-- Name: fki_FK_T_ORGANISMO_PROVINCIA; Type: INDEX; Schema: comun; Owner: iepnb
--

CREATE INDEX "fki_FK_T_ORGANISMO_PROVINCIA" ON comun.organismo_provincia USING btree (id_provincia);


--
-- Name: fki_FK_T_ORGANISMO_PROVINCIA_ID_ORGANISMO; Type: INDEX; Schema: comun; Owner: iepnb
--

CREATE INDEX "fki_FK_T_ORGANISMO_PROVINCIA_ID_ORGANISMO" ON comun.organismo_provincia USING btree (id_organismo);


--
-- Name: fki_FK_T_PROVINCIAS_ID_CCAA; Type: INDEX; Schema: comun; Owner: iepnb
--

CREATE INDEX "fki_FK_T_PROVINCIAS_ID_CCAA" ON comun.t_provincia USING btree (id_ccaa);


--
-- Name: fki_ORG_APL1I_FK; Type: INDEX; Schema: comun; Owner: iepnb
--

CREATE INDEX "fki_ORG_APL1I_FK" ON comun.organismo_organismo USING btree (id_aplicacion DESC);


--
-- Name: fki_ORG_APLI_FK; Type: INDEX; Schema: comun; Owner: iepnb
--

CREATE INDEX "fki_ORG_APLI_FK" ON comun.organismo_organismo USING btree (id_aplicacion);


--
-- Name: fki_T_MEDIDA_FK1; Type: INDEX; Schema: comun; Owner: iepnb
--

CREATE INDEX "fki_T_MEDIDA_FK1" ON comun.t_medida_conserva_gestion USING btree (id_aplicacion_origen);


--
-- Name: fki_T_NORMA_APLICACION_FK; Type: INDEX; Schema: comun; Owner: iepnb
--

CREATE INDEX "fki_T_NORMA_APLICACION_FK" ON comun.t_norma USING btree (id_aplicacion);


--
-- Name: fki_T_UNIDAD_TIPO_MEDIDA_FK2; Type: INDEX; Schema: comun; Owner: iepnb
--

CREATE INDEX "fki_T_UNIDAD_TIPO_MEDIDA_FK2" ON comun.unidad_tipo_medicion USING btree (id_tipo_medicion);


--
-- Name: INDEX_AMBITOGEOGRAFICO; Type: INDEX; Schema: especie; Owner: iepnb
--

CREATE UNIQUE INDEX "INDEX_AMBITOGEOGRAFICO" ON especie.t_ambito_es USING btree (id_ambito_es);


--
-- Name: nombrecodigosexternos_codigo_idx; Type: INDEX; Schema: especie; Owner: iepnb
--

CREATE INDEX nombrecodigosexternos_codigo_idx ON especie.nombrecodigosexternos USING btree (codigo);


--
-- Name: INDEX_IEH_INVESPHABITAT; Type: INDEX; Schema: habitat; Owner: iepnb
--

CREATE UNIQUE INDEX "INDEX_IEH_INVESPHABITAT" ON habitat.habitat USING btree (id_ieh);


--
-- Name: INDEX_LC_COLECCION; Type: INDEX; Schema: habitat; Owner: iepnb
--

CREATE UNIQUE INDEX "INDEX_LC_COLECCION" ON habitat.lc_colecciones USING btree (id_coleccion);


--
-- Name: norma_norma FK2_T_NORMA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.norma_norma
    ADD CONSTRAINT "FK2_T_NORMA" FOREIGN KEY (id_norma_2) REFERENCES comun.t_norma(id_norma);


--
-- Name: t_provincia FK_CCAA_PROVINCIA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_provincia
    ADD CONSTRAINT "FK_CCAA_PROVINCIA" FOREIGN KEY (id_ccaa) REFERENCES comun.t_ccaa(id_ccaa) NOT VALID;


--
-- Name: especimen FK_ESPECIMEN_ID_MADRE; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.especimen
    ADD CONSTRAINT "FK_ESPECIMEN_ID_MADRE" FOREIGN KEY (id_especimen) REFERENCES comun.especimen(id_especimen);


--
-- Name: especimen FK_ESPECIMEN_ID_PADRE; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.especimen
    ADD CONSTRAINT "FK_ESPECIMEN_ID_PADRE" FOREIGN KEY (id_especimen) REFERENCES comun.especimen(id_especimen);


--
-- Name: especimen FK_ESPECIMEN_ID_TAXON; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.especimen
    ADD CONSTRAINT "FK_ESPECIMEN_ID_TAXON" FOREIGN KEY (id_taxon) REFERENCES especie.taxon(idtaxon);


--
-- Name: especimen FK_ESPECIMEN_SEXO; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.especimen
    ADD CONSTRAINT "FK_ESPECIMEN_SEXO" FOREIGN KEY (id_sexo) REFERENCES comun.t_sexo(id_sexo);


--
-- Name: especimen FK_ESPECIMEN_T_APLICACION; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.especimen
    ADD CONSTRAINT "FK_ESPECIMEN_T_APLICACION" FOREIGN KEY (id_aplicacion) REFERENCES comun.t_aplicacion(id_aplicacion);


--
-- Name: t_estado_conserva_otras_codif FK_ESTAS_CONSRVA_OTRA_COD_APLICACIN; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_estado_conserva_otras_codif
    ADD CONSTRAINT "FK_ESTAS_CONSRVA_OTRA_COD_APLICACIN" FOREIGN KEY (id_aplicacion) REFERENCES comun.t_aplicacion(id_aplicacion) NOT VALID;


--
-- Name: t_estado_conserva_otras_codif FK_ESTD_CONSERVA_OTRA_CODTIPO_ESTA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_estado_conserva_otras_codif
    ADD CONSTRAINT "FK_ESTD_CONSERVA_OTRA_CODTIPO_ESTA" FOREIGN KEY (id_estado_conserva) REFERENCES comun.t_tipo_estado_conservacion(id_tipo_conservacion) NOT VALID;


--
-- Name: t_presion_amenaza FK_PRES_ID_PADRE; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_presion_amenaza
    ADD CONSTRAINT "FK_PRES_ID_PADRE" FOREIGN KEY (id_padre) REFERENCES comun.t_presion_amenaza(id_presion);


--
-- Name: t_municipio FK_PROVINCIA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_municipio
    ADD CONSTRAINT "FK_PROVINCIA" FOREIGN KEY (id_provincia) REFERENCES comun.t_provincia(id_provincia) NOT VALID;


--
-- Name: t_rango_norma_inf FK_RANGO_INT; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_rango_norma_inf
    ADD CONSTRAINT "FK_RANGO_INT" FOREIGN KEY (id_rango_int) REFERENCES comun.t_rango_norma_int(id_rango_norma);


--
-- Name: t_rango_norma_inf FK_RANGO_SUP; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_rango_norma_inf
    ADD CONSTRAINT "FK_RANGO_SUP" FOREIGN KEY (id_rango_sup) REFERENCES comun.t_rango_norma_sup(id_rango_norma);


--
-- Name: t_rango_norma_int FK_RANGO_SUPER; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_rango_norma_int
    ADD CONSTRAINT "FK_RANGO_SUPER" FOREIGN KEY (id_rango_sup) REFERENCES comun.t_rango_norma_sup(id_rango_norma);


--
-- Name: organismo_aplicacion FK_TO_APP; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.organismo_aplicacion
    ADD CONSTRAINT "FK_TO_APP" FOREIGN KEY (id_aplicacion) REFERENCES comun.t_aplicacion(id_aplicacion);


--
-- Name: organismo_organismo FK_TO_ORG; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.organismo_organismo
    ADD CONSTRAINT "FK_TO_ORG" FOREIGN KEY (id_organismo) REFERENCES comun.t_organismo(id_organismo);


--
-- Name: organismo_organismo FK_TO_ORG2; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.organismo_organismo
    ADD CONSTRAINT "FK_TO_ORG2" FOREIGN KEY (id_organismo2) REFERENCES comun.t_organismo(id_organismo);


--
-- Name: organismo_aplicacion FK_TRN_ORG_TO_NUT2; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.organismo_aplicacion
    ADD CONSTRAINT "FK_TRN_ORG_TO_NUT2" FOREIGN KEY (ccaa) REFERENCES comun.t_ccaa(id_ccaa);


--
-- Name: grupo_taxon_eidos_otros FK_T_GRUPO_TAXON_EIDOS_OTROS; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.grupo_taxon_eidos_otros
    ADD CONSTRAINT "FK_T_GRUPO_TAXON_EIDOS_OTROS" FOREIGN KEY (id_grupo_taxon) REFERENCES comun.t_grupo_taxonomico(id_grupo_taxon);


--
-- Name: norma_norma FK_T_NORMA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.norma_norma
    ADD CONSTRAINT "FK_T_NORMA" FOREIGN KEY (id_norma) REFERENCES comun.t_norma(id_norma);


--
-- Name: organismo_provincia FK_T_ORGANISMO_PROVINCIA_ID_ORGANISMO; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.organismo_provincia
    ADD CONSTRAINT "FK_T_ORGANISMO_PROVINCIA_ID_ORGANISMO" FOREIGN KEY (id_organismo) REFERENCES comun.t_organismo(id_organismo);


--
-- Name: organismo_provincia FK_T_ORGANISMO_PROVINCIA_ID_PROVINCIA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.organismo_provincia
    ADD CONSTRAINT "FK_T_ORGANISMO_PROVINCIA_ID_PROVINCIA" FOREIGN KEY (id_provincia) REFERENCES comun.t_provincia(id_provincia);


--
-- Name: norma_norma FK_T_TIPO_NORMA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.norma_norma
    ADD CONSTRAINT "FK_T_TIPO_NORMA" FOREIGN KEY (id_tipo_relacion_norma) REFERENCES comun.t_tipo_relacion_norma(id_tipo_relacion_norma);


--
-- Name: t_usuario FK_T_USUARIO_T_ORGANISMO; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_usuario
    ADD CONSTRAINT "FK_T_USUARIO_T_ORGANISMO" FOREIGN KEY (id_organismo) REFERENCES comun.t_organismo(id_organismo);


--
-- Name: t_unidad_otra_codif FK_UNIDAD_APLICACION; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_unidad_otra_codif
    ADD CONSTRAINT "FK_UNIDAD_APLICACION" FOREIGN KEY (id_aplicacion) REFERENCES comun.t_aplicacion(id_aplicacion) NOT VALID;


--
-- Name: t_unidad_otra_codif FK_UNIDAD_OTRA_UNIDAD; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_unidad_otra_codif
    ADD CONSTRAINT "FK_UNIDAD_OTRA_UNIDAD" FOREIGN KEY (id_unidad) REFERENCES comun.t_unidad(id_unidad) NOT VALID;


--
-- Name: unidad_tipo_medicion FK_UNIDAD_TIPO_MEDICION_T_APLICACION; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.unidad_tipo_medicion
    ADD CONSTRAINT "FK_UNIDAD_TIPO_MEDICION_T_APLICACION" FOREIGN KEY (id_aplicacion) REFERENCES comun.t_aplicacion(id_aplicacion) NOT VALID;


--
-- Name: unidad_tipo_medicion FK_UNIDA_TIPO_MED_MED; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.unidad_tipo_medicion
    ADD CONSTRAINT "FK_UNIDA_TIPO_MED_MED" FOREIGN KEY (id_tipo_medicion) REFERENCES comun.t_tipo_medicion(id_tipo_medicion) NOT VALID;


--
-- Name: t_norma FK_USUARIO_CREA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_norma
    ADD CONSTRAINT "FK_USUARIO_CREA" FOREIGN KEY (id_usuario_crea_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: t_municipio FK_USUARIO_CREA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_municipio
    ADD CONSTRAINT "FK_USUARIO_CREA" FOREIGN KEY (id_usuario_crea_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: t_presion_amenaza FK_USUARIO_CREA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_presion_amenaza
    ADD CONSTRAINT "FK_USUARIO_CREA" FOREIGN KEY (id_usuario_crea_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: organismo_aplicacion FK_USUARIO_CREA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.organismo_aplicacion
    ADD CONSTRAINT "FK_USUARIO_CREA" FOREIGN KEY (id_usuario_crea_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: t_organismo FK_USUARIO_CREA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_organismo
    ADD CONSTRAINT "FK_USUARIO_CREA" FOREIGN KEY (id_usuario_crea_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: t_usuario FK_USUARIO_CREA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_usuario
    ADD CONSTRAINT "FK_USUARIO_CREA" FOREIGN KEY (id_usuario_crea_registro) REFERENCES comun.t_usuario(id_usuario);


--
-- Name: norma_tema FK_USUARIO_CREA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.norma_tema
    ADD CONSTRAINT "FK_USUARIO_CREA" FOREIGN KEY (id_usuario_crea_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: t_componente FK_USUARIO_CREA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_componente
    ADD CONSTRAINT "FK_USUARIO_CREA" FOREIGN KEY (id_usuario_crea_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: t_unidad FK_USUARIO_CREA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_unidad
    ADD CONSTRAINT "FK_USUARIO_CREA" FOREIGN KEY (id_usuario_crea_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: t_provincia FK_USUARIO_CREA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_provincia
    ADD CONSTRAINT "FK_USUARIO_CREA" FOREIGN KEY (id_usuario_crea_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: t_medida_conserva_gestion FK_USUARIO_CREA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_medida_conserva_gestion
    ADD CONSTRAINT "FK_USUARIO_CREA" FOREIGN KEY (id_usuario_crea_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: t_aplicacion FK_USUARIO_CREA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_aplicacion
    ADD CONSTRAINT "FK_USUARIO_CREA" FOREIGN KEY (id_usuario_crea_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: t_rango_norma_sup FK_USUARIO_CREA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_rango_norma_sup
    ADD CONSTRAINT "FK_USUARIO_CREA" FOREIGN KEY (id_usuario_crea_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: t_ccaa FK_USUARIO_CREA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_ccaa
    ADD CONSTRAINT "FK_USUARIO_CREA" FOREIGN KEY (id_usuario_crea_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: t_tipo_norma FK_USUARIO_CREA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_tipo_norma
    ADD CONSTRAINT "FK_USUARIO_CREA" FOREIGN KEY (id_usuario_crea_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: t_perfil FK_USUARIO_CREA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_perfil
    ADD CONSTRAINT "FK_USUARIO_CREA" FOREIGN KEY (id_usuario_crea_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: t_nombre_grupo_taxonomico FK_USUARIO_CREA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_nombre_grupo_taxonomico
    ADD CONSTRAINT "FK_USUARIO_CREA" FOREIGN KEY (id_usuario_crea_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: t_rango_norma_inf FK_USUARIO_CREA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_rango_norma_inf
    ADD CONSTRAINT "FK_USUARIO_CREA" FOREIGN KEY (id_usuario_crea_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: t_contaminante FK_USUARIO_CREA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_contaminante
    ADD CONSTRAINT "FK_USUARIO_CREA" FOREIGN KEY (id_usuario_crea_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: t_rango_norma_int FK_USUARIO_CREA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_rango_norma_int
    ADD CONSTRAINT "FK_USUARIO_CREA" FOREIGN KEY (id_usuario_crea_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: t_unidad_otra_codif FK_USUARIO_CREA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_unidad_otra_codif
    ADD CONSTRAINT "FK_USUARIO_CREA" FOREIGN KEY (id_usuario_crea_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: medida_conservacion_norma FK_USUARIO_CREA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.medida_conservacion_norma
    ADD CONSTRAINT "FK_USUARIO_CREA" FOREIGN KEY (id_usuario_crea_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: organismo_organismo FK_USUARIO_CREA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.organismo_organismo
    ADD CONSTRAINT "FK_USUARIO_CREA" FOREIGN KEY (id_usuario_crea_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: t_tema FK_USUARIO_CREA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_tema
    ADD CONSTRAINT "FK_USUARIO_CREA" FOREIGN KEY (id_usuario_crea_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: unidad_tipo_medicion FK_USUARIO_CREA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.unidad_tipo_medicion
    ADD CONSTRAINT "FK_USUARIO_CREA" FOREIGN KEY (id_usuario_crea_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: t_grupo_taxonomico FK_USUARIO_CREA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_grupo_taxonomico
    ADD CONSTRAINT "FK_USUARIO_CREA" FOREIGN KEY (id_usuario_crea_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: t_region_biogeografica FK_USUARIO_CREA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_region_biogeografica
    ADD CONSTRAINT "FK_USUARIO_CREA" FOREIGN KEY (id_usuario_crea_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: t_impacto FK_USUARIO_CREA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_impacto
    ADD CONSTRAINT "FK_USUARIO_CREA" FOREIGN KEY (id_usuario_crea_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: t_relacion_espacial FK_USUARIO_CREA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_relacion_espacial
    ADD CONSTRAINT "FK_USUARIO_CREA" FOREIGN KEY (id_usuario_crea_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: t_ambito FK_USUARIO_CREA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_ambito
    ADD CONSTRAINT "FK_USUARIO_CREA" FOREIGN KEY (id_usuario_crea_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: t_tipo_relacion_norma FK_USUARIO_CREA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_tipo_relacion_norma
    ADD CONSTRAINT "FK_USUARIO_CREA" FOREIGN KEY (id_usuario_crea_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: t_ambito_nivel_geografico_politico FK_USUARIO_CREA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_ambito_nivel_geografico_politico
    ADD CONSTRAINT "FK_USUARIO_CREA" FOREIGN KEY (id_usuario_crea_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: coleccion_medida FK_USUARIO_CREA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.coleccion_medida
    ADD CONSTRAINT "FK_USUARIO_CREA" FOREIGN KEY (id_usuario_crea_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: norma_componente FK_USUARIO_CREA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.norma_componente
    ADD CONSTRAINT "FK_USUARIO_CREA" FOREIGN KEY (id_usuario_crea_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: norma_norma FK_USUARIO_CREA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.norma_norma
    ADD CONSTRAINT "FK_USUARIO_CREA" FOREIGN KEY (id_usuario_crea_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: organismo_provincia FK_USUARIO_CREA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.organismo_provincia
    ADD CONSTRAINT "FK_USUARIO_CREA" FOREIGN KEY (id_usuario_crea_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: t_tipopropiedad FK_USUARIO_CREA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_tipopropiedad
    ADD CONSTRAINT "FK_USUARIO_CREA" FOREIGN KEY (id_usuario_crea_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: t_norma FK_USUARIO_MODIFICA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_norma
    ADD CONSTRAINT "FK_USUARIO_MODIFICA" FOREIGN KEY (id_usuario_modifica_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: t_municipio FK_USUARIO_MODIFICA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_municipio
    ADD CONSTRAINT "FK_USUARIO_MODIFICA" FOREIGN KEY (id_usuario_modifica_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: t_presion_amenaza FK_USUARIO_MODIFICA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_presion_amenaza
    ADD CONSTRAINT "FK_USUARIO_MODIFICA" FOREIGN KEY (id_usuario_modifica_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: organismo_aplicacion FK_USUARIO_MODIFICA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.organismo_aplicacion
    ADD CONSTRAINT "FK_USUARIO_MODIFICA" FOREIGN KEY (id_usuario_modifica_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: t_organismo FK_USUARIO_MODIFICA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_organismo
    ADD CONSTRAINT "FK_USUARIO_MODIFICA" FOREIGN KEY (id_usuario_modifica_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: t_usuario FK_USUARIO_MODIFICA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_usuario
    ADD CONSTRAINT "FK_USUARIO_MODIFICA" FOREIGN KEY (id_usuario_modifica_registro) REFERENCES comun.t_usuario(id_usuario);


--
-- Name: norma_tema FK_USUARIO_MODIFICA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.norma_tema
    ADD CONSTRAINT "FK_USUARIO_MODIFICA" FOREIGN KEY (id_usuario_modifica_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: t_componente FK_USUARIO_MODIFICA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_componente
    ADD CONSTRAINT "FK_USUARIO_MODIFICA" FOREIGN KEY (id_usuario_modifica_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: t_unidad FK_USUARIO_MODIFICA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_unidad
    ADD CONSTRAINT "FK_USUARIO_MODIFICA" FOREIGN KEY (id_usuario_modifica_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: t_provincia FK_USUARIO_MODIFICA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_provincia
    ADD CONSTRAINT "FK_USUARIO_MODIFICA" FOREIGN KEY (id_usuario_modifica_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: t_medida_conserva_gestion FK_USUARIO_MODIFICA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_medida_conserva_gestion
    ADD CONSTRAINT "FK_USUARIO_MODIFICA" FOREIGN KEY (id_usuario_modifica_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: t_aplicacion FK_USUARIO_MODIFICA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_aplicacion
    ADD CONSTRAINT "FK_USUARIO_MODIFICA" FOREIGN KEY (id_usuario_modifica_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: t_rango_norma_sup FK_USUARIO_MODIFICA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_rango_norma_sup
    ADD CONSTRAINT "FK_USUARIO_MODIFICA" FOREIGN KEY (id_usuario_modifica_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: t_ccaa FK_USUARIO_MODIFICA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_ccaa
    ADD CONSTRAINT "FK_USUARIO_MODIFICA" FOREIGN KEY (id_usuario_modifica_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: t_tipo_norma FK_USUARIO_MODIFICA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_tipo_norma
    ADD CONSTRAINT "FK_USUARIO_MODIFICA" FOREIGN KEY (id_usuario_modifica_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: t_perfil FK_USUARIO_MODIFICA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_perfil
    ADD CONSTRAINT "FK_USUARIO_MODIFICA" FOREIGN KEY (id_usuario_modifica_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: t_nombre_grupo_taxonomico FK_USUARIO_MODIFICA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_nombre_grupo_taxonomico
    ADD CONSTRAINT "FK_USUARIO_MODIFICA" FOREIGN KEY (id_usuario_modifica_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: t_rango_norma_inf FK_USUARIO_MODIFICA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_rango_norma_inf
    ADD CONSTRAINT "FK_USUARIO_MODIFICA" FOREIGN KEY (id_usuario_modifica_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: t_contaminante FK_USUARIO_MODIFICA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_contaminante
    ADD CONSTRAINT "FK_USUARIO_MODIFICA" FOREIGN KEY (id_usuario_modifica_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: t_rango_norma_int FK_USUARIO_MODIFICA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_rango_norma_int
    ADD CONSTRAINT "FK_USUARIO_MODIFICA" FOREIGN KEY (id_usuario_modifica_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: t_unidad_otra_codif FK_USUARIO_MODIFICA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_unidad_otra_codif
    ADD CONSTRAINT "FK_USUARIO_MODIFICA" FOREIGN KEY (id_usuario_modifica_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: medida_conservacion_norma FK_USUARIO_MODIFICA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.medida_conservacion_norma
    ADD CONSTRAINT "FK_USUARIO_MODIFICA" FOREIGN KEY (id_usuario_modifica_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: organismo_organismo FK_USUARIO_MODIFICA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.organismo_organismo
    ADD CONSTRAINT "FK_USUARIO_MODIFICA" FOREIGN KEY (id_usuario_modifica_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: t_tema FK_USUARIO_MODIFICA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_tema
    ADD CONSTRAINT "FK_USUARIO_MODIFICA" FOREIGN KEY (id_usuario_modifica_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: unidad_tipo_medicion FK_USUARIO_MODIFICA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.unidad_tipo_medicion
    ADD CONSTRAINT "FK_USUARIO_MODIFICA" FOREIGN KEY (id_usuario_modifica_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: t_grupo_taxonomico FK_USUARIO_MODIFICA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_grupo_taxonomico
    ADD CONSTRAINT "FK_USUARIO_MODIFICA" FOREIGN KEY (id_usuario_modifica_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: t_region_biogeografica FK_USUARIO_MODIFICA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_region_biogeografica
    ADD CONSTRAINT "FK_USUARIO_MODIFICA" FOREIGN KEY (id_usuario_modifica_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: t_impacto FK_USUARIO_MODIFICA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_impacto
    ADD CONSTRAINT "FK_USUARIO_MODIFICA" FOREIGN KEY (id_usuario_modifica_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: t_relacion_espacial FK_USUARIO_MODIFICA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_relacion_espacial
    ADD CONSTRAINT "FK_USUARIO_MODIFICA" FOREIGN KEY (id_usuario_modifica_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: t_ambito FK_USUARIO_MODIFICA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_ambito
    ADD CONSTRAINT "FK_USUARIO_MODIFICA" FOREIGN KEY (id_usuario_modifica_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: t_tipo_relacion_norma FK_USUARIO_MODIFICA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_tipo_relacion_norma
    ADD CONSTRAINT "FK_USUARIO_MODIFICA" FOREIGN KEY (id_usuario_modifica_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: t_ambito_nivel_geografico_politico FK_USUARIO_MODIFICA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_ambito_nivel_geografico_politico
    ADD CONSTRAINT "FK_USUARIO_MODIFICA" FOREIGN KEY (id_usuario_modifica_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: coleccion_medida FK_USUARIO_MODIFICA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.coleccion_medida
    ADD CONSTRAINT "FK_USUARIO_MODIFICA" FOREIGN KEY (id_usuario_modifica_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: norma_componente FK_USUARIO_MODIFICA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.norma_componente
    ADD CONSTRAINT "FK_USUARIO_MODIFICA" FOREIGN KEY (id_usuario_modifica_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: norma_norma FK_USUARIO_MODIFICA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.norma_norma
    ADD CONSTRAINT "FK_USUARIO_MODIFICA" FOREIGN KEY (id_usuario_modifica_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: organismo_provincia FK_USUARIO_MODIFICA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.organismo_provincia
    ADD CONSTRAINT "FK_USUARIO_MODIFICA" FOREIGN KEY (id_usuario_modifica_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: t_tipopropiedad FK_USUARIO_MODIFICA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_tipopropiedad
    ADD CONSTRAINT "FK_USUARIO_MODIFICA" FOREIGN KEY (id_usuario_modifica_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: organismo_organismo ORG_APLI_FK; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.organismo_organismo
    ADD CONSTRAINT "ORG_APLI_FK" FOREIGN KEY (id_aplicacion) REFERENCES comun.t_aplicacion(id_aplicacion);


--
-- Name: norma_componente REF_COMPO_ID_NORMA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.norma_componente
    ADD CONSTRAINT "REF_COMPO_ID_NORMA" FOREIGN KEY (id_norma) REFERENCES comun.t_norma(id_norma);


--
-- Name: norma_componente REF_NORMA_ID_COMPO; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.norma_componente
    ADD CONSTRAINT "REF_NORMA_ID_COMPO" FOREIGN KEY (id_componente) REFERENCES comun.t_componente(id_componente);


--
-- Name: t_componente REF_TEMA_COMPONENTE; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_componente
    ADD CONSTRAINT "REF_TEMA_COMPONENTE" FOREIGN KEY (id_tema) REFERENCES comun.t_tema(id_tema);


--
-- Name: norma_tema REF_TEMA_ID_TEMA; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.norma_tema
    ADD CONSTRAINT "REF_TEMA_ID_TEMA" FOREIGN KEY (id_tema) REFERENCES comun.t_tema(id_tema);


--
-- Name: t_tipo_medicion TSEG_TIPO_MEDICION_FK1; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_tipo_medicion
    ADD CONSTRAINT "TSEG_TIPO_MEDICION_FK1" FOREIGN KEY (id_tipo_geometria_carto) REFERENCES comun.t_tipo_geometria_carto(id_tipo_geometria_carto);


--
-- Name: t_tipo_medic_valor_texto TSEG_TIPO_MEDIC_VALOR_TEX_FK2; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_tipo_medic_valor_texto
    ADD CONSTRAINT "TSEG_TIPO_MEDIC_VALOR_TEX_FK2" FOREIGN KEY (id_tipo_medicion) REFERENCES comun.t_tipo_medicion(id_tipo_medicion);


--
-- Name: t_medida_conserva_gestion T_MEDIDA_FK1; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_medida_conserva_gestion
    ADD CONSTRAINT "T_MEDIDA_FK1" FOREIGN KEY (id_aplicacion_origen) REFERENCES comun.t_aplicacion(id_aplicacion);


--
-- Name: t_medida_conserva_gestion T_MEDIDA_FK3; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_medida_conserva_gestion
    ADD CONSTRAINT "T_MEDIDA_FK3" FOREIGN KEY (id_ambito_geografico) REFERENCES comun.t_ambito_nivel_geografico_politico(id_ambito_nivel_geografico_politico);


--
-- Name: t_medida_conserva_gestion T_MEDIDA_FK6; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_medida_conserva_gestion
    ADD CONSTRAINT "T_MEDIDA_FK6" FOREIGN KEY (id_medida_padre) REFERENCES comun.t_medida_conserva_gestion(id_medida);


--
-- Name: medida_conservacion_norma T_MEDIDA_NORMA_FK2; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.medida_conservacion_norma
    ADD CONSTRAINT "T_MEDIDA_NORMA_FK2" FOREIGN KEY (id_medida) REFERENCES comun.t_medida_conserva_gestion(id_medida);


--
-- Name: t_norma T_NORMA_APLICACION_FK; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_norma
    ADD CONSTRAINT "T_NORMA_APLICACION_FK" FOREIGN KEY (id_aplicacion) REFERENCES comun.t_aplicacion(id_aplicacion);


--
-- Name: unidad_tipo_medicion T_UNIDAD_TIPO_MEDIDA_FK1; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.unidad_tipo_medicion
    ADD CONSTRAINT "T_UNIDAD_TIPO_MEDIDA_FK1" FOREIGN KEY (id_unidad) REFERENCES comun.t_unidad(id_unidad);


--
-- Name: ccaa_elemento_toponimo ccaa_elemento_toponimo_fk; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.ccaa_elemento_toponimo
    ADD CONSTRAINT ccaa_elemento_toponimo_fk FOREIGN KEY (id_ccaa) REFERENCES comun.t_elemento_toponomico(id_elemento_toponimico);


--
-- Name: ccaa_elemento_toponimo ccaa_elemento_toponimo_fk_1; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.ccaa_elemento_toponimo
    ADD CONSTRAINT ccaa_elemento_toponimo_fk_1 FOREIGN KEY (id_ccaa) REFERENCES comun.t_ccaa(id_ccaa);


--
-- Name: organismo_aplicacion fk_direcc_municipio; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.organismo_aplicacion
    ADD CONSTRAINT fk_direcc_municipio FOREIGN KEY (id_municipio) REFERENCES comun.t_municipio(id_municipios) NOT VALID;


--
-- Name: organismo_aplicacion fk_direcc_provincia; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.organismo_aplicacion
    ADD CONSTRAINT fk_direcc_provincia FOREIGN KEY (id_provincia) REFERENCES comun.t_provincia(id_provincia) NOT VALID;


--
-- Name: documento fk_documento_crea; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.documento
    ADD CONSTRAINT fk_documento_crea FOREIGN KEY (id_usuario_crea_registro) REFERENCES comun.t_usuario(id_usuario);


--
-- Name: documento fk_documento_modif; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.documento
    ADD CONSTRAINT fk_documento_modif FOREIGN KEY (id_usuario_modifica_registro) REFERENCES comun.t_usuario(id_usuario);


--
-- Name: documento fk_documento_t_aplicacion; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.documento
    ADD CONSTRAINT fk_documento_t_aplicacion FOREIGN KEY (id_aplicacion) REFERENCES comun.t_aplicacion(id_aplicacion);


--
-- Name: documento fk_documento_t_tipo_verificacion_documento; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.documento
    ADD CONSTRAINT fk_documento_t_tipo_verificacion_documento FOREIGN KEY (id_tipo_verificacion_documento) REFERENCES comun.t_tipo_verificacion_documento(id_tipo_verificacion_documento);


--
-- Name: documento fk_documento_tipo_documento; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.documento
    ADD CONSTRAINT fk_documento_tipo_documento FOREIGN KEY (id_tipo_documento) REFERENCES comun.t_tipo_documento(id_tipo_documento);


--
-- Name: t_tipo_estado_conservacion fk_estado_conserva_aplicaci; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_tipo_estado_conservacion
    ADD CONSTRAINT fk_estado_conserva_aplicaci FOREIGN KEY (id_aplicacion) REFERENCES comun.t_aplicacion(id_aplicacion) NOT VALID;


--
-- Name: t_grupo_taxonomico fk_grupo_tax_aplicacion; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_grupo_taxonomico
    ADD CONSTRAINT fk_grupo_tax_aplicacion FOREIGN KEY (id_aplicacion) REFERENCES comun.t_aplicacion(id_aplicacion) NOT VALID;


--
-- Name: grupo_taxon_eidos_otros fk_grupotax_rel_otros; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.grupo_taxon_eidos_otros
    ADD CONSTRAINT fk_grupotax_rel_otros FOREIGN KEY (id_grupotax_eidos) REFERENCES comun.t_grupo_taxonomico(id_grupo_taxon) NOT VALID;


--
-- Name: t_valor_texto_otra_codif fk_id_valor_texto; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_valor_texto_otra_codif
    ADD CONSTRAINT fk_id_valor_texto FOREIGN KEY (id_valor_texto) REFERENCES comun.t_valor_texto(id_valor_texto) NOT VALID;


--
-- Name: t_localidad fk_localidad_municipio; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_localidad
    ADD CONSTRAINT fk_localidad_municipio FOREIGN KEY (id_municipio) REFERENCES comun.t_municipio(id_municipios);


--
-- Name: norma_tema fk_noma_tema_norma; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.norma_tema
    ADD CONSTRAINT fk_noma_tema_norma FOREIGN KEY (id_norma) REFERENCES comun.t_norma(id_norma) NOT VALID;


--
-- Name: t_grupo_taxonomico fk_nombre_grupo; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_grupo_taxonomico
    ADD CONSTRAINT fk_nombre_grupo FOREIGN KEY (id_nombre_grupo_taxon) REFERENCES comun.t_nombre_grupo_taxonomico(id_nombre_grupo_taxon) NOT VALID;


--
-- Name: organismo_aplicacion fk_org_app_to_org; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.organismo_aplicacion
    ADD CONSTRAINT fk_org_app_to_org FOREIGN KEY (id_organismo) REFERENCES comun.t_organismo(id_organismo);


--
-- Name: organismo_ambito_aplica fk_organismo_ambito_aplica_t_ambito_aplica; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.organismo_ambito_aplica
    ADD CONSTRAINT fk_organismo_ambito_aplica_t_ambito_aplica FOREIGN KEY (id_ambito_aplica) REFERENCES comun.t_ambito_aplica(id_ambito_aplica);


--
-- Name: organismo_ambito_aplica fk_organismo_ambito_aplica_t_ccaa; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.organismo_ambito_aplica
    ADD CONSTRAINT fk_organismo_ambito_aplica_t_ccaa FOREIGN KEY (id_ccaa) REFERENCES comun.t_ccaa(id_ccaa);


--
-- Name: organismo_ambito_aplica fk_organismo_ambito_aplica_t_municipio; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.organismo_ambito_aplica
    ADD CONSTRAINT fk_organismo_ambito_aplica_t_municipio FOREIGN KEY (id_municipio) REFERENCES comun.t_municipio(id_municipios);


--
-- Name: organismo_ambito_aplica fk_organismo_ambito_aplica_t_organismo; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.organismo_ambito_aplica
    ADD CONSTRAINT fk_organismo_ambito_aplica_t_organismo FOREIGN KEY (id_organismo) REFERENCES comun.t_organismo(id_organismo);


--
-- Name: organismo_ambito_aplica fk_organismo_ambito_aplica_t_provincia; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.organismo_ambito_aplica
    ADD CONSTRAINT fk_organismo_ambito_aplica_t_provincia FOREIGN KEY (id_provincia) REFERENCES comun.t_provincia(id_provincia);


--
-- Name: organismo_ambito_aplica fk_organismo_ambito_aplica_t_usuario_crea; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.organismo_ambito_aplica
    ADD CONSTRAINT fk_organismo_ambito_aplica_t_usuario_crea FOREIGN KEY (id_usuario_crea_registro) REFERENCES comun.t_usuario(id_usuario);


--
-- Name: organismo_ambito_aplica fk_organismo_ambito_aplica_t_usuario_modifica; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.organismo_ambito_aplica
    ADD CONSTRAINT fk_organismo_ambito_aplica_t_usuario_modifica FOREIGN KEY (id_usuario_modifica_registro) REFERENCES comun.t_usuario(id_usuario);


--
-- Name: perfil_funcionalidad fk_perfil_funcionalidad_t_funcionalidad; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.perfil_funcionalidad
    ADD CONSTRAINT fk_perfil_funcionalidad_t_funcionalidad FOREIGN KEY (id_funcionalidad) REFERENCES comun.t_funcionalidad(id_funcionalidad);


--
-- Name: perfil_funcionalidad fk_perfil_funcionalidad_t_perfil; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.perfil_funcionalidad
    ADD CONSTRAINT fk_perfil_funcionalidad_t_perfil FOREIGN KEY (id_perfil) REFERENCES comun.t_perfil(id_perfil);


--
-- Name: perfil_funcionalidad fk_perfil_funcionalidad_t_usuario_crea; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.perfil_funcionalidad
    ADD CONSTRAINT fk_perfil_funcionalidad_t_usuario_crea FOREIGN KEY (id_usuario_crea_registro) REFERENCES comun.t_usuario(id_usuario);


--
-- Name: perfil_funcionalidad fk_perfil_funcionalidad_t_usuario_modifica; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.perfil_funcionalidad
    ADD CONSTRAINT fk_perfil_funcionalidad_t_usuario_modifica FOREIGN KEY (id_usuario_modifica_registro) REFERENCES comun.t_usuario(id_usuario);


--
-- Name: t_ambito_aplica fk_t_ambito_aplica_t_aplicacion; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_ambito_aplica
    ADD CONSTRAINT fk_t_ambito_aplica_t_aplicacion FOREIGN KEY (id_aplicacion) REFERENCES comun.t_aplicacion(id_aplicacion);


--
-- Name: t_ambito_aplica fk_t_ambito_aplica_t_usuario_crea; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_ambito_aplica
    ADD CONSTRAINT fk_t_ambito_aplica_t_usuario_crea FOREIGN KEY (id_usuario_crea_registro) REFERENCES comun.t_usuario(id_usuario);


--
-- Name: t_ambito_aplica fk_t_ambito_aplica_t_usuario_modifica; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_ambito_aplica
    ADD CONSTRAINT fk_t_ambito_aplica_t_usuario_modifica FOREIGN KEY (id_usuario_modifica_registro) REFERENCES comun.t_usuario(id_usuario);


--
-- Name: t_catalogo fk_t_catalogo_t_aplicacion; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_catalogo
    ADD CONSTRAINT fk_t_catalogo_t_aplicacion FOREIGN KEY (id_aplicacion) REFERENCES comun.t_aplicacion(id_aplicacion);


--
-- Name: t_funcionalidad fk_t_funcionalidad_t_aplicacion; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_funcionalidad
    ADD CONSTRAINT fk_t_funcionalidad_t_aplicacion FOREIGN KEY (id_aplicacion) REFERENCES comun.t_aplicacion(id_aplicacion);


--
-- Name: t_funcionalidad fk_t_funcionalidad_t_usuario_crea; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_funcionalidad
    ADD CONSTRAINT fk_t_funcionalidad_t_usuario_crea FOREIGN KEY (id_usuario_crea_registro) REFERENCES comun.t_usuario(id_usuario);


--
-- Name: t_funcionalidad fk_t_funcionalidad_t_usuario_modifica; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_funcionalidad
    ADD CONSTRAINT fk_t_funcionalidad_t_usuario_modifica FOREIGN KEY (id_usuario_modifica_registro) REFERENCES comun.t_usuario(id_usuario);


--
-- Name: t_norma fk_t_norma_t_rango_norma_inf; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_norma
    ADD CONSTRAINT fk_t_norma_t_rango_norma_inf FOREIGN KEY (id_rango_norma_inf) REFERENCES comun.t_rango_norma_inf(id_rango_norma);


--
-- Name: t_norma fk_t_norma_t_rango_norma_int; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_norma
    ADD CONSTRAINT fk_t_norma_t_rango_norma_int FOREIGN KEY (id_rango_norma_int) REFERENCES comun.t_rango_norma_int(id_rango_norma);


--
-- Name: t_norma fk_t_norma_t_rango_norma_sup; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_norma
    ADD CONSTRAINT fk_t_norma_t_rango_norma_sup FOREIGN KEY (id_rango_norma_sup) REFERENCES comun.t_rango_norma_sup(id_rango_norma);


--
-- Name: t_norma fk_t_norma_t_visible; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_norma
    ADD CONSTRAINT fk_t_norma_t_visible FOREIGN KEY (id_visible) REFERENCES comun.t_visible(idvisible);


--
-- Name: t_organismo fk_t_organismo_t_ambito_nivel_geografico_politico; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_organismo
    ADD CONSTRAINT fk_t_organismo_t_ambito_nivel_geografico_politico FOREIGN KEY (id_ambito_nivel_geografico_politico) REFERENCES comun.t_ambito_nivel_geografico_politico(id_ambito_nivel_geografico_politico);


--
-- Name: t_organismo fk_t_organismo_t_tipo_organismo; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_organismo
    ADD CONSTRAINT fk_t_organismo_t_tipo_organismo FOREIGN KEY (id_tipo_organismo) REFERENCES comun.t_tipo_organismo(id_tipo_organismo);


--
-- Name: t_parametro_configuracion fk_t_parametro_t_aplicacion; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_parametro_configuracion
    ADD CONSTRAINT fk_t_parametro_t_aplicacion FOREIGN KEY (id_aplicacion) REFERENCES comun.t_aplicacion(id_aplicacion);


--
-- Name: t_parametro_configuracion fk_t_parametro_t_usuario_crea; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_parametro_configuracion
    ADD CONSTRAINT fk_t_parametro_t_usuario_crea FOREIGN KEY (id_usuario_crea_registro) REFERENCES comun.t_usuario(id_usuario);


--
-- Name: t_parametro_configuracion fk_t_parametro_t_usuario_modifica; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_parametro_configuracion
    ADD CONSTRAINT fk_t_parametro_t_usuario_modifica FOREIGN KEY (id_usuario_modifica_registro) REFERENCES comun.t_usuario(id_usuario);


--
-- Name: t_ref_bibliografica fk_t_ref_bibliografica_t_fuente; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_ref_bibliografica
    ADD CONSTRAINT fk_t_ref_bibliografica_t_fuente FOREIGN KEY (idfuente) REFERENCES especie.t_fuente(idfuente);


--
-- Name: t_ref_bibliografica fk_t_ref_bibliografica_t_idioma; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_ref_bibliografica
    ADD CONSTRAINT fk_t_ref_bibliografica_t_idioma FOREIGN KEY (ididioma) REFERENCES comun.t_idioma(ididioma);


--
-- Name: t_ref_bibliografica fk_t_ref_bibliografica_t_tipo_publicacion; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_ref_bibliografica
    ADD CONSTRAINT fk_t_ref_bibliografica_t_tipo_publicacion FOREIGN KEY (idtipo_publicacion) REFERENCES especie.t_tipo_publicacion(idtipo_publicacion);


--
-- Name: t_tipo_relieve fk_t_tipo_relieve_t_ambito; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_tipo_relieve
    ADD CONSTRAINT fk_t_tipo_relieve_t_ambito FOREIGN KEY (cod_tipo_ambito) REFERENCES comun.t_ambito(cod_ambito);


--
-- Name: t_usuario fk_t_usuario_t_organismo; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_usuario
    ADD CONSTRAINT fk_t_usuario_t_organismo FOREIGN KEY (id_organismo) REFERENCES comun.t_organismo(id_organismo);


--
-- Name: t_valor_texto_otra_codif fk_valot_id_aplicacion; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_valor_texto_otra_codif
    ADD CONSTRAINT fk_valot_id_aplicacion FOREIGN KEY (id_aplicacion) REFERENCES comun.t_aplicacion(id_aplicacion) NOT VALID;


--
-- Name: norma_ccaa norma_ccaa_fk; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.norma_ccaa
    ADD CONSTRAINT norma_ccaa_fk FOREIGN KEY (id_norma) REFERENCES comun.t_norma(id_norma);


--
-- Name: norma_ccaa norma_ccaa_fk_1; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.norma_ccaa
    ADD CONSTRAINT norma_ccaa_fk_1 FOREIGN KEY (id_ccaa) REFERENCES comun.t_ccaa(id_ccaa);


--
-- Name: norma_elemento_toponimo norma_elemento_toponimo_fk; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.norma_elemento_toponimo
    ADD CONSTRAINT norma_elemento_toponimo_fk FOREIGN KEY (id_norma) REFERENCES comun.t_norma(id_norma);


--
-- Name: norma_elemento_toponimo norma_elemento_toponimo_fk_2; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.norma_elemento_toponimo
    ADD CONSTRAINT norma_elemento_toponimo_fk_2 FOREIGN KEY (id_elemento_toponimo) REFERENCES comun.t_elemento_toponomico(id_elemento_toponimico);


--
-- Name: organismo_ccaa organismo_ccaa_fk; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.organismo_ccaa
    ADD CONSTRAINT organismo_ccaa_fk FOREIGN KEY (id_organismo) REFERENCES comun.t_organismo(id_organismo);


--
-- Name: organismo_ccaa organismo_ccaa_fk_1; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.organismo_ccaa
    ADD CONSTRAINT organismo_ccaa_fk_1 FOREIGN KEY (id_ccaa) REFERENCES comun.t_ccaa(id_ccaa);


--
-- Name: t_categoria_medida_conservacion t_categoria_medida_conservacion_fk; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_categoria_medida_conservacion
    ADD CONSTRAINT t_categoria_medida_conservacion_fk FOREIGN KEY (id_aplicacion) REFERENCES comun.t_aplicacion(id_aplicacion);


--
-- Name: t_ccaa t_ccaa_agrup_fk; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_ccaa
    ADD CONSTRAINT t_ccaa_agrup_fk FOREIGN KEY (id_agrupacion) REFERENCES comun.t_ccaa(id_ccaa);


--
-- Name: t_ccaa t_ccaa_fk; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_ccaa
    ADD CONSTRAINT t_ccaa_fk FOREIGN KEY (id_aplicacion) REFERENCES comun.t_aplicacion(id_aplicacion);


--
-- Name: t_elemento_toponomico t_elemento_toponimico_fk; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_elemento_toponomico
    ADD CONSTRAINT t_elemento_toponimico_fk FOREIGN KEY (id_tipo_toponimo) REFERENCES comun.t_tipo_toponimia(id_tipo_toponimia);


--
-- Name: t_elemento_toponomico t_elemento_toponimico_fk_1; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_elemento_toponomico
    ADD CONSTRAINT t_elemento_toponimico_fk_1 FOREIGN KEY (id_tipo_relieve) REFERENCES comun.t_tipo_relieve(id_tipo_relieve);


--
-- Name: t_elemento_toponomico t_elemento_toponimico_fk_2; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_elemento_toponomico
    ADD CONSTRAINT t_elemento_toponimico_fk_2 FOREIGN KEY (cod_punto_cardinal) REFERENCES comun.t_punto_cardinal(cod_cardinal);


--
-- Name: t_elemento_toponomico t_elemento_toponimico_fk_3; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_elemento_toponomico
    ADD CONSTRAINT t_elemento_toponimico_fk_3 FOREIGN KEY (id_ambito_nivel_geograf_politico) REFERENCES comun.t_ambito_nivel_geografico_politico(id_ambito_nivel_geografico_politico);


--
-- Name: t_elemento_toponomico t_elemento_toponomico_fk; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_elemento_toponomico
    ADD CONSTRAINT t_elemento_toponomico_fk FOREIGN KEY (id_nombre_toponimo) REFERENCES comun.t_nombre_toponimia(id_nombre_toponimia);


--
-- Name: t_tipo_especif_valor_texto t_especif_valor_texto_t_valor_texto_fk; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_tipo_especif_valor_texto
    ADD CONSTRAINT t_especif_valor_texto_t_valor_texto_fk FOREIGN KEY (id_valor_texto) REFERENCES comun.t_valor_texto(id_valor_texto);


--
-- Name: t_tipo_especificacion t_especificacion_t_especif_valor_texto_fk; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_tipo_especificacion
    ADD CONSTRAINT t_especificacion_t_especif_valor_texto_fk FOREIGN KEY (id_especificacion) REFERENCES comun.t_tipo_especif_valor_texto(id_especificacion);


--
-- Name: t_medida_conserva_gestion t_medida_conserva_gestion_fk; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_medida_conserva_gestion
    ADD CONSTRAINT t_medida_conserva_gestion_fk FOREIGN KEY (id_region_biogeografica) REFERENCES comun.t_region_biogeografica(id_region);


--
-- Name: t_norma t_norma_fk; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_norma
    ADD CONSTRAINT t_norma_fk FOREIGN KEY (id_clasif_objetivo_norma) REFERENCES comun.t_clasif_objetivo_norma(id_clasific_objetivo_norma);


--
-- Name: t_norma t_norma_organismo_fk; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_norma
    ADD CONSTRAINT t_norma_organismo_fk FOREIGN KEY (id_organismo) REFERENCES comun.t_organismo(id_organismo);


--
-- Name: t_presion_amenaza t_presion_amenaza_fk; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_presion_amenaza
    ADD CONSTRAINT t_presion_amenaza_fk FOREIGN KEY (id_fuente_catalogo) REFERENCES comun.t_fuente_presion_amenaza(id_fuente_presion_amenza);


--
-- Name: t_tipo_medic_valor_texto t_tipo_medic_valor_texto_t_valor_texto_fk; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_tipo_medic_valor_texto
    ADD CONSTRAINT t_tipo_medic_valor_texto_t_valor_texto_fk FOREIGN KEY (id_valor_texto) REFERENCES comun.t_valor_texto(id_valor_texto);


--
-- Name: t_tipo_medicion t_tipo_medicion_fk; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_tipo_medicion
    ADD CONSTRAINT t_tipo_medicion_fk FOREIGN KEY (id_aplicacion) REFERENCES comun.t_aplicacion(id_aplicacion);


--
-- Name: t_valor_medida t_valor_medida_fk; Type: FK CONSTRAINT; Schema: comun; Owner: iepnb
--

ALTER TABLE ONLY comun.t_valor_medida
    ADD CONSTRAINT t_valor_medida_fk FOREIGN KEY (id_tipo_medicion) REFERENCES comun.t_tipo_medicion(id_tipo_medicion);


--
-- Name: taxon FK_ESPECIE_TAXON_T_AMBITO; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxon
    ADD CONSTRAINT "FK_ESPECIE_TAXON_T_AMBITO" FOREIGN KEY (cod_ambito) REFERENCES comun.t_ambito(cod_ambito);


--
-- Name: pliniancore-extension FK_USUARIO_CREA; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie."pliniancore-extension"
    ADD CONSTRAINT "FK_USUARIO_CREA" FOREIGN KEY (id_usuario_crea_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: taxondistribucion FK_USUARIO_CREA; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxondistribucion
    ADD CONSTRAINT "FK_USUARIO_CREA" FOREIGN KEY (id_usuario_crea_registro) REFERENCES comun.t_usuario(id_usuario);


--
-- Name: taxon_medicion FK_USUARIO_CREA; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxon_medicion
    ADD CONSTRAINT "FK_USUARIO_CREA" FOREIGN KEY (id_usuario_crea_registro) REFERENCES comun.t_usuario(id_usuario);


--
-- Name: taxonhabitat FK_USUARIO_CREA; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonhabitat
    ADD CONSTRAINT "FK_USUARIO_CREA" FOREIGN KEY (id_usuario_crea_registro) REFERENCES comun.t_usuario(id_usuario);


--
-- Name: endemismo FK_USUARIO_CREA; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.endemismo
    ADD CONSTRAINT "FK_USUARIO_CREA" FOREIGN KEY (id_usuario_crea_registro) REFERENCES comun.t_usuario(id_usuario);


--
-- Name: pliniancore-extension FK_USUARIO_MODIFICA; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie."pliniancore-extension"
    ADD CONSTRAINT "FK_USUARIO_MODIFICA" FOREIGN KEY (id_usuario_modifica_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: taxondistribucion FK_USUARIO_MODIFICA; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxondistribucion
    ADD CONSTRAINT "FK_USUARIO_MODIFICA" FOREIGN KEY (id_usuario_modifica_registro) REFERENCES comun.t_usuario(id_usuario);


--
-- Name: taxon_medicion FK_USUARIO_MODIFICA; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxon_medicion
    ADD CONSTRAINT "FK_USUARIO_MODIFICA" FOREIGN KEY (id_usuario_modifica_registro) REFERENCES comun.t_usuario(id_usuario);


--
-- Name: taxonhabitat FK_USUARIO_MODIFICA; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonhabitat
    ADD CONSTRAINT "FK_USUARIO_MODIFICA" FOREIGN KEY (id_usuario_modifica_registro) REFERENCES comun.t_usuario(id_usuario);


--
-- Name: endemismo FK_USUARIO_MODIFICA; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.endemismo
    ADD CONSTRAINT "FK_USUARIO_MODIFICA" FOREIGN KEY (id_usuario_modifica_registro) REFERENCES comun.t_usuario(id_usuario);


--
-- Name: t_dataset dataset_tiponormativacolfk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_dataset
    ADD CONSTRAINT dataset_tiponormativacolfk FOREIGN KEY (idtiponormativadataset) REFERENCES especie.t_tiponormativadataset(idtiponormativadataset);


--
-- Name: taxondistribucion distribucion_ambitodistrfk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxondistribucion
    ADD CONSTRAINT distribucion_ambitodistrfk FOREIGN KEY (idambitodistr) REFERENCES especie.t_ambito_distribucion(idambitodistr);


--
-- Name: taxondistribucion distribucion_aplicadoafk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxondistribucion
    ADD CONSTRAINT distribucion_aplicadoafk FOREIGN KEY (idaplicadoa) REFERENCES especie.t_aplicaa_distribucion(idaplicaa);


--
-- Name: taxondistribucion distribucion_taxonfk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxondistribucion
    ADD CONSTRAINT distribucion_taxonfk FOREIGN KEY (idtaxon) REFERENCES especie.taxon(idtaxon);


--
-- Name: taxondistribucion distribucion_tipoambitodistrfk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxondistribucion
    ADD CONSTRAINT distribucion_tipoambitodistrfk FOREIGN KEY (idtipoambitodistr) REFERENCES especie.t_tipoambito_ditribucion(idtipoambitodistr);


--
-- Name: taxondistribucion distribucion_tipofk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxondistribucion
    ADD CONSTRAINT distribucion_tipofk FOREIGN KEY (idtipodistribucion) REFERENCES especie.t_tipo_distribucion(idtipodistribucion);


--
-- Name: endemismo endemismo_datasetfk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.endemismo
    ADD CONSTRAINT endemismo_datasetfk FOREIGN KEY (iddataset) REFERENCES especie.t_dataset(iddataset);


--
-- Name: endemismo endemismo_endemismocoenfk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.endemismo
    ADD CONSTRAINT endemismo_endemismocoenfk FOREIGN KEY (idendemicoen) REFERENCES especie.t_endemicoen(idendemicoen);


--
-- Name: endemismo endemismo_taxonfk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.endemismo
    ADD CONSTRAINT endemismo_taxonfk FOREIGN KEY (idtaxon) REFERENCES especie.taxon(idtaxon);


--
-- Name: taxonestadoconservacion estadoconservacion_categoriafk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonestadoconservacion
    ADD CONSTRAINT estadoconservacion_categoriafk FOREIGN KEY (idcategoria) REFERENCES especie.t_categoria_conservacion(idcategoria);


--
-- Name: taxonestadoconservacion estadoconservacion_criteriofk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonestadoconservacion
    ADD CONSTRAINT estadoconservacion_criteriofk FOREIGN KEY (idcriterio) REFERENCES especie.t_criteriomedidaconservacion(idcriterio);


--
-- Name: t_estadolegal estadolegal_normativafk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_estadolegal
    ADD CONSTRAINT estadolegal_normativafk FOREIGN KEY (id_norma) REFERENCES comun.t_norma(id_norma);


--
-- Name: endemismo fk_endemismo_t_tipo_cambio; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.endemismo
    ADD CONSTRAINT fk_endemismo_t_tipo_cambio FOREIGN KEY (id_tipo_cambio) REFERENCES comun.t_tipo_cambio(id_tipo_cambio);


--
-- Name: endemismo fk_endemismo_t_vigente; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.endemismo
    ADD CONSTRAINT fk_endemismo_t_vigente FOREIGN KEY (idvigente) REFERENCES comun.t_vigente(idvigente);


--
-- Name: lp_fuentereferencias fk_lp_fuentereferencias_t_fuentereferencias_lp; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.lp_fuentereferencias
    ADD CONSTRAINT fk_lp_fuentereferencias_t_fuentereferencias_lp FOREIGN KEY (idfuentereferencialp) REFERENCES especie.t_fuentereferencias_lp(idfuentereferencialp);


--
-- Name: lp_fuentereferencias fk_lp_fuentereferencias_t_origen_lp; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.lp_fuentereferencias
    ADD CONSTRAINT fk_lp_fuentereferencias_t_origen_lp FOREIGN KEY (idorigenlp) REFERENCES especie.t_origen_lp(idorigenlp);


--
-- Name: lp_origen fk_lp_origen_nombre; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.lp_origen
    ADD CONSTRAINT fk_lp_origen_nombre FOREIGN KEY (idnombre) REFERENCES especie.nombre(idnombre);


--
-- Name: lp_origen fk_lp_origen_t_dataset; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.lp_origen
    ADD CONSTRAINT fk_lp_origen_t_dataset FOREIGN KEY (iddataset) REFERENCES especie.t_dataset(iddataset);


--
-- Name: lp_origen fk_lp_origen_t_origen_lp; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.lp_origen
    ADD CONSTRAINT fk_lp_origen_t_origen_lp FOREIGN KEY (idorigenlp) REFERENCES especie.t_origen_lp(idorigenlp);


--
-- Name: lp_sociedades fk_lp_sociedades_t_origen_lp; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.lp_sociedades
    ADD CONSTRAINT fk_lp_sociedades_t_origen_lp FOREIGN KEY (idorigenlp) REFERENCES especie.t_origen_lp(idorigenlp);


--
-- Name: lp_sociedades fk_lp_sociedades_t_sociedades_lp; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.lp_sociedades
    ADD CONSTRAINT fk_lp_sociedades_t_sociedades_lp FOREIGN KEY (idsociedadlp) REFERENCES especie.t_sociedades_lp(idsociedadlp);


--
-- Name: taxon fk_taxon_t_origen_taxon; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxon
    ADD CONSTRAINT fk_taxon_t_origen_taxon FOREIGN KEY (idorigen_canarias) REFERENCES especie.t_origentaxon(idorigen);


--
-- Name: taxondistribucion fk_taxondistribucion_t_vigente; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxondistribucion
    ADD CONSTRAINT fk_taxondistribucion_t_vigente FOREIGN KEY (idvigente) REFERENCES comun.t_vigente(idvigente);


--
-- Name: taxonestadoconservacion fk_taxonestadoconservacion_nombre; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonestadoconservacion
    ADD CONSTRAINT fk_taxonestadoconservacion_nombre FOREIGN KEY (idnombre) REFERENCES especie.nombre(idnombre);


--
-- Name: taxonestadoconservacion fk_taxonestadoconservacion_t_vigente; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonestadoconservacion
    ADD CONSTRAINT fk_taxonestadoconservacion_t_vigente FOREIGN KEY (idvigente) REFERENCES comun.t_vigente(idvigente);


--
-- Name: taxonestadoconservacion fk_taxonestadoconservacion_t_visible; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonestadoconservacion
    ADD CONSTRAINT fk_taxonestadoconservacion_t_visible FOREIGN KEY (idvisible) REFERENCES comun.t_visible(idvisible);


--
-- Name: taxonestadolegal fk_taxonestadolegal_t_aplicaa_distribucion; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonestadolegal
    ADD CONSTRAINT fk_taxonestadolegal_t_aplicaa_distribucion FOREIGN KEY (idaplicadoa) REFERENCES especie.t_aplicaa_distribucion(idaplicaa);


--
-- Name: taxonestadolegal fk_taxonestadolegal_t_tipo_cambio; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonestadolegal
    ADD CONSTRAINT fk_taxonestadolegal_t_tipo_cambio FOREIGN KEY (id_tipo_cambio) REFERENCES comun.t_tipo_cambio(id_tipo_cambio);


--
-- Name: taxonhabitat fk_taxonhabitat_habitat; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonhabitat
    ADD CONSTRAINT fk_taxonhabitat_habitat FOREIGN KEY (idhabitat) REFERENCES habitat.habitat(id_ieh);


--
-- Name: taxonhabitat fk_taxonhabitat_t_aplicaa_distribucion; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonhabitat
    ADD CONSTRAINT fk_taxonhabitat_t_aplicaa_distribucion FOREIGN KEY (idaplicaa) REFERENCES especie.t_aplicaa_distribucion(idaplicaa);


--
-- Name: taxonhabitat fk_taxonhabitat_t_dataset; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonhabitat
    ADD CONSTRAINT fk_taxonhabitat_t_dataset FOREIGN KEY (iddataset) REFERENCES especie.t_dataset(iddataset);


--
-- Name: taxonhabitat fk_taxonhabitat_t_fuente; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonhabitat
    ADD CONSTRAINT fk_taxonhabitat_t_fuente FOREIGN KEY (idfuente) REFERENCES especie.t_fuente(idfuente);


--
-- Name: taxonhabitat fk_taxonhabitat_t_tipo_cambio; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonhabitat
    ADD CONSTRAINT fk_taxonhabitat_t_tipo_cambio FOREIGN KEY (id_tipo_cambio) REFERENCES comun.t_tipo_cambio(id_tipo_cambio);


--
-- Name: taxonhabitat fk_taxonhabitat_t_vigente; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonhabitat
    ADD CONSTRAINT fk_taxonhabitat_t_vigente FOREIGN KEY (idvigente) REFERENCES comun.t_vigente(idvigente);


--
-- Name: taxonhabitat fk_taxonhabitat_taxon; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonhabitat
    ADD CONSTRAINT fk_taxonhabitat_taxon FOREIGN KEY (idtaxon) REFERENCES especie.taxon(idtaxon);


--
-- Name: taxonnombre fk_taxonnombre_t_tipo_cambio; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonnombre
    ADD CONSTRAINT fk_taxonnombre_t_tipo_cambio FOREIGN KEY (id_tipo_cambio) REFERENCES comun.t_tipo_cambio(id_tipo_cambio);


--
-- Name: taxonplanesgestion fk_taxonplanesgestion_t_aplicaa_distribucion; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonplanesgestion
    ADD CONSTRAINT fk_taxonplanesgestion_t_aplicaa_distribucion FOREIGN KEY (idaplicadoa) REFERENCES especie.t_aplicaa_distribucion(idaplicaa);


--
-- Name: taxonplanesgestion fk_taxonplanesgestion_t_tipo_plan; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonplanesgestion
    ADD CONSTRAINT fk_taxonplanesgestion_t_tipo_plan FOREIGN KEY (idtipoplan) REFERENCES comun.t_tipo_plan(id_tipo_plan);


--
-- Name: taxonreferencia fk_taxonreferencia_t_ref_bibliografica; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonreferencia
    ADD CONSTRAINT fk_taxonreferencia_t_ref_bibliografica FOREIGN KEY (idreferencia) REFERENCES comun.t_ref_bibliografica(idreferencia);


--
-- Name: taxonubicacion fk_taxonubicacion_t_estado_cuadricula; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonubicacion
    ADD CONSTRAINT fk_taxonubicacion_t_estado_cuadricula FOREIGN KEY (idestadocuadr) REFERENCES especie.t_estado_cuadricula(idestadocuad);


--
-- Name: grupodataset grupodataset_datasetfk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.grupodataset
    ADD CONSTRAINT grupodataset_datasetfk FOREIGN KEY (iddataset) REFERENCES especie.t_dataset(iddataset);


--
-- Name: grupodataset grupodataset_grupofk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.grupodataset
    ADD CONSTRAINT grupodataset_grupofk FOREIGN KEY (idgrupo) REFERENCES especie.t_grupo(idgrupo);


--
-- Name: grupolegislacion grupolegislacion_grupofk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.grupolegislacion
    ADD CONSTRAINT grupolegislacion_grupofk FOREIGN KEY (idgrupo) REFERENCES especie.t_grupo(idgrupo);


--
-- Name: grupolegislacion grupolegislacion_normafk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.grupolegislacion
    ADD CONSTRAINT grupolegislacion_normafk FOREIGN KEY (idnorma) REFERENCES comun.t_norma(id_norma);


--
-- Name: t_medidaconservacion medidaconservacion_fuentefk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_medidaconservacion
    ADD CONSTRAINT medidaconservacion_fuentefk FOREIGN KEY (idfuente) REFERENCES especie.t_fuente(idfuente);


--
-- Name: taxon_medicion medidas_datasetfk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxon_medicion
    ADD CONSTRAINT medidas_datasetfk FOREIGN KEY (iddataset) REFERENCES especie.t_dataset(iddataset);


--
-- Name: taxon_medicion medidas_metodomedidafk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxon_medicion
    ADD CONSTRAINT medidas_metodomedidafk FOREIGN KEY (idmetodomedida) REFERENCES especie.t_metodomedida(idmetodomedida);


--
-- Name: taxon_medicion medidas_precionmedidafk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxon_medicion
    ADD CONSTRAINT medidas_precionmedidafk FOREIGN KEY (idprecisionmedida) REFERENCES especie.t_precisionmedida(idprecisionmedida);


--
-- Name: taxon_medicion medidas_taxonk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxon_medicion
    ADD CONSTRAINT medidas_taxonk FOREIGN KEY (idtaxon) REFERENCES especie.taxon(idtaxon);


--
-- Name: taxon_medicion medidas_unidadfk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxon_medicion
    ADD CONSTRAINT medidas_unidadfk FOREIGN KEY (idunidadmedida) REFERENCES comun.t_unidad(id_unidad);


--
-- Name: nombre nombre_idiomafk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.nombre
    ADD CONSTRAINT nombre_idiomafk FOREIGN KEY (ididioma) REFERENCES comun.t_idioma(ididioma);


--
-- Name: nombrecodigosexternos nombrecodigosexternos_datasetfk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.nombrecodigosexternos
    ADD CONSTRAINT nombrecodigosexternos_datasetfk FOREIGN KEY (iddataset) REFERENCES especie.t_dataset(iddataset);


--
-- Name: nombrecodigosexternos nombrecodigosexternos_nombrefk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.nombrecodigosexternos
    ADD CONSTRAINT nombrecodigosexternos_nombrefk FOREIGN KEY (idnombre) REFERENCES especie.nombre(idnombre);


--
-- Name: nombrecodigosexternos nombrecodigosexternos_tipocodigofk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.nombrecodigosexternos
    ADD CONSTRAINT nombrecodigosexternos_tipocodigofk FOREIGN KEY (id_tipo_codigo) REFERENCES especie.t_tipo_codigo(id_tipo_codigo);


--
-- Name: nombrepreferencia nombrepreferencia_idiomafk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.nombrepreferencia
    ADD CONSTRAINT nombrepreferencia_idiomafk FOREIGN KEY (ididioma) REFERENCES comun.t_idioma(ididioma);


--
-- Name: nombrepreferencia nombrepreferencia_nombrefk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.nombrepreferencia
    ADD CONSTRAINT nombrepreferencia_nombrefk FOREIGN KEY (idnombre) REFERENCES especie.nombre(idnombre);


--
-- Name: pliniancore-extension pliniancore_extension_atributofk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie."pliniancore-extension"
    ADD CONSTRAINT pliniancore_extension_atributofk FOREIGN KEY (idatributo) REFERENCES especie.t_atributo(idatributo);


--
-- Name: pliniancore-extension pliniancore_extension_datasetfk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie."pliniancore-extension"
    ADD CONSTRAINT pliniancore_extension_datasetfk FOREIGN KEY (iddataset) REFERENCES especie.t_dataset(iddataset);


--
-- Name: pliniancore-extension pliniancore_extension_fuentefk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie."pliniancore-extension"
    ADD CONSTRAINT pliniancore_extension_fuentefk FOREIGN KEY (idfuente) REFERENCES especie.t_fuente(idfuente);


--
-- Name: pliniancore-extension pliniancore_extension_taxonfk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie."pliniancore-extension"
    ADD CONSTRAINT pliniancore_extension_taxonfk FOREIGN KEY (idtaxon) REFERENCES especie.taxon(idtaxon);


--
-- Name: poblacion_aplicaa_nut2 poblacion_aplicaa_nut2_fk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.poblacion_aplicaa_nut2
    ADD CONSTRAINT poblacion_aplicaa_nut2_fk FOREIGN KEY (idaplicaa_nut2) REFERENCES especie.t_aplicaa_distribucion(idaplicaa);


--
-- Name: poblacion_aplicaa_nut2 poblacion_excepto_aplicaa_nut2_fk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.poblacion_aplicaa_nut2
    ADD CONSTRAINT poblacion_excepto_aplicaa_nut2_fk FOREIGN KEY (excepto_idaplicaa_nut2) REFERENCES especie.t_aplicaa_distribucion(idaplicaa);


--
-- Name: relacion_taxonomica relacion_taxonomica_datasetfk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.relacion_taxonomica
    ADD CONSTRAINT relacion_taxonomica_datasetfk FOREIGN KEY (iddataset) REFERENCES especie.t_dataset(iddataset);


--
-- Name: relacion_taxonomica relacion_taxonomica_relacionadofk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.relacion_taxonomica
    ADD CONSTRAINT relacion_taxonomica_relacionadofk FOREIGN KEY (idtaxon1_relacionado) REFERENCES especie.taxon(idtaxon);


--
-- Name: relacion_taxonomica relacion_taxonomica_taxonfk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.relacion_taxonomica
    ADD CONSTRAINT relacion_taxonomica_taxonfk FOREIGN KEY (idtaxon) REFERENCES especie.taxon(idtaxon);


--
-- Name: relacion_taxonomica relacion_taxonomica_tipofk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.relacion_taxonomica
    ADD CONSTRAINT relacion_taxonomica_tipofk FOREIGN KEY (idtipo_reltax) REFERENCES especie.t_tipo_relaciontax(idtipo_reltax);


--
-- Name: t_ambito_distribucion t_ambito_ditribucion_tipoambitofk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_ambito_distribucion
    ADD CONSTRAINT t_ambito_ditribucion_tipoambitofk FOREIGN KEY (idtipoambitodistr) REFERENCES especie.t_tipoambito_ditribucion(idtipoambitodistr);


--
-- Name: t_aplicaa_conservacion t_aplicaa_conservacion_fk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_aplicaa_conservacion
    ADD CONSTRAINT t_aplicaa_conservacion_fk FOREIGN KEY (idautoridad) REFERENCES especie.t_autoridad_conservacion(idautoridad);


--
-- Name: t_aplicaa_nut2 t_aplicaa_nut2_nut2_fk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_aplicaa_nut2
    ADD CONSTRAINT t_aplicaa_nut2_nut2_fk FOREIGN KEY (nut2) REFERENCES comun.t_ccaa(id_ccaa);


--
-- Name: t_aplicaa_nut2 t_aplicaanut2_aplicaa_fk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_aplicaa_nut2
    ADD CONSTRAINT t_aplicaanut2_aplicaa_fk FOREIGN KEY (idaplicaa) REFERENCES especie.t_aplicaa_distribucion(idaplicaa);


--
-- Name: t_aplicaa_distribucion t_aplicadoa_distribucion_fk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_aplicaa_distribucion
    ADD CONSTRAINT t_aplicadoa_distribucion_fk FOREIGN KEY (idambitodistr) REFERENCES especie.t_ambito_distribucion(idambitodistr);


--
-- Name: t_categoria_conservacion t_categoria_conservacion_autoridadfk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_categoria_conservacion
    ADD CONSTRAINT t_categoria_conservacion_autoridadfk FOREIGN KEY (idautoridad) REFERENCES especie.t_autoridad_conservacion(idautoridad);


--
-- Name: t_dataset_medida t_dataset_medida_organismofk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_dataset_medida
    ADD CONSTRAINT t_dataset_medida_organismofk FOREIGN KEY (id_organismo) REFERENCES comun.t_organismo(id_organismo);


--
-- Name: t_dataset t_dataset_t_aplicaa_distribucion; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_dataset
    ADD CONSTRAINT t_dataset_t_aplicaa_distribucion FOREIGN KEY (identidaddistr) REFERENCES especie.t_aplicaa_distribucion(idaplicaa);


--
-- Name: t_dataset t_dataset_tipoambitodistfk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_dataset
    ADD CONSTRAINT t_dataset_tipoambitodistfk FOREIGN KEY (idtipoambitodistr) REFERENCES especie.t_tipoambito_ditribucion(idtipoambitodistr);


--
-- Name: t_dataset t_dataset_tipoambitofk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_dataset
    ADD CONSTRAINT t_dataset_tipoambitofk FOREIGN KEY (idambitogeografico) REFERENCES especie.t_ambito_es(id_ambito_es);


--
-- Name: t_medidaconservacion t_medidaconservacion_tipomedidaconserfk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_medidaconservacion
    ADD CONSTRAINT t_medidaconservacion_tipomedidaconserfk FOREIGN KEY (idtipomedidaconservacion) REFERENCES especie.t_tipomedidaconservacion(idtipomedidaconservacion);


--
-- Name: t_origentaxon t_origentaxon_fk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_origentaxon
    ADD CONSTRAINT t_origentaxon_fk FOREIGN KEY (idfuente) REFERENCES especie.t_fuente(idfuente);


--
-- Name: t_rutaintroduccion t_rutaintroduccion_fk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_rutaintroduccion
    ADD CONSTRAINT t_rutaintroduccion_fk FOREIGN KEY (idfuente) REFERENCES especie.t_fuente(idfuente);


--
-- Name: t_tiponombre t_tiponombre_fk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.t_tiponombre
    ADD CONSTRAINT t_tiponombre_fk FOREIGN KEY (id_agrup_tiponombre) REFERENCES especie.t_agrup_tiponombre(id_agrup_tiponombre);


--
-- Name: taxon taxon_estadotaxonfk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxon
    ADD CONSTRAINT taxon_estadotaxonfk FOREIGN KEY (idestadotaxon) REFERENCES especie.t_estadotaxon(idestadotaxon);


--
-- Name: taxon taxon_idGrupoTax; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxon
    ADD CONSTRAINT "taxon_idGrupoTax" FOREIGN KEY (idgrupotax) REFERENCES comun.t_grupo_taxonomico(id_grupo_taxon) NOT VALID;


--
-- Name: taxon_medicion taxon_medicion_ambitofk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxon_medicion
    ADD CONSTRAINT taxon_medicion_ambitofk FOREIGN KEY (id_ambito_es) REFERENCES especie.t_ambito_es(id_ambito_es);


--
-- Name: taxon_medicion taxon_medicion_aplicaafk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxon_medicion
    ADD CONSTRAINT taxon_medicion_aplicaafk FOREIGN KEY (idaplicadoa) REFERENCES especie.t_aplicaa_distribucion(idaplicaa);


--
-- Name: taxon_medicion taxon_medicion_t_tipo_cambio_fk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxon_medicion
    ADD CONSTRAINT taxon_medicion_t_tipo_cambio_fk FOREIGN KEY (id_tipo_cambio) REFERENCES comun.t_tipo_cambio(id_tipo_cambio);


--
-- Name: taxon_medicion taxon_medicion_valormedfk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxon_medicion
    ADD CONSTRAINT taxon_medicion_valormedfk FOREIGN KEY (id_valor_medida) REFERENCES comun.t_valor_medida(id_valor_medida);


--
-- Name: taxon taxon_origenfk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxon
    ADD CONSTRAINT taxon_origenfk FOREIGN KEY (idorigen) REFERENCES especie.t_origentaxon(idorigen);


--
-- Name: taxondataset taxondataset_ambito_esfk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxondataset
    ADD CONSTRAINT taxondataset_ambito_esfk FOREIGN KEY (id_ambito_es) REFERENCES especie.t_ambito_es(id_ambito_es);


--
-- Name: taxondataset taxondataset_datasetfk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxondataset
    ADD CONSTRAINT taxondataset_datasetfk FOREIGN KEY (iddataset) REFERENCES especie.t_dataset(iddataset);


--
-- Name: taxondataset taxondataset_taxonfk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxondataset
    ADD CONSTRAINT taxondataset_taxonfk FOREIGN KEY (idtaxon) REFERENCES especie.taxon(idtaxon);


--
-- Name: taxondistribucion taxondistribucion_datasetfk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxondistribucion
    ADD CONSTRAINT taxondistribucion_datasetfk FOREIGN KEY (iddataset) REFERENCES especie.t_dataset(iddataset);


--
-- Name: taxondistribucion taxondistribucion_t_fuente_fk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxondistribucion
    ADD CONSTRAINT taxondistribucion_t_fuente_fk FOREIGN KEY (idfuente) REFERENCES especie.t_fuente(idfuente);


--
-- Name: taxondistribucion taxondistribucion_t_tipo_cambio_fk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxondistribucion
    ADD CONSTRAINT taxondistribucion_t_tipo_cambio_fk FOREIGN KEY (id_tipo_cambio) REFERENCES comun.t_tipo_cambio(id_tipo_cambio);


--
-- Name: taxonestadoconservacion taxonestadoconservacion_aplicaafk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonestadoconservacion
    ADD CONSTRAINT taxonestadoconservacion_aplicaafk FOREIGN KEY (idaplicaa) REFERENCES especie.t_aplicaa_conservacion(idaplicaa);


--
-- Name: taxonestadoconservacion taxonestadoconservacion_autoridadfk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonestadoconservacion
    ADD CONSTRAINT taxonestadoconservacion_autoridadfk FOREIGN KEY (idautoridad) REFERENCES especie.t_autoridad_conservacion(idautoridad);


--
-- Name: taxonestadoconservacion taxonestadoconservacion_datasetfk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonestadoconservacion
    ADD CONSTRAINT taxonestadoconservacion_datasetfk FOREIGN KEY (iddataset) REFERENCES especie.t_dataset(iddataset);


--
-- Name: taxonestadoconservacion taxonestadoconservacion_taxonfk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonestadoconservacion
    ADD CONSTRAINT taxonestadoconservacion_taxonfk FOREIGN KEY (idtaxon) REFERENCES especie.taxon(idtaxon);


--
-- Name: taxonestadolegal taxonestadolegal_datasetfk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonestadolegal
    ADD CONSTRAINT taxonestadolegal_datasetfk FOREIGN KEY (iddataset) REFERENCES especie.t_dataset(iddataset);


--
-- Name: taxonestadolegal taxonestadolegal_estadolegalfk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonestadolegal
    ADD CONSTRAINT taxonestadolegal_estadolegalfk FOREIGN KEY (idestadolegal) REFERENCES especie.t_estadolegal(idestadolegal);


--
-- Name: taxonestadolegal taxonestadolegal_taxonfk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonestadolegal
    ADD CONSTRAINT taxonestadolegal_taxonfk FOREIGN KEY (idtaxon) REFERENCES especie.taxon(idtaxon);


--
-- Name: taxonestadolegal taxonestadolegal_tipocambiofk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonestadolegal
    ADD CONSTRAINT taxonestadolegal_tipocambiofk FOREIGN KEY (id_tipo_cambio) REFERENCES comun.t_tipo_cambio(id_tipo_cambio);


--
-- Name: taxonfactoresamenaza taxonfactoresamenaza_datasetfk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonfactoresamenaza
    ADD CONSTRAINT taxonfactoresamenaza_datasetfk FOREIGN KEY (iddataset) REFERENCES especie.t_dataset(iddataset);


--
-- Name: taxonfactoresamenaza taxonfactoresamenaza_factoramefk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonfactoresamenaza
    ADD CONSTRAINT taxonfactoresamenaza_factoramefk FOREIGN KEY (idfactoramenaza) REFERENCES comun.t_presion_amenaza(id_presion);


--
-- Name: taxonfactoresamenaza taxonfactoresamenaza_fk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonfactoresamenaza
    ADD CONSTRAINT taxonfactoresamenaza_fk FOREIGN KEY (idaplicaa) REFERENCES especie.t_aplicaa_distribucion(idaplicaa);


--
-- Name: taxonfactoresamenaza taxonfactoresamenaza_idimportancia_fk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonfactoresamenaza
    ADD CONSTRAINT taxonfactoresamenaza_idimportancia_fk FOREIGN KEY (idimportancia) REFERENCES comun.t_importancia(id_importancia);


--
-- Name: taxonfactoresamenaza taxonfactoresamenaza_taxonfk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonfactoresamenaza
    ADD CONSTRAINT taxonfactoresamenaza_taxonfk FOREIGN KEY (idtaxon) REFERENCES especie.taxon(idtaxon);


--
-- Name: taxonfactoresamenaza taxonfactoresamenaza_tipofk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonfactoresamenaza
    ADD CONSTRAINT taxonfactoresamenaza_tipofk FOREIGN KEY (id_tipo_medicion) REFERENCES comun.t_tipo_medicion(id_tipo_medicion);


--
-- Name: taxonfactoresamenaza taxonfactoresamenaza_tituloamenazafk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonfactoresamenaza
    ADD CONSTRAINT taxonfactoresamenaza_tituloamenazafk FOREIGN KEY (idtituloamenaza) REFERENCES especie.t_tituloamenaza(idtituloamenaza);


--
-- Name: taxonhabitat taxonhabitat_tipocambiofk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonhabitat
    ADD CONSTRAINT taxonhabitat_tipocambiofk FOREIGN KEY (id_tipo_cambio) REFERENCES comun.t_tipo_cambio(id_tipo_cambio);


--
-- Name: taxonmedidaconservacion taxonmedidaconservacion_criteriofk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonmedidaconservacion
    ADD CONSTRAINT taxonmedidaconservacion_criteriofk FOREIGN KEY (idcriterio) REFERENCES especie.t_criteriomedidaconservacion(idcriterio);


--
-- Name: taxonmedidaconservacion taxonmedidaconservacion_importanciafk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonmedidaconservacion
    ADD CONSTRAINT taxonmedidaconservacion_importanciafk FOREIGN KEY (idimportancia) REFERENCES comun.t_importancia(id_importancia);


--
-- Name: taxonmedidaconservacion taxonmedidaconservacion_taxonfk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonmedidaconservacion
    ADD CONSTRAINT taxonmedidaconservacion_taxonfk FOREIGN KEY (idtaxon) REFERENCES especie.taxon(idtaxon);


--
-- Name: taxonmedidaconservacion taxonmedidaconservacion_tipomedidaconservafk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonmedidaconservacion
    ADD CONSTRAINT taxonmedidaconservacion_tipomedidaconservafk FOREIGN KEY (idmedidaconservacion) REFERENCES especie.t_medidaconservacion(idmedidaconservacion);


--
-- Name: taxonnombre taxonnombre_ambitofk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonnombre
    ADD CONSTRAINT taxonnombre_ambitofk FOREIGN KEY (id_ambito_es) REFERENCES especie.t_ambito_es(id_ambito_es);


--
-- Name: taxonnombre taxonnombre_datasetfk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonnombre
    ADD CONSTRAINT taxonnombre_datasetfk FOREIGN KEY (iddataset) REFERENCES especie.t_dataset(iddataset);


--
-- Name: taxonnombre taxonnombre_nomfk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonnombre
    ADD CONSTRAINT taxonnombre_nomfk FOREIGN KEY (idnombre) REFERENCES especie.nombre(idnombre);


--
-- Name: taxonnombre taxonnombre_taxonfk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonnombre
    ADD CONSTRAINT taxonnombre_taxonfk FOREIGN KEY (idtaxon) REFERENCES especie.taxon(idtaxon);


--
-- Name: taxonnombre taxonnombre_tipocambiofk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonnombre
    ADD CONSTRAINT taxonnombre_tipocambiofk FOREIGN KEY (id_tipo_cambio) REFERENCES comun.t_tipo_cambio(id_tipo_cambio);


--
-- Name: taxonnombre taxonnombre_tiponombrefk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonnombre
    ADD CONSTRAINT taxonnombre_tiponombrefk FOREIGN KEY (idtiponombre) REFERENCES especie.t_tiponombre(idtiponombre);


--
-- Name: taxonomia taxonomia_grupotaxfk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonomia
    ADD CONSTRAINT taxonomia_grupotaxfk FOREIGN KEY (idgrupotaxonomico) REFERENCES comun.t_nombre_grupo_taxonomico(id_nombre_grupo_taxon);


--
-- Name: taxonomia taxonomia_nombrefk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonomia
    ADD CONSTRAINT taxonomia_nombrefk FOREIGN KEY (idnombre) REFERENCES especie.nombre(idnombre);


--
-- Name: taxonomia taxonomia_subgrupotaxfk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonomia
    ADD CONSTRAINT taxonomia_subgrupotaxfk FOREIGN KEY (idsubgrupotaxonomico) REFERENCES comun.t_nombre_grupo_taxonomico(id_nombre_grupo_taxon);


--
-- Name: taxonomia taxonomia_taxonrankfk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonomia
    ADD CONSTRAINT taxonomia_taxonrankfk FOREIGN KEY (idtaxonrank) REFERENCES especie.t_taxonrank(idtaxonrank);


--
-- Name: taxonplanesgestion taxonplanesgestion_datasetfk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonplanesgestion
    ADD CONSTRAINT taxonplanesgestion_datasetfk FOREIGN KEY (iddataset) REFERENCES especie.t_dataset(iddataset);


--
-- Name: taxonplanesgestion taxonplanesgestion_idimportancia_fk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonplanesgestion
    ADD CONSTRAINT taxonplanesgestion_idimportancia_fk FOREIGN KEY (idimportancia) REFERENCES comun.t_importancia(id_importancia);


--
-- Name: taxonplanesgestion taxonplanesgestion_normafk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonplanesgestion
    ADD CONSTRAINT taxonplanesgestion_normafk FOREIGN KEY (idnorma) REFERENCES comun.t_norma(id_norma);


--
-- Name: taxonplanesgestion taxonplanesgestion_objetivo_fk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonplanesgestion
    ADD CONSTRAINT taxonplanesgestion_objetivo_fk FOREIGN KEY (idobjetivoplan) REFERENCES especie.t_objetivo_planesgestion(idobjetivoplan);


--
-- Name: taxonplanesgestion taxonplanesgestion_taxonfk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonplanesgestion
    ADD CONSTRAINT taxonplanesgestion_taxonfk FOREIGN KEY (idtaxon) REFERENCES especie.taxon(idtaxon);


--
-- Name: taxonplanesgestion taxonplanesgestion_vigencia_fk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonplanesgestion
    ADD CONSTRAINT taxonplanesgestion_vigencia_fk FOREIGN KEY (idestado_vigencia) REFERENCES comun.t_vigente(idvigente);


--
-- Name: taxonreferencia taxonreferencia_datasetfk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonreferencia
    ADD CONSTRAINT taxonreferencia_datasetfk FOREIGN KEY (iddataset) REFERENCES especie.t_dataset(iddataset);


--
-- Name: taxonreferencia taxonreferencia_taxonfk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonreferencia
    ADD CONSTRAINT taxonreferencia_taxonfk FOREIGN KEY (idtaxon) REFERENCES especie.taxon(idtaxon);


--
-- Name: taxonubicacion taxonubicacion_sistcoord_fk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonubicacion
    ADD CONSTRAINT taxonubicacion_sistcoord_fk FOREIGN KEY (idsistcoord) REFERENCES comun.t_sist_coordenadas(idsistcoord);


--
-- Name: taxonubicacion taxonubicacion_t_dataset_fk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonubicacion
    ADD CONSTRAINT taxonubicacion_t_dataset_fk FOREIGN KEY (iddataset) REFERENCES especie.t_dataset(iddataset);


--
-- Name: taxonubicacion taxonubicacion_taxon_fk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonubicacion
    ADD CONSTRAINT taxonubicacion_taxon_fk FOREIGN KEY (idtaxon) REFERENCES especie.taxon(idtaxon);


--
-- Name: taxonviaintroduccion taxonviaintroduccion_datasetfk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonviaintroduccion
    ADD CONSTRAINT taxonviaintroduccion_datasetfk FOREIGN KEY (iddataset) REFERENCES especie.t_dataset(iddataset);


--
-- Name: taxonviaintroduccion taxonviaintroduccion_rutafk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonviaintroduccion
    ADD CONSTRAINT taxonviaintroduccion_rutafk FOREIGN KEY (idrutaintroduccion) REFERENCES especie.t_rutaintroduccion(idrutaintroduccion);


--
-- Name: taxonviaintroduccion taxonviaintroduccion_taxonfk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.taxonviaintroduccion
    ADD CONSTRAINT taxonviaintroduccion_taxonfk FOREIGN KEY (idtaxon) REFERENCES especie.taxon(idtaxon);


--
-- Name: usos usos_aplicadoafk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.usos
    ADD CONSTRAINT usos_aplicadoafk FOREIGN KEY (idaplicadoa) REFERENCES especie.t_aplicaa_distribucion(idaplicaa);


--
-- Name: usos usos_datasetfk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.usos
    ADD CONSTRAINT usos_datasetfk FOREIGN KEY (iddataset) REFERENCES especie.t_dataset(iddataset);


--
-- Name: usos usos_taxonfk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.usos
    ADD CONSTRAINT usos_taxonfk FOREIGN KEY (idtaxon) REFERENCES especie.taxon(idtaxon);


--
-- Name: usos usos_tipo1fk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.usos
    ADD CONSTRAINT usos_tipo1fk FOREIGN KEY (iduso1) REFERENCES especie.t_tipouso_nivel1(iduso1);


--
-- Name: usos usos_tipo2fk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.usos
    ADD CONSTRAINT usos_tipo2fk FOREIGN KEY (iduso2) REFERENCES especie.t_tipouso_nivel2(iduso2);


--
-- Name: usos usos_tipo3fk; Type: FK CONSTRAINT; Schema: especie; Owner: iepnb
--

ALTER TABLE ONLY especie.usos
    ADD CONSTRAINT usos_tipo3fk FOREIGN KEY (iduso3) REFERENCES especie.t_tipouso_nivel3(iduso3);


--
-- Name: habitat FK_HABITAT_HABITAT_T_AMBITO; Type: FK CONSTRAINT; Schema: habitat; Owner: iepnb
--

ALTER TABLE ONLY habitat.habitat
    ADD CONSTRAINT "FK_HABITAT_HABITAT_T_AMBITO" FOREIGN KEY (cd_ambito) REFERENCES comun.t_ambito(cod_ambito);


--
-- Name: habitat FK_LC_COLECCION_01; Type: FK CONSTRAINT; Schema: habitat; Owner: iepnb
--

ALTER TABLE ONLY habitat.habitat
    ADD CONSTRAINT "FK_LC_COLECCION_01" FOREIGN KEY (id_coleccion) REFERENCES habitat.lc_colecciones(id_coleccion);


--
-- Name: habitat FK_USUARIO_CREA; Type: FK CONSTRAINT; Schema: habitat; Owner: iepnb
--

ALTER TABLE ONLY habitat.habitat
    ADD CONSTRAINT "FK_USUARIO_CREA" FOREIGN KEY (id_usuario_crea_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: lc_colecciones FK_USUARIO_CREA; Type: FK CONSTRAINT; Schema: habitat; Owner: iepnb
--

ALTER TABLE ONLY habitat.lc_colecciones
    ADD CONSTRAINT "FK_USUARIO_CREA" FOREIGN KEY (id_usuario_crea_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: habitat FK_USUARIO_MODIFICA; Type: FK CONSTRAINT; Schema: habitat; Owner: iepnb
--

ALTER TABLE ONLY habitat.habitat
    ADD CONSTRAINT "FK_USUARIO_MODIFICA" FOREIGN KEY (id_usuario_modifica_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: lc_colecciones FK_USUARIO_MODIFICA; Type: FK CONSTRAINT; Schema: habitat; Owner: iepnb
--

ALTER TABLE ONLY habitat.lc_colecciones
    ADD CONSTRAINT "FK_USUARIO_MODIFICA" FOREIGN KEY (id_usuario_modifica_registro) REFERENCES comun.t_usuario(id_usuario) NOT VALID;


--
-- Name: habitat_region_biogeografica fk_habitat_reg_biog_hab; Type: FK CONSTRAINT; Schema: habitat; Owner: iepnb
--

ALTER TABLE ONLY habitat.habitat_region_biogeografica
    ADD CONSTRAINT fk_habitat_reg_biog_hab FOREIGN KEY (id_ieh) REFERENCES habitat.habitat(id_ieh);


--
-- Name: habitat_region_biogeografica fk_habitat_reg_biog_reg; Type: FK CONSTRAINT; Schema: habitat; Owner: iepnb
--

ALTER TABLE ONLY habitat.habitat_region_biogeografica
    ADD CONSTRAINT fk_habitat_reg_biog_reg FOREIGN KEY (id_region_biogeografica) REFERENCES comun.t_region_biogeografica(id_region);


--
-- Name: ocurrencia_muestra FK_OCURREN_MUESTRA_OCUERRENC; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.ocurrencia_muestra
    ADD CONSTRAINT "FK_OCURREN_MUESTRA_OCUERRENC" FOREIGN KEY (cod_ocurencia) REFERENCES seguimiento_especie.ocurrencia(cod_ocurrencia) NOT VALID;


--
-- Name: t_tipo_medicion_darwincore FK_TIPO_MEDICION_DARWINCORE_MEDIC; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.t_tipo_medicion_darwincore
    ADD CONSTRAINT "FK_TIPO_MEDICION_DARWINCORE_MEDIC" FOREIGN KEY (id_tipo_medicion) REFERENCES comun.t_tipo_medicion(id_tipo_medicion) NOT VALID;


--
-- Name: entidad_ejecutora TSEG_ENTIDAD_EJECUTORA_FK1; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.entidad_ejecutora
    ADD CONSTRAINT "TSEG_ENTIDAD_EJECUTORA_FK1" FOREIGN KEY (id_organismo) REFERENCES comun.t_organismo(id_organismo) NOT VALID;


--
-- Name: evento_programa TSEG_EVENTO_PROGRAMA_FK1; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.evento_programa
    ADD CONSTRAINT "TSEG_EVENTO_PROGRAMA_FK1" FOREIGN KEY (id_programa) REFERENCES seguimiento_especie.programa(id_programa);


--
-- Name: evento_programa TSEG_EVENTO_PROGRAMA_FK2; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.evento_programa
    ADD CONSTRAINT "TSEG_EVENTO_PROGRAMA_FK2" FOREIGN KEY (id_evento) REFERENCES seguimiento_especie.evento(id_evento);


--
-- Name: evento_tipo_medicion TSEG_EVENTO_TIPO_MEDICION_FK1; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.evento_tipo_medicion
    ADD CONSTRAINT "TSEG_EVENTO_TIPO_MEDICION_FK1" FOREIGN KEY (id_tipo_medicion) REFERENCES comun.t_tipo_medicion(id_tipo_medicion);


--
-- Name: evento_tipo_medicion TSEG_EVENTO_TIPO_MEDICION_FK2; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.evento_tipo_medicion
    ADD CONSTRAINT "TSEG_EVENTO_TIPO_MEDICION_FK2" FOREIGN KEY (id_evento_programa) REFERENCES seguimiento_especie.evento_programa(id_evento_programa);


--
-- Name: evento_tipo_medicion TSEG_EVENTO_TIPO_MEDICION_FK3; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.evento_tipo_medicion
    ADD CONSTRAINT "TSEG_EVENTO_TIPO_MEDICION_FK3" FOREIGN KEY (id_medic_relaciona_sup) REFERENCES comun.t_tipo_medicion(id_tipo_medicion);


--
-- Name: gis_medicion_linea TSEG_GIS_MEDICION_LINEA_FK1; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.gis_medicion_linea
    ADD CONSTRAINT "TSEG_GIS_MEDICION_LINEA_FK1" FOREIGN KEY (cod_ocurrencia) REFERENCES seguimiento_especie.ocurrencia(cod_ocurrencia);


--
-- Name: gis_medicion_poligon TSEG_GIS_MEDICION_POLIGON_FK1; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.gis_medicion_poligon
    ADD CONSTRAINT "TSEG_GIS_MEDICION_POLIGON_FK1" FOREIGN KEY (cod_ocurencia) REFERENCES seguimiento_especie.ocurrencia(cod_ocurrencia);


--
-- Name: gis_medicion_punto TSEG_GIS_MEDICION_PUNTO_FK1; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.gis_medicion_punto
    ADD CONSTRAINT "TSEG_GIS_MEDICION_PUNTO_FK1" FOREIGN KEY (cod_ocurencia) REFERENCES seguimiento_especie.ocurrencia(cod_ocurrencia);


--
-- Name: programa_entidad_ejecutora TSEG_PROGRAM_ENTID_EJECUT_FK1; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.programa_entidad_ejecutora
    ADD CONSTRAINT "TSEG_PROGRAM_ENTID_EJECUT_FK1" FOREIGN KEY (id_programa) REFERENCES seguimiento_especie.programa(id_programa);


--
-- Name: programa_entidad_ejecutora TSEG_PROGRAM_ENTID_EJECUT_FK2; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.programa_entidad_ejecutora
    ADD CONSTRAINT "TSEG_PROGRAM_ENTID_EJECUT_FK2" FOREIGN KEY (id_entidad_ejecutora) REFERENCES seguimiento_especie.entidad_ejecutora(id_entidad_ejecutora);


--
-- Name: rango_valor TSEG_RANGO_VALOR_FK1; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.rango_valor
    ADD CONSTRAINT "TSEG_RANGO_VALOR_FK1" FOREIGN KEY (id_tipo_medicion) REFERENCES comun.t_tipo_medicion(id_tipo_medicion);


--
-- Name: rango_valor TSEG_RANGO_VALOR_FK2; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.rango_valor
    ADD CONSTRAINT "TSEG_RANGO_VALOR_FK2" FOREIGN KEY (id_evento_programa) REFERENCES seguimiento_especie.evento_programa(id_evento_programa);


--
-- Name: especimen_medicion TSEG_especimen_MED_especimenFK1; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.especimen_medicion
    ADD CONSTRAINT "TSEG_especimen_MED_especimenFK1" FOREIGN KEY (id_especimen) REFERENCES comun.especimen(id_especimen);


--
-- Name: especimen_medicion TSEG_especimen_MED_tipomedFK3; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.especimen_medicion
    ADD CONSTRAINT "TSEG_especimen_MED_tipomedFK3" FOREIGN KEY (id_tipo_medicion) REFERENCES comun.t_tipo_medicion(id_tipo_medicion);


--
-- Name: especimen_medicion TSEG_especimen_MED_valortexto_FK2; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.especimen_medicion
    ADD CONSTRAINT "TSEG_especimen_MED_valortexto_FK2" FOREIGN KEY (id_valor_texto) REFERENCES comun.t_valor_texto(id_valor_texto);


--
-- Name: evento equipo_fk; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.evento
    ADD CONSTRAINT equipo_fk FOREIGN KEY (id_equipo) REFERENCES seguimiento_especie.t_equipo_ejecutor(id_equipo);


--
-- Name: equipo_personas equipo_personas_fk; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.equipo_personas
    ADD CONSTRAINT equipo_personas_fk FOREIGN KEY (id_persona_ejecutora) REFERENCES seguimiento_especie.t_persona_ejecutora(id_persona_ejecutora);


--
-- Name: equipo_personas equipo_personas_t_equipo_ejecutor_fk; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.equipo_personas
    ADD CONSTRAINT equipo_personas_t_equipo_ejecutor_fk FOREIGN KEY (id_equipo) REFERENCES seguimiento_especie.t_equipo_ejecutor(id_equipo);


--
-- Name: especimen_foto especimen_foto_foto_fk; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.especimen_foto
    ADD CONSTRAINT especimen_foto_foto_fk FOREIGN KEY (id_foto) REFERENCES seguimiento_especie.foto(id_foto);


--
-- Name: evento_especificacion evento_especificacion_evento_programa_fk; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.evento_especificacion
    ADD CONSTRAINT evento_especificacion_evento_programa_fk FOREIGN KEY (id_evento_programa) REFERENCES seguimiento_especie.evento_programa(id_evento_programa);


--
-- Name: evento_especificacion evento_especificacion_t_especificacion_fk; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.evento_especificacion
    ADD CONSTRAINT evento_especificacion_t_especificacion_fk FOREIGN KEY (id_especificacion) REFERENCES comun.t_tipo_especificacion(id_especificacion);


--
-- Name: evento_foto evento_foto_evento_fk; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.evento_foto
    ADD CONSTRAINT evento_foto_evento_fk FOREIGN KEY (id_evento) REFERENCES seguimiento_especie.evento(id_evento);


--
-- Name: evento_foto evento_foto_foto_fk; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.evento_foto
    ADD CONSTRAINT evento_foto_foto_fk FOREIGN KEY (id_foto) REFERENCES seguimiento_especie.foto(id_foto);


--
-- Name: evento_medicion evento_medicion_evento_programa_fk; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.evento_medicion
    ADD CONSTRAINT evento_medicion_evento_programa_fk FOREIGN KEY (id_evento_programa) REFERENCES seguimiento_especie.evento_programa(id_evento_programa);


--
-- Name: evento_medicion_multiple evento_medicion_evento_programa_fk; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.evento_medicion_multiple
    ADD CONSTRAINT evento_medicion_evento_programa_fk FOREIGN KEY (id_evento_programa) REFERENCES seguimiento_especie.evento_programa(id_evento_programa);


--
-- Name: evento_medicion evento_medicion_t_tipo_medicion_fk; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.evento_medicion
    ADD CONSTRAINT evento_medicion_t_tipo_medicion_fk FOREIGN KEY (id_tipo_medicion) REFERENCES comun.t_tipo_medicion(id_tipo_medicion);


--
-- Name: evento_medicion_multiple evento_medicion_t_tipo_medicion_fk; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.evento_medicion_multiple
    ADD CONSTRAINT evento_medicion_t_tipo_medicion_fk FOREIGN KEY (id_tipo_medicion) REFERENCES comun.t_tipo_medicion(id_tipo_medicion);


--
-- Name: evento_tipo_especificacion evento_tipo_especificacion_evento_programa_fk; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.evento_tipo_especificacion
    ADD CONSTRAINT evento_tipo_especificacion_evento_programa_fk FOREIGN KEY (id_evento_programa) REFERENCES seguimiento_especie.evento_programa(id_evento_programa);


--
-- Name: evento_tipo_especificacion evento_tipo_especificacion_t_especificacion_fk; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.evento_tipo_especificacion
    ADD CONSTRAINT evento_tipo_especificacion_t_especificacion_fk FOREIGN KEY (id_especificacion) REFERENCES comun.t_tipo_especificacion(id_especificacion);


--
-- Name: evento_valor_texto evento_valor_texto_evento_fk; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.evento_valor_texto
    ADD CONSTRAINT evento_valor_texto_evento_fk FOREIGN KEY (id_evento) REFERENCES seguimiento_especie.evento(id_evento);


--
-- Name: evento_valor_texto evento_valor_texto_habitat_fk; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.evento_valor_texto
    ADD CONSTRAINT evento_valor_texto_habitat_fk FOREIGN KEY (id_habitat) REFERENCES habitat.habitat(id_ieh);


--
-- Name: evento_valor_texto evento_valor_texto_t_medida_conserva_gestion_fk; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.evento_valor_texto
    ADD CONSTRAINT evento_valor_texto_t_medida_conserva_gestion_fk FOREIGN KEY (id_medida) REFERENCES comun.t_medida_conserva_gestion(id_medida);


--
-- Name: evento_valor_texto evento_valor_texto_t_presion_amenaza_fk; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.evento_valor_texto
    ADD CONSTRAINT evento_valor_texto_t_presion_amenaza_fk FOREIGN KEY (id_presion) REFERENCES comun.t_presion_amenaza(id_presion);


--
-- Name: evento_valor_texto evento_valor_texto_t_tipo_medicion_fk; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.evento_valor_texto
    ADD CONSTRAINT evento_valor_texto_t_tipo_medicion_fk FOREIGN KEY (id_tipo_medicion) REFERENCES comun.t_tipo_medicion(id_tipo_medicion);


--
-- Name: evento_valor_texto evento_valor_texto_taxon_fk; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.evento_valor_texto
    ADD CONSTRAINT evento_valor_texto_taxon_fk FOREIGN KEY (id_taxon) REFERENCES especie.taxon(idtaxon);


--
-- Name: evento_valor_texto evento_valortexto_t_contaminante_fk; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.evento_valor_texto
    ADD CONSTRAINT evento_valortexto_t_contaminante_fk FOREIGN KEY (id_contaminante) REFERENCES comun.t_contaminante(id_contaminante);


--
-- Name: especimen_foto fk_espcimen_for_esp; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.especimen_foto
    ADD CONSTRAINT fk_espcimen_for_esp FOREIGN KEY (id_especimen) REFERENCES comun.especimen(id_especimen);


--
-- Name: evento fk_evento_evento; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.evento
    ADD CONSTRAINT fk_evento_evento FOREIGN KEY (idpadre) REFERENCES seguimiento_especie.evento(id_evento);


--
-- Name: evento_medicion fk_evento_medicion_t_valor_texto; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.evento_medicion
    ADD CONSTRAINT fk_evento_medicion_t_valor_texto FOREIGN KEY (id_valor_texto) REFERENCES comun.t_valor_texto(id_valor_texto);


--
-- Name: t_valor_texto_otra_codif_seguimiento fk_id_tipo_medicion; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.t_valor_texto_otra_codif_seguimiento
    ADD CONSTRAINT fk_id_tipo_medicion FOREIGN KEY (id_tipo_medicion) REFERENCES comun.t_tipo_medicion(id_tipo_medicion);


--
-- Name: t_valor_texto_otra_codif_seguimiento fk_id_valor_texto; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.t_valor_texto_otra_codif_seguimiento
    ADD CONSTRAINT fk_id_valor_texto FOREIGN KEY (id_valor_texto) REFERENCES comun.t_valor_texto(id_valor_texto);


--
-- Name: muestra_laboratorio fk_muestra_laboratorio_laboratorio; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.muestra_laboratorio
    ADD CONSTRAINT fk_muestra_laboratorio_laboratorio FOREIGN KEY (id_laboratorio) REFERENCES seguimiento_especie.laboratorio(id_laboratorio);


--
-- Name: ocurrencia fk_ocurrencia_especimen; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.ocurrencia
    ADD CONSTRAINT fk_ocurrencia_especimen FOREIGN KEY (id_especimen) REFERENCES comun.especimen(id_especimen);


--
-- Name: ocurrencia fk_ocurrencia_evento_programa; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.ocurrencia
    ADD CONSTRAINT fk_ocurrencia_evento_programa FOREIGN KEY (id_evento_programa) REFERENCES seguimiento_especie.evento_programa(id_evento_programa);


--
-- Name: ocurrencia_foto fk_ocurrencia_foto_ocurrenca; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.ocurrencia_foto
    ADD CONSTRAINT fk_ocurrencia_foto_ocurrenca FOREIGN KEY (cod_ocurrencia) REFERENCES seguimiento_especie.ocurrencia(cod_ocurrencia) NOT VALID;


--
-- Name: ocurrencia fk_ocurrencia_habitat; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.ocurrencia
    ADD CONSTRAINT fk_ocurrencia_habitat FOREIGN KEY (id_habitat) REFERENCES habitat.habitat(id_ieh) NOT VALID;


--
-- Name: ocurrencia_medicion fk_ocurrencia_medicion_ocurrencia; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.ocurrencia_medicion
    ADD CONSTRAINT fk_ocurrencia_medicion_ocurrencia FOREIGN KEY (cod_ocurrencia) REFERENCES seguimiento_especie.ocurrencia(cod_ocurrencia);


--
-- Name: ocurrencia_medicion_multiple fk_ocurrencia_medicion_ocurrencia; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.ocurrencia_medicion_multiple
    ADD CONSTRAINT fk_ocurrencia_medicion_ocurrencia FOREIGN KEY (cod_ocurrencia) REFERENCES seguimiento_especie.ocurrencia(cod_ocurrencia);


--
-- Name: ocurrencia_medicion fk_ocurrencia_medicion_t_tipo_medicion; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.ocurrencia_medicion
    ADD CONSTRAINT fk_ocurrencia_medicion_t_tipo_medicion FOREIGN KEY (id_tipo_medicion) REFERENCES comun.t_tipo_medicion(id_tipo_medicion);


--
-- Name: ocurrencia_medicion_multiple fk_ocurrencia_medicion_t_tipo_medicion; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.ocurrencia_medicion_multiple
    ADD CONSTRAINT fk_ocurrencia_medicion_t_tipo_medicion FOREIGN KEY (id_tipo_medicion) REFERENCES comun.t_tipo_medicion(id_tipo_medicion);


--
-- Name: ocurrencia_medicion fk_ocurrencia_medicion_t_unidad; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.ocurrencia_medicion
    ADD CONSTRAINT fk_ocurrencia_medicion_t_unidad FOREIGN KEY (id_unidad) REFERENCES comun.t_unidad(id_unidad);


--
-- Name: ocurrencia_medicion_multiple fk_ocurrencia_medicion_t_unidad; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.ocurrencia_medicion_multiple
    ADD CONSTRAINT fk_ocurrencia_medicion_t_unidad FOREIGN KEY (id_unidad) REFERENCES comun.t_unidad(id_unidad);


--
-- Name: ocurrencia fk_ocurrencia_ocurrencia; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.ocurrencia
    ADD CONSTRAINT fk_ocurrencia_ocurrencia FOREIGN KEY (cod_ocurrencia_padre) REFERENCES seguimiento_especie.ocurrencia(cod_ocurrencia);


--
-- Name: ocurrencia fk_ocurrencia_persona_ejecutora; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.ocurrencia
    ADD CONSTRAINT fk_ocurrencia_persona_ejecutora FOREIGN KEY (id_persona_ejecutora) REFERENCES seguimiento_especie.t_persona_ejecutora(id_persona_ejecutora);


--
-- Name: ocurrencia fk_ocurrencia_taxon; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.ocurrencia
    ADD CONSTRAINT fk_ocurrencia_taxon FOREIGN KEY (id_taxon) REFERENCES especie.taxon(idtaxon) NOT VALID;


--
-- Name: CONSTRAINT fk_ocurrencia_taxon ON ocurrencia; Type: COMMENT; Schema: seguimiento_especie; Owner: iepnb
--

COMMENT ON CONSTRAINT fk_ocurrencia_taxon ON seguimiento_especie.ocurrencia IS 'FK ala tabla de especies';


--
-- Name: foto foto_persona_ejecutora_fk; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.foto
    ADD CONSTRAINT foto_persona_ejecutora_fk FOREIGN KEY (id_persona_ejecutora) REFERENCES seguimiento_especie.t_persona_ejecutora(id_persona_ejecutora);


--
-- Name: foto foto_t_contenido_foto_fk; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.foto
    ADD CONSTRAINT foto_t_contenido_foto_fk FOREIGN KEY (id_contenido_foto) REFERENCES seguimiento_especie.t_contenido_foto(id_contenido_foto);


--
-- Name: gis_medicion_linea gis_medicion_linea_evento_fk; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.gis_medicion_linea
    ADD CONSTRAINT gis_medicion_linea_evento_fk FOREIGN KEY (id_evento) REFERENCES seguimiento_especie.evento(id_evento);


--
-- Name: gis_medicion_linea gis_medicion_linea_tipo_medic_fk; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.gis_medicion_linea
    ADD CONSTRAINT gis_medicion_linea_tipo_medic_fk FOREIGN KEY (id_tipo_medicion) REFERENCES comun.t_tipo_medicion(id_tipo_medicion);


--
-- Name: gis_medicion_linea gis_medicion_linea_unidad_fk; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.gis_medicion_linea
    ADD CONSTRAINT gis_medicion_linea_unidad_fk FOREIGN KEY (id_unidad_medida) REFERENCES comun.t_unidad(id_unidad);


--
-- Name: gis_medicion_poligon gis_medicion_poligon_evento_fk; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.gis_medicion_poligon
    ADD CONSTRAINT gis_medicion_poligon_evento_fk FOREIGN KEY (id_evento) REFERENCES seguimiento_especie.evento(id_evento);


--
-- Name: gis_medicion_poligon gis_medicion_poligon_tipo_medic_fk; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.gis_medicion_poligon
    ADD CONSTRAINT gis_medicion_poligon_tipo_medic_fk FOREIGN KEY (id_tipo_medicion) REFERENCES comun.t_tipo_medicion(id_tipo_medicion);


--
-- Name: gis_medicion_poligon gis_medicion_poligon_unidad_fk; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.gis_medicion_poligon
    ADD CONSTRAINT gis_medicion_poligon_unidad_fk FOREIGN KEY (id_unidad_medida) REFERENCES comun.t_unidad(id_unidad);


--
-- Name: gis_medicion_punto gis_medicion_punto_evento_fk; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.gis_medicion_punto
    ADD CONSTRAINT gis_medicion_punto_evento_fk FOREIGN KEY (id_evento) REFERENCES seguimiento_especie.evento(id_evento);


--
-- Name: gis_medicion_punto gis_medicion_punto_tipo_medicion_fk; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.gis_medicion_punto
    ADD CONSTRAINT gis_medicion_punto_tipo_medicion_fk FOREIGN KEY (id_tipo_medicion) REFERENCES comun.t_tipo_medicion(id_tipo_medicion);


--
-- Name: gis_medicion_punto gis_medicion_punto_unidad_fk; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.gis_medicion_punto
    ADD CONSTRAINT gis_medicion_punto_unidad_fk FOREIGN KEY (id_unidad_medida) REFERENCES comun.t_unidad(id_unidad);


--
-- Name: ocurrencia id_importancia_fk; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.ocurrencia
    ADD CONSTRAINT id_importancia_fk FOREIGN KEY (id_importancia) REFERENCES comun.t_importancia(id_importancia);


--
-- Name: ocurrencia idnombre_fk; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.ocurrencia
    ADD CONSTRAINT idnombre_fk FOREIGN KEY (idnombre) REFERENCES especie.nombre(idnombre);


--
-- Name: muestra_taxon muestra_taxon_fk; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.muestra_taxon
    ADD CONSTRAINT muestra_taxon_fk FOREIGN KEY (id_taxon) REFERENCES especie.taxon(idtaxon);


--
-- Name: muestra_taxon muestra_taxon_ocurrencia_fk; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.muestra_taxon
    ADD CONSTRAINT muestra_taxon_ocurrencia_fk FOREIGN KEY (cod_muestra) REFERENCES seguimiento_especie.ocurrencia_muestra(cod_muestra);


--
-- Name: ocurrencia_especificacion ocurrencia_especificacion_cod_ocurrencia_fkey; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.ocurrencia_especificacion
    ADD CONSTRAINT ocurrencia_especificacion_cod_ocurrencia_fkey FOREIGN KEY (cod_ocurrencia) REFERENCES seguimiento_especie.ocurrencia(cod_ocurrencia);


--
-- Name: ocurrencia_especificacion ocurrencia_especificacion_id_especificacion_fkey; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.ocurrencia_especificacion
    ADD CONSTRAINT ocurrencia_especificacion_id_especificacion_fkey FOREIGN KEY (id_especificacion) REFERENCES comun.t_tipo_especificacion(id_especificacion);


--
-- Name: ocurrencia_foto ocurrencia_foto_fk; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.ocurrencia_foto
    ADD CONSTRAINT ocurrencia_foto_fk FOREIGN KEY (id_persona_ejecutora) REFERENCES seguimiento_especie.t_persona_ejecutora(id_persona_ejecutora);


--
-- Name: ocurrencia_foto ocurrencia_foto_foto_fk; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.ocurrencia_foto
    ADD CONSTRAINT ocurrencia_foto_foto_fk FOREIGN KEY (id_foto) REFERENCES seguimiento_especie.foto(id_foto);


--
-- Name: ocurrencia ocurrencia_importanciafk; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.ocurrencia
    ADD CONSTRAINT ocurrencia_importanciafk FOREIGN KEY (id_importancia) REFERENCES comun.t_importancia(id_importancia);


--
-- Name: ocurrencia_medicion_multiple ocurrencia_medicion_importancia_fk; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.ocurrencia_medicion_multiple
    ADD CONSTRAINT ocurrencia_medicion_importancia_fk FOREIGN KEY (id_tipo_medicion) REFERENCES comun.t_tipo_medicion(id_tipo_medicion);


--
-- Name: ocurrencia_valor_texto ocurrencia_valortexto_fk; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.ocurrencia_valor_texto
    ADD CONSTRAINT ocurrencia_valortexto_fk FOREIGN KEY (cod_ocurrencia) REFERENCES seguimiento_especie.ocurrencia(cod_ocurrencia);


--
-- Name: ocurrencia_valor_texto ocurrencia_valortexto_fk_1; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.ocurrencia_valor_texto
    ADD CONSTRAINT ocurrencia_valortexto_fk_1 FOREIGN KEY (id_tipo_medicion) REFERENCES comun.t_tipo_medicion(id_tipo_medicion);


--
-- Name: ocurrencia_valor_texto ocurrencia_valortexto_fk_2; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.ocurrencia_valor_texto
    ADD CONSTRAINT ocurrencia_valortexto_fk_2 FOREIGN KEY (id_habitat) REFERENCES habitat.habitat(id_ieh);


--
-- Name: ocurrencia_valor_texto ocurrencia_valortexto_fk_3; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.ocurrencia_valor_texto
    ADD CONSTRAINT ocurrencia_valortexto_fk_3 FOREIGN KEY (id_contaminante) REFERENCES comun.t_contaminante(id_contaminante);


--
-- Name: ocurrencia_valor_texto ocurrencia_valortexto_fk_4; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.ocurrencia_valor_texto
    ADD CONSTRAINT ocurrencia_valortexto_fk_4 FOREIGN KEY (id_medida) REFERENCES comun.t_medida_conserva_gestion(id_medida);


--
-- Name: ocurrencia_valor_texto ocurrencia_valortexto_fk_5; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.ocurrencia_valor_texto
    ADD CONSTRAINT ocurrencia_valortexto_fk_5 FOREIGN KEY (id_presion) REFERENCES comun.t_presion_amenaza(id_presion);


--
-- Name: ocurrencia_valor_texto ocurrencia_valortexto_fk_6; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.ocurrencia_valor_texto
    ADD CONSTRAINT ocurrencia_valortexto_fk_6 FOREIGN KEY (id_taxon) REFERENCES especie.taxon(idtaxon);


--
-- Name: evento persona_ejecutora_fk; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.evento
    ADD CONSTRAINT persona_ejecutora_fk FOREIGN KEY (id_persona_ejecutora) REFERENCES seguimiento_especie.t_persona_ejecutora(id_persona_ejecutora);


--
-- Name: ocurrencia_medicion_multiple presion_fk; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.ocurrencia_medicion_multiple
    ADD CONSTRAINT presion_fk FOREIGN KEY (id_presion) REFERENCES comun.t_presion_amenaza(id_presion);


--
-- Name: evento programa_fk; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.evento
    ADD CONSTRAINT programa_fk FOREIGN KEY (id_programa) REFERENCES seguimiento_especie.programa(id_programa);


--
-- Name: programa programa_organismo_aplicacion_fk; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.programa
    ADD CONSTRAINT programa_organismo_aplicacion_fk FOREIGN KEY (id_org_app) REFERENCES comun.organismo_aplicacion(id_org_app);


--
-- Name: programa programa_t_grupo_taxonomico_fk; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.programa
    ADD CONSTRAINT programa_t_grupo_taxonomico_fk FOREIGN KEY (id_grupo_taxonomico) REFERENCES comun.t_grupo_taxonomico(id_grupo_taxon);


--
-- Name: t_gis_linea t_gis_linea_ocurrencia_fk; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.t_gis_linea
    ADD CONSTRAINT t_gis_linea_ocurrencia_fk FOREIGN KEY (cod_ocurrencia) REFERENCES seguimiento_especie.ocurrencia(cod_ocurrencia);


--
-- Name: t_gis_linea t_gis_linea_t_tipo_medicion_fk; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.t_gis_linea
    ADD CONSTRAINT t_gis_linea_t_tipo_medicion_fk FOREIGN KEY (id_tipo_medicion) REFERENCES comun.t_tipo_medicion(id_tipo_medicion);


--
-- Name: t_gis_poligon t_gis_poligon_ocurrencia_fk; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.t_gis_poligon
    ADD CONSTRAINT t_gis_poligon_ocurrencia_fk FOREIGN KEY (cod_ocurrencia) REFERENCES seguimiento_especie.ocurrencia(cod_ocurrencia);


--
-- Name: t_gis_poligon t_gis_poligon_t_tipo_medicion_fk; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.t_gis_poligon
    ADD CONSTRAINT t_gis_poligon_t_tipo_medicion_fk FOREIGN KEY (id_tipo_medicion) REFERENCES comun.t_tipo_medicion(id_tipo_medicion);


--
-- Name: t_gis_punto t_gis_punto_ocurrencia_fk; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.t_gis_punto
    ADD CONSTRAINT t_gis_punto_ocurrencia_fk FOREIGN KEY (cod_ocurrencia) REFERENCES seguimiento_especie.ocurrencia(cod_ocurrencia);


--
-- Name: t_gis_punto t_gis_punto_t_tipo_medicion_fk; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.t_gis_punto
    ADD CONSTRAINT t_gis_punto_t_tipo_medicion_fk FOREIGN KEY (id_tipo_medicion) REFERENCES comun.t_tipo_medicion(id_tipo_medicion);


--
-- Name: t_persona_ejecutora t_tipo_persona_ejecutora_t_tipo_persona_ejecutora_fk; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.t_persona_ejecutora
    ADD CONSTRAINT t_tipo_persona_ejecutora_t_tipo_persona_ejecutora_fk FOREIGN KEY (id_tipo_persona) REFERENCES seguimiento_especie.t_tipo_persona_ejecutora(id_tipo_persona);


--
-- Name: muestra_medicion tseg_muestra_medicion_muestra_fk; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.muestra_medicion
    ADD CONSTRAINT tseg_muestra_medicion_muestra_fk FOREIGN KEY (cod_muestra) REFERENCES seguimiento_especie.ocurrencia_muestra(cod_muestra);


--
-- Name: muestra_medicion tseg_muestra_tipo_medicion_fk; Type: FK CONSTRAINT; Schema: seguimiento_especie; Owner: iepnb
--

ALTER TABLE ONLY seguimiento_especie.muestra_medicion
    ADD CONSTRAINT tseg_muestra_tipo_medicion_fk FOREIGN KEY (id_tipo_medicion) REFERENCES comun.t_tipo_medicion(id_tipo_medicion);


--
-- Name: SCHEMA comun; Type: ACL; Schema: -; Owner: iepnb
--

GRANT USAGE ON SCHEMA comun TO iepnb_app;
GRANT ALL ON SCHEMA comun TO iepnb_model;
GRANT USAGE ON SCHEMA comun TO sit;


--
-- Name: SCHEMA especie; Type: ACL; Schema: -; Owner: iepnb
--

GRANT USAGE ON SCHEMA especie TO iepnb_app;
GRANT ALL ON SCHEMA especie TO iepnb_model;
GRANT USAGE ON SCHEMA especie TO sit;


--
-- Name: SCHEMA habitat; Type: ACL; Schema: -; Owner: iepnb
--

GRANT USAGE ON SCHEMA habitat TO iepnb_app;
GRANT ALL ON SCHEMA habitat TO iepnb_model;
GRANT USAGE ON SCHEMA habitat TO sit;


--
-- Name: SCHEMA seguimiento_especie; Type: ACL; Schema: -; Owner: iepnb
--

GRANT USAGE ON SCHEMA seguimiento_especie TO iepnb_app;
GRANT ALL ON SCHEMA seguimiento_especie TO iepnb_model;
GRANT USAGE ON SCHEMA seguimiento_especie TO sit;


--
-- Name: FUNCTION update_text_geometry(id numeric); Type: ACL; Schema: seguimiento_especie; Owner: iepnb
--

GRANT ALL ON FUNCTION seguimiento_especie.update_text_geometry(id numeric) TO iepnb_app;


--
-- Name: FUNCTION wkt_gis_geometria(); Type: ACL; Schema: seguimiento_especie; Owner: iepnb
--

GRANT ALL ON FUNCTION seguimiento_especie.wkt_gis_geometria() TO iepnb_app;


--
-- Name: TABLE ccaa_elemento_toponimo; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.ccaa_elemento_toponimo TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.ccaa_elemento_toponimo TO iepnb_model;


--
-- Name: TABLE coleccion_medida; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.coleccion_medida TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.coleccion_medida TO iepnb_model;


--
-- Name: TABLE documento; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.documento TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.documento TO iepnb_model;


--
-- Name: SEQUENCE especimen_sec; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT ALL ON SEQUENCE comun.especimen_sec TO iepnb_app;
GRANT ALL ON SEQUENCE comun.especimen_sec TO iepnb_model;


--
-- Name: TABLE especimen; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.especimen TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.especimen TO iepnb_model;


--
-- Name: TABLE grupo_taxon_eidos_otros; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.grupo_taxon_eidos_otros TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.grupo_taxon_eidos_otros TO iepnb_model;


--
-- Name: TABLE listado_provisonal_org_distintos; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.listado_provisonal_org_distintos TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.listado_provisonal_org_distintos TO iepnb_model;


--
-- Name: TABLE medida_conservacion_norma; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.medida_conservacion_norma TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.medida_conservacion_norma TO iepnb_model;


--
-- Name: TABLE norma_ccaa; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.norma_ccaa TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.norma_ccaa TO iepnb_model;


--
-- Name: TABLE norma_componente; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.norma_componente TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.norma_componente TO iepnb_model;


--
-- Name: TABLE norma_elemento_toponimo; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.norma_elemento_toponimo TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.norma_elemento_toponimo TO iepnb_model;


--
-- Name: TABLE norma_norma; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.norma_norma TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.norma_norma TO iepnb_model;


--
-- Name: TABLE norma_tema; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.norma_tema TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.norma_tema TO iepnb_model;


--
-- Name: SEQUENCE sec_organismo_ambito_aplica; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT ALL ON SEQUENCE comun.sec_organismo_ambito_aplica TO iepnb_app;
GRANT ALL ON SEQUENCE comun.sec_organismo_ambito_aplica TO iepnb_model;


--
-- Name: TABLE organismo_ambito_aplica; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.organismo_ambito_aplica TO iepnb_app;
GRANT ALL ON TABLE comun.organismo_ambito_aplica TO iepnb_model;


--
-- Name: TABLE organismo_aplicacion; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.organismo_aplicacion TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.organismo_aplicacion TO iepnb_model;


--
-- Name: TABLE organismo_ccaa; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.organismo_ccaa TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.organismo_ccaa TO iepnb_model;


--
-- Name: TABLE organismo_organismo; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.organismo_organismo TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.organismo_organismo TO iepnb_model;


--
-- Name: TABLE organismo_provincia; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.organismo_provincia TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.organismo_provincia TO iepnb_model;


--
-- Name: SEQUENCE sec_perfil_funcionalidad; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT ALL ON SEQUENCE comun.sec_perfil_funcionalidad TO iepnb_app;
GRANT ALL ON SEQUENCE comun.sec_perfil_funcionalidad TO iepnb_model;


--
-- Name: TABLE perfil_funcionalidad; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.perfil_funcionalidad TO iepnb_app;
GRANT ALL ON TABLE comun.perfil_funcionalidad TO iepnb_model;


--
-- Name: TABLE presion_amenaza_organismo; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.presion_amenaza_organismo TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.presion_amenaza_organismo TO iepnb_model;


--
-- Name: SEQUENCE sec_revision_info; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT ALL ON SEQUENCE comun.sec_revision_info TO iepnb_app;
GRANT ALL ON SEQUENCE comun.sec_revision_info TO iepnb_model;


--
-- Name: TABLE revision_info; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.revision_info TO iepnb_app;
GRANT ALL ON TABLE comun.revision_info TO iepnb_model;


--
-- Name: TABLE revtype; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.revtype TO iepnb_app;
GRANT ALL ON TABLE comun.revtype TO iepnb_model;


--
-- Name: SEQUENCE sec_casticket; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT ALL ON SEQUENCE comun.sec_casticket TO iepnb_app;


--
-- Name: SEQUENCE sec_catalogo; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT ALL ON SEQUENCE comun.sec_catalogo TO iepnb_app;
GRANT ALL ON SEQUENCE comun.sec_catalogo TO iepnb_model;


--
-- Name: SEQUENCE sec_funcionalidad; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT ALL ON SEQUENCE comun.sec_funcionalidad TO iepnb_app;
GRANT ALL ON SEQUENCE comun.sec_funcionalidad TO iepnb_model;


--
-- Name: SEQUENCE sec_id_ambito_t_ambito; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT ALL ON SEQUENCE comun.sec_id_ambito_t_ambito TO iepnb_app;
GRANT ALL ON SEQUENCE comun.sec_id_ambito_t_ambito TO iepnb_model;


--
-- Name: SEQUENCE sec_id_certificado_digital; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT ALL ON SEQUENCE comun.sec_id_certificado_digital TO iepnb_app;
GRANT ALL ON SEQUENCE comun.sec_id_certificado_digital TO iepnb_model;


--
-- Name: SEQUENCE sec_id_normativa; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT ALL ON SEQUENCE comun.sec_id_normativa TO iepnb_app;
GRANT ALL ON SEQUENCE comun.sec_id_normativa TO iepnb_model;


--
-- Name: SEQUENCE sec_id_normativarelacionada; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT ALL ON SEQUENCE comun.sec_id_normativarelacionada TO iepnb_app;
GRANT ALL ON SEQUENCE comun.sec_id_normativarelacionada TO iepnb_model;


--
-- Name: SEQUENCE sec_id_tiporelacionnormativa; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT ALL ON SEQUENCE comun.sec_id_tiporelacionnormativa TO iepnb_app;
GRANT ALL ON SEQUENCE comun.sec_id_tiporelacionnormativa TO iepnb_model;


--
-- Name: SEQUENCE sec_medida; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT ALL ON SEQUENCE comun.sec_medida TO iepnb_app;
GRANT ALL ON SEQUENCE comun.sec_medida TO iepnb_model;


--
-- Name: SEQUENCE sec_normas; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT ALL ON SEQUENCE comun.sec_normas TO iepnb_app;
GRANT ALL ON SEQUENCE comun.sec_normas TO iepnb_model;


--
-- Name: SEQUENCE sec_organismo_aplicacion; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT ALL ON SEQUENCE comun.sec_organismo_aplicacion TO iepnb_app;
GRANT ALL ON SEQUENCE comun.sec_organismo_aplicacion TO iepnb_model;


--
-- Name: SEQUENCE sec_organismos; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT ALL ON SEQUENCE comun.sec_organismos TO iepnb_app;
GRANT ALL ON SEQUENCE comun.sec_organismos TO iepnb_model;


--
-- Name: SEQUENCE sec_origen; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT ALL ON SEQUENCE comun.sec_origen TO iepnb_app;
GRANT ALL ON SEQUENCE comun.sec_origen TO iepnb_model;


--
-- Name: SEQUENCE sec_parametro_configuracion; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT ALL ON SEQUENCE comun.sec_parametro_configuracion TO iepnb_app;
GRANT ALL ON SEQUENCE comun.sec_parametro_configuracion TO iepnb_model;


--
-- Name: SEQUENCE sec_perfil; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT ALL ON SEQUENCE comun.sec_perfil TO iepnb_app;
GRANT ALL ON SEQUENCE comun.sec_perfil TO iepnb_model;


--
-- Name: SEQUENCE sec_t_tipo_plan; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT ALL ON SEQUENCE comun.sec_t_tipo_plan TO iepnb_app;


--
-- Name: SEQUENCE sec_usuarios; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT ALL ON SEQUENCE comun.sec_usuarios TO iepnb_app;
GRANT ALL ON SEQUENCE comun.sec_usuarios TO iepnb_model;


--
-- Name: SEQUENCE sec_visible; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT ALL ON SEQUENCE comun.sec_visible TO iepnb_app;


--
-- Name: TABLE t_ambito; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_ambito TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.t_ambito TO iepnb_model;


--
-- Name: TABLE t_ambito_aplica; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_ambito_aplica TO iepnb_app;
GRANT ALL ON TABLE comun.t_ambito_aplica TO iepnb_model;


--
-- Name: TABLE t_ambito_nivel_geografico_politico; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_ambito_nivel_geografico_politico TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.t_ambito_nivel_geografico_politico TO iepnb_model;


--
-- Name: TABLE t_aplicacion; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_aplicacion TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.t_aplicacion TO iepnb_model;


--
-- Name: TABLE t_catalogo; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_catalogo TO iepnb_app;
GRANT ALL ON TABLE comun.t_catalogo TO iepnb_model;


--
-- Name: TABLE t_categoria_medida_conservacion; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_categoria_medida_conservacion TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.t_categoria_medida_conservacion TO iepnb_model;


--
-- Name: TABLE t_ccaa; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_ccaa TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.t_ccaa TO iepnb_model;


--
-- Name: TABLE t_clasif_objetivo_norma; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_clasif_objetivo_norma TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.t_clasif_objetivo_norma TO iepnb_model;


--
-- Name: TABLE t_componente; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_componente TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.t_componente TO iepnb_model;


--
-- Name: TABLE t_contaminante; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_contaminante TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.t_contaminante TO iepnb_model;


--
-- Name: TABLE t_elemento_toponomico; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_elemento_toponomico TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.t_elemento_toponomico TO iepnb_model;


--
-- Name: TABLE t_estado_conserva_otras_codif; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_estado_conserva_otras_codif TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.t_estado_conserva_otras_codif TO iepnb_model;


--
-- Name: TABLE t_fuente_presion_amenaza; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_fuente_presion_amenaza TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.t_fuente_presion_amenaza TO iepnb_model;


--
-- Name: TABLE t_funcionalidad; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_funcionalidad TO iepnb_app;
GRANT ALL ON TABLE comun.t_funcionalidad TO iepnb_model;


--
-- Name: TABLE t_grupo_taxonomico; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_grupo_taxonomico TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.t_grupo_taxonomico TO iepnb_model;


--
-- Name: TABLE t_idioma; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_idioma TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.t_idioma TO iepnb_model;


--
-- Name: TABLE t_impacto; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_impacto TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.t_impacto TO iepnb_model;


--
-- Name: TABLE t_importancia; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_importancia TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.t_importancia TO iepnb_model;


--
-- Name: TABLE t_localidad; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_localidad TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.t_localidad TO iepnb_model;


--
-- Name: TABLE t_medida_conserva_gestion; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_medida_conserva_gestion TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.t_medida_conserva_gestion TO iepnb_model;


--
-- Name: TABLE t_municipio; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_municipio TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.t_municipio TO iepnb_model;


--
-- Name: TABLE t_nombre_grupo_taxonomico; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_nombre_grupo_taxonomico TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.t_nombre_grupo_taxonomico TO iepnb_model;


--
-- Name: TABLE t_nombre_toponimia; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_nombre_toponimia TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.t_nombre_toponimia TO iepnb_model;


--
-- Name: TABLE t_norma; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_norma TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.t_norma TO iepnb_model;


--
-- Name: TABLE t_nut; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_nut TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.t_nut TO iepnb_model;


--
-- Name: TABLE t_organismo; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_organismo TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.t_organismo TO iepnb_model;


--
-- Name: TABLE t_origen; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_origen TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.t_origen TO iepnb_model;


--
-- Name: TABLE t_parametro_configuracion; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_parametro_configuracion TO iepnb_app;
GRANT ALL ON TABLE comun.t_parametro_configuracion TO iepnb_model;


--
-- Name: TABLE t_perfil; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_perfil TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.t_perfil TO iepnb_model;


--
-- Name: TABLE t_presion_amenaza; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_presion_amenaza TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.t_presion_amenaza TO iepnb_model;


--
-- Name: TABLE t_provincia; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_provincia TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.t_provincia TO iepnb_model;


--
-- Name: TABLE t_punto_cardinal; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_punto_cardinal TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.t_punto_cardinal TO iepnb_model;


--
-- Name: TABLE t_rango_norma_inf; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_rango_norma_inf TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.t_rango_norma_inf TO iepnb_model;


--
-- Name: TABLE t_rango_norma_int; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_rango_norma_int TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.t_rango_norma_int TO iepnb_model;


--
-- Name: TABLE t_rango_norma_sup; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_rango_norma_sup TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.t_rango_norma_sup TO iepnb_model;


--
-- Name: TABLE taxonnombre; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.taxonnombre TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.taxonnombre TO iepnb_model;


--
-- Name: SEQUENCE sec_id_taxonnombre; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT ALL ON SEQUENCE especie.sec_id_taxonnombre TO iepnb_app;


--
-- Name: TABLE t_ref_bibliografica; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_ref_bibliografica TO iepnb_app;
GRANT ALL ON TABLE comun.t_ref_bibliografica TO iepnb_model;


--
-- Name: TABLE t_region_biogeografica; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_region_biogeografica TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.t_region_biogeografica TO iepnb_model;


--
-- Name: TABLE t_relacion_espacial; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_relacion_espacial TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.t_relacion_espacial TO iepnb_model;


--
-- Name: TABLE t_sexo; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_sexo TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.t_sexo TO iepnb_model;


--
-- Name: TABLE t_sist_coordenadas; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_sist_coordenadas TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.t_sist_coordenadas TO iepnb_model;


--
-- Name: TABLE t_tema; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_tema TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.t_tema TO iepnb_model;


--
-- Name: TABLE t_tipo_cambio; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_tipo_cambio TO iepnb_app;


--
-- Name: TABLE t_tipo_documento; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_tipo_documento TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.t_tipo_documento TO iepnb_model;


--
-- Name: TABLE t_tipo_especif_valor_texto; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_tipo_especif_valor_texto TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.t_tipo_especif_valor_texto TO iepnb_model;


--
-- Name: TABLE t_tipo_especificacion; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_tipo_especificacion TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.t_tipo_especificacion TO iepnb_model;


--
-- Name: TABLE t_tipo_estado_conservacion; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_tipo_estado_conservacion TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.t_tipo_estado_conservacion TO iepnb_model;


--
-- Name: TABLE t_tipo_geometria_carto; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_tipo_geometria_carto TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.t_tipo_geometria_carto TO iepnb_model;


--
-- Name: TABLE t_tipo_medic_valor_texto; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_tipo_medic_valor_texto TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.t_tipo_medic_valor_texto TO iepnb_model;


--
-- Name: TABLE t_tipo_medicion; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_tipo_medicion TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.t_tipo_medicion TO iepnb_model;


--
-- Name: TABLE t_tipo_norma; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_tipo_norma TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.t_tipo_norma TO iepnb_model;


--
-- Name: TABLE t_tipo_organismo; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT ON TABLE comun.t_tipo_organismo TO sit;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.t_tipo_organismo TO iepnb_app;
GRANT ALL ON TABLE comun.t_tipo_organismo TO iepnb_model;


--
-- Name: TABLE t_tipo_plan; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_tipo_plan TO iepnb_app;
GRANT ALL ON TABLE comun.t_tipo_plan TO iepnb_model;


--
-- Name: TABLE t_tipo_relacion_norma; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_tipo_relacion_norma TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.t_tipo_relacion_norma TO iepnb_model;


--
-- Name: TABLE t_tipo_relieve; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_tipo_relieve TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.t_tipo_relieve TO iepnb_model;


--
-- Name: TABLE t_tipo_toponimia; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_tipo_toponimia TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.t_tipo_toponimia TO iepnb_model;


--
-- Name: TABLE t_tipo_verificacion_documento; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT ON TABLE comun.t_tipo_verificacion_documento TO sit;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.t_tipo_verificacion_documento TO iepnb_app;
GRANT ALL ON TABLE comun.t_tipo_verificacion_documento TO iepnb_model;


--
-- Name: TABLE t_tipopropiedad; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_tipopropiedad TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.t_tipopropiedad TO iepnb_model;


--
-- Name: TABLE t_unidad; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_unidad TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.t_unidad TO iepnb_model;


--
-- Name: TABLE t_unidad_otra_codif; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_unidad_otra_codif TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.t_unidad_otra_codif TO iepnb_model;


--
-- Name: TABLE t_usuario; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_usuario TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.t_usuario TO iepnb_model;


--
-- Name: TABLE t_valor_medida; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_valor_medida TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.t_valor_medida TO iepnb_model;


--
-- Name: TABLE t_valor_texto; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_valor_texto TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.t_valor_texto TO iepnb_model;


--
-- Name: TABLE t_valor_texto_otra_codif; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_valor_texto_otra_codif TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.t_valor_texto_otra_codif TO iepnb_model;


--
-- Name: SEQUENCE sec_id_vigencia; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT ALL ON SEQUENCE especie.sec_id_vigencia TO iepnb_app;


--
-- Name: TABLE t_vigente; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_vigente TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.t_vigente TO iepnb_model;


--
-- Name: TABLE t_visible; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.t_visible TO iepnb_app;
GRANT ALL ON TABLE comun.t_visible TO iepnb_model;


--
-- Name: TABLE unidad_tipo_medicion; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.unidad_tipo_medicion TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE comun.unidad_tipo_medicion TO iepnb_model;


--
-- Name: TABLE v_t_parametro_configuracion; Type: ACL; Schema: comun; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE comun.v_t_parametro_configuracion TO iepnb_app;
GRANT ALL ON TABLE comun.v_t_parametro_configuracion TO iepnb_model;


--
-- Name: TABLE atributo_taxon; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.atributo_taxon TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.atributo_taxon TO iepnb_model;


--
-- Name: TABLE endemismo; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.endemismo TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.endemismo TO iepnb_model;


--
-- Name: SEQUENCE sec_id_grupocoleccion; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT ALL ON SEQUENCE especie.sec_id_grupocoleccion TO iepnb_app;


--
-- Name: TABLE grupodataset; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.grupodataset TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.grupodataset TO iepnb_model;


--
-- Name: TABLE grupolegislacion; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.grupolegislacion TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.grupolegislacion TO iepnb_model;


--
-- Name: SEQUENCE sec_id_taxoncoleccion; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT ALL ON SEQUENCE especie.sec_id_taxoncoleccion TO iepnb_app;


--
-- Name: TABLE lp_fotofija; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.lp_fotofija TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.lp_fotofija TO iepnb_model;


--
-- Name: TABLE lp_fuentereferencias; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.lp_fuentereferencias TO iepnb_app;
GRANT ALL ON TABLE especie.lp_fuentereferencias TO iepnb_model;


--
-- Name: SEQUENCE sec_lp_origen; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT ALL ON SEQUENCE especie.sec_lp_origen TO iepnb_app;
GRANT ALL ON SEQUENCE especie.sec_lp_origen TO iepnb_model;


--
-- Name: TABLE lp_origen; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.lp_origen TO iepnb_app;
GRANT ALL ON TABLE especie.lp_origen TO iepnb_model;


--
-- Name: TABLE lp_sociedades; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.lp_sociedades TO iepnb_app;
GRANT ALL ON TABLE especie.lp_sociedades TO iepnb_model;


--
-- Name: TABLE nombre; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.nombre TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.nombre TO iepnb_model;


--
-- Name: SEQUENCE sec_id_nombrecodigoexterno; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT ALL ON SEQUENCE especie.sec_id_nombrecodigoexterno TO iepnb_app;


--
-- Name: TABLE nombrecodigosexternos; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.nombrecodigosexternos TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.nombrecodigosexternos TO iepnb_model;


--
-- Name: SEQUENCE sec_id_grupotax; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT ALL ON SEQUENCE especie.sec_id_grupotax TO iepnb_app;


--
-- Name: TABLE nombrepreferencia; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.nombrepreferencia TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.nombrepreferencia TO iepnb_model;


--
-- Name: SEQUENCE sec_id_plinian; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT ALL ON SEQUENCE especie.sec_id_plinian TO iepnb_app;


--
-- Name: TABLE "pliniancore-extension"; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie."pliniancore-extension" TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie."pliniancore-extension" TO iepnb_model;


--
-- Name: TABLE poblacion_aplicaa_nut2; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.poblacion_aplicaa_nut2 TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.poblacion_aplicaa_nut2 TO iepnb_model;


--
-- Name: SEQUENCE poblacion_aplicaa_nut2_idpoblacion_seq; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT ALL ON SEQUENCE especie.poblacion_aplicaa_nut2_idpoblacion_seq TO iepnb_app;


--
-- Name: SEQUENCE sec_estado_cuadricula; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,UPDATE ON SEQUENCE especie.sec_estado_cuadricula TO iepnb_app;
GRANT ALL ON SEQUENCE especie.sec_estado_cuadricula TO iepnb_model;


--
-- Name: SEQUENCE sec_id_ubicacion; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT ALL ON SEQUENCE especie.sec_id_ubicacion TO iepnb_app;


--
-- Name: TABLE t_dataset; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.t_dataset TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.t_dataset TO iepnb_model;


--
-- Name: TABLE t_estado_cuadricula; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT ON TABLE especie.t_estado_cuadricula TO sit;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.t_estado_cuadricula TO iepnb_app;
GRANT ALL ON TABLE especie.t_estado_cuadricula TO iepnb_model;


--
-- Name: TABLE t_tiponombre; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.t_tiponombre TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.t_tiponombre TO iepnb_model;


--
-- Name: TABLE taxon; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.taxon TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.taxon TO iepnb_model;


--
-- Name: TABLE taxonubicacion; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.taxonubicacion TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.taxonubicacion TO iepnb_model;


--
-- Name: TABLE presencia_cuadriculas; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.presencia_cuadriculas TO iepnb_app;
GRANT SELECT,INSERT,UPDATE ON TABLE especie.presencia_cuadriculas TO iepnb_model;
GRANT DELETE ON TABLE especie.presencia_cuadriculas TO iepnb_model WITH GRANT OPTION;
GRANT SELECT ON TABLE especie.presencia_cuadriculas TO sit;


--
-- Name: TABLE relacion_taxonomica; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.relacion_taxonomica TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.relacion_taxonomica TO iepnb_model;


--
-- Name: SEQUENCE sec_id; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT ALL ON SEQUENCE especie.sec_id TO iepnb_app;


--
-- Name: SEQUENCE sec_id_ambitogeo; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT ALL ON SEQUENCE especie.sec_id_ambitogeo TO iepnb_app;


--
-- Name: SEQUENCE sec_id_aplicadoa; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT ALL ON SEQUENCE especie.sec_id_aplicadoa TO iepnb_app;


--
-- Name: SEQUENCE sec_id_atributo; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT ALL ON SEQUENCE especie.sec_id_atributo TO iepnb_app;


--
-- Name: SEQUENCE sec_id_coleccion; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT ALL ON SEQUENCE especie.sec_id_coleccion TO iepnb_app;


--
-- Name: SEQUENCE sec_id_coltiponorm; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT ALL ON SEQUENCE especie.sec_id_coltiponorm TO iepnb_app;


--
-- Name: SEQUENCE sec_id_endemismo; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT ALL ON SEQUENCE especie.sec_id_endemismo TO iepnb_app;


--
-- Name: SEQUENCE sec_id_estadolegal; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT ALL ON SEQUENCE especie.sec_id_estadolegal TO iepnb_app;


--
-- Name: SEQUENCE sec_id_estadonombre; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT ALL ON SEQUENCE especie.sec_id_estadonombre TO iepnb_app;


--
-- Name: SEQUENCE sec_id_estadonombrevalor; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT ALL ON SEQUENCE especie.sec_id_estadonombrevalor TO iepnb_app;


--
-- Name: SEQUENCE sec_id_estadotaxon; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT ALL ON SEQUENCE especie.sec_id_estadotaxon TO iepnb_app;


--
-- Name: SEQUENCE sec_id_estadovig; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT ALL ON SEQUENCE especie.sec_id_estadovig TO iepnb_app;


--
-- Name: SEQUENCE sec_id_grupo; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT ALL ON SEQUENCE especie.sec_id_grupo TO iepnb_app;


--
-- Name: SEQUENCE sec_id_taxon; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT ALL ON SEQUENCE especie.sec_id_taxon TO iepnb_app;


--
-- Name: SEQUENCE sec_id_taxonestadolegal; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT ALL ON SEQUENCE especie.sec_id_taxonestadolegal TO iepnb_app;


--
-- Name: SEQUENCE sec_id_tiponombre; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT ALL ON SEQUENCE especie.sec_id_tiponombre TO iepnb_app;


--
-- Name: SEQUENCE sec_id_tiponormativacoleccion; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT ALL ON SEQUENCE especie.sec_id_tiponormativacoleccion TO iepnb_app;


--
-- Name: TABLE t_agrup_tiponombre; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.t_agrup_tiponombre TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.t_agrup_tiponombre TO iepnb_model;


--
-- Name: TABLE t_ambito_distribucion; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.t_ambito_distribucion TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.t_ambito_distribucion TO iepnb_model;


--
-- Name: TABLE t_ambito_es; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.t_ambito_es TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.t_ambito_es TO iepnb_model;


--
-- Name: TABLE t_aplicaa_conservacion; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.t_aplicaa_conservacion TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.t_aplicaa_conservacion TO iepnb_model;


--
-- Name: TABLE t_aplicaa_distribucion; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.t_aplicaa_distribucion TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.t_aplicaa_distribucion TO iepnb_model;


--
-- Name: TABLE t_aplicaa_nut2; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.t_aplicaa_nut2 TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.t_aplicaa_nut2 TO iepnb_model;


--
-- Name: TABLE t_atributo; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.t_atributo TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.t_atributo TO iepnb_model;


--
-- Name: TABLE t_autoridad_conservacion; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.t_autoridad_conservacion TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.t_autoridad_conservacion TO iepnb_model;


--
-- Name: TABLE t_categoria_conservacion; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.t_categoria_conservacion TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.t_categoria_conservacion TO iepnb_model;


--
-- Name: TABLE t_codigohabitat; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.t_codigohabitat TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.t_codigohabitat TO iepnb_model;


--
-- Name: TABLE t_codigosexternos_eliminar; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.t_codigosexternos_eliminar TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.t_codigosexternos_eliminar TO iepnb_model;


--
-- Name: TABLE t_criteriomedidaconservacion; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.t_criteriomedidaconservacion TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.t_criteriomedidaconservacion TO iepnb_model;


--
-- Name: TABLE t_dataset_medida; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.t_dataset_medida TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.t_dataset_medida TO iepnb_model;


--
-- Name: TABLE t_endemicoen; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.t_endemicoen TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.t_endemicoen TO iepnb_model;


--
-- Name: TABLE t_estadolegal; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.t_estadolegal TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.t_estadolegal TO iepnb_model;


--
-- Name: TABLE t_estadotaxon; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.t_estadotaxon TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.t_estadotaxon TO iepnb_model;


--
-- Name: TABLE t_fuente; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.t_fuente TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.t_fuente TO iepnb_model;


--
-- Name: TABLE t_fuentereferencias_lp; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.t_fuentereferencias_lp TO iepnb_app;
GRANT ALL ON TABLE especie.t_fuentereferencias_lp TO iepnb_model;


--
-- Name: TABLE t_grupo; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.t_grupo TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.t_grupo TO iepnb_model;


--
-- Name: TABLE t_medidaconservacion; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.t_medidaconservacion TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.t_medidaconservacion TO iepnb_model;


--
-- Name: TABLE t_metodomedida; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.t_metodomedida TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.t_metodomedida TO iepnb_model;


--
-- Name: TABLE t_objetivo_planesgestion; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.t_objetivo_planesgestion TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.t_objetivo_planesgestion TO iepnb_model;


--
-- Name: TABLE t_origen_lp; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.t_origen_lp TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.t_origen_lp TO iepnb_model;


--
-- Name: TABLE t_origentaxon; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.t_origentaxon TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.t_origentaxon TO iepnb_model;


--
-- Name: TABLE t_poblacionreferida; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.t_poblacionreferida TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.t_poblacionreferida TO iepnb_model;


--
-- Name: TABLE t_precisionmedida; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.t_precisionmedida TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.t_precisionmedida TO iepnb_model;


--
-- Name: TABLE t_regionreferenciada; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.t_regionreferenciada TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.t_regionreferenciada TO iepnb_model;


--
-- Name: TABLE t_rutaintroduccion; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.t_rutaintroduccion TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.t_rutaintroduccion TO iepnb_model;


--
-- Name: TABLE t_sociedades_lp; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.t_sociedades_lp TO iepnb_app;
GRANT ALL ON TABLE especie.t_sociedades_lp TO iepnb_model;


--
-- Name: TABLE t_taxonrank; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.t_taxonrank TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.t_taxonrank TO iepnb_model;


--
-- Name: TABLE t_tendencia; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.t_tendencia TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.t_tendencia TO iepnb_model;


--
-- Name: TABLE t_tipo_atributo_taxon; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.t_tipo_atributo_taxon TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.t_tipo_atributo_taxon TO iepnb_model;


--
-- Name: TABLE t_tipo_codigo; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.t_tipo_codigo TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.t_tipo_codigo TO iepnb_model;


--
-- Name: TABLE t_tipo_distribucion; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.t_tipo_distribucion TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.t_tipo_distribucion TO iepnb_model;


--
-- Name: TABLE t_tipo_planesgestion; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.t_tipo_planesgestion TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.t_tipo_planesgestion TO iepnb_model;


--
-- Name: TABLE t_tipo_publicacion; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.t_tipo_publicacion TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.t_tipo_publicacion TO iepnb_model;


--
-- Name: TABLE t_tipo_relaciontax; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.t_tipo_relaciontax TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.t_tipo_relaciontax TO iepnb_model;


--
-- Name: TABLE t_tipoambito_ditribucion; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.t_tipoambito_ditribucion TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.t_tipoambito_ditribucion TO iepnb_model;


--
-- Name: TABLE t_tipoamenaza; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.t_tipoamenaza TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.t_tipoamenaza TO iepnb_model;


--
-- Name: TABLE t_tipomedidaconservacion; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.t_tipomedidaconservacion TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.t_tipomedidaconservacion TO iepnb_model;


--
-- Name: TABLE t_tiponormativadataset; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.t_tiponormativadataset TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.t_tiponormativadataset TO iepnb_model;


--
-- Name: TABLE t_tipouso_nivel1; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.t_tipouso_nivel1 TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.t_tipouso_nivel1 TO iepnb_model;


--
-- Name: TABLE t_tipouso_nivel2; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.t_tipouso_nivel2 TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.t_tipouso_nivel2 TO iepnb_model;


--
-- Name: TABLE t_tipouso_nivel3; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.t_tipouso_nivel3 TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.t_tipouso_nivel3 TO iepnb_model;


--
-- Name: TABLE t_tituloamenaza; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.t_tituloamenaza TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.t_tituloamenaza TO iepnb_model;


--
-- Name: TABLE t_titulopoblacion; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.t_titulopoblacion TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.t_titulopoblacion TO iepnb_model;


--
-- Name: TABLE t_unidad_medida_atributo; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.t_unidad_medida_atributo TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.t_unidad_medida_atributo TO iepnb_model;


--
-- Name: TABLE t_valor_atributo; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.t_valor_atributo TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.t_valor_atributo TO iepnb_model;


--
-- Name: TABLE taxon_imagen; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.taxon_imagen TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.taxon_imagen TO iepnb_model;


--
-- Name: TABLE taxon_medicion; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.taxon_medicion TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.taxon_medicion TO iepnb_model;


--
-- Name: TABLE taxondataset; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.taxondataset TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.taxondataset TO iepnb_model;


--
-- Name: TABLE taxondistribucion; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.taxondistribucion TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.taxondistribucion TO iepnb_model;


--
-- Name: TABLE taxonestadoconservacion; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.taxonestadoconservacion TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.taxonestadoconservacion TO iepnb_model;


--
-- Name: TABLE taxonestadolegal; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.taxonestadolegal TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.taxonestadolegal TO iepnb_model;


--
-- Name: TABLE taxonfactoresamenaza; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.taxonfactoresamenaza TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.taxonfactoresamenaza TO iepnb_model;


--
-- Name: TABLE taxonhabitat; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.taxonhabitat TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.taxonhabitat TO iepnb_model;


--
-- Name: TABLE taxonmedidaconservacion; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.taxonmedidaconservacion TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.taxonmedidaconservacion TO iepnb_model;


--
-- Name: TABLE taxonomia; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.taxonomia TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.taxonomia TO iepnb_model;


--
-- Name: TABLE taxonplanesgestion; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.taxonplanesgestion TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.taxonplanesgestion TO iepnb_model;


--
-- Name: SEQUENCE taxonplanesgestion_id_seq; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT ALL ON SEQUENCE especie.taxonplanesgestion_id_seq TO iepnb_app;


--
-- Name: TABLE taxonreferencia; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.taxonreferencia TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.taxonreferencia TO iepnb_model;


--
-- Name: TABLE taxonviaintroduccion; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.taxonviaintroduccion TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.taxonviaintroduccion TO iepnb_model;


--
-- Name: TABLE tgis_linea; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.tgis_linea TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.tgis_linea TO iepnb_model;


--
-- Name: TABLE tgis_poligon; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.tgis_poligon TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.tgis_poligon TO iepnb_model;


--
-- Name: TABLE tgis_punto; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.tgis_punto TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.tgis_punto TO iepnb_model;


--
-- Name: TABLE usos; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.usos TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.usos TO iepnb_model;


--
-- Name: TABLE v_ind_15_1_lesrpe_ceea_especies; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.v_ind_15_1_lesrpe_ceea_especies TO iepnb_app;
GRANT SELECT,INSERT,UPDATE ON TABLE especie.v_ind_15_1_lesrpe_ceea_especies TO iepnb_model;
GRANT DELETE ON TABLE especie.v_ind_15_1_lesrpe_ceea_especies TO iepnb_model WITH GRANT OPTION;
GRANT SELECT ON TABLE especie.v_ind_15_1_lesrpe_ceea_especies TO sit;


--
-- Name: TABLE v_ind_16_1_especies_planes19; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.v_ind_16_1_especies_planes19 TO iepnb_app;
GRANT SELECT,INSERT,UPDATE ON TABLE especie.v_ind_16_1_especies_planes19 TO iepnb_model;
GRANT DELETE ON TABLE especie.v_ind_16_1_especies_planes19 TO iepnb_model WITH GRANT OPTION;
GRANT SELECT ON TABLE especie.v_ind_16_1_especies_planes19 TO sit;


--
-- Name: TABLE v_ind_16_1_especies_planes; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.v_ind_16_1_especies_planes TO iepnb_app;
GRANT SELECT,INSERT,UPDATE ON TABLE especie.v_ind_16_1_especies_planes TO iepnb_model;
GRANT DELETE ON TABLE especie.v_ind_16_1_especies_planes TO iepnb_model WITH GRANT OPTION;
GRANT SELECT ON TABLE especie.v_ind_16_1_especies_planes TO sit;


--
-- Name: TABLE v_ind_16_2_group; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.v_ind_16_2_group TO iepnb_app;
GRANT SELECT,INSERT,UPDATE ON TABLE especie.v_ind_16_2_group TO iepnb_model;
GRANT DELETE ON TABLE especie.v_ind_16_2_group TO iepnb_model WITH GRANT OPTION;
GRANT SELECT ON TABLE especie.v_ind_16_2_group TO sit;


--
-- Name: TABLE v_ind_16_3_group_especie; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.v_ind_16_3_group_especie TO iepnb_app;
GRANT SELECT,INSERT,UPDATE ON TABLE especie.v_ind_16_3_group_especie TO iepnb_model;
GRANT DELETE ON TABLE especie.v_ind_16_3_group_especie TO iepnb_model WITH GRANT OPTION;
GRANT SELECT ON TABLE especie.v_ind_16_3_group_especie TO sit;


--
-- Name: TABLE v_ind_16_4_suma_especies; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.v_ind_16_4_suma_especies TO iepnb_app;
GRANT SELECT,INSERT,UPDATE ON TABLE especie.v_ind_16_4_suma_especies TO iepnb_model;
GRANT DELETE ON TABLE especie.v_ind_16_4_suma_especies TO iepnb_model WITH GRANT OPTION;
GRANT SELECT ON TABLE especie.v_ind_16_4_suma_especies TO sit;


--
-- Name: TABLE v_ind_16_5_suma_especies_tot; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.v_ind_16_5_suma_especies_tot TO iepnb_app;
GRANT SELECT,INSERT,UPDATE ON TABLE especie.v_ind_16_5_suma_especies_tot TO iepnb_model;
GRANT DELETE ON TABLE especie.v_ind_16_5_suma_especies_tot TO iepnb_model WITH GRANT OPTION;
GRANT SELECT ON TABLE especie.v_ind_16_5_suma_especies_tot TO sit;


--
-- Name: TABLE v_ind_16_6_suma_planes; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.v_ind_16_6_suma_planes TO iepnb_app;
GRANT SELECT,INSERT,UPDATE ON TABLE especie.v_ind_16_6_suma_planes TO iepnb_model;
GRANT DELETE ON TABLE especie.v_ind_16_6_suma_planes TO iepnb_model WITH GRANT OPTION;
GRANT SELECT ON TABLE especie.v_ind_16_6_suma_planes TO sit;


--
-- Name: TABLE v_ind_16_7_suma_planes_tot; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.v_ind_16_7_suma_planes_tot TO iepnb_app;
GRANT SELECT,INSERT,UPDATE ON TABLE especie.v_ind_16_7_suma_planes_tot TO iepnb_model;
GRANT DELETE ON TABLE especie.v_ind_16_7_suma_planes_tot TO iepnb_model WITH GRANT OPTION;
GRANT SELECT ON TABLE especie.v_ind_16_7_suma_planes_tot TO sit;


--
-- Name: TABLE v_ind_16_lesrpe_ceea_planes2; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.v_ind_16_lesrpe_ceea_planes2 TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.v_ind_16_lesrpe_ceea_planes2 TO iepnb_model;
GRANT SELECT ON TABLE especie.v_ind_16_lesrpe_ceea_planes2 TO sit;


--
-- Name: TABLE v_ind_16_lesrpe_ceea_planes3; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.v_ind_16_lesrpe_ceea_planes3 TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.v_ind_16_lesrpe_ceea_planes3 TO iepnb_model;
GRANT SELECT ON TABLE especie.v_ind_16_lesrpe_ceea_planes3 TO sit;


--
-- Name: TABLE v_ind_16_lesrpe_ceea_planes5; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.v_ind_16_lesrpe_ceea_planes5 TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.v_ind_16_lesrpe_ceea_planes5 TO iepnb_model;
GRANT SELECT ON TABLE especie.v_ind_16_lesrpe_ceea_planes5 TO sit;


--
-- Name: TABLE v_ind_16_lesrpe_ceea_planes6; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.v_ind_16_lesrpe_ceea_planes6 TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.v_ind_16_lesrpe_ceea_planes6 TO iepnb_model;
GRANT SELECT ON TABLE especie.v_ind_16_lesrpe_ceea_planes6 TO sit;


--
-- Name: TABLE v_ind_3aves_1_especie; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT ON TABLE especie.v_ind_3aves_1_especie TO sit;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.v_ind_3aves_1_especie TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.v_ind_3aves_1_especie TO iepnb_model;


--
-- Name: TABLE v_ind_3aves_2_especie_agrup; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT ON TABLE especie.v_ind_3aves_2_especie_agrup TO sit;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.v_ind_3aves_2_especie_agrup TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.v_ind_3aves_2_especie_agrup TO iepnb_model;


--
-- Name: TABLE v_ind_3aves_3; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT ON TABLE especie.v_ind_3aves_3 TO sit;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.v_ind_3aves_3 TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.v_ind_3aves_3 TO iepnb_model;


--
-- Name: TABLE v_ind_3aves_4_tot; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT ON TABLE especie.v_ind_3aves_4_tot TO sit;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.v_ind_3aves_4_tot TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.v_ind_3aves_4_tot TO iepnb_model;


--
-- Name: TABLE v_ind_3aves_5_porcent; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT ON TABLE especie.v_ind_3aves_5_porcent TO sit;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.v_ind_3aves_5_porcent TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.v_ind_3aves_5_porcent TO iepnb_model;


--
-- Name: TABLE v_nombre_repetido; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.v_nombre_repetido TO iepnb_app;
GRANT SELECT,INSERT,UPDATE ON TABLE especie.v_nombre_repetido TO iepnb_model;
GRANT DELETE ON TABLE especie.v_nombre_repetido TO iepnb_model WITH GRANT OPTION;
GRANT SELECT ON TABLE especie.v_nombre_repetido TO sit;


--
-- Name: TABLE v_nombre_repetido_id; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.v_nombre_repetido_id TO iepnb_app;
GRANT SELECT,INSERT,UPDATE ON TABLE especie.v_nombre_repetido_id TO iepnb_model;
GRANT DELETE ON TABLE especie.v_nombre_repetido_id TO iepnb_model WITH GRANT OPTION;
GRANT SELECT ON TABLE especie.v_nombre_repetido_id TO sit;


--
-- Name: TABLE v_presencia_cedex; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.v_presencia_cedex TO iepnb_app;
GRANT SELECT,INSERT,UPDATE ON TABLE especie.v_presencia_cedex TO iepnb_model;
GRANT DELETE ON TABLE especie.v_presencia_cedex TO iepnb_model WITH GRANT OPTION;
GRANT SELECT ON TABLE especie.v_presencia_cedex TO sit;


--
-- Name: TABLE v_taxon_presencia_utm10x10; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.v_taxon_presencia_utm10x10 TO iepnb_app;
GRANT SELECT,INSERT,UPDATE ON TABLE especie.v_taxon_presencia_utm10x10 TO iepnb_model;
GRANT DELETE ON TABLE especie.v_taxon_presencia_utm10x10 TO iepnb_model WITH GRANT OPTION;
GRANT SELECT ON TABLE especie.v_taxon_presencia_utm10x10 TO sit;


--
-- Name: TABLE v_tendencia_poblacional_dirhab2018; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT ON TABLE especie.v_tendencia_poblacional_dirhab2018 TO sit;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.v_tendencia_poblacional_dirhab2018 TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.v_tendencia_poblacional_dirhab2018 TO iepnb_model;


--
-- Name: TABLE vv_riqueza_especies_cuenta; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.vv_riqueza_especies_cuenta TO iepnb_app;
GRANT SELECT,INSERT,UPDATE ON TABLE especie.vv_riqueza_especies_cuenta TO iepnb_model;
GRANT DELETE ON TABLE especie.vv_riqueza_especies_cuenta TO iepnb_model WITH GRANT OPTION;
GRANT SELECT ON TABLE especie.vv_riqueza_especies_cuenta TO sit;


--
-- Name: TABLE vv_riqueza_especies_cuenta_new; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.vv_riqueza_especies_cuenta_new TO iepnb_app;
GRANT SELECT,INSERT,UPDATE ON TABLE especie.vv_riqueza_especies_cuenta_new TO iepnb_model;
GRANT DELETE ON TABLE especie.vv_riqueza_especies_cuenta_new TO iepnb_model WITH GRANT OPTION;
GRANT SELECT ON TABLE especie.vv_riqueza_especies_cuenta_new TO sit;


--
-- Name: TABLE zz_vv_taxon_medicion; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT ON TABLE especie.zz_vv_taxon_medicion TO sit;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.zz_vv_taxon_medicion TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE especie.zz_vv_taxon_medicion TO iepnb_model;


--
-- Name: TABLE zz_vv_taxonubicacion; Type: ACL; Schema: especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE especie.zz_vv_taxonubicacion TO iepnb_app;
GRANT SELECT,INSERT,UPDATE ON TABLE especie.zz_vv_taxonubicacion TO iepnb_model;
GRANT DELETE ON TABLE especie.zz_vv_taxonubicacion TO iepnb_model WITH GRANT OPTION;
GRANT SELECT ON TABLE especie.zz_vv_taxonubicacion TO sit;


--
-- Name: TABLE habitat; Type: ACL; Schema: habitat; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE habitat.habitat TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE habitat.habitat TO iepnb_model;


--
-- Name: TABLE habitat_region_biogeografica; Type: ACL; Schema: habitat; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE habitat.habitat_region_biogeografica TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE habitat.habitat_region_biogeografica TO iepnb_model;


--
-- Name: TABLE lc_colecciones; Type: ACL; Schema: habitat; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE habitat.lc_colecciones TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE habitat.lc_colecciones TO iepnb_model;


--
-- Name: SEQUENCE "MALLA1X1_C_id_seq"; Type: ACL; Schema: seguimiento_especie; Owner: iepnb
--

GRANT ALL ON SEQUENCE seguimiento_especie."MALLA1X1_C_id_seq" TO iepnb_app;


--
-- Name: SEQUENCE "MALLA1X1_P_id_seq"; Type: ACL; Schema: seguimiento_especie; Owner: iepnb
--

GRANT ALL ON SEQUENCE seguimiento_especie."MALLA1X1_P_id_seq" TO iepnb_app;


--
-- Name: SEQUENCE "UTM 1x1 PIBAL_id_seq"; Type: ACL; Schema: seguimiento_especie; Owner: iepnb
--

GRANT ALL ON SEQUENCE seguimiento_especie."UTM 1x1 PIBAL_id_seq" TO iepnb_app;


--
-- Name: TABLE csv_fla_fuente_presiones; Type: ACL; Schema: seguimiento_especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE seguimiento_especie.csv_fla_fuente_presiones TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE seguimiento_especie.csv_fla_fuente_presiones TO iepnb_model;


--
-- Name: TABLE csv_ocurrencia_multiple_fla; Type: ACL; Schema: seguimiento_especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE seguimiento_especie.csv_ocurrencia_multiple_fla TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE seguimiento_especie.csv_ocurrencia_multiple_fla TO iepnb_model;


--
-- Name: TABLE entidad_ejecutora; Type: ACL; Schema: seguimiento_especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE seguimiento_especie.entidad_ejecutora TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE seguimiento_especie.entidad_ejecutora TO iepnb_model;


--
-- Name: TABLE equipo_personas; Type: ACL; Schema: seguimiento_especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE seguimiento_especie.equipo_personas TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE seguimiento_especie.equipo_personas TO iepnb_model;


--
-- Name: TABLE especimen_foto; Type: ACL; Schema: seguimiento_especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE seguimiento_especie.especimen_foto TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE seguimiento_especie.especimen_foto TO iepnb_model;


--
-- Name: TABLE especimen_medicion; Type: ACL; Schema: seguimiento_especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE seguimiento_especie.especimen_medicion TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE seguimiento_especie.especimen_medicion TO iepnb_model;


--
-- Name: TABLE evento; Type: ACL; Schema: seguimiento_especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE seguimiento_especie.evento TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE seguimiento_especie.evento TO iepnb_model;


--
-- Name: TABLE evento_especificacion; Type: ACL; Schema: seguimiento_especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE seguimiento_especie.evento_especificacion TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE seguimiento_especie.evento_especificacion TO iepnb_model;


--
-- Name: TABLE evento_foto; Type: ACL; Schema: seguimiento_especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE seguimiento_especie.evento_foto TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE seguimiento_especie.evento_foto TO iepnb_model;


--
-- Name: TABLE evento_medicion; Type: ACL; Schema: seguimiento_especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE seguimiento_especie.evento_medicion TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE seguimiento_especie.evento_medicion TO iepnb_model;


--
-- Name: TABLE evento_medicion_multiple; Type: ACL; Schema: seguimiento_especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE seguimiento_especie.evento_medicion_multiple TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE seguimiento_especie.evento_medicion_multiple TO iepnb_model;


--
-- Name: TABLE evento_programa; Type: ACL; Schema: seguimiento_especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE seguimiento_especie.evento_programa TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE seguimiento_especie.evento_programa TO iepnb_model;


--
-- Name: TABLE evento_tipo_especificacion; Type: ACL; Schema: seguimiento_especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE seguimiento_especie.evento_tipo_especificacion TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE seguimiento_especie.evento_tipo_especificacion TO iepnb_model;


--
-- Name: TABLE evento_tipo_medicion; Type: ACL; Schema: seguimiento_especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE seguimiento_especie.evento_tipo_medicion TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE seguimiento_especie.evento_tipo_medicion TO iepnb_model;


--
-- Name: TABLE evento_valor_texto; Type: ACL; Schema: seguimiento_especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE seguimiento_especie.evento_valor_texto TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE seguimiento_especie.evento_valor_texto TO iepnb_model;


--
-- Name: TABLE foto; Type: ACL; Schema: seguimiento_especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE seguimiento_especie.foto TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE seguimiento_especie.foto TO iepnb_model;


--
-- Name: TABLE gis_medicion_linea; Type: ACL; Schema: seguimiento_especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE seguimiento_especie.gis_medicion_linea TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE seguimiento_especie.gis_medicion_linea TO iepnb_model;


--
-- Name: TABLE gis_medicion_poligon; Type: ACL; Schema: seguimiento_especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE seguimiento_especie.gis_medicion_poligon TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE seguimiento_especie.gis_medicion_poligon TO iepnb_model;


--
-- Name: TABLE gis_medicion_punto; Type: ACL; Schema: seguimiento_especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE seguimiento_especie.gis_medicion_punto TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE seguimiento_especie.gis_medicion_punto TO iepnb_model;


--
-- Name: TABLE laboratorio; Type: ACL; Schema: seguimiento_especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE seguimiento_especie.laboratorio TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE seguimiento_especie.laboratorio TO iepnb_model;


--
-- Name: SEQUENCE malla1x1_70_id_seq; Type: ACL; Schema: seguimiento_especie; Owner: iepnb
--

GRANT ALL ON SEQUENCE seguimiento_especie.malla1x1_70_id_seq TO iepnb_app;


--
-- Name: TABLE muestra_laboratorio; Type: ACL; Schema: seguimiento_especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE seguimiento_especie.muestra_laboratorio TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE seguimiento_especie.muestra_laboratorio TO iepnb_model;


--
-- Name: TABLE muestra_medicion; Type: ACL; Schema: seguimiento_especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE seguimiento_especie.muestra_medicion TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE seguimiento_especie.muestra_medicion TO iepnb_model;


--
-- Name: TABLE muestra_taxon; Type: ACL; Schema: seguimiento_especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE seguimiento_especie.muestra_taxon TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE seguimiento_especie.muestra_taxon TO iepnb_model;


--
-- Name: TABLE ocurrencia; Type: ACL; Schema: seguimiento_especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE seguimiento_especie.ocurrencia TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE seguimiento_especie.ocurrencia TO iepnb_model;


--
-- Name: TABLE ocurrencia_especificacion; Type: ACL; Schema: seguimiento_especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE seguimiento_especie.ocurrencia_especificacion TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE seguimiento_especie.ocurrencia_especificacion TO iepnb_model;


--
-- Name: TABLE ocurrencia_foto; Type: ACL; Schema: seguimiento_especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE seguimiento_especie.ocurrencia_foto TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE seguimiento_especie.ocurrencia_foto TO iepnb_model;


--
-- Name: TABLE ocurrencia_medicion; Type: ACL; Schema: seguimiento_especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE seguimiento_especie.ocurrencia_medicion TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE seguimiento_especie.ocurrencia_medicion TO iepnb_model;


--
-- Name: SEQUENCE sec_id_ocurrencia_medicion_multiple; Type: ACL; Schema: seguimiento_especie; Owner: iepnb
--

GRANT ALL ON SEQUENCE seguimiento_especie.sec_id_ocurrencia_medicion_multiple TO iepnb_app;


--
-- Name: TABLE ocurrencia_medicion_multiple; Type: ACL; Schema: seguimiento_especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE seguimiento_especie.ocurrencia_medicion_multiple TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE seguimiento_especie.ocurrencia_medicion_multiple TO iepnb_model;


--
-- Name: TABLE ocurrencia_muestra; Type: ACL; Schema: seguimiento_especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE seguimiento_especie.ocurrencia_muestra TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE seguimiento_especie.ocurrencia_muestra TO iepnb_model;


--
-- Name: TABLE ocurrencia_valor_texto; Type: ACL; Schema: seguimiento_especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE seguimiento_especie.ocurrencia_valor_texto TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE seguimiento_especie.ocurrencia_valor_texto TO iepnb_model;


--
-- Name: TABLE programa; Type: ACL; Schema: seguimiento_especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE seguimiento_especie.programa TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE seguimiento_especie.programa TO iepnb_model;


--
-- Name: TABLE programa_entidad_ejecutora; Type: ACL; Schema: seguimiento_especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE seguimiento_especie.programa_entidad_ejecutora TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE seguimiento_especie.programa_entidad_ejecutora TO iepnb_model;


--
-- Name: TABLE rango_valor; Type: ACL; Schema: seguimiento_especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE seguimiento_especie.rango_valor TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE seguimiento_especie.rango_valor TO iepnb_model;


--
-- Name: SEQUENCE sec_wkt_geometria; Type: ACL; Schema: seguimiento_especie; Owner: iepnb
--

GRANT ALL ON SEQUENCE seguimiento_especie.sec_wkt_geometria TO iepnb_app;


--
-- Name: TABLE t_contenido_foto; Type: ACL; Schema: seguimiento_especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE seguimiento_especie.t_contenido_foto TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE seguimiento_especie.t_contenido_foto TO iepnb_model;


--
-- Name: TABLE t_equipo_ejecutor; Type: ACL; Schema: seguimiento_especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE seguimiento_especie.t_equipo_ejecutor TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE seguimiento_especie.t_equipo_ejecutor TO iepnb_model;


--
-- Name: TABLE t_gis_linea; Type: ACL; Schema: seguimiento_especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE seguimiento_especie.t_gis_linea TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE seguimiento_especie.t_gis_linea TO iepnb_model;


--
-- Name: TABLE t_gis_poligon; Type: ACL; Schema: seguimiento_especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE seguimiento_especie.t_gis_poligon TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE seguimiento_especie.t_gis_poligon TO iepnb_model;


--
-- Name: TABLE t_gis_punto; Type: ACL; Schema: seguimiento_especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE seguimiento_especie.t_gis_punto TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE seguimiento_especie.t_gis_punto TO iepnb_model;


--
-- Name: TABLE t_persona_ejecutora; Type: ACL; Schema: seguimiento_especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE seguimiento_especie.t_persona_ejecutora TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE seguimiento_especie.t_persona_ejecutora TO iepnb_model;


--
-- Name: TABLE t_tipo_identificacion_especimen; Type: ACL; Schema: seguimiento_especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE seguimiento_especie.t_tipo_identificacion_especimen TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE seguimiento_especie.t_tipo_identificacion_especimen TO iepnb_model;


--
-- Name: TABLE t_tipo_medicion_darwincore; Type: ACL; Schema: seguimiento_especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE seguimiento_especie.t_tipo_medicion_darwincore TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE seguimiento_especie.t_tipo_medicion_darwincore TO iepnb_model;


--
-- Name: TABLE t_tipo_muestreo; Type: ACL; Schema: seguimiento_especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE seguimiento_especie.t_tipo_muestreo TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE seguimiento_especie.t_tipo_muestreo TO iepnb_model;


--
-- Name: TABLE t_tipo_persona_ejecutora; Type: ACL; Schema: seguimiento_especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE seguimiento_especie.t_tipo_persona_ejecutora TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE seguimiento_especie.t_tipo_persona_ejecutora TO iepnb_model;


--
-- Name: TABLE t_valor_texto_otra_codif_seguimiento; Type: ACL; Schema: seguimiento_especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE seguimiento_especie.t_valor_texto_otra_codif_seguimiento TO iepnb_app;
GRANT ALL ON TABLE seguimiento_especie.t_valor_texto_otra_codif_seguimiento TO iepnb_model;


--
-- Name: TABLE v_bevacet_evento; Type: ACL; Schema: seguimiento_especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE seguimiento_especie.v_bevacet_evento TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE seguimiento_especie.v_bevacet_evento TO iepnb_model;


--
-- Name: TABLE v_bevacet_ocurrencia; Type: ACL; Schema: seguimiento_especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE seguimiento_especie.v_bevacet_ocurrencia TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE seguimiento_especie.v_bevacet_ocurrencia TO iepnb_model;


--
-- Name: TABLE v_bevacet_ocurrencia_medicion; Type: ACL; Schema: seguimiento_especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE seguimiento_especie.v_bevacet_ocurrencia_medicion TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE seguimiento_especie.v_bevacet_ocurrencia_medicion TO iepnb_model;


--
-- Name: TABLE v_bevacet_ocurrencia_muestra; Type: ACL; Schema: seguimiento_especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE seguimiento_especie.v_bevacet_ocurrencia_muestra TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE seguimiento_especie.v_bevacet_ocurrencia_muestra TO iepnb_model;


--
-- Name: TABLE v_bevacet_programa; Type: ACL; Schema: seguimiento_especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE seguimiento_especie.v_bevacet_programa TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE seguimiento_especie.v_bevacet_programa TO iepnb_model;


--
-- Name: TABLE v_oc_med; Type: ACL; Schema: seguimiento_especie; Owner: iepnb
--

GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLE seguimiento_especie.v_oc_med TO iepnb_app;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE seguimiento_especie.v_oc_med TO iepnb_model;


--
-- Name: DEFAULT PRIVILEGES FOR SEQUENCES; Type: DEFAULT ACL; Schema: comun; Owner: postgres
--

ALTER DEFAULT PRIVILEGES FOR ROLE postgres IN SCHEMA comun GRANT ALL ON SEQUENCES TO iepnb_app;


--
-- Name: DEFAULT PRIVILEGES FOR FUNCTIONS; Type: DEFAULT ACL; Schema: comun; Owner: postgres
--

ALTER DEFAULT PRIVILEGES FOR ROLE postgres IN SCHEMA comun GRANT ALL ON FUNCTIONS TO iepnb_app;


--
-- Name: DEFAULT PRIVILEGES FOR TABLES; Type: DEFAULT ACL; Schema: comun; Owner: postgres
--

ALTER DEFAULT PRIVILEGES FOR ROLE postgres IN SCHEMA comun GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLES TO iepnb_app;
ALTER DEFAULT PRIVILEGES FOR ROLE postgres IN SCHEMA comun GRANT SELECT,INSERT,DELETE,UPDATE ON TABLES TO iepnb_model;


--
-- Name: DEFAULT PRIVILEGES FOR TABLES; Type: DEFAULT ACL; Schema: comun; Owner: iepnb
--

ALTER DEFAULT PRIVILEGES FOR ROLE iepnb IN SCHEMA comun GRANT SELECT ON TABLES TO sit;


--
-- Name: DEFAULT PRIVILEGES FOR SEQUENCES; Type: DEFAULT ACL; Schema: especie; Owner: postgres
--

ALTER DEFAULT PRIVILEGES FOR ROLE postgres IN SCHEMA especie GRANT ALL ON SEQUENCES TO iepnb_app;


--
-- Name: DEFAULT PRIVILEGES FOR FUNCTIONS; Type: DEFAULT ACL; Schema: especie; Owner: postgres
--

ALTER DEFAULT PRIVILEGES FOR ROLE postgres IN SCHEMA especie GRANT ALL ON FUNCTIONS TO iepnb_app;


--
-- Name: DEFAULT PRIVILEGES FOR TABLES; Type: DEFAULT ACL; Schema: especie; Owner: postgres
--

ALTER DEFAULT PRIVILEGES FOR ROLE postgres IN SCHEMA especie GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLES TO iepnb_app;
ALTER DEFAULT PRIVILEGES FOR ROLE postgres IN SCHEMA especie GRANT SELECT,INSERT,DELETE,UPDATE ON TABLES TO iepnb_model;


--
-- Name: DEFAULT PRIVILEGES FOR TABLES; Type: DEFAULT ACL; Schema: especie; Owner: iepnb
--

ALTER DEFAULT PRIVILEGES FOR ROLE iepnb IN SCHEMA especie GRANT SELECT ON TABLES TO sit;


--
-- Name: DEFAULT PRIVILEGES FOR SEQUENCES; Type: DEFAULT ACL; Schema: habitat; Owner: postgres
--

ALTER DEFAULT PRIVILEGES FOR ROLE postgres IN SCHEMA habitat GRANT ALL ON SEQUENCES TO iepnb_app;


--
-- Name: DEFAULT PRIVILEGES FOR FUNCTIONS; Type: DEFAULT ACL; Schema: habitat; Owner: postgres
--

ALTER DEFAULT PRIVILEGES FOR ROLE postgres IN SCHEMA habitat GRANT ALL ON FUNCTIONS TO iepnb_app;


--
-- Name: DEFAULT PRIVILEGES FOR TABLES; Type: DEFAULT ACL; Schema: habitat; Owner: postgres
--

ALTER DEFAULT PRIVILEGES FOR ROLE postgres IN SCHEMA habitat GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLES TO iepnb_app;
ALTER DEFAULT PRIVILEGES FOR ROLE postgres IN SCHEMA habitat GRANT SELECT,INSERT,DELETE,UPDATE ON TABLES TO iepnb_model;


--
-- Name: DEFAULT PRIVILEGES FOR TABLES; Type: DEFAULT ACL; Schema: habitat; Owner: iepnb
--

ALTER DEFAULT PRIVILEGES FOR ROLE iepnb IN SCHEMA habitat GRANT SELECT ON TABLES TO sit;


--
-- Name: DEFAULT PRIVILEGES FOR SEQUENCES; Type: DEFAULT ACL; Schema: seguimiento_especie; Owner: postgres
--

ALTER DEFAULT PRIVILEGES FOR ROLE postgres IN SCHEMA seguimiento_especie GRANT ALL ON SEQUENCES TO iepnb_app;


--
-- Name: DEFAULT PRIVILEGES FOR FUNCTIONS; Type: DEFAULT ACL; Schema: seguimiento_especie; Owner: postgres
--

ALTER DEFAULT PRIVILEGES FOR ROLE postgres IN SCHEMA seguimiento_especie GRANT ALL ON FUNCTIONS TO iepnb_app;


--
-- Name: DEFAULT PRIVILEGES FOR TABLES; Type: DEFAULT ACL; Schema: seguimiento_especie; Owner: postgres
--

ALTER DEFAULT PRIVILEGES FOR ROLE postgres IN SCHEMA seguimiento_especie GRANT SELECT,INSERT,DELETE,TRIGGER,UPDATE ON TABLES TO iepnb_app;
ALTER DEFAULT PRIVILEGES FOR ROLE postgres IN SCHEMA seguimiento_especie GRANT SELECT,INSERT,DELETE,UPDATE ON TABLES TO iepnb_model;


--
-- Name: DEFAULT PRIVILEGES FOR TABLES; Type: DEFAULT ACL; Schema: seguimiento_especie; Owner: iepnb
--

ALTER DEFAULT PRIVILEGES FOR ROLE iepnb IN SCHEMA seguimiento_especie GRANT SELECT ON TABLES TO sit;


--
-- PostgreSQL database dump complete
--

